<?php
/*
Plugin Name: Commentator
Plugin URI: http://www.persianscript.ir
Description: Commentator Wordpress Plugin is a fully featured ajaxified comments system for your wordpress website that let you easily supercharge your discussions.
Author: Yukulelix
Author URI: http://codecanyon.net/user/yukulelix
Version: 2.5.2
Text Domain: commentator
Domain Path: /lang
*/

// Make sure that no info is exposed if file is called directly -- Idea taken from Akismet plugin
if ( !function_exists( 'add_action' ) ) {
	_e( 'This page cannot be called directly.', 'commentator' );
	exit;
}

// Define some useful constants that can be used by functions
if ( ! defined( 'WP_CONTENT_URL' ) ) {	
	if ( ! defined( 'WP_SITEURL' ) ) define( 'WP_SITEURL', get_option("siteurl") );
	define( 'WP_CONTENT_URL', WP_SITEURL . '/wp-content' );
}
if ( ! defined( 'WP_SITEURL' ) ) define( 'WP_SITEURL', get_option("siteurl") );
if ( ! defined( 'WP_CONTENT_DIR' ) ) define( 'WP_CONTENT_DIR', ABSPATH . 'wp-content' );
if ( ! defined( 'WP_PLUGIN_URL' ) ) define( 'WP_PLUGIN_URL', WP_CONTENT_URL. '/plugins' );
if ( ! defined( 'WP_PLUGIN_DIR' ) ) define( 'WP_PLUGIN_DIR', WP_CONTENT_DIR . '/plugins' );

if ( ! defined( 'SPEC_COMMENT_TMP' ) ) define('SPEC_COMMENT_TMP', plugins_url( '/php/commentator-template.php', __FILE__ ));

if ( basename(dirname(__FILE__)) == 'plugins' )
	define("COMMENTATOR_DIR",'');
else define("COMMENTATOR_DIR" , basename(dirname(__FILE__)) . '/');
define("COMMENTATOR_PATH", WP_PLUGIN_URL . "/" . COMMENTATOR_DIR);
/* Add new menu */
add_action('admin_menu', 'commentator_add_pages');
/* Register Settings */
add_action( 'admin_init', 'register_commentator_settings' );
 
require_once( WP_PLUGIN_DIR . '/' . COMMENTATOR_DIR . 'hybridauth/Hybrid/Auth.php' );

add_role(
    'commentator_commenter',
    __( 'Commentator Commenter' , 'commentator' ),
    array(
        'read'         => false,
        'edit_posts'   => false,
        'delete_posts' => false,
    )
);

function register_session(){
    if( !session_id())
        session_start();
}
add_action('init','register_session');

function commentator_translation_init() {
	$plugin_dir = basename(dirname(__FILE__));
	load_plugin_textdomain( 'commentator', false, $plugin_dir."/lang" );
}
add_action('plugins_loaded', 'commentator_translation_init');
/*

******** BEGIN PLUGIN FUNCTIONS ********

*/

add_action('wp_head','commentator_ajaxurl');
function commentator_ajaxurl() {
?>
<script type="text/javascript">
	var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
</script>
<?php
}

function roles_and_capabilities(){
	$roles = get_option('commentator_disabled-user-roles', array());
	$roles = is_array($roles) ? $roles : array();
	global $wp_roles;
    $allRoles = $wp_roles->get_names();
	foreach ($allRoles as $role_name => $role_info){
		if(!in_array( $role_name, $roles ))
			get_role($role_name)->add_cap('commentator-comment');
		else
			get_role($role_name)->remove_cap('commentator-comment');
	}
}
add_action('wp_loaded', 'roles_and_capabilities');

add_action( 'wp_ajax_commentator_register', 'commentator_register' );
add_action('wp_ajax_nopriv_commentator_register', 'commentator_register' );
function commentator_register() {
	$errors = array();
	$arr = array();
	$username = isset($_POST['username']) ? $_POST['username'] : "";
	if(empty($username)) {  
        $errors[] = __( 'User name should not be empty.', 'commentator' );  
    }
    $email = isset($_POST['email']) ? $_POST['email'] : "";
    if(!$email || strlen($email) == 0 || ctype_space($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {  
        $errors[] = __( 'The email is empty or invalid.', 'commentator' );  
    }
    $password = isset($_POST['password']) ? $_POST['password'] : "";
    if(get_option('commentator_register_password_chose')){
    	if(!$password || strlen($password) == 0 || ctype_space($password)) {  
        	$errors[] = __( 'You need to chose a password.', 'commentator' );  
    	}
    }
    else{
    	$password = wp_generate_password( 12, false );
    }

    if(count($errors) == 0){
	    $status = wp_create_user( $username, $password, $email );
	    if ( is_wp_error($status) ) {
	        $errors[] = $status->get_error_message();
	    }
	}

    if(count($errors) == 0){
    	$user = get_userdata( $status );
    	$user->set_role('commentator_commenter');
        $from = get_option('admin_email');  
        $headers = __( 'From', 'commentator' ).' '.$from . "</br>";  
        $subject = __( 'Registration successful', 'commentator' );
        $msg = __( 'Registration successful', 'commentator' ).".<br/>".__( 'Your login details', 'commentator' )."\n".__( 'Username', 'commentator' ).": ".$username."\n".__( 'Password', 'commentator' ).": ".$password;
        add_filter( 'wp_mail_content_type', 'set_html_content_type' );
        wp_mail( $email, $subject, $msg, $headers );
        remove_filter( 'wp_mail_content_type', 'set_html_content_type' );
        $arr = array(
			'message' => __( 'Registration successful, check your email for your password', 'commentator' )
		);
    }
    else{
    	$arr = array(
			'errors' => $errors,
		);
    }
	wp_send_json($arr);
	die();
}



add_action( 'wp_ajax_commentator_login', 'commentator_login' );
add_action('wp_ajax_nopriv_commentator_login', 'commentator_login' );
function commentator_login() {
	$errors = array();
	$arr = array();
	$username = isset($_POST['username']) ? $_POST['username'] : "";
	$password = isset($_POST['password']) ? $_POST['password'] : "";

	$creds = array();
	$creds['user_login'] = $username;
	$creds['user_password'] = $password;
	$creds['remember'] = isset($_POST['remember']);
	$user = wp_signon( $creds, false );

	if ( is_wp_error($user) )
		$errors[] = $user->get_error_message();

    if(count($errors) == 0){
        $arr = array(
			'avatar' => get_avatar( $user->ID ),
			'username' => $user->user_login,
			'ID' => $user->ID
		);
    }  
    else{
    	$arr = array(
			'errors' => $errors,
		);
    }
	wp_send_json($arr);
	die();
}

add_action( 'wp_ajax_commentator_logout', 'commentator_logout' );
add_action('wp_ajax_nopriv_commentator_logout', 'commentator_logout' );
function commentator_logout() {
	if(is_user_logged_in()){
		wp_logout();
	}
	elseif(isset($_SESSION['commentator_user_profile']) && $_SESSION["commentator_user_profile"] != null){
			Hybrid_Auth::logoutAllProviders();
			$_SESSION["commentator_user_profile"] = null;
			$_SESSION["commentator_provider"] = null;
	}
	die();
}

add_action( 'wp_ajax_commentator_vote-thread', 'commentator_voteThread' );
add_action('wp_ajax_nopriv_commentator_vote-thread', 'commentator_voteThread' );
function commentator_voteThread() {
	$upVotes = get_post_meta( $_POST['comment_post_ID'], "upVote-discussion" );
	$count = count($upVotes);
	$hasVoted = false;
	$errors = array();
	$arr = array();
	$content_post = get_post($_POST['comment_post_ID']);

	global $current_user;
	get_currentuserinfo();

	$voteAuthorID = $current_user->ID;

	$user_profile = isset($_SESSION['commentator_user_profile']) ? $_SESSION["commentator_user_profile"] : null;
	if(!is_user_logged_in() && $user_profile != null){
		$voteAuthorID = $_SESSION["commentator_provider"]."-".$user_profile['identifier'];
	}

	if(!$content_post){
		$errors[] = __( 'the post doesn\'t exist', 'commentator' );
	}

	if(!is_user_logged_in() && $user_profile == null){
		$errors[] = __( 'you are not logged in !', 'commentator' );
	}

	if(count($errors) == 0){
	    if(!in_array ( $voteAuthorID, $upVotes )){
			add_post_meta($_POST['comment_post_ID'], "upVote-discussion", $voteAuthorID);
	    	$hasVoted = true;
		}
		else{
			delete_post_meta( $_POST['comment_post_ID'], "upVote-discussion", $voteAuthorID );
		}

		$upVotes = get_post_meta( $_POST['comment_post_ID'], "upVote-discussion" );
		$count = count($upVotes);

		$arr = array(
			'count' => $count,
			'hasVoted' => $hasVoted
		);
	}

	else{
		$arr = array(
			'errors' => $errors,
		);
	}

	wp_send_json($arr);
	die();
}

add_action( 'wp_ajax_commentator_flag', 'commentator_flag' );
add_action('wp_ajax_nopriv_commentator_flag', 'commentator_flag' );
function commentator_flag() {
	$comment_ID = $_POST['comment_ID'];
	$comment = get_comment( $comment_ID );
	$post  = get_post( $comment->comment_post_ID );
	$errors = array();
	$arr = array();

	global $current_user;
	get_currentuserinfo();

	$voteAuthorID = $current_user->ID;
	$user_profile = isset($_SESSION['commentator_user_profile']) ? $_SESSION["commentator_user_profile"] : null;
	if(!is_user_logged_in() && $user_profile != null){
		$voteAuthorID = $_SESSION["commentator_provider"]."-".$user_profile['identifier'];
	}

	if(!is_user_logged_in() && $user_profile == null){
		$errors[] = __( 'you are not logged in !', 'commentator' );
	}

	if(!get_option('commentator_flag-comment')){
		$errors[] = __( 'Flagging is not allowed !', 'commentator' );
	}

	if(count($errors) == 0){
	    update_comment_meta($comment_ID, "flag-comment", $voteAuthorID);
	    $link = get_comment_link( $comment->comment_ID );
	    $count = count(get_comment_meta($comment_ID, "flag-comment"));
	    update_comment_meta($comment_ID, "flag-comment-count", $count);

	    if(get_option('commentator_flag-limit') && $count >= ((int) get_option('commentator_flag-limit'))){
	    	$commentarr = array();
			$commentarr['comment_ID'] = $comment_ID; // This is the only required array key
			$commentarr['comment_approved'] = 0;
			wp_update_comment( $commentarr );
		}

	    $to = get_option('admin_email');  
        $headers = __( 'From', 'commentator' ).' '.$to . "</br>";  
        $subject = __( 'New Comment Flagging', 'commentator' );
        $msg = 
        	__( 'A new comment has been flagged on ', 'commentator' ).'<a href="'.$link.'">'.$post->post_title.'</a>'.
			".<br/>".
        	__( 'Number of flags : ', 'commentator' ).$count.
        	".<br/>".
        	"<pre>".$comment->comment_content."</pre>".
        	"<br/>".
        	__( 'Go to your wordpress admin to see it', 'commentator' );
        add_filter( 'wp_mail_content_type', 'set_html_content_type' );
        wp_mail( $to, $subject, $msg, $headers );
        remove_filter( 'wp_mail_content_type', 'set_html_content_type' );
		$arr = array(
			'message' => __('The comment has been flagged', 'commentator')
		);
	}

	else{
		$arr = array(
			'errors' => $errors,
		);
	}

	wp_send_json($arr);
	die();
}

add_action( 'wp_ajax_commentator_delete', 'commentator_delete' );
add_action('wp_ajax_nopriv_commentator_delete', 'commentator_delete' );
function commentator_delete() {
	$comment_ID = $_POST['comment_ID'];
	$comment = get_comment( $comment_ID );
	$errors = array();
	$arr = array();

	if(get_option('commentator_social-signin')){
		$user_profile = isset($_SESSION['commentator_user_profile']) ? $_SESSION["commentator_user_profile"] : null;
		if($user_profile != null){
			$user_email = $user_profile['email'];
		}
	}

	// If the user is logged in
	$user = wp_get_current_user();
	if ( $user->exists() ) {
		$user_email = wp_slash( $user->user_email );
	} else {
		if ( $user_profile==null ){
			$errors[] = __('you are not logged in !', 'commentator');
		}
	}

	if ( $comment->comment_author_email != $user_email ){
		$errors[] = __('Sorry, this is not your comment', 'commentator');
	}

	if(count($errors) == 0){
		wp_delete_comment( $comment_ID );
		$arr = array(
			'message' => __('This comment has been deleted', 'commentator')
		);
	}
	else{
		$arr = array(
			'errors' => $errors,
		);
	}

	wp_send_json($arr);
	die();
}

add_action( 'wp_ajax_commentator_pick', 'commentator_pick' );
add_action('wp_ajax_nopriv_commentator_pick', 'commentator_pick' );
function commentator_pick() {
	$comment_ID = $_POST['comment_ID'];
	$comment = get_comment( $comment_ID );
	$post = get_post( $comment->comment_post_ID );
	$authorID = $post->post_author;
	$author = get_user_by( 'id', $authorID );
	$errors = array();
	$arr = array();

	if(get_option('commentator_social-signin')){
		$user_profile = isset($_SESSION['commentator_user_profile']) ? $_SESSION["commentator_user_profile"] : null;
		if($user_profile != null){
			$user_email = $user_profile['email'];
		}
	}

	// If the user is logged in
	$user = wp_get_current_user();
	if ( $user->exists() ) {
		$user_email = wp_slash( $user->user_email );
	} else {
		if ( $user_profile==null ){
			$errors[] = __('you are not logged in !', 'commentator');
		}
	}

	if ( $author->user_email != $user_email ){
		$errors[] = __('Sorry, this is not your post', 'commentator');
	}

	if(count($errors) == 0){
		$pickedComments = get_post_meta ( $post->ID, "pickedComments");
		$isPicked = in_array ( $comment_ID, $pickedComments );

		if($isPicked){
			delete_post_meta( $post->ID, "pickedComments", $comment_ID);
			$arr = array(
				'message' => __('This comment has been unpicked', 'commentator')
			);
		}
		else{
			add_post_meta( $post->ID, "pickedComments", $comment_ID);
			$arr = array(
				'message' => __('This comment has been picked', 'commentator')
			);
		}
	}
	else{
		$arr = array(
			'errors' => $errors,
		);
	}

	wp_send_json($arr);
	die();
}

add_action('transition_comment_status', 'commentator_approve_comment_callback', 10, 3);
function commentator_approve_comment_callback($new_status, $old_status, $comment) {
    if($old_status != $new_status) {
        if($new_status == 'approved') {
            delete_comment_meta($comment->comment_ID, "flag-comment");
        }
    }
}

function set_html_content_type()
{
    return 'text/html';
}

add_action( 'wp_ajax_commentator_social_signin', 'commentator_social_signin' );
add_action('wp_ajax_nopriv_commentator_social_signin', 'commentator_social_signin' );
function commentator_social_signin(){
	if( isset($_REQUEST["provider"]) ){ 
		// the selected provider
		$provider_name = $_REQUEST["provider"];
		try{
			// initialize Hybrid_Auth with a given file
			$hybridauth = new Hybrid_Auth( 
				array(
					"base_url" => WP_PLUGIN_URL . '/' . COMMENTATOR_DIR . 'hybridauth/', 

					"providers" => array ( 
						// openid providers

						"Google" => array ( 
							"enabled" => get_option('commentator_id_key-google') && get_option('commentator_secret_key-google'),
							"keys"    => array ( "id" => get_option('commentator_id_key-google'), "secret" => get_option('commentator_secret_key-google') ), 
						),

						"Facebook" => array ( 
							"enabled" => get_option('commentator_id_key-facebook') && get_option('commentator_secret_key-facebook'),
							"scope"   => "email",
							"keys"    => array ( "id" => get_option('commentator_id_key-facebook'), "secret" => get_option('commentator_secret_key-facebook') ), 
						),

						"Twitter" => array ( 
							"enabled" => get_option('commentator_id_key-twitter') && get_option('commentator_secret_key-twitter'),
							"keys"    => array ( "key" => get_option('commentator_id_key-twitter'), "secret" => get_option('commentator_secret_key-twitter') ), 
						),

						"LinkedIn" => array ( 
							"enabled" => get_option('commentator_id_key-linkedin') && get_option('commentator_secret_key-linkedin'),
							"keys"    => array ( "key" => get_option('commentator_id_key-linkedin'), "secret" => get_option('commentator_secret_key-linkedin') ), 
						),
					),

					// if you want to enable logging, set 'debug_mode' to true  then provide a writable file by the web server on "debug_file"
					"debug_mode" => false,

					"debug_file" => "",
				)	
			);
 
			// try to authenticate with the selected provider
			$adapter = $hybridauth->authenticate( $provider_name );
 
			// then grab the user profile 
			$user_profile = $adapter->getUserProfile();

			$_SESSION["commentator_user_profile"] = (array) $user_profile;
			$_SESSION["commentator_provider"] = $provider_name;
		}
		catch( Exception $e ){
			$caught = true;
		}
?>
	<!DOCTYPE html>
	<html lang="en">
		<head>
		    <meta charset="utf-8">
		    <title><?php _e("Commentator Social Signin", "commentator"); ?></title>
		    <style>
			    body, html{
			    	margin: 0;
			    	padding: 0;
					width: 100%;
					height: 100%;
  					font-family: 'Helvetica Neue', arial, sans-serif;
			    }
			    #commentator-social-signin{
			    	position: relative;
					width: 100%;
					height: 100%;
			    }
				.commentator-social-message{
					color: #fff;
					position: absolute;
					top: 0;
					left: 0;
					width: 100%;
					height: 100%;
		  			display: table; 
				}
				#commentator-social-signin .commentator-social-message > div{
					display: table-cell; 
		  			vertical-align: middle; 
		  			text-align: center; 
		  			text-align: center;
				}
				h4{
					opacity: .8;
				}
				.commentator-facebook .commentator-social-message{
					background: #4862A3;
				}
				.commentator-twitter .commentator-social-message{
					background: #00ACEE;
				}
				.commentator-google .commentator-social-message{
				  background: #C13222;
				}
				.commentator-linkedin .commentator-social-message{
				  background: #0073B2;
				}
			</style>
		</head>
		<body>
		    <div id="commentator-social-signin" class="commentator-<?php echo $provider_name; ?>">

		    	<div class="commentator-social-message">
			    	<div id="commentator-social-loading">
			    		<div>
			    			<?php _e("Connecting...", "commentator"); ?>
			    		</div>
					</div>
				</div>

		<?php
		if($caught){
		?>
			<div class="commentator-social-message">
				<div>
					<h1><?php _e("Error: please try again!", "commentator"); ?></h1>
					<h4><?php _e("Original error message: ", "commentator"); ?> <?php echo $e->getMessage(); ?></h4>
				</div>
			</div>
			<?php
		}else{
	?>
			<div class="commentator-social-message">
				<div>
					<h1><?php _e('Congratulations !', "commentator"); ?></h1>
					<h4><?php _e('You can now join the conversation !', "commentator"); ?></h4>
				</div>
			</div>

			<script type="text/javascript">
				window.opener.location.reload();
				setTimeout(function(){
					window.close();
				}, 3000);
			</script>
		<?php
		}
		?>
		</body>
	</html>
	<?php
	}
	die();
}

add_action( 'wp_ajax_commentator_upload-image', 'commentator_upload_image' );
add_action('wp_ajax_nopriv_commentator_upload-image', 'commentator_upload_image' );
function commentator_upload_image() {
	$errors = array();
	$arr = array();
	// A list of permitted file extensions
	$allowed = array('png', 'jpg', 'gif');
	$upload_dir = wp_upload_dir();

	if(get_option('commentator_allow-images')){

		if(isset($_FILES['upl']) && $_FILES['upl']['error'] == 0){

			$extension = pathinfo($_FILES['upl']['name'], PATHINFO_EXTENSION);

			if(!in_array(strtolower($extension), $allowed)){
				$errors[] = __( 'This type of image is not allowed', 'commentator' );
			}

			$url = $upload_dir['url']."/".$_FILES['upl']['name'];
			$path = $upload_dir['path']."/".$_FILES['upl']['name'];

			if(!move_uploaded_file($_FILES['upl']['tmp_name'], $path)){
				$errors[] = __( 'There was an error uploading the image', 'commentator' );
			}
		}
		else{
			$errors[] = __( 'There was an error uploading the image', 'commentator' );
		}

	}
	else{
		$errors[] = __( 'Images upload is not allowed', 'commentator' );
	}



	if(count($errors) == 0){
		$arr = array(
			'url' => $url
		);
	}
	else{
		$arr = array(
			'errors' => $errors,
		);
	}

	wp_send_json($arr);
	die();
}

add_action( 'wp_ajax_commentator_add-comment', 'commentator_add_comment' );
add_action('wp_ajax_nopriv_commentator_add-comment', 'commentator_add_comment' );
function commentator_add_comment() {

	$comment_post_ID = isset($_POST['comment_post_ID']) ? (int) $_POST['comment_post_ID'] : 0;

	$post = get_post($comment_post_ID);

	if ( empty( $post->comment_status ) ) {
		/**
		 * Fires when a comment is attempted on a post that does not exist.
		 *
		 * @since unknown
		 * @param int $comment_post_ID Post ID.
		 */
		do_action( 'comment_id_not_found', $comment_post_ID );
		exit;
	}

	// get_post_status() will get the parent status for attachments.
	$status = get_post_status($post);

	$status_obj = get_post_status_object($status);

	if ( ! comments_open( $comment_post_ID ) ) {
		/**
		 * Fires when a comment is attempted on a post that has comments closed.
		 *
		 * @since unknown
		 * @param int $comment_post_ID Post ID.
		 */
		do_action( 'comment_closed', $comment_post_ID );
		wp_die( __('Sorry, comments are closed for this item.') );
	} elseif ( 'trash' == $status ) {
		/**
		 * Fires when a comment is attempted on a trashed post.
		 *
		 * @since 2.9.0
		 * @param int $comment_post_ID Post ID.
		 */
		do_action( 'comment_on_trash', $comment_post_ID );
		exit;
	} elseif ( ! $status_obj->public && ! $status_obj->private ) {
		/**
		 * Fires when a comment is attempted on a post in draft mode.
		 *
		 * @since unknown
		 * @param int $comment_post_ID Post ID.
		 */
		do_action( 'comment_on_draft', $comment_post_ID );
		exit;
	} elseif ( post_password_required( $comment_post_ID ) ) {
		/**
		 * Fires when a comment is attempted on a password-protected post.
		 *
		 * @since unknown
		 * @param int $comment_post_ID Post ID.
		 */
		do_action( 'comment_on_password_protected', $comment_post_ID );
		exit;
	} else {
		/**
		 * Fires before a comment is posted.
		 *
		 * @since unknown
		 * @param int $comment_post_ID Post ID.
		 */
		do_action( 'pre_comment_on_post', $comment_post_ID );
	}

	$comment_author       = ( isset($_POST['author-name']) )  ? trim(strip_tags($_POST['author-name'])) : null;
	$comment_author_email = ( isset($_POST['author-email']) )   ? trim($_POST['author-email']) : null;
	$comment_author_url   = ( isset($_POST['author-url']) )     ? trim($_POST['author-url']) : null;
	$comment_content      = ( isset($_POST['comment']) ) ? trim($_POST['comment']) : null;
	$user_ID = 0;
	$comment_image = ( isset($_POST['attached-image']) ) ? trim($_POST['attached-image']) : null;

	$user_profile = null;
	if(get_option('commentator_social-signin')){
		$user_profile = isset($_SESSION['commentator_user_profile']) ? $_SESSION["commentator_user_profile"] : null;
		if($user_profile != null){
			$comment_author = $user_profile['displayName'];
			$comment_author_url = $user_profile['webSiteURL'] ? $user_profile['webSiteURL'] : $user_profile['profileURL'];
			$comment_author_email = $user_profile['email'];
		}
	}

	// If the user is logged in
	$user = wp_get_current_user();
	if ( $user->exists() ) {
		if ( empty( $user->display_name ) )
			$user->display_name=$user->user_login;
		$comment_author       = wp_slash( $user->display_name );
		$comment_author_email = wp_slash( $user->user_email );
		$comment_author_url   = wp_slash( $user->user_url );
		$user_ID   = wp_slash( $user->ID );
		if(!current_user_can( 'commentator-comment' )){
			wp_die( __('Sorry, your user role doesn\'t allow you to comment.', 'commentator') );
		}
		if ( current_user_can( 'unfiltered_html' ) ) {
			if ( ! isset( $_POST['_wp_unfiltered_html_comment'] )
				|| ! wp_verify_nonce( $_POST['_wp_unfiltered_html_comment'], 'unfiltered-html-comment_' . $comment_post_ID )
			) {
				kses_remove_filters(); // start with a clean slate
				kses_init_filters(); // set up the filters
			}
		}
	} else {
		if ( $user_profile==null && (get_option('comment_registration') || 'private' == $status) )
			wp_die( __('Sorry, you must be logged in to post a comment.') );
	}

	$comment_type = '';

	if ( get_option('require_name_email') && !$user->exists() && $user_profile == null ) {
		if ( 6 > strlen($comment_author_email) || '' == $comment_author )
			wp_die( __('<strong>ERROR</strong>: please fill the required fields (name, email).') );
		elseif ( !is_email($comment_author_email))
			wp_die( __('<strong>ERROR</strong>: please enter a valid email address.') );
	}

	if ( '' == $comment_content && $comment_image==null )
		wp_die( __('<strong>ERROR</strong>: please type a comment.') );

	$comment_parent = isset($_POST['comment_parent']) ? absint($_POST['comment_parent']) : 0;

	$commentdata = compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_type', 'comment_parent', 'user_ID');

	$comment_id = wp_new_comment( $commentdata );
	$comment = get_comment($comment_id);

	if(get_option('commentator_allow-images') && $comment_image!=null ){
		update_comment_meta( $comment_id, "commentator-attached-image", $comment_image);
	}

	if($user_profile != null){
		update_comment_meta( $comment_id, "commentator-social-avatar", $user_profile['photoURL']);
	}

	/**
	 * Perform other actions when comment cookies are set.
	 *
	 * @since 3.4.0
	 *
	 * @param object $comment Comment object.
	 * @param WP_User $user   User object. The user may not exist.
	 */
	do_action( 'set_comment_cookies', $comment, $user );

	$result = array();
	if ( '0' == $comment->comment_approved ){
		$result['message'] = __('Your comment is awaiting moderation', 'commentator');
	}
	$result['comment_ID'] = $comment_id;

	wp_send_json($result);
    die();
}

add_action( 'wp_ajax_commentator_get-comment-html', 'commentator_get_comment_html' );
add_action('wp_ajax_nopriv_commentator_get-comment-html', 'commentator_get_comment_html' );
function commentator_get_comment_html() {
	$comment_id = $_POST['comment_ID'];
	global $comment_depth;
	$comment_depth = get_option('commentator_max_depth', 3);
	$comment = get_comment($comment_id);
	global $post;
	$post = get_post($comment->comment_post_ID);
	commentator_comment( $comment, array(), 0 );
	echo "</li>";
	die();
}

add_action( 'wp_ajax_commentator_vote-comment', 'commentator_vote_comment' );
add_action('wp_ajax_nopriv_commentator_vote-comment', 'commentator_vote_comment' );
function commentator_vote_comment(){
	$multiplicator = $_POST['multiplicator'];
	$voteType = ($multiplicator > 0) ? "upVote" : "downVote";
	$voteOpposite = ($multiplicator < 0) ? "upVote" : "downVote";
	$votes = get_comment_meta( $_POST['comment_ID'], $voteType );

	$errors = array();
	$arr = array();


	global $current_user;
	get_currentuserinfo();

	$voteAuthorID = $current_user->ID;

	$user_profile = isset($_SESSION['commentator_user_profile']) ? $_SESSION["commentator_user_profile"] : null;
	if(!is_user_logged_in() && $user_profile != null){
		$voteAuthorID = $_SESSION["commentator_provider"]."-".$user_profile['identifier'];
	}

	if(!is_user_logged_in() && $user_profile == null){
		$errors[] = __( 'you are not logged in', 'commentator' );
	}

	if(!get_comment($_POST['comment_ID'])){
		$errors[] = __( 'the comment you wan\'t to vote doesn\'t exist', 'commentator' );
	}

	if(count($errors) == 0){
	    if(!in_array ( $voteAuthorID, $votes )){
	    	add_comment_meta( $_POST['comment_ID'], $voteType, $voteAuthorID);
			delete_comment_meta( $_POST['comment_ID'], $voteOpposite, $voteAuthorID );
		}
		else{
			delete_comment_meta( $_POST['comment_ID'], $voteType, $voteAuthorID );
		}


		$votes = get_comment_meta( $_POST['comment_ID'], $voteType );
		$count = count($votes);
		update_comment_meta( $_POST['comment_ID'], $voteType."-count", $count );
		$hasVoted = in_array ( $voteAuthorID, $votes );
		$votesOpposite = get_comment_meta( $_POST['comment_ID'], $voteOpposite );
		$countOpposite = count($votesOpposite);
		update_comment_meta( $_POST['comment_ID'], $voteOpposite."-count", $countOpposite );
		$hasVotedOpposite = in_array ( $voteAuthorID, $votesOpposite );

		$arr = array(
			'count' => $count,
			'hasVoted' => $hasVoted,
			'countOpposite' => $countOpposite,
			'hasVotedOpposite' => $hasVotedOpposite
		);
		$commentarr = array();
		$commentarr['comment_ID'] = $_POST['comment_ID'];
		wp_update_comment( $commentarr );
	}

	else{
		$arr = array(
			'errors' => $errors,
		);
	}


	wp_send_json($arr);
    die();
}

add_action( 'wp_ajax_commentator_sort-comments', 'commentator_sort_comments');
add_action('wp_ajax_nopriv_commentator_sort-comments', 'commentator_sort_comments' );
function commentator_sort_comments(){
	$post_ID = $_POST['comment_post_ID'];
	$args = array(
		'post_id' => $post_ID,
		'order' => 'ASC',
		'status' => 'approve'
	);
	if($_POST['commentator_sort'] == 'picked'){
		$args['comment__in'] = get_post_meta ( $post_ID, "pickedComments");
	}
	
	$comments = get_comments($args);
	$page = null;
	if(get_option('page_comments') && isset($_POST['comment_page'])){
		$page = $_POST['comment_page'];
	}
	if($_POST['commentator_sort'] == 'popular'){
		$comments = commentator_compare_topLevels($comments, 'commentator_comment_karma_comparator');
	}
	else if($_POST['commentator_sort'] == 'desc'){
		$comments = commentator_compare_topLevels($comments, 'commentator_comment_desc_comparator');
	}

	global $post;
	$oldPost = $post;
	$post = get_post($_POST['comment_post_ID']);

    wp_list_comments( 
    	array( 
    		'callback' => 'commentator_comment',
    		'page'              => get_option('page_comments') ? $page : "",
    		'per_page'			=> get_option('page_comments') ? get_option('comments_per_page') : "",
    		'max_depth' => get_option('commentator_max_depth', 3)
    	), $comments);

    ?>
    <?php
    	if(get_option('page_comments')){
    ?>
    <li id="commentator-new-pagination-container">
    	<?php
    	$args = array(
			'base' => '#%#%',
			'add_fragment' => ''
		);
		$max_page = get_comment_pages_count();
		$defaults = array(
			'base' => add_query_arg( 'cpage', '%#%' ),
			'format' => '',
			'total' => $max_page,
			'current' => $page,
			'echo' => true,
			'add_fragment' => '#comments'
		);
		$args = wp_parse_args( $args, $defaults );
		$page_links = paginate_links( $args );

		if ( $args['echo'] )
			echo $page_links;
		else
			return $page_links;
		?>
	</li>
	<?php
    	}
    $post = $oldPost;
    ?>
<?php
	die();
}

function get_comment_karma($comment_id){
	$downVotes = get_comment_meta( $comment_id, "downVote" );
	$downCount = count($downVotes);
	$upVotes = get_comment_meta( $comment_id, "upVote" );
	$upCount = count($upVotes);
	return $upCount - $downCount;
}

function commentator_compare_topLevels($comments, $sorting){
	$firstLevels = array();
	$children = array();
	$result = array();

	foreach ($comments as $index => $comment) {
		if($comment->comment_parent == 0){
			$firstLevels[] = $comment;
		}
		else{
			if(!array_key_exists($comment->comment_parent, $children)){
				$children[$comment->comment_parent] = array();
			}
			$children[$comment->comment_parent][] = $comment;
		}
	}
	
	usort($firstLevels, $sorting);

	foreach($firstLevels as $c){
		$result = commentator_fill_with_children($result, $c, $children);
	}

	return $result;
}

function commentator_fill_with_children($result, $comment, $children){
	$result[] = $comment;
	if(array_key_exists($comment->comment_ID, $children)){
		foreach($children[$comment->comment_ID] as $child){
			$result = commentator_fill_with_children($result, $child, $children);
		}
	}
	return $result;
}

function commentator_comment_karma_comparator($a, $b){
	$compared = 0;
	$karmaA = get_comment_karma($a->comment_ID);
	$karmaB = get_comment_karma($b->comment_ID);
	if($karmaA != $karmaB){
		$compared = ( $karmaA < $karmaB) ? 1:-1;
	}
	return $compared;
}

function commentator_comment_desc_comparator($a, $b){
	$compared = 0;
	if($a->comment_date != $b->comment_date){
		$compared = ( strtotime($a->comment_date) < strtotime($b->comment_date) ) ? 1:-1;
	}
	return $compared;
}



function commentator_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	global $post;
	global $current_user;

	get_currentuserinfo();
	$comment_user = ($comment->user_id && ($comment->user_id > 0)) ? get_user_by( 'id', $comment->user_id  ) : get_user_by( 'email', $comment->comment_author_email );

	$voteAuthorID = $current_user->ID;
	$avatar = get_avatar( $comment );
	$user_profile = isset($_SESSION['commentator_user_profile']) ? $_SESSION["commentator_user_profile"] : null;
	if(!is_user_logged_in() && $user_profile != null){
		$voteAuthorID = $_SESSION["commentator_provider"]."-".$user_profile['identifier'];
	}
	if(get_comment_meta( $comment->comment_ID, "commentator-social-avatar", true )){
		$avatar = '<img alt="" src="'.get_comment_meta( $comment->comment_ID, "commentator-social-avatar", true ).'" class="avatar avatar-96 photo" height="96" width="96">';
	}

	$upVotes = get_comment_meta( $comment->comment_ID, "upVote" );
	$hasUpVoted = in_array ( $voteAuthorID, $upVotes );
	$downVotes = get_comment_meta( $comment->comment_ID, "downVote" );
	$hasDownVoted = in_array ( $voteAuthorID, $downVotes );
	$pickedComments = get_post_meta ( $post->ID, "pickedComments");
	$isPicked = in_array ( $comment->comment_ID, $pickedComments );

	$commentUrl = '';
	if(isset($comment_user->ID) && $comment_user->ID > 0){
		if (class_exists('BuddyPress')) {
	        $commentUrl = bp_core_get_user_domain($comment_user->ID);
	    } else if (class_exists('XooUserUltra')) {
	        global $xoouserultra;
	        $commentUrl = $xoouserultra->userpanel->get_user_profile_permalink($comment_user->ID);
	    } else if (class_exists('userpro_api')) {
	        global $userpro;
	        $commentUrl = $userpro->permalink($comment_user->ID);
	    } else if (class_exists('UM_API')) {
	        um_fetch_user($comment_user->ID);
	        $commentUrl = um_user_profile_url();
	    } else {
	        $commentUrl = get_comment_author_url($comment->comment_ID);
	    }
	}

	$authorLink = isset($comment_user->ID) ? $comment_user->display_name : get_comment_author($comment->comment_ID);
	?>
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<article id="comment-<?php comment_ID(); ?>" class="commentator-comment-content">
			<div class="commentator-avatar hovercard">
				<?php if(empty($commentUrl)){ ?>
					<div class="user">
						<?php echo $avatar; ?>
					</div>
				<?php } else {?>
		            <a href="<?php echo $commentUrl; ?>" class="user">
		                <?php echo $avatar; ?>
		            </a>
		        <?php }?>
	        </div>
	        <div class="commentator-comment-body">
	        	<div class="commentator-comment-header">
                    <span class="commentator-comment-byline">
	                    <span class="author publisher-anchor-color">
	                    	<?php if(empty($commentUrl)){ ?>
								<span class="user">
									<?php echo $authorLink; ?>
								</span>
							<?php } else {?>
					            <a href="<?php echo $commentUrl; ?>" class="user">
					                <?php echo $authorLink; ?>
					            </a>
					        <?php }?>
	                    </span>
                    </span>

                    <?php if ( isset($comment_user->ID) && $comment_user->ID == $post->post_author ){ ?>
                    <span class="commentator-comment-bullet time-ago-bullet">•</span>
                    <span class="commentator-comment-author-tag"><?php _e("author", "commentator"); ?></span>
                   	<?php } ?>

                   	<?php
			        if (class_exists('userpro_api') && isset($comment_user->ID) && $comment_user->ID > 0) {
				        ?>
                    	<span class="commentator-comment-bullet time-ago-bullet">•</span>
				        <span class="commentator-comment-badges">
			                 <?php echo userpro_show_badges($comment_user->ID, $inline = true); ?>
			            </span>
			            <?php
			            }
		            ?>


                    <div class="commentator-comment-meta">
                        <span class="commentator-comment-bullet time-ago-bullet">•</span>
						<?php
							$time = get_option('commentator_time-ago') ? sprintf(__('%1$s ago', 'commentator'), human_time_diff(get_comment_time('U'),current_time('timestamp'))) : sprintf(__( '%1$s at %2$s', 'commentator' ), get_comment_date(),get_comment_time());
							echo '<a href="'.esc_url( get_comment_link( $comment->comment_ID ) ).'" class="commentator-time" title="'.get_comment_time( 'c' ).'">'.$time.'</a>';
						?>
                    </div>

				    <ul class="commentator-comment-menu">
				        <li class="commentator-collapse">
				           <a class="commentator-toggle-visibility" href="#comment-<?php comment_ID(); ?>" title="Collapse">
								<i class="commentator-icon commentator-icon-minus"></i>
							</a>
				        </li>
				        <li class="commentator-expand">
				            <a class="commentator-toggle-visibility" href="#comment-<?php comment_ID(); ?>" title="Expand">
								<i class="commentator-icon commentator-icon-plus"></i>
							</a>
				        </li>
			            <?php
			            	$flag = get_option('commentator_flag-comment') && true;
			            	$delete = get_option('commentator_delete-comment') && (isset($comment_user->ID) && $voteAuthorID == $comment_user->ID);
			            	$atLeastTwo = $flag && $delete;

			            	if($atLeastTwo){
			            ?>
			            		<li class="commentator-dropdown">
									<a class="commentator-dropdown-toggle" href="#">
										<i class="commentator-icon <?php echo get_option('commentator_icon-comment-dropdown', 'commentator-icon-chevron-down'); ?>"></i>
									</a>
									<ul class="commentator-dropdown-menu">
						            <?php
						            	}
						            	if($flag){
						            ?>
						            	<li class="commentator-flag-comment">
											<a href="#" title="<?php _e( 'Flag comment', 'commentator' ); ?>" class="commentator-flag">
												<i class="commentator-icon <?php echo get_option('commentator_icon-comment-flag', 'commentator-icon-flag'); ?>"></i>
												<span><?php _e( 'Flag comment', 'commentator' ); ?></span>
											</a>
										</li>
									<?php 
										}
										if($delete){
						            ?>
						            	<li class="commentator-delete-comment">
											<a href="#" title="<?php _e( 'Delete comment', 'commentator' ); ?>" class="commentator-delete">
												<i class="commentator-icon <?php echo get_option('commentator_icon-comment-delete', 'commentator-icon-trash'); ?>"></i>
												<span><?php _e( 'Delete comment', 'commentator' ); ?></span>
											</a>
										</li>
									<?php 
										}
										if($atLeastTwo){
						            ?>
									</ul>
									<?php 
										} 
									?>
				    </ul>
                </div class="commentator-comment-header">
                <?php if ( '0' == $comment->comment_approved ) : ?>
				<p class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'commentator' ); ?></p>
				<?php endif; ?>


				<?php
					if(get_option('commentator_allow-images')){
						$image = get_comment_meta( $comment->comment_ID, "commentator-attached-image", true);
						if($image){
				?>

					<a class="commentator-attached-image" href="<?php echo $image; ?>" target="_blank">
						<img src="<?php echo $image; ?>"/>
					</a>

				<?php
						}
					}
				?>

				<section class="commentator-comment-text">

				<?php
					$comment_text = get_comment_text();
					if(get_option('commentator_enable-oembed')){
						global $wp_embed;
						$comment_text = $wp_embed->autoembed($comment_text);
					}
					if(get_option('commentator_enable-clickable-links')){
						$comment_text = make_clickable( $comment_text );
					}
					echo $comment_text;
				?>
				</section><!-- .comment-content -->

				<div class="commentator-comment-footer">
					<?php
						if(get_option('commentator_pick-comment')){
					?>
					<a href="#" class="commentator-pick<?php if($isPicked){ echo " commentator-active"; } if($voteAuthorID != $post->post_author){ echo " commentator-disabled"; } ?>" title="<?php _e( 'Pick comment', 'commentator' ); ?>">
						<i class="commentator-icon <?php echo get_option('commentator_icon-comment-pick', 'commentator-icon-thumb-tack'); ?>"></i>
					</a>
		            <span class="commentator-comment-bullet">•</span>
					<?php
						}
					?>
		            <span class="commentator-voting">
					    <a href="#" class="commentator-vote-up<?php if($hasUpVoted){ echo " commentator-active"; } ?>" title="<?php _e( 'Vote up', 'commentator' ); ?>" data-comment-id="<?php comment_ID(); ?>">
					        <span><?php echo count($upVotes); ?></span>
					        <i class="commentator-icon <?php echo get_option('commentator_icon-comment-upvote', 'commentator-icon-caret-up'); ?>"></i>
					    </a>
					    <a href="#" class="commentator-vote-down<?php if($hasDownVoted){ echo " commentator-active"; } ?>" title="<?php _e( 'Vote down', 'commentator' ); ?>" data-comment-id="<?php comment_ID(); ?>">
					        <span><?php echo count($downVotes); ?></span>
					        <i class="commentator-icon <?php echo get_option('commentator_icon-comment-downvote', 'commentator-icon-caret-down'); ?>"></i>
					    </a>
		            </span>
		            <?php global $comment_depth; ?>
		            <?php
		            	if($comment_depth < get_option('commentator_max_depth', 3)){
		            ?>
		            <span class="commentator-comment-bullet">•</span>
					<span>
						<a href="#" class="commentator-reply">
							<i class="commentator-icon <?php echo get_option('commentator_icon-comment-reply', 'commentator-icon-reply'); ?>"></i>
							<span><?php _e( 'Reply', 'commentator' ); ?></span>
						</a>
					</span>
					<?php } ?>

			    </div>
	        </div>
		</article><!-- #comment-## -->
	<?php
}

function commentator_atLeastTwo($a, $b, $c) {
    return $a ? ($b || $c) : ($b && $c);
}


function commentator_shortcode( $atts ){
	ob_start();
	comments_template();
	return ob_get_clean();
}
add_shortcode( 'commentator', 'commentator_shortcode' );

/**
 * Proper way to enqueue scripts and styles
**/

function commentator_scripts() {
	wp_enqueue_script( 'jquery.iframe-transport', plugins_url( '/js/jquery.iframe-transport.js', __FILE__ ), array( 'jquery' ), true);
	wp_enqueue_script( 'jquery.ui.widget', plugins_url( '/js/jquery.ui.widget.js', __FILE__ ), array( 'jquery' ), true);
	wp_enqueue_script( 'jquery.fileupload', plugins_url( '/js/jquery.fileupload.js', __FILE__ ), array( 'jquery', 'jquery.iframe-transport', 'jquery.ui.widget' ), true);
	wp_enqueue_script( 'commentator-script', plugins_url( '/js/commentator-script.js', __FILE__ ), array( 'jquery', 'jquery.fileupload' ), '2.3', true);
	wp_enqueue_style( 'commentator-style', plugins_url( '/css/commentator.css', __FILE__ ), '2.3' );
	wp_enqueue_style( 'commentator-font-awesome', plugins_url( '/css/font-awesome.min.css', __FILE__ ) );
}
if(!get_option('commentator_load-from-cdn')) {
	add_action( 'wp_enqueue_scripts', 'commentator_scripts', 15 );
}

function commentator_admin_scripts($hook) {
	global $commentator_settings_page;
 
	if( $hook != $commentator_settings_page ) 
		return;

	wp_enqueue_script( 'commentator-admin-script', plugins_url( '/js/commentator-admin-script.js', __FILE__ ), array( 'jquery' ), '1.0');
	wp_enqueue_style( 'commentator-admin-style', plugins_url( '/css/commentator-admin.css', __FILE__ ) );

	wp_enqueue_script( 'commentator-color-picker-script', plugins_url( '/colorpicker/js/colorpicker.js', __FILE__ ), array( 'jquery' ), '1.0');
	wp_enqueue_style( 'commentator-color-picker-style', plugins_url( '/colorpicker/css/colorpicker.css', __FILE__ ) );

	wp_enqueue_script( 'commentator-select2', plugins_url( '/select2/select2.js', __FILE__ ), array( 'jquery' ), '1.0');
	wp_enqueue_style( 'commentator-select2-style', plugins_url( '/select2/select2.css', __FILE__ ) );

	wp_enqueue_style( 'commentator-font-awesome', plugins_url( '/css/font-awesome.min.css', __FILE__ ) );
}
add_action( 'admin_enqueue_scripts', 'commentator_admin_scripts' );

add_filter('comments_template', 'commentator_template');
function commentator_template($passed){
	return dirname(__FILE__) . '/php/commentator-template.php';
}

function commentator_comment_columns( $columns )
{
	return array_merge( $columns, array(
		'upVote-count' => __( 'Upvotes', 'commentator' ),
		'downVote-count' => __( 'Downvotes', 'commentator' ),
		'flag-comment-count' => __( 'Flags', 'commentator' )
	) );
}
add_filter( 'manage_edit-comments_columns', 'commentator_comment_columns' );

function commentator_comment_column( $column, $comment_ID )
{
	if ( $meta = get_comment_meta( $comment_ID, $column , true ) ) {
		echo $meta;
	} else {
		echo '-';
	}
}
add_filter( 'manage_comments_custom_column', 'commentator_comment_column', 10, 2 );

// Register the column as sortable
function register_sortable_columns( $columns ) {
    return array_merge( $columns, array(
		'upVote-count' => 'upVote-count',
		'downVote-count' => 'downVote-count',
		'flag-comment-count' => 'flag-comment-count'
	) );
}
add_filter( 'manage_edit-comments_sortable_columns', 'register_sortable_columns' );

add_action( 'pre_get_comments', 'commentator_orderby' );  
function commentator_orderby( $comments ) {  
    $orderby = $comments->query_vars['orderby'];
    if( 'upVote-count' == $orderby || 'downVote-count' == $orderby || 'flag-comment-count' == $orderby ) {  
        $comments->query_vars['meta_key'] = $orderby;
        $comments->query_vars['orderby'] = 'meta_value_num';
    }
    $comments->meta_query->parse_query_vars( $comments->query_vars );
}

global $arrayProviders;
$arrayProviders = array(
	array(
		"Google",
		"google",
		"google-plus"
	),
	array(
		"LinkedIn",
		"linkedin",
		"linkedin"
	),
	array(
		"Facebook",
		"facebook",
		"facebook"
	),
	array(
		"Twitter",
		"twitter",
		"twitter"
	)
);

function register_commentator_settings(){
	global $arrayProviders;
	//register our settings
	register_setting( 'commentator-settings-group', 'commentator_max_depth' );
	register_setting( 'commentator-settings-group', 'commentator_anybody_register' );
	register_setting( 'commentator-settings-group', 'commentator_register_password_chose' );
	register_setting( 'commentator-settings-group', 'commentator_disable-login-tab' );
	register_setting( 'commentator-settings-group', 'commentator_before' );
	register_setting( 'commentator-settings-group', 'commentator_custom-menu' );
	register_setting( 'commentator-settings-group', 'commentator_disable-avatars' );
	register_setting( 'commentator-settings-group', 'commentator_disable-thread-votes' );
	register_setting( 'commentator-settings-group', 'commentator_allow-images' );
	register_setting( 'commentator-settings-group', 'commentator_enable-oembed' );
	register_setting( 'commentator-settings-group', 'commentator_enable-clickable-links' );
	register_setting( 'commentator-settings-group', 'commentator_order-tabs' );
	register_setting( 'commentator-settings-group', 'commentator_flag-comment' );
	register_setting( 'commentator-settings-group', 'commentator_pick-comment' );
	register_setting( 'commentator-settings-group', 'commentator_delete-comment' );
	register_setting( 'commentator-settings-group', 'commentator_flag-limit');
	register_setting( 'commentator-settings-group', 'commentator_user-roles' );
	register_setting( 'commentator-settings-group', 'commentator_time-ago');
	register_setting( 'commentator-settings-group', 'commentator_disabled-user-roles');


	register_setting( 'commentator-settings-group', 'commentator_updated-counts-in-db' );
	if(!get_option( 'commentator_updated-counts-in-db' )){
		update_option( 'commentator_updated-counts-in-db', '1' );
		$arrayComments = get_comments();
		foreach ($arrayComments as $comment) {
			$comment_ID = $comment->comment_ID;

			$countFlags = count(get_comment_meta($comment_ID, "flag-comment"));
	    	update_comment_meta($comment_ID, "flag-comment-count", $countFlags);

			$countDownVotes = count(get_comment_meta( $comment_ID, "downVote" ));
			update_comment_meta( $comment_ID, "downVote-count", $countDownVotes );

			$countUpVotes = count(get_comment_meta( $comment_ID, "upVote" ));
			update_comment_meta( $comment_ID, "upVote-count", $countUpVotes );
		}
	}
	register_setting( 'commentator-settings-group', 'commentator_base-theme' );

	register_setting( 'commentator-settings-group', 'commentator_icon-thread-vote' );
	register_setting( 'commentator-settings-group', 'commentator_color-thread-vote' );
	register_setting( 'commentator-settings-group', 'commentator_icon-thread-voted' );
	register_setting( 'commentator-settings-group', 'commentator_color-thread-voted' );
	register_setting( 'commentator-settings-group', 'commentator_color-up-voted' );
	register_setting( 'commentator-settings-group', 'commentator_color-down-voted' );
	register_setting( 'commentator-settings-group', 'commentator_color-picked' );
	register_setting( 'commentator-settings-group', 'commentator_icon-send-message' );
	register_setting( 'commentator-settings-group', 'commentator_icon-comment-upvote' );
	register_setting( 'commentator-settings-group', 'commentator_icon-comment-downvote' );
	register_setting( 'commentator-settings-group', 'commentator_icon-comment-reply' );
	register_setting( 'commentator-settings-group', 'commentator_icon-register' );
	register_setting( 'commentator-settings-group', 'commentator_icon-login' );
	register_setting( 'commentator-settings-group', 'commentator_icon-comment-flag' );
	register_setting( 'commentator-settings-group', 'commentator_icon-comment-pick' );
	register_setting( 'commentator-settings-group', 'commentator_icon-comment-delete' );

	register_setting( 'commentator-settings-group', 'commentator_social-signin' );
	foreach ($arrayProviders as $provider) {
		register_setting( 'commentator-settings-group', 'commentator_id_key-'.$provider[1] );
		register_setting( 'commentator-settings-group', 'commentator_secret_key-'.$provider[1] );
	}

	register_setting( 'commentator-settings-group', 'commentator_load-from-cdn' );

}

function commentator_add_pages() {
	global $commentator_settings_page;
	$commentator_settings_page = add_comments_page(__( 'Overview for the Commentator Plugin', 'commentator' ), __( 'Commentator', 'commentator' ), 'manage_options', 'commentator_overview', 'commentator_overview');

}

function icon_option($title, $name, $defaultIcon, $defaultColor){
?>
	<tr>
        <th scope="row"><?php echo $title; ?></th>
        <td>
            <?php icon_choose_option($name, $defaultIcon); ?>
        	<?php color_option($name, $defaultColor); ?>
        </td>
    </tr>
<?php
}

function icon_only_option($title, $name, $defaultIcon){
?>
	<tr>
        <th scope="row"><?php echo $title; ?></th>
        <td>
            <?php icon_choose_option($name, $defaultIcon); ?>
        </td>
    </tr>
<?php
}

function color_only_option($title, $name, $defaultColor){
?>
	<tr>
        <th scope="row"><?php echo $title; ?></th>
        <td>
            <?php color_option($name, $defaultColor); ?>
        </td>
    </tr>
<?php
}

function icon_choose_option($name, $defaultIcon){
?>
	<div class="commentator-icon-preview">
		<i class="commentator-icon commentator-icon-modal <?php echo get_option('commentator_icon-'.$name, $defaultIcon); ?>"></i>
	</div>
	<input class="commentator-icon-input" type="hidden" name="commentator_icon-<?php echo $name; ?>" value="<?php echo get_option('commentator_icon-'.$name, $defaultIcon); ?>" data-commentator-default="<?php echo $defaultIcon; ?>" />
<?php
}

function color_option($name, $defaultColor){
?>
	<div class="commentator-color-preview">
		<div style="background-color: <?php echo get_option('commentator_color-'.$name, $defaultColor); ?>;">
		</div>
	</div>
	<input class="commentator-color-input" type="hidden" name="commentator_color-<?php echo $name; ?>" value="<?php echo get_option('commentator_color-'.$name, $defaultColor); ?>" data-commentator-default="<?php echo $defaultColor; ?>"/>
<?php
}

function social_provider_option($provider_array){
	$provider = $provider_array[0];
	$provider_perma = $provider_array[1];
	$provider_icon = $provider_array[2];
	?>
		<tr>
	        <th scope="row"><?php echo $provider; ?></th>
	        <td class="commentator-form-icon-social">
	        	<i class="commentator-icon commentator-icon-<?php echo $provider_icon; ?>"></i>
	        </td>
	        <td>
	            <label>ID Key</label>
				<input type="text" name="commentator_id_key-<?php echo $provider_perma; ?>" value="<?php echo get_option('commentator_id_key-'.$provider_perma); ?>" data-commentator-default=""/>
				<label>Secret Key</label>
				<input type="text" name="commentator_secret_key-<?php echo $provider_perma; ?>" value="<?php echo get_option('commentator_secret_key-'.$provider_perma); ?>" data-commentator-default=""/>
	        </td>
	    </tr>
	<?php
}

function get_tab_name($key){
	$result = array(
		"asc" => __("Oldest", "commentator"),
		"desc" => __("Newest", "commentator"),
		"popular" => __("Best", "commentator"),
		"picked" => __("Picked", "commentator"),
	);
	return $result[$key];
}

function commentator_overview() {
	global $arrayProviders;
?>
<div id="commentator-admin-settings">
	<div class="wrap">
		<h2>Commentator Overview</h2>
	    <ul class="commentator-admin-tabs">
	    	<li>
	    		<a href="#commentator-admin-general" class="commentator-active"><?php _e( 'General', 'commentator' ); ?></a>
	    	</li>
	    	<li>
	    		<a href="#commentator-admin-icons"><?php _e( 'Icons', 'commentator' ); ?></a>
	    	</li>
	    	<li>
	    		<a href="#commentator-admin-style"><?php _e( 'Style', 'commentator' ); ?></a>
	    	</li>
	    	<li>
	    		<a href="#commentator-admin-social"><?php _e( 'Social', 'commentator' ); ?></a>
	    	</li>
	    	<li>
	    		<a href="#commentator-admin-advanced"><?php _e( 'Advanced', 'commentator' ); ?></a>
	    	</li>
	    </ul>
		<form method="post" action="options.php">
		    <?php settings_fields( 'commentator-settings-group' ); ?>
		    <?php do_settings_sections( 'commentator-settings-group' ); ?>

			<div class="commentator-admin-wrapper">
			    <div class="commentator-tabs-content">
			    	<div id="commentator-admin-general" class="commentator-tab-content commentator-active">
					    <table class="form-table">
					        <tr>
						        <th scope="row"><?php _e( 'Max Threaded Comments Depth (default : 3)', 'commentator' ); ?></th>
						        <td><input type="text" name="commentator_max_depth" value="<?php echo get_option('commentator_max_depth', 3); ?>" data-commentator-default="3"/></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Anybody can register ?', 'commentator' ); ?></th>
						        <td><input name="commentator_anybody_register" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_anybody_register' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Human readable time (ago) ?', 'commentator' ); ?></th>
						        <td><input name="commentator_time-ago" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_time-ago' ) ); ?> /></td>
					        </tr>
					        <tr>
					        	 <th scope="row"><?php _e( 'Chose your password when registering ?', 'commentator' ); ?></th>
						        <td><input name="commentator_register_password_chose" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_register_password_chose' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Disable login tab ?', 'commentator' ); ?></th>
						        <td><input name="commentator_disable-login-tab" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_disable-login-tab' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Enable comment flagging ?', 'commentator' ); ?></th>
						        <td><input name="commentator_flag-comment" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_flag-comment' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Enable comment deletion by their author ?', 'commentator' ); ?></th>
						        <td><input name="commentator_delete-comment" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_delete-comment' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Enable comment picking ?', 'commentator' ); ?></th>
						        <td><input name="commentator_pick-comment" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_pick-comment' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'From how many flags untill a comment gets unapproved (leave blank for no automation)', 'commentator' ); ?></th>
						        <td><input type="text" name="commentator_flag-limit" value="<?php echo get_option('commentator_flag-limit'); ?>"/></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Disable thread votes ?', 'commentator' ); ?></th>
						        <td><input name="commentator_disable-thread-votes" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_disable-thread-votes' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Section of content before the commenting section', 'commentator' ); ?></th>
						        <td><textarea name="commentator_before"><?php echo get_option('commentator_before', '') ?></textarea></td>
					        </tr>

					        <tr>
						        <th scope="row"><?php _e( 'Custom menu html', 'commentator' ); ?></th>
						        <td><textarea name="commentator_custom-menu"><?php echo get_option('commentator_custom-menu', '') ?></textarea></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Disable avatars ?', 'commentator' ); ?></th>
						        <td><input name="commentator_disable-avatars" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_disable-avatars' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Enable images uploads ?', 'commentator' ); ?></th>
						        <td><input name="commentator_allow-images" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_allow-images' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Enable oEmbed ?', 'commentator' ); ?></th>
						        <td><input name="commentator_enable-oembed" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_enable-oembed' ) ); ?> /></td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Enable clickable links ?', 'commentator' ); ?></th>
						        <td><input name="commentator_enable-clickable-links" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_enable-clickable-links' ) ); ?> /></td>
					        </tr>
					        <tr>
					        	<?php
					        		$tabs = get_option( 'commentator_order-tabs', 'picked,popular,asc,desc|');
					        		$arrayTabs = explode( "|", $tabs );
					        		$enabledTabs = explode( ",", $arrayTabs[0] );
					        		$disabledTabs = explode( ",", $arrayTabs[1] );
					        	?>
						        <th scope="row"><?php _e( 'Order and Disable Tabs ?', 'commentator' ); ?></th>
						        <td>
						        	<span><?php _e( 'Enabled Tabs', 'commentator' ); ?></span>
						        	<div class="commentator-tab-sortable" id="commentator-enabled-tabs">
						        		<?php
						        			foreach ($enabledTabs as $value) {
						        				if(!empty($value)){
											    ?>
											    <div class="commentator-tab" data-commentator-tab="<?php echo $value; ?>">
											    	<span><?php echo get_tab_name($value); ?></span>
											    </div>
											    <?php
												}
											}
						        		?>
						        	</div>
						          	<input id="commentator_order-tabs" name="commentator_order-tabs" type="hidden" value="<?php echo get_option( 'commentator_order-tabs', 'picked,popular,asc,desc|'); ?>">
						        </td>
						        <td>
						        	<span><?php _e( 'Disabled Tabs', 'commentator' ); ?></span>
						        	<div class="commentator-tab-sortable" id="commentator-disabled-tabs">
						        		<?php
						        			foreach ($disabledTabs as $value) {
						        				if(!empty($value)){
											    ?>
											    <div class="commentator-tab" data-commentator-tab="<?php echo $value; ?>">
											    	<span><?php echo get_tab_name($value); ?></span>
											    </div>
											    <?php
												}
											}
						        		?>
						        	</div>
						        </td>
					        </tr>
					        <tr>
						        <th scope="row"><?php _e( 'Disable commenting abilities to some user roles ?', 'commentator' ); ?></th>
						        <td colspan="2">
						        	<?php
											// create a new role for Members
											$roles = get_option('commentator_disabled-user-roles', array());
											$roles = is_array($roles) ? $roles : array();
											global $wp_roles;
    										$allRoles = $wp_roles->get_names();
    								?>
						        	<select class="commentator-select2" name="commentator_disabled-user-roles[]" multiple style="width:100%;">
						        			<?php
						        		
											foreach ($allRoles as $role_name => $role_info){
												$selected = in_array ( $role_name, $roles ) ? " selected" : "";
											?>
												<option value="<?php echo $role_name; ?>"<?php echo $selected; ?>><?php echo $role_info; ?></option>
											<?php
											}
						        		?>
						        	</select>
						        </td>
					        </tr>
					    </table>
					</div>
					<div id="commentator-admin-style" class="commentator-tab-content">
					    <table class="form-table">
					    	<tr>
						        <th scope="row"><?php _e( 'Base Theme', 'commentator' ); ?></th>
						        <td>
						        	<?php
											// create a new role for Members
											$selectedTheme = get_option('commentator_base-theme', 'light');
    										$allThemes = array('light', 'dark', 'boxed');
    								?>
						        	<select class="commentator-select2" name="commentator_base-theme" style="width:100%;">
						        			<?php
						        		
											foreach ($allThemes as $theme){
												$selected = ($selectedTheme == $theme) ? " selected" : "";
											?>
												<option value="<?php echo $theme; ?>"<?php echo $selected; ?>><?php echo $theme; ?></option>
											<?php
											}
						        		?>
						        	</select>
						        </td>
					        </tr>
					    </table>
					</div>
					<div id="commentator-admin-icons" class="commentator-tab-content">
					    <table class="form-table">
					        <?php icon_option(__( 'Icon and color for thread voting', 'commentator' ), 'thread-vote', 'commentator-icon-star', '#ffbf00'); ?>
					        <?php icon_only_option(__( 'Icon for thread voted', 'commentator' ), 'thread-voted', 'commentator-icon-check'); ?>
					        <?php color_only_option(__( 'Color when the thread is voted', 'commentator' ), 'thread-voted', '#8fc847'); ?>
					        <?php icon_only_option(__( 'Icon for comment button', 'commentator' ), 'send-message', 'commentator-icon-rocket'); ?>
					        <?php icon_only_option(__( 'Icon for comment upvote', 'commentator' ), 'comment-upvote', 'commentator-icon-caret-up'); ?>
					        <?php icon_only_option(__( 'Icon for comment downvote', 'commentator' ), 'comment-downvote', 'commentator-icon-chevron-down'); ?>
					        <?php icon_only_option(__( 'Icon for comment flagging', 'commentator' ), 'comment-flag', 'commentator-icon-flag'); ?>
					        <?php icon_only_option(__( 'Icon to pick a comment', 'commentator' ), 'comment-pick', 'commentator-icon-thumb-tack'); ?>
					        <?php icon_only_option(__( 'Icon to delete a comment', 'commentator' ), 'comment-delete', 'commentator-icon-trash'); ?>
					        <?php icon_only_option(__( 'Icon for comment reply', 'commentator' ), 'comment-reply', 'commentator-icon-reply'); ?>
					        <?php icon_only_option(__( 'Icon for comment register', 'commentator' ), 'register', 'commentator-icon-arrow-right'); ?>
					        <?php icon_only_option(__( 'Icon for comment login', 'commentator' ), 'login', 'commentator-icon-arrow-right'); ?>
					        <?php color_only_option(__( 'Color when a comment is down voted', 'commentator' ), 'down-voted', '#f55567'); ?>
					        <?php color_only_option(__( 'Color when a comment is up voted', 'commentator' ), 'up-voted', '#2e9fff'); ?>
					        <?php color_only_option(__( 'Color when a comment is picked', 'commentator' ), 'picked', '#8fc847'); ?>
					    </table>
					</div>
					<div id="commentator-admin-social" class="commentator-tab-content">
					    <table class="form-table">
					        <tr>
						        <th scope="row"><?php _e( 'Enable Social Signin ?', 'commentator' ); ?></th>
						        <td><input name="commentator_social-signin" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_social-signin' ) ); ?> /></td>
					        </tr>
					        <?php 
					        	foreach ($arrayProviders as $provider) {
									social_provider_option($provider);
								}
							?>
					    </table>
					</div>
					<div id="commentator-admin-advanced" class="commentator-tab-content">
					    <table class="form-table">
					        <tr>
						        <th scope="row"><?php _e( 'I load my scripts myself from my CDN', 'commentator' ); ?></th>
						        <td><input name="commentator_load-from-cdn" type="checkbox" value="1" <?php checked( '1', get_option( 'commentator_load-from-cdn' ) ); ?> /></td>
					        </tr>
					    </table>
					</div>
				</div>
			</div>
			<div class="commentator-admin-footer"><!-- 
		    	<a href="#" class="commentator-reset-default">Reset all to defaults</a>    --> 
		    	<?php submit_button( 'Submit', 'primary', 'submit-form', false ); ?>
		    </div>
		</form>
	</div>
	<div id="commentator-modal-overlay">
		<section id="commentator-icons">
			<h3><?php _e( 'Choose an icon', 'commentator' ); ?></h3>
			<div id="commentator-icon-list">
				<i class="commentator-icon commentator-icon-glass"></i>
				<i class="commentator-icon commentator-icon-music"></i>
				<i class="commentator-icon commentator-icon-search"></i>
				<i class="commentator-icon commentator-icon-envelope-o"></i>
				<i class="commentator-icon commentator-icon-heart"></i>
				<i class="commentator-icon commentator-icon-star"></i>
				<i class="commentator-icon commentator-icon-star-o"></i>
				<i class="commentator-icon commentator-icon-user"></i>
				<i class="commentator-icon commentator-icon-film"></i>
				<i class="commentator-icon commentator-icon-th-large"></i>
				<i class="commentator-icon commentator-icon-th"></i>
				<i class="commentator-icon commentator-icon-th-list"></i>
				<i class="commentator-icon commentator-icon-check"></i>
				<i class="commentator-icon commentator-icon-times"></i>
				<i class="commentator-icon commentator-icon-search-plus"></i>
				<i class="commentator-icon commentator-icon-search-minus"></i>
				<i class="commentator-icon commentator-icon-power-off"></i>
				<i class="commentator-icon commentator-icon-signal"></i>
				<i class="commentator-icon commentator-icon-cog"></i>
				<i class="commentator-icon commentator-icon-trash-o"></i>
				<i class="commentator-icon commentator-icon-home"></i>
				<i class="commentator-icon commentator-icon-file-o"></i>
				<i class="commentator-icon commentator-icon-clock-o"></i>
				<i class="commentator-icon commentator-icon-road"></i>
				<i class="commentator-icon commentator-icon-download"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-o-down"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-o-up"></i>
				<i class="commentator-icon commentator-icon-inbox"></i>
				<i class="commentator-icon commentator-icon-play-circle-o"></i>
				<i class="commentator-icon commentator-icon-repeat"></i>
				<i class="commentator-icon commentator-icon-refresh"></i>
				<i class="commentator-icon commentator-icon-list-alt"></i>
				<i class="commentator-icon commentator-icon-lock"></i>
				<i class="commentator-icon commentator-icon-flag"></i>
				<i class="commentator-icon commentator-icon-headphones"></i>
				<i class="commentator-icon commentator-icon-volume-off"></i>
				<i class="commentator-icon commentator-icon-volume-down"></i>
				<i class="commentator-icon commentator-icon-volume-up"></i>
				<i class="commentator-icon commentator-icon-qrcode"></i>
				<i class="commentator-icon commentator-icon-barcode"></i>
				<i class="commentator-icon commentator-icon-tag"></i>
				<i class="commentator-icon commentator-icon-tags"></i>
				<i class="commentator-icon commentator-icon-book"></i>
				<i class="commentator-icon commentator-icon-bookmark"></i>
				<i class="commentator-icon commentator-icon-print"></i>
				<i class="commentator-icon commentator-icon-camera"></i>
				<i class="commentator-icon commentator-icon-font"></i>
				<i class="commentator-icon commentator-icon-bold"></i>
				<i class="commentator-icon commentator-icon-italic"></i>
				<i class="commentator-icon commentator-icon-text-height"></i>
				<i class="commentator-icon commentator-icon-text-width"></i>
				<i class="commentator-icon commentator-icon-align-left"></i>
				<i class="commentator-icon commentator-icon-align-center"></i>
				<i class="commentator-icon commentator-icon-align-right"></i>
				<i class="commentator-icon commentator-icon-align-justify"></i>
				<i class="commentator-icon commentator-icon-list"></i>
				<i class="commentator-icon commentator-icon-outdent"></i>
				<i class="commentator-icon commentator-icon-indent"></i>
				<i class="commentator-icon commentator-icon-video-camera"></i>
				<i class="commentator-icon commentator-icon-picture-o"></i>
				<i class="commentator-icon commentator-icon-pencil"></i>
				<i class="commentator-icon commentator-icon-map-marker"></i>
				<i class="commentator-icon commentator-icon-adjust"></i>
				<i class="commentator-icon commentator-icon-tint"></i>
				<i class="commentator-icon commentator-icon-pencil-square-o"></i>
				<i class="commentator-icon commentator-icon-share-square-o"></i>
				<i class="commentator-icon commentator-icon-check-square-o"></i>
				<i class="commentator-icon commentator-icon-arrows"></i>
				<i class="commentator-icon commentator-icon-step-backward"></i>
				<i class="commentator-icon commentator-icon-fast-backward"></i>
				<i class="commentator-icon commentator-icon-backward"></i>
				<i class="commentator-icon commentator-icon-play"></i>
				<i class="commentator-icon commentator-icon-pause"></i>
				<i class="commentator-icon commentator-icon-stop"></i>
				<i class="commentator-icon commentator-icon-forward"></i>
				<i class="commentator-icon commentator-icon-fast-forward"></i>
				<i class="commentator-icon commentator-icon-step-forward"></i>
				<i class="commentator-icon commentator-icon-eject"></i>
				<i class="commentator-icon commentator-icon-chevron-left"></i>
				<i class="commentator-icon commentator-icon-chevron-right"></i>
				<i class="commentator-icon commentator-icon-plus-circle"></i>
				<i class="commentator-icon commentator-icon-minus-circle"></i>
				<i class="commentator-icon commentator-icon-times-circle"></i>
				<i class="commentator-icon commentator-icon-check-circle"></i>
				<i class="commentator-icon commentator-icon-question-circle"></i>
				<i class="commentator-icon commentator-icon-info-circle"></i>
				<i class="commentator-icon commentator-icon-crosshairs"></i>
				<i class="commentator-icon commentator-icon-times-circle-o"></i>
				<i class="commentator-icon commentator-icon-check-circle-o"></i>
				<i class="commentator-icon commentator-icon-ban"></i>
				<i class="commentator-icon commentator-icon-arrow-left"></i>
				<i class="commentator-icon commentator-icon-arrow-right"></i>
				<i class="commentator-icon commentator-icon-arrow-up"></i>
				<i class="commentator-icon commentator-icon-arrow-down"></i>
				<i class="commentator-icon commentator-icon-share"></i>
				<i class="commentator-icon commentator-icon-expand"></i>
				<i class="commentator-icon commentator-icon-compress"></i>
				<i class="commentator-icon commentator-icon-plus"></i>
				<i class="commentator-icon commentator-icon-minus"></i>
				<i class="commentator-icon commentator-icon-asterisk"></i>
				<i class="commentator-icon commentator-icon-exclamation-circle"></i>
				<i class="commentator-icon commentator-icon-gift"></i>
				<i class="commentator-icon commentator-icon-leaf"></i>
				<i class="commentator-icon commentator-icon-fire"></i>
				<i class="commentator-icon commentator-icon-eye"></i>
				<i class="commentator-icon commentator-icon-eye-slash"></i>
				<i class="commentator-icon commentator-icon-exclamation-triangle"></i>
				<i class="commentator-icon commentator-icon-plane"></i>
				<i class="commentator-icon commentator-icon-calendar"></i>
				<i class="commentator-icon commentator-icon-random"></i>
				<i class="commentator-icon commentator-icon-comment"></i>
				<i class="commentator-icon commentator-icon-magnet"></i>
				<i class="commentator-icon commentator-icon-chevron-up"></i>
				<i class="commentator-icon commentator-icon-chevron-down"></i>
				<i class="commentator-icon commentator-icon-retweet"></i>
				<i class="commentator-icon commentator-icon-shopping-cart"></i>
				<i class="commentator-icon commentator-icon-folder"></i>
				<i class="commentator-icon commentator-icon-folder-open"></i>
				<i class="commentator-icon commentator-icon-arrows-v"></i>
				<i class="commentator-icon commentator-icon-arrows-h"></i>
				<i class="commentator-icon commentator-icon-bar-chart"></i>
				<i class="commentator-icon commentator-icon-twitter-square"></i>
				<i class="commentator-icon commentator-icon-facebook-square"></i>
				<i class="commentator-icon commentator-icon-camera-retro"></i>
				<i class="commentator-icon commentator-icon-key"></i>
				<i class="commentator-icon commentator-icon-cogs"></i>
				<i class="commentator-icon commentator-icon-comments"></i>
				<i class="commentator-icon commentator-icon-thumbs-o-up"></i>
				<i class="commentator-icon commentator-icon-thumbs-o-down"></i>
				<i class="commentator-icon commentator-icon-star-half"></i>
				<i class="commentator-icon commentator-icon-heart-o"></i>
				<i class="commentator-icon commentator-icon-sign-out"></i>
				<i class="commentator-icon commentator-icon-linkedin-square"></i>
				<i class="commentator-icon commentator-icon-thumb-tack"></i>
				<i class="commentator-icon commentator-icon-external-link"></i>
				<i class="commentator-icon commentator-icon-sign-in"></i>
				<i class="commentator-icon commentator-icon-trophy"></i>
				<i class="commentator-icon commentator-icon-github-square"></i>
				<i class="commentator-icon commentator-icon-upload"></i>
				<i class="commentator-icon commentator-icon-lemon-o"></i>
				<i class="commentator-icon commentator-icon-phone"></i>
				<i class="commentator-icon commentator-icon-square-o"></i>
				<i class="commentator-icon commentator-icon-bookmark-o"></i>
				<i class="commentator-icon commentator-icon-phone-square"></i>
				<i class="commentator-icon commentator-icon-twitter"></i>
				<i class="commentator-icon commentator-icon-facebook"></i>
				<i class="commentator-icon commentator-icon-github"></i>
				<i class="commentator-icon commentator-icon-unlock"></i>
				<i class="commentator-icon commentator-icon-credit-card"></i>
				<i class="commentator-icon commentator-icon-rss"></i>
				<i class="commentator-icon commentator-icon-hdd-o"></i>
				<i class="commentator-icon commentator-icon-bullhorn"></i>
				<i class="commentator-icon commentator-icon-bell"></i>
				<i class="commentator-icon commentator-icon-certificate"></i>
				<i class="commentator-icon commentator-icon-hand-o-right"></i>
				<i class="commentator-icon commentator-icon-hand-o-left"></i>
				<i class="commentator-icon commentator-icon-hand-o-up"></i>
				<i class="commentator-icon commentator-icon-hand-o-down"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-left"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-right"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-up"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-down"></i>
				<i class="commentator-icon commentator-icon-globe"></i>
				<i class="commentator-icon commentator-icon-wrench"></i>
				<i class="commentator-icon commentator-icon-tasks"></i>
				<i class="commentator-icon commentator-icon-filter"></i>
				<i class="commentator-icon commentator-icon-briefcase"></i>
				<i class="commentator-icon commentator-icon-arrows-alt"></i>
				<i class="commentator-icon commentator-icon-users"></i>
				<i class="commentator-icon commentator-icon-link"></i>
				<i class="commentator-icon commentator-icon-cloud"></i>
				<i class="commentator-icon commentator-icon-flask"></i>
				<i class="commentator-icon commentator-icon-scissors"></i>
				<i class="commentator-icon commentator-icon-files-o"></i>
				<i class="commentator-icon commentator-icon-paperclip"></i>
				<i class="commentator-icon commentator-icon-floppy-o"></i>
				<i class="commentator-icon commentator-icon-square"></i>
				<i class="commentator-icon commentator-icon-bars"></i>
				<i class="commentator-icon commentator-icon-list-ul"></i>
				<i class="commentator-icon commentator-icon-list-ol"></i>
				<i class="commentator-icon commentator-icon-strikethrough"></i>
				<i class="commentator-icon commentator-icon-underline"></i>
				<i class="commentator-icon commentator-icon-table"></i>
				<i class="commentator-icon commentator-icon-magic"></i>
				<i class="commentator-icon commentator-icon-truck"></i>
				<i class="commentator-icon commentator-icon-pinterest"></i>
				<i class="commentator-icon commentator-icon-pinterest-square"></i>
				<i class="commentator-icon commentator-icon-google-plus-square"></i>
				<i class="commentator-icon commentator-icon-google-plus"></i>
				<i class="commentator-icon commentator-icon-money"></i>
				<i class="commentator-icon commentator-icon-caret-down"></i>
				<i class="commentator-icon commentator-icon-caret-up"></i>
				<i class="commentator-icon commentator-icon-caret-left"></i>
				<i class="commentator-icon commentator-icon-caret-right"></i>
				<i class="commentator-icon commentator-icon-columns"></i>
				<i class="commentator-icon commentator-icon-sort"></i>
				<i class="commentator-icon commentator-icon-sort-desc"></i>
				<i class="commentator-icon commentator-icon-sort-asc"></i>
				<i class="commentator-icon commentator-icon-envelope"></i>
				<i class="commentator-icon commentator-icon-linkedin"></i>
				<i class="commentator-icon commentator-icon-undo"></i>
				<i class="commentator-icon commentator-icon-gavel"></i>
				<i class="commentator-icon commentator-icon-tachometer"></i>
				<i class="commentator-icon commentator-icon-comment-o"></i>
				<i class="commentator-icon commentator-icon-comments-o"></i>
				<i class="commentator-icon commentator-icon-bolt"></i>
				<i class="commentator-icon commentator-icon-sitemap"></i>
				<i class="commentator-icon commentator-icon-umbrella"></i>
				<i class="commentator-icon commentator-icon-clipboard"></i>
				<i class="commentator-icon commentator-icon-lightbulb-o"></i>
				<i class="commentator-icon commentator-icon-exchange"></i>
				<i class="commentator-icon commentator-icon-cloud-download"></i>
				<i class="commentator-icon commentator-icon-cloud-upload"></i>
				<i class="commentator-icon commentator-icon-user-md"></i>
				<i class="commentator-icon commentator-icon-stethoscope"></i>
				<i class="commentator-icon commentator-icon-suitcase"></i>
				<i class="commentator-icon commentator-icon-bell-o"></i>
				<i class="commentator-icon commentator-icon-coffee"></i>
				<i class="commentator-icon commentator-icon-cutlery"></i>
				<i class="commentator-icon commentator-icon-file-text-o"></i>
				<i class="commentator-icon commentator-icon-building-o"></i>
				<i class="commentator-icon commentator-icon-hospital-o"></i>
				<i class="commentator-icon commentator-icon-ambulance"></i>
				<i class="commentator-icon commentator-icon-medkit"></i>
				<i class="commentator-icon commentator-icon-fighter-jet"></i>
				<i class="commentator-icon commentator-icon-beer"></i>
				<i class="commentator-icon commentator-icon-h-square"></i>
				<i class="commentator-icon commentator-icon-plus-square"></i>
				<i class="commentator-icon commentator-icon-angle-double-left"></i>
				<i class="commentator-icon commentator-icon-angle-double-right"></i>
				<i class="commentator-icon commentator-icon-angle-double-up"></i>
				<i class="commentator-icon commentator-icon-angle-double-down"></i>
				<i class="commentator-icon commentator-icon-angle-left"></i>
				<i class="commentator-icon commentator-icon-angle-right"></i>
				<i class="commentator-icon commentator-icon-angle-up"></i>
				<i class="commentator-icon commentator-icon-angle-down"></i>
				<i class="commentator-icon commentator-icon-desktop"></i>
				<i class="commentator-icon commentator-icon-laptop"></i>
				<i class="commentator-icon commentator-icon-tablet"></i>
				<i class="commentator-icon commentator-icon-mobile"></i>
				<i class="commentator-icon commentator-icon-circle-o"></i>
				<i class="commentator-icon commentator-icon-quote-left"></i>
				<i class="commentator-icon commentator-icon-quote-right"></i>
				<i class="commentator-icon commentator-icon-spinner"></i>
				<i class="commentator-icon commentator-icon-circle"></i>
				<i class="commentator-icon commentator-icon-reply"></i>
				<i class="commentator-icon commentator-icon-github-alt"></i>
				<i class="commentator-icon commentator-icon-folder-o"></i>
				<i class="commentator-icon commentator-icon-folder-open-o"></i>
				<i class="commentator-icon commentator-icon-smile-o"></i>
				<i class="commentator-icon commentator-icon-frown-o"></i>
				<i class="commentator-icon commentator-icon-meh-o"></i>
				<i class="commentator-icon commentator-icon-gamepad"></i>
				<i class="commentator-icon commentator-icon-keyboard-o"></i>
				<i class="commentator-icon commentator-icon-flag-o"></i>
				<i class="commentator-icon commentator-icon-flag-checkered"></i>
				<i class="commentator-icon commentator-icon-terminal"></i>
				<i class="commentator-icon commentator-icon-code"></i>
				<i class="commentator-icon commentator-icon-reply-all"></i>
				<i class="commentator-icon commentator-icon-star-half-o"></i>
				<i class="commentator-icon commentator-icon-location-arrow"></i>
				<i class="commentator-icon commentator-icon-crop"></i>
				<i class="commentator-icon commentator-icon-code-fork"></i>
				<i class="commentator-icon commentator-icon-chain-broken"></i>
				<i class="commentator-icon commentator-icon-question"></i>
				<i class="commentator-icon commentator-icon-info"></i>
				<i class="commentator-icon commentator-icon-exclamation"></i>
				<i class="commentator-icon commentator-icon-superscript"></i>
				<i class="commentator-icon commentator-icon-subscript"></i>
				<i class="commentator-icon commentator-icon-eraser"></i>
				<i class="commentator-icon commentator-icon-puzzle-piece"></i>
				<i class="commentator-icon commentator-icon-microphone"></i>
				<i class="commentator-icon commentator-icon-microphone-slash"></i>
				<i class="commentator-icon commentator-icon-shield"></i>
				<i class="commentator-icon commentator-icon-calendar-o"></i>
				<i class="commentator-icon commentator-icon-fire-extinguisher"></i>
				<i class="commentator-icon commentator-icon-rocket"></i>
				<i class="commentator-icon commentator-icon-maxcdn"></i>
				<i class="commentator-icon commentator-icon-chevron-circle-left"></i>
				<i class="commentator-icon commentator-icon-chevron-circle-right"></i>
				<i class="commentator-icon commentator-icon-chevron-circle-up"></i>
				<i class="commentator-icon commentator-icon-chevron-circle-down"></i>
				<i class="commentator-icon commentator-icon-html5"></i>
				<i class="commentator-icon commentator-icon-css3"></i>
				<i class="commentator-icon commentator-icon-anchor"></i>
				<i class="commentator-icon commentator-icon-unlock-alt"></i>
				<i class="commentator-icon commentator-icon-bullseye"></i>
				<i class="commentator-icon commentator-icon-ellipsis-h"></i>
				<i class="commentator-icon commentator-icon-ellipsis-v"></i>
				<i class="commentator-icon commentator-icon-rss-square"></i>
				<i class="commentator-icon commentator-icon-play-circle"></i>
				<i class="commentator-icon commentator-icon-ticket"></i>
				<i class="commentator-icon commentator-icon-minus-square"></i>
				<i class="commentator-icon commentator-icon-minus-square-o"></i>
				<i class="commentator-icon commentator-icon-level-up"></i>
				<i class="commentator-icon commentator-icon-level-down"></i>
				<i class="commentator-icon commentator-icon-check-square"></i>
				<i class="commentator-icon commentator-icon-pencil-square"></i>
				<i class="commentator-icon commentator-icon-external-link-square"></i>
				<i class="commentator-icon commentator-icon-share-square"></i>
				<i class="commentator-icon commentator-icon-compass"></i>
				<i class="commentator-icon commentator-icon-caret-square-o-down"></i>
				<i class="commentator-icon commentator-icon-caret-square-o-up"></i>
				<i class="commentator-icon commentator-icon-caret-square-o-right"></i>
				<i class="commentator-icon commentator-icon-eur"></i>
				<i class="commentator-icon commentator-icon-gbp"></i>
				<i class="commentator-icon commentator-icon-usd"></i>
				<i class="commentator-icon commentator-icon-inr"></i>
				<i class="commentator-icon commentator-icon-jpy"></i>
				<i class="commentator-icon commentator-icon-rub"></i>
				<i class="commentator-icon commentator-icon-krw"></i>
				<i class="commentator-icon commentator-icon-btc"></i>
				<i class="commentator-icon commentator-icon-file"></i>
				<i class="commentator-icon commentator-icon-file-text"></i>
				<i class="commentator-icon commentator-icon-sort-alpha-asc"></i>
				<i class="commentator-icon commentator-icon-sort-alpha-desc"></i>
				<i class="commentator-icon commentator-icon-sort-amount-asc"></i>
				<i class="commentator-icon commentator-icon-sort-amount-desc"></i>
				<i class="commentator-icon commentator-icon-sort-numeric-asc"></i>
				<i class="commentator-icon commentator-icon-sort-numeric-desc"></i>
				<i class="commentator-icon commentator-icon-thumbs-up"></i>
				<i class="commentator-icon commentator-icon-thumbs-down"></i>
				<i class="commentator-icon commentator-icon-youtube-square"></i>
				<i class="commentator-icon commentator-icon-youtube"></i>
				<i class="commentator-icon commentator-icon-xing"></i>
				<i class="commentator-icon commentator-icon-xing-square"></i>
				<i class="commentator-icon commentator-icon-youtube-play"></i>
				<i class="commentator-icon commentator-icon-dropbox"></i>
				<i class="commentator-icon commentator-icon-stack-overflow"></i>
				<i class="commentator-icon commentator-icon-instagram"></i>
				<i class="commentator-icon commentator-icon-flickr"></i>
				<i class="commentator-icon commentator-icon-adn"></i>
				<i class="commentator-icon commentator-icon-bitbucket"></i>
				<i class="commentator-icon commentator-icon-bitbucket-square"></i>
				<i class="commentator-icon commentator-icon-tumblr"></i>
				<i class="commentator-icon commentator-icon-tumblr-square"></i>
				<i class="commentator-icon commentator-icon-long-arrow-down"></i>
				<i class="commentator-icon commentator-icon-long-arrow-up"></i>
				<i class="commentator-icon commentator-icon-long-arrow-left"></i>
				<i class="commentator-icon commentator-icon-long-arrow-right"></i>
				<i class="commentator-icon commentator-icon-apple"></i>
				<i class="commentator-icon commentator-icon-windows"></i>
				<i class="commentator-icon commentator-icon-android"></i>
				<i class="commentator-icon commentator-icon-linux"></i>
				<i class="commentator-icon commentator-icon-dribbble"></i>
				<i class="commentator-icon commentator-icon-skype"></i>
				<i class="commentator-icon commentator-icon-foursquare"></i>
				<i class="commentator-icon commentator-icon-trello"></i>
				<i class="commentator-icon commentator-icon-female"></i>
				<i class="commentator-icon commentator-icon-male"></i>
				<i class="commentator-icon commentator-icon-gratipay"></i>
				<i class="commentator-icon commentator-icon-sun-o"></i>
				<i class="commentator-icon commentator-icon-moon-o"></i>
				<i class="commentator-icon commentator-icon-archive"></i>
				<i class="commentator-icon commentator-icon-bug"></i>
				<i class="commentator-icon commentator-icon-vk"></i>
				<i class="commentator-icon commentator-icon-weibo"></i>
				<i class="commentator-icon commentator-icon-renren"></i>
				<i class="commentator-icon commentator-icon-pagelines"></i>
				<i class="commentator-icon commentator-icon-stack-exchange"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-o-right"></i>
				<i class="commentator-icon commentator-icon-arrow-circle-o-left"></i>
				<i class="commentator-icon commentator-icon-caret-square-o-left"></i>
				<i class="commentator-icon commentator-icon-dot-circle-o"></i>
				<i class="commentator-icon commentator-icon-wheelchair"></i>
				<i class="commentator-icon commentator-icon-vimeo-square"></i>
				<i class="commentator-icon commentator-icon-try"></i>
				<i class="commentator-icon commentator-icon-plus-square-o"></i>
				<i class="commentator-icon commentator-icon-space-shuttle"></i>
				<i class="commentator-icon commentator-icon-slack"></i>
				<i class="commentator-icon commentator-icon-envelope-square"></i>
				<i class="commentator-icon commentator-icon-wordpress"></i>
				<i class="commentator-icon commentator-icon-openid"></i>
				<i class="commentator-icon commentator-icon-university"></i>
				<i class="commentator-icon commentator-icon-graduation-cap"></i>
				<i class="commentator-icon commentator-icon-yahoo"></i>
				<i class="commentator-icon commentator-icon-google"></i>
				<i class="commentator-icon commentator-icon-reddit"></i>
				<i class="commentator-icon commentator-icon-reddit-square"></i>
				<i class="commentator-icon commentator-icon-stumbleupon-circle"></i>
				<i class="commentator-icon commentator-icon-stumbleupon"></i>
				<i class="commentator-icon commentator-icon-delicious"></i>
				<i class="commentator-icon commentator-icon-digg"></i>
				<i class="commentator-icon commentator-icon-pied-piper"></i>
				<i class="commentator-icon commentator-icon-pied-piper-alt"></i>
				<i class="commentator-icon commentator-icon-drupal"></i>
				<i class="commentator-icon commentator-icon-joomla"></i>
				<i class="commentator-icon commentator-icon-language"></i>
				<i class="commentator-icon commentator-icon-fax"></i>
				<i class="commentator-icon commentator-icon-building"></i>
				<i class="commentator-icon commentator-icon-child"></i>
				<i class="commentator-icon commentator-icon-paw"></i>
				<i class="commentator-icon commentator-icon-spoon"></i>
				<i class="commentator-icon commentator-icon-cube"></i>
				<i class="commentator-icon commentator-icon-cubes"></i>
				<i class="commentator-icon commentator-icon-behance"></i>
				<i class="commentator-icon commentator-icon-behance-square"></i>
				<i class="commentator-icon commentator-icon-steam"></i>
				<i class="commentator-icon commentator-icon-steam-square"></i>
				<i class="commentator-icon commentator-icon-recycle"></i>
				<i class="commentator-icon commentator-icon-car"></i>
				<i class="commentator-icon commentator-icon-taxi"></i>
				<i class="commentator-icon commentator-icon-tree"></i>
				<i class="commentator-icon commentator-icon-spotify"></i>
				<i class="commentator-icon commentator-icon-deviantart"></i>
				<i class="commentator-icon commentator-icon-soundcloud"></i>
				<i class="commentator-icon commentator-icon-database"></i>
				<i class="commentator-icon commentator-icon-file-pdf-o"></i>
				<i class="commentator-icon commentator-icon-file-word-o"></i>
				<i class="commentator-icon commentator-icon-file-excel-o"></i>
				<i class="commentator-icon commentator-icon-file-powerpoint-o"></i>
				<i class="commentator-icon commentator-icon-file-image-o"></i>
				<i class="commentator-icon commentator-icon-file-archive-o"></i>
				<i class="commentator-icon commentator-icon-file-audio-o"></i>
				<i class="commentator-icon commentator-icon-file-video-o"></i>
				<i class="commentator-icon commentator-icon-file-code-o"></i>
				<i class="commentator-icon commentator-icon-vine"></i>
				<i class="commentator-icon commentator-icon-codepen"></i>
				<i class="commentator-icon commentator-icon-jsfiddle"></i>
				<i class="commentator-icon commentator-icon-life-ring"></i>
				<i class="commentator-icon commentator-icon-circle-o-notch"></i>
				<i class="commentator-icon commentator-icon-rebel"></i>
				<i class="commentator-icon commentator-icon-empire"></i>
				<i class="commentator-icon commentator-icon-git-square"></i>
				<i class="commentator-icon commentator-icon-git"></i>
				<i class="commentator-icon commentator-icon-hacker-news"></i>
				<i class="commentator-icon commentator-icon-tencent-weibo"></i>
				<i class="commentator-icon commentator-icon-qq"></i>
				<i class="commentator-icon commentator-icon-weixin"></i>
				<i class="commentator-icon commentator-icon-paper-plane"></i>
				<i class="commentator-icon commentator-icon-paper-plane-o"></i>
				<i class="commentator-icon commentator-icon-history"></i>
				<i class="commentator-icon commentator-icon-circle-thin"></i>
				<i class="commentator-icon commentator-icon-header"></i>
				<i class="commentator-icon commentator-icon-paragraph"></i>
				<i class="commentator-icon commentator-icon-sliders"></i>
				<i class="commentator-icon commentator-icon-share-alt"></i>
				<i class="commentator-icon commentator-icon-share-alt-square"></i>
				<i class="commentator-icon commentator-icon-bomb"></i>
				<i class="commentator-icon commentator-icon-futbol-o"></i>
				<i class="commentator-icon commentator-icon-tty"></i>
				<i class="commentator-icon commentator-icon-binoculars"></i>
				<i class="commentator-icon commentator-icon-plug"></i>
				<i class="commentator-icon commentator-icon-slideshare"></i>
				<i class="commentator-icon commentator-icon-twitch"></i>
				<i class="commentator-icon commentator-icon-yelp"></i>
				<i class="commentator-icon commentator-icon-newspaper-o"></i>
				<i class="commentator-icon commentator-icon-wifi"></i>
				<i class="commentator-icon commentator-icon-calculator"></i>
				<i class="commentator-icon commentator-icon-paypal"></i>
				<i class="commentator-icon commentator-icon-google-wallet"></i>
				<i class="commentator-icon commentator-icon-cc-visa"></i>
				<i class="commentator-icon commentator-icon-cc-mastercard"></i>
				<i class="commentator-icon commentator-icon-cc-discover"></i>
				<i class="commentator-icon commentator-icon-cc-amex"></i>
				<i class="commentator-icon commentator-icon-cc-paypal"></i>
				<i class="commentator-icon commentator-icon-cc-stripe"></i>
				<i class="commentator-icon commentator-icon-bell-slash"></i>
				<i class="commentator-icon commentator-icon-bell-slash-o"></i>
				<i class="commentator-icon commentator-icon-trash"></i>
				<i class="commentator-icon commentator-icon-copyright"></i>
				<i class="commentator-icon commentator-icon-at"></i>
				<i class="commentator-icon commentator-icon-eyedropper"></i>
				<i class="commentator-icon commentator-icon-paint-brush"></i>
				<i class="commentator-icon commentator-icon-birthday-cake"></i>
				<i class="commentator-icon commentator-icon-area-chart"></i>
				<i class="commentator-icon commentator-icon-pie-chart"></i>
				<i class="commentator-icon commentator-icon-line-chart"></i>
				<i class="commentator-icon commentator-icon-lastfm"></i>
				<i class="commentator-icon commentator-icon-lastfm-square"></i>
				<i class="commentator-icon commentator-icon-toggle-off"></i>
				<i class="commentator-icon commentator-icon-toggle-on"></i>
				<i class="commentator-icon commentator-icon-bicycle"></i>
				<i class="commentator-icon commentator-icon-bus"></i>
				<i class="commentator-icon commentator-icon-ioxhost"></i>
				<i class="commentator-icon commentator-icon-angellist"></i>
				<i class="commentator-icon commentator-icon-cc"></i>
				<i class="commentator-icon commentator-icon-ils"></i>
				<i class="commentator-icon commentator-icon-meanpath"></i>
				<i class="commentator-icon commentator-icon-buysellads"></i>
				<i class="commentator-icon commentator-icon-connectdevelop"></i>
				<i class="commentator-icon commentator-icon-dashcube"></i>
				<i class="commentator-icon commentator-icon-forumbee"></i>
				<i class="commentator-icon commentator-icon-leanpub"></i>
				<i class="commentator-icon commentator-icon-sellsy"></i>
				<i class="commentator-icon commentator-icon-shirtsinbulk"></i>
				<i class="commentator-icon commentator-icon-simplybuilt"></i>
				<i class="commentator-icon commentator-icon-skyatlas"></i>
				<i class="commentator-icon commentator-icon-cart-plus"></i>
				<i class="commentator-icon commentator-icon-cart-arrow-down"></i>
				<i class="commentator-icon commentator-icon-diamond"></i>
				<i class="commentator-icon commentator-icon-ship"></i>
				<i class="commentator-icon commentator-icon-user-secret"></i>
				<i class="commentator-icon commentator-icon-motorcycle"></i>
				<i class="commentator-icon commentator-icon-street-view"></i>
				<i class="commentator-icon commentator-icon-heartbeat"></i>
				<i class="commentator-icon commentator-icon-venus"></i>
				<i class="commentator-icon commentator-icon-mars"></i>
				<i class="commentator-icon commentator-icon-mercury"></i>
				<i class="commentator-icon commentator-icon-transgender"></i>
				<i class="commentator-icon commentator-icon-transgender-alt"></i>
				<i class="commentator-icon commentator-icon-venus-double"></i>
				<i class="commentator-icon commentator-icon-mars-double"></i>
				<i class="commentator-icon commentator-icon-venus-mars"></i>
				<i class="commentator-icon commentator-icon-mars-stroke"></i>
				<i class="commentator-icon commentator-icon-mars-stroke-v"></i>
				<i class="commentator-icon commentator-icon-mars-stroke-h"></i>
				<i class="commentator-icon commentator-icon-neuter"></i>
				<i class="commentator-icon commentator-icon-facebook-official"></i>
				<i class="commentator-icon commentator-icon-pinterest-p"></i>
				<i class="commentator-icon commentator-icon-whatsapp"></i>
				<i class="commentator-icon commentator-icon-server"></i>
				<i class="commentator-icon commentator-icon-user-plus"></i>
				<i class="commentator-icon commentator-icon-user-times"></i>
				<i class="commentator-icon commentator-icon-bed"></i>
				<i class="commentator-icon commentator-icon-viacoin"></i>
				<i class="commentator-icon commentator-icon-train"></i>
				<i class="commentator-icon commentator-icon-subway"></i>
				<i class="commentator-icon commentator-icon-medium"></i>
			</div>
		</section>
	</div>
</div>
<?php
exit;
}

?>