(function($) {
    // creates the plugin
    tinymce.create('tinymce.plugins.displayProduct', {
       init : function(ed, url) {
            ed.addButton('displayProduct_button', {
                title : 'Display Product Shortcode',
                image : displayProduct.plugin_folder + 'assets/js/display-icon.png',
                onclick: function() {
                    // triggers the thickbox
                    var width = jQuery(window).width(), H = jQuery(window).height(), W = (720 < width) ? 720 : width;
                    W = W - 80;
                    H = H - 115;
                    tb_show('Display Product Shortcode', '#TB_inline?width=' + W + '&height=' + H + '&inlineId=displayProduct-form');
                }
            });
        },
        createControl: function(n, cm) {
            return null;
        },
        getInfo : function() {
            return {
                longname : "Display Product Shortcode",
                author : 'Sureshopress',
                authorurl : 'http://www.sureshopress.com/',
                infourl : 'http://www.sureshopress.com/',
                version : "1.8.3"
            };
        }
    });
    tinymce.PluginManager.add('displayProduct', tinymce.plugins.displayProduct);
    // executes this when the DOM is ready
    jQuery(function() {
        var form = jQuery('<div id="displayProduct-form">\
                    <div id="displayProduct-wooLogo"></div>\
                    <div id="displayProduct-step-1" class="displayProduct-headline">' + displayProduct.selectliststyle + '</div>\
                                <ul class="displayProduct-liststyle">\
                                        <li><label class="fb" for="displayProduct-fb1">\
                                                    <input id="displayProduct-fb1" type="radio" name="fb" value="grid" />\
                                                    <img src="' + displayProduct.plugin_folder + 'assets/images/icon_grid.png">\
                                                    <div class="displayProduct-layoutname">' + displayProduct.Grid + '</div>\
                                            </label></li>\
                                        <li><label class="fb" for="displayProduct-fb2">\
                                                    <input id="displayProduct-fb2" type="radio" name="fb" value="list" />\
                                                    <img src="' + displayProduct.plugin_folder + 'assets/images/icon_list.png">\
                                                    <div class="displayProduct-layoutname">' + displayProduct.List + '</div>\
                                            </label></li>\
                                        <li><label class="fb" for="displayProduct-fb3">\
                                                    <input id="displayProduct-fb3" type="radio" name="fb" value="table" />\
                                                    <img src="' + displayProduct.plugin_folder + 'assets/images/icon_table.png">\
                                                    <div class="displayProduct-layoutname">' + displayProduct.Table + '</div>\
                                            </label></li>\
                                        <li><label class="fb" for="displayProduct-fb4">\
                                                    <input id="displayProduct-fb4" type="radio" name="fb" value="box" />\
                                                    <img src="' + displayProduct.plugin_folder + 'assets/images/icon_box.png">\
                                                    <div class="displayProduct-layoutname">' + displayProduct.Box + '</div>\
                                            </label></li>\
                                        <li><label class="fb" for="displayProduct-fb5">\
                                                    <input id="displayProduct-fb5" type="radio" name="fb" value="carousel" />\
                                                    <img src="' + displayProduct.plugin_folder + 'assets/images/icon_carousel_box.png">\
                                                    <div class="displayProduct-layoutname">' + displayProduct.Carousel_Box + '</div>\
                                            </label></li>\
                                        <li><label class="fb" for="displayProduct-fb6">\
                                                    <input id="displayProduct-fb6" type="radio" name="fb" value="carouselGrid" />\
                                                    <img src="' + displayProduct.plugin_folder + 'assets/images/icon_carousel_grid.png">\
                                                    <div class="displayProduct-layoutname">' + displayProduct.Carousel_Grid + '</div>\
                                            </label></li>\
                                </ul>\
                    <div id="displayProduct-step-2" class="displayProduct-headline">' + displayProduct.DisplayOptions + '</div>\
                        <table id="displayProduct-table" class="form-table">\
                                <tr>\
                                        <th><label for="displayProduct-filter">' + displayProduct.Select_product + '</label></th>\
                                        <td><label for="dp-product-allproduct"><input id="dp-product-allproduct" name="displayProduct-product_condition" type="radio" value="allproduct" checked> ' + displayProduct.allproduct + '</label>\
                                            <label for="dp-product-filterproduct"><input id="dp-product-filterproduct" name="displayProduct-product_condition" type="radio" value="filterproduct"> ' + displayProduct.filterproduct + '</label>\
                                            <select id="displayProduct-filter" name="displayProduct-filter" multiple size="3">\
                                                <option value="featured">' + displayProduct.featuredproduct + '</option>\
                                                <option value="sales">' + displayProduct.saleproduct + '</option>\
                                                <option value="instock">' + displayProduct.instockproduct + '</option>\
                                                <option value="outofstock">' + displayProduct.outofstockpproduct + '</option>\
                                            </select></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-category">' + displayProduct.productcategory + '</label></th>\
                                        <td><label for="dp-product-allcatogory"><input id="dp-product-allcatogory" name="displayProduct-cat_condition" type="radio" value="allcatogory" checked> ' + displayProduct.allcategory + '</label>\
                                            <label for="dp-product-customcatogory"><input id="dp-product-customcatogory" name="displayProduct-cat_condition" type="radio" value="customcatogory"> ' + displayProduct.customcategory + '</label>\
                                            <select id="displayProduct-category" name="displayProduct-category" multiple size="3">\
                                                ' + displayProduct.product_cat + '\
                                            </select></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-sort">' + displayProduct.sortbuy + '</label></th>\
                                        <td><select id="displayProduct-sort" name="displayProduct-sort">\
                                                <option value="default">' + displayProduct.Default_sorting + '</option>\
                                                <option value="popularity">' + displayProduct.Sort_by_popularity + '</option>\
                                                <option value="newness">' + displayProduct.Sort_by_newness + '</option>\
                                                <option value="oldest">' + displayProduct.Sort_by_oldest + '</option>\
                                                <option value="nameaz">' + displayProduct.Sort_by_Product_title_a_to_z + '</option>\
                                                <option value="nameza">' + displayProduct.Sort_by_Product_title_z_to_a + '</option>\
                                                <option value="lowhigh">' + displayProduct.Sort_by_Price_low_to_high + '</option>\
                                                <option value="highlow">' + displayProduct.Sort_by_Price_high_to_low + '</option>\
                                                <option value="skulowhigh">' + displayProduct.Sort_by_SKU_low_to_high + '</option>\
                                                <option value="skuhighlow">' + displayProduct.Sort_by_SKU_high_to_low + '</option>\
                                                <option value="stocklowhigh">' + displayProduct.Sort_by_stock_low_to_high + '</option>\
                                                <option value="stockhighlow">' + displayProduct.Sort_by_stock_high_to_low + '</option>\
                                                <option value="random">' + displayProduct.Sort_by_random + '</option>\
                                            </select></td>\
                                </tr>\
                                <tr class="hideintable">\
                                        <th><label for="displayProduct-columns">' + displayProduct.Columns + '</label></th>\
                                        <td><input type="number" id="displayProduct-columns" name="displayProduct-columns" min="1" max="6" value="3" /></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-perpage">' + displayProduct.Products_displayed_per_page + '</label></th>\
                                        <td><input type="number" id="displayProduct-perpage" min="1" name="displayed-perpage" value="20" /></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-pagination">' + displayProduct.Pagination + '</label></th>\
                                        <td><select id="displayProduct-pagination" name="displayProduct-pagination">\
                                                <option value="default">' + displayProduct.Default + '</option>\
                                                <option value="disable">' + displayProduct.Disable + '</option>\
                                            </select></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-trimwords">' + displayProduct.Trimwords + '</label></th>\
                                        <td><input type="number" id="displayProduct-trimwords" min="0" name="displayed-trimwords" value="20" /></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-quickview">' + displayProduct.Quickview + '</label></th>\
                                        <td><select id="displayProduct-quickview" name="displayProduct-quickview">\
                                                <option value="default">' + displayProduct.Default + '</option>\
                                                <option value="disable">' + displayProduct.Disable + '</option>\
                                            </select></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-showhide">' + displayProduct.Show + '</label></th>\
                                        <td><label class="showhide" for="displayProduct-title"><input id="displayProduct-title" type="checkbox" checked="checked" value="show"> ' + displayProduct.Title + '</label>  \
                                            <label class="showhide" for="displayProduct-excerpt"><input id="displayProduct-excerpt" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Excerpt + '</label>\
                                            <label class="showhide" for="displayProduct-image"><input id="displayProduct-image" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Image + '</label>\
                                            <label class="showhide" for="displayProduct-price"><input id="displayProduct-price" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Price + '</label>\
                                            <label class="showhide" for="displayProduct-star"><input id="displayProduct-star" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Star + '</label>\
                                            <label class="showhide" for="displayProduct-sku"><input id="displayProduct-sku" type="checkbox" checked="checked" value="show"> ' + displayProduct.SKU + '</label>\
                                            <label class="showhide" for="displayProduct-metacategory"><input id="displayProduct-metacategory" type="checkbox" checked="checked" value="show"> ' + displayProduct.Category + '</label>\
                                            <label class="showhide" for="displayProduct-metatag"><input id="displayProduct-metatag" type="checkbox" checked="checked" value="show"> ' + displayProduct.Tag + '</label>\
                                            <label class="showhide" for="displayProduct-button"><input id="displayProduct-button" type="checkbox" checked="checked" value="show"> ' + displayProduct.Button + '</label>\
                                            <label class="showhide" for="displayProduct-featured"><input id="displayProduct-featured" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Featured + '</label>\
                                            <label class="showhide" for="displayProduct-sale"><input id="displayProduct-sale" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Sale + '</label>\
                                            <label class="showhide" for="displayProduct-outofstock"><input id="displayProduct-outofstock" type="checkbox" checked="checked" value="show"> ' + displayProduct.Out_of_Stock + '</label>\
                                            <label class="showhide" for="displayProduct-link"><input id="displayProduct-link" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Link_to_Product_Page + '</label>\
                                            <label class="showhide" for="displayProduct-frontsorter"><input id="displayProduct-frontsorter" type="checkbox" checked="checked" value="show" class="displayProduct-eneble"> ' + displayProduct.Frontend_Sorter + '</label></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-addtocartbutton">' + displayProduct.Button_and_Quantity + '</label></th>\
                                        <td><select id="displayProduct-addtocartbutton" name="displayProduct-addtocartbutton">\
                                                <option value="default">' + displayProduct.Button_default + '</option>\
                                                <option value="buttonquantity">' + displayProduct.Button_Quantity + '</option>\
                                                <option value="productDetail">' + displayProduct.Product_detail + '</option>\
                                                <option value="customButton">' + displayProduct.Custom_Button + '</option>\
                                                <option value="customText">' + displayProduct.Custom_Text_Call_for_price + '</option>\
                                            </select></td>\
                                </tr>\
                                <tr class="addtocartcustom hideproductDetail">\
                                        <th><label for="displayProduct-addtocarturl">' + displayProduct.Button_Custom_URL + '</label></th>\
                                        <td><input id="displayProduct-addtocarturl" name="displayProduct-addtocarturl" type="text" placeholder="Leave blank to disable. http://"></td>\
                                </tr>\
                                <tr class="addtocartcustom productDetail">\
                                        <th><label for="displayProduct-addtocarttext">' + displayProduct.Button_Custom_Text + '</label></th>\
                                        <td><input id="displayProduct-addtocarttext" name="displayProduct-addtocarttext" type="text" placeholder="Call for price"></td>\
                                </tr>\
                        </table>\
                    <div id="displayProduct-step-3" class="displayProduct-headline">' + displayProduct.Customize + '</div>\
                       <table id="displayProduct-table" class="form-table">\
                                <tr class="carousel">\
                                        <th><label for="displayProduct-arrowanddot">' + displayProduct.Arrow_Dot + '</label></th>\
                                        <td><select id="displayProduct-arrowanddot" name="displayProduct-arrowanddot">\
                                                <option value="1">' + displayProduct.Arrow + '</option>\
                                                <option value="2">' + displayProduct.Show_pagination_Dot + '</option>\
                                                <option value="3">' + displayProduct.Arrow_and_Dot + '</option>\
                                            </select></td>\
                                </tr>\
                                <tr class="carousel">\
                                        <th><label for="displayProduct-arrowstyle">' + displayProduct.Arrow_Style + '</label></th>\
                                        <td><select id="displayProduct-arrowstyle" name="displayProduct-arrowstyle">\
                                                <option value="1">Style 1</option>\
                                                <option value="2">Style 2</option>\
                                                <option value="3">Style 3</option>\
                                                <option value="4">Style 4</option>\
                                            </select></td>\
                                </tr>\
                                <tr class="carousel">\
                                        <th><label for="displayProduct-arrowposition">' + displayProduct.Arrow_Position + '</label></th>\
                                        <td><select id="displayProduct-arrowposition" name="displayProduct-arrowposition">\
                                                <option value="sideMiddle">' + displayProduct.Side_Middle + '</option>\
                                                <option value="topRight">' + displayProduct.Top_Right + '</option>\
                                                <option value="topLeft">' + displayProduct.Top_Left + '</option>\
                                            </select></td>\
                                </tr>\
                                <tr class="showinall">\
                                        <th><label for="displayProduct-columns">' + displayProduct.Select_Thumbnail_Hover_Effect + '</label></th>\
                                        <td><select id="displayProduct-dpanimatehover" name="displayProduct-dpanimatehover">\
                                                <option value="disable">Disable</option>\
                                                <option value="fadeIn">Default fadeIn</option>\
                                                <option value="fadeInLeft">fadeInLeft</option>\
                                                <option value="fadeInRight">fadeInRight</option>\
                                                <option value="fadeInUp">fadeInUp</option>\
                                                <option value="fadeInDown">fadeInDown</option>\
                                                <option value="rotateIn">rotateIn</option>\
                                                <option value="rotateInLeft">rotateInLeft</option>\
                                                <option value="rotateInRight">rotateInRight</option>\
                                                <option value="rotateInUp">rotateInUp</option>\
                                                <option value="rotateInDown">rotateInDown</option>\
                                                <option value="bounce">bounce</option>\
                                                <option value="bounceInLeft">bounceInLeft</option>\
                                                <option value="bounceInRight">bounceInRight</option>\
                                                <option value="bounceInUp">bounceInUp</option>\
                                                <option value="bounceInDown">bounceInDown</option>\
                                                <option value="elasticInLeft">elasticInLeft</option>\
                                                <option value="elasticInRight">elasticInRight</option>\
                                                <option value="elasticInUp">elasticInUp</option>\
                                                <option value="elasticInDown">elasticInDown</option>\
                                                <option value="zoomIn">zoomIn</option>\
                                                <option value="zoomInLeft">zoomInLeft</option>\
                                                <option value="zoomInRight">zoomInRight</option>\
                                                <option value="zoomInUp">zoomInUp</option>\
                                                <option value="zoomInDown">zoomInDown</option>\
                                                <option value="jellyInLeft">jellyInLeft</option>\
                                                <option value="jellyInRight">jellyInRight</option>\
                                                <option value="jellyInDown">jellyInDown</option>\
                                                <option value="jellyInUp">jellyInUp</option>\
                                                <option value="flipInLeft">flipInLeft</option>\
                                                <option value="flipInRight">flipInRight</option>\
                                                <option value="flipInUp">flipInUp</option>\
                                                <option value="flipInDown">flipInDown</option>\
                                                <option value="flipInV">flipInV</option>\
                                                <option value="flipInH">flipInH</option>\
                                                <option value="pendulum">pendulum</option>\
                                       </select></td>\
                                </tr>\
                                <tr class="box_carousel">\
                                        <th><label for="displayProduct-columns">' + displayProduct.Select_Hover_Effec_Product_Name + '</label></th>\
                                        <td><select id="displayProduct-dpanimatehover_productname" name="displayProduct-dpanimatehover_productname">\
                                                <option value="fadeIn">Default fadeIn</option>\
                                                <option value="fadeInLeft">fadeInLeft</option>\
                                                <option value="fadeInRight">fadeInRight</option>\
                                                <option value="fadeInUp">fadeInUp</option>\
                                                <option value="fadeInDown">fadeInDown</option>\
                                                <option value="rotateIn">rotateIn</option>\
                                                <option value="rotateInLeft">rotateInLeft</option>\
                                                <option value="rotateInRight">rotateInRight</option>\
                                                <option value="rotateInUp">rotateInUp</option>\
                                                <option value="rotateInDown">rotateInDown</option>\
                                                <option value="bounce">bounce</option>\
                                                <option value="bounceInLeft">bounceInLeft</option>\
                                                <option value="bounceInRight">bounceInRight</option>\
                                                <option value="bounceInUp">bounceInUp</option>\
                                                <option value="bounceInDown">bounceInDown</option>\
                                                <option value="elasticInLeft">elasticInLeft</option>\
                                                <option value="elasticInRight">elasticInRight</option>\
                                                <option value="elasticInUp">elasticInUp</option>\
                                                <option value="elasticInDown">elasticInDown</option>\
                                                <option value="zoomIn">zoomIn</option>\
                                                <option value="zoomInLeft">zoomInLeft</option>\
                                                <option value="zoomInRight">zoomInRight</option>\
                                                <option value="zoomInUp">zoomInUp</option>\
                                                <option value="zoomInDown">zoomInDown</option>\
                                                <option value="jellyInLeft">jellyInLeft</option>\
                                                <option value="jellyInRight">jellyInRight</option>\
                                                <option value="jellyInDown">jellyInDown</option>\
                                                <option value="jellyInUp">jellyInUp</option>\
                                                <option value="flipInLeft">flipInLeft</option>\
                                                <option value="flipInRight">flipInRight</option>\
                                                <option value="flipInUp">flipInUp</option>\
                                                <option value="flipInDown">flipInDown</option>\
                                                <option value="flipInV">flipInV</option>\
                                                <option value="flipInH">flipInH</option>\
                                                <option value="pendulum">pendulum</option>\
                                       </select></td>\
                                </tr>\
                                <tr class="box_carousel">\
                                        <th><label for="displayProduct-columns">' + displayProduct.Select_Hover_Effect_excerpt_and_star + '</label></th>\
                                        <td><select id="displayProduct-dpanimatehover_star" name="displayProduct-dpanimatehover_star">\
                                                <option value="fadeIn">Default fadeIn</option>\
                                                <option value="fadeInLeft">fadeInLeft</option>\
                                                <option value="fadeInRight">fadeInRight</option>\
                                                <option value="fadeInUp">fadeInUp</option>\
                                                <option value="fadeInDown">fadeInDown</option>\
                                                <option value="rotateIn">rotateIn</option>\
                                                <option value="rotateInLeft">rotateInLeft</option>\
                                                <option value="rotateInRight">rotateInRight</option>\
                                                <option value="rotateInUp">rotateInUp</option>\
                                                <option value="rotateInDown">rotateInDown</option>\
                                                <option value="bounce">bounce</option>\
                                                <option value="bounceInLeft">bounceInLeft</option>\
                                                <option value="bounceInRight">bounceInRight</option>\
                                                <option value="bounceInUp">bounceInUp</option>\
                                                <option value="bounceInDown">bounceInDown</option>\
                                                <option value="elasticInLeft">elasticInLeft</option>\
                                                <option value="elasticInRight">elasticInRight</option>\
                                                <option value="elasticInUp">elasticInUp</option>\
                                                <option value="elasticInDown">elasticInDown</option>\
                                                <option value="zoomIn">zoomIn</option>\
                                                <option value="zoomInLeft">zoomInLeft</option>\
                                                <option value="zoomInRight">zoomInRight</option>\
                                                <option value="zoomInUp">zoomInUp</option>\
                                                <option value="zoomInDown">zoomInDown</option>\
                                                <option value="jellyInLeft">jellyInLeft</option>\
                                                <option value="jellyInRight">jellyInRight</option>\
                                                <option value="jellyInDown">jellyInDown</option>\
                                                <option value="jellyInUp">jellyInUp</option>\
                                                <option value="flipInLeft">flipInLeft</option>\
                                                <option value="flipInRight">flipInRight</option>\
                                                <option value="flipInUp">flipInUp</option>\
                                                <option value="flipInDown">flipInDown</option>\
                                                <option value="flipInV">flipInV</option>\
                                                <option value="flipInH">flipInH</option>\
                                                <option value="pendulum">pendulum</option>\
                                       </select></td>\
                                </tr>\
                                <tr class="box_carousel">\
                                        <th><label for="displayProduct-columns">' + displayProduct.Select_Hover_Effect_Price + '</label></th>\
                                        <td><select id="displayProduct-dpanimatehover_price" name="displayProduct-dpanimatehover_price">\
                                                <option value="fadeIn">Default fadeIn</option>\
                                                <option value="fadeInLeft">fadeInLeft</option>\
                                                <option value="fadeInRight">fadeInRight</option>\
                                                <option value="fadeInUp">fadeInUp</option>\
                                                <option value="fadeInDown">fadeInDown</option>\
                                                <option value="rotateIn">rotateIn</option>\
                                                <option value="rotateInLeft">rotateInLeft</option>\
                                                <option value="rotateInRight">rotateInRight</option>\
                                                <option value="rotateInUp">rotateInUp</option>\
                                                <option value="rotateInDown">rotateInDown</option>\
                                                <option value="bounce">bounce</option>\
                                                <option value="bounceInLeft">bounceInLeft</option>\
                                                <option value="bounceInRight">bounceInRight</option>\
                                                <option value="bounceInUp">bounceInUp</option>\
                                                <option value="bounceInDown">bounceInDown</option>\
                                                <option value="elasticInLeft">elasticInLeft</option>\
                                                <option value="elasticInRight">elasticInRight</option>\
                                                <option value="elasticInUp">elasticInUp</option>\
                                                <option value="elasticInDown">elasticInDown</option>\
                                                <option value="zoomIn">zoomIn</option>\
                                                <option value="zoomInLeft">zoomInLeft</option>\
                                                <option value="zoomInRight">zoomInRight</option>\
                                                <option value="zoomInUp">zoomInUp</option>\
                                                <option value="zoomInDown">zoomInDown</option>\
                                                <option value="jellyInLeft">jellyInLeft</option>\
                                                <option value="jellyInRight">jellyInRight</option>\
                                                <option value="jellyInDown">jellyInDown</option>\
                                                <option value="jellyInUp">jellyInUp</option>\
                                                <option value="flipInLeft">flipInLeft</option>\
                                                <option value="flipInRight">flipInRight</option>\
                                                <option value="flipInUp">flipInUp</option>\
                                                <option value="flipInDown">flipInDown</option>\
                                                <option value="flipInV">flipInV</option>\
                                                <option value="flipInH">flipInH</option>\
                                                <option value="pendulum">pendulum</option>\
                                       </select></td>\
                                </tr>\
                                <tr class="showintable tablebackground">\
                                        <th><label for="displayProduct-tablebackground">' + displayProduct.Table_Background_color + '</label></th>\
                                        <td><input id="displayProduct-tablebackground" name="displayProduct-tablebackground" type="text" class="dp_picker_color" value="#ffffff" data-default-color="#ffffff"></td>\
                                </tr>\
                                <tr class="showintable tableheadbackground">\
                                        <th><label for="displayProduct-tableheadbackground">' + displayProduct.Table_Head_Background_color + '</label></th>\
                                        <td><input id="displayProduct-tableheadbackground" name="displayProduct-tableheadbackground" type="text" class="dp_picker_color" value="#DBDADA" data-default-color="#DBDADA"></td>\
                                </tr>\
                                <tr class="showintable tableheadtextcolor">\
                                        <th><label for="displayProduct-tableheadtextcolor">' + displayProduct.Table_Head_Text_color + '</label></th>\
                                        <td><input id="displayProduct-tableheadtextcolor" name="displayProduct-tableheadtextcolor" type="text" class="dp_picker_color" value="#ffffff" data-default-color="#ffffff"></td>\
                                </tr>\
                                <tr class="showintable tablerowhovercolor">\
                                        <th><label for="displayProduct-tablerowhovercolor">' + displayProduct.Table_Row_hover_color + '</label></th>\
                                        <td><input id="displayProduct-tablerowhovercolor" name="displayProduct-tablerowhovercolor" type="text" class="dp_picker_color" value="#fafafa" data-default-color="#fafafa"></td>\
                                </tr>\
                                <tr class="bordercolor">\
                                        <th><label for="displayProduct-bordercolor">' + displayProduct.Border_color + '</label></th>\
                                        <td><input id="displayProduct-bordercolor" name="displayProduct-bordercolor" type="text" class="dp_picker_color" value="#fc5b5b" data-default-color="#fc5b5b"></td>\
                                </tr>\
                                <tr class="backgroundcolor">\
                                        <th><label for="displayProduct-backgroundcolor">' + displayProduct.Background_color + '</label></th>\
                                        <td><input id="displayProduct-backgroundcolor" name="displayProduct-backgroundcolor" type="text" class="dp_picker_color" value="#fefefe" data-default-color="#fefefe"></td>\
                                </tr>\
                                <tr class="productnamecolor">\
                                        <th><label for="displayProduct-productnamecolor">' + displayProduct.Product_name_color + '</label></th>\
                                        <td><input id="displayProduct-productnamecolor" name="displayProduct-productnamecolor" type="text" class="dp_picker_color" value="#444444" data-default-color="#444444"></td>\
                                </tr>\
                                <tr class="productnamehovercolor">\
                                        <th><label for="displayProduct-productnamehovercolor">' + displayProduct.Product_nam_hover_color + '</label></th>\
                                        <td><input id="displayProduct-productnamehovercolor" name="displayProduct-productnamehovercolor" type="text" class="dp_picker_color" value="#A88F5C" data-default-color="#A88F5C"></td>\
                                </tr>\
                                <tr class="pricecolor">\
                                        <th><label for="displayProduct-pricecolor">' + displayProduct.Price_color + '</label></th>\
                                        <td><input id="displayProduct-pricecolor" name="displayProduct-pricecolor" type="text" class="dp_picker_color" value="#444444" data-default-color="#444444"></td>\
                                </tr>\
                                <tr class="textcolor">\
                                        <th><label for="displayProduct-textcolor">' + displayProduct.Text_color + '</label></th>\
                                        <td><input id="displayProduct-textcolor" name="displayProduct-textcolor" type="text" class="dp_picker_color" value="#444444" data-default-color="#444444"></td>\
                                </tr>\
                                <tr class="linkcolor">\
                                        <th><label for="displayProduct-linkcolor">' + displayProduct.Link_color + '</label></th>\
                                        <td><input id="displayProduct-linkcolor" name="displayProduct-linkcolor" type="text" class="dp_picker_color" value="#fc5b5b" data-default-color="#fc5b5b"></td>\
                                </tr>\
                                <tr class="linkhovercolor">\
                                        <th><label for="displayProduct-linkhovercolor">' + displayProduct.Link_hover_color + '</label></th>\
                                        <td><input id="displayProduct-linkhovercolor" name="displayProduct-linkhovercolor" type="text" class="dp_picker_color" value="#A88F5C" data-default-color="#A88F5C"></td>\
                                </tr>\
                                <tr class="buttoncolor">\
                                        <th><label for="displayProduct-buttoncolor">' + displayProduct.Button_color + '</label></th>\
                                        <td><input id="displayProduct-buttoncolor" name="displayProduct-buttoncolor" type="text" class="dp_picker_color" value="#fc5b5b" data-default-color="#fc5b5b"></td>\
                                </tr>\
                                <tr class="buttonhovercolor">\
                                        <th><label for="displayProduct-buttonhovercolor">' + displayProduct.Button_hover_color + '</label></th>\
                                        <td><input id="displayProduct-buttonhovercolor" name="displayProduct-buttonhovercolor" type="text" class="dp_picker_color" value="#444444" data-default-color="#444444"></td>\
                                </tr>\
                                <tr class="featuredcolor">\
                                        <th><label for="displayProduct-featuredcolor">' + displayProduct.featuredcolor + '</label></th>\
                                        <td><input id="displayProduct-featuredcolor" name="displayProduct-featuredcolor" type="text" class="dp_picker_color" value="#ffd347" data-default-color="#ffd347"></td>\
                                </tr>\
                                <tr class="salecolor">\
                                        <th><label for="displayProduct-salecolor">' + displayProduct.salecolor + '</label></th>\
                                        <td><input id="displayProduct-salecolor" name="displayProduct-salecolor" type="text" class="dp_picker_color" value="#fc5b5b" data-default-color="#fc5b5b"></td>\
                                </tr>\
                                <tr>\
                                        <th><label for="displayProduct-font">' + displayProduct.Select_Font + '</label></th>\
                                        <td><select id="displayProduct-font" name="displayProduct-font">\
                                                <option value="Droid+Sans">Droid Sans</option>\
                                                <option value="Source+Sans+Pro">Source Sans Pro</option>\
                                                <option value="Source+Sans+Pro">Nixie One</option>\
                                                <option value="Signika+Negative">Signika Negative</option>\
                                                <option value="Lato">Lato</option>\
                                                <option value="Lora">Lora</option>\
                                                <option value="PT+Sans+Narrow">PT Sans Narrow</option>\
                                                <option value="Ubuntu">Ubuntu</option>\
                                                <option value="Contrail+One">Contrail One</option>\
                                                <option value="Bitter">Bitter</option>\
                                                <option value="Lobster">Lobster</option>\
                                                <option value="Shadows+Into+Light">Shadows Into Light</option>\
                                                <option value="Libre+Baskerville">Libre Baskerville</option>\
                                                <option value="Open+Sans">Open Sans</option>\
                                                <option value="Open+Sans+Condensed">Open Sans Condensed</option>\
                                                <option value="Varela+Round">Varela Round</option>\
                                                <option value="Cinzel">Cinzel</option>\
                                                <option value="Comfortaa">Comfortaa</option>\
                                                <option value="Doppio+One">Doppio+One</option>\
                                        </select></td>\
                                </tr>\
                        </table>\
		<p class="submit">\
			<input type="button" id="displayProduct-submit" class="button-primary" value="' + displayProduct.Insert_Product_Shortcode + '" name="submit" />\
		</p>\
		</div>');

        var table = form.find('#displayProduct-form');
        form.appendTo('body').hide();

        // handles the click event of the submit button
        form.find('#displayProduct-submit').click(function() {
            // defines the options and their default values
            // again, this is not the most elegant way to do this
            // but well, this gets the job done nonetheless
            var options = {
                'fb1': 'grid',
                'fb2': 'list',
                'fb3': 'table',
                'fb4': 'box',
                'fb5': 'carousel',
                'fb6': 'carouselGrid',
                'filter': 'latest',
                'category': 'all',
                'sort': 'default',
                'columns': '3',
                'perpage': '20',
                'pagination': 'default',
                'trimwords': '20',
                'title': 'show',
                'excerpt': 'show',
                'image': 'show',
                'price': 'show',
                'button': 'show',
                'star': 'show',
                'sku': 'show',
                'metacategory': 'show',
                'metatag': 'show',
                'sale': 'show',
                'featured': 'show',
                'outofstock': 'show',
                'link': 'show',
                'frontsorter': 'show',
                'dpanimatehover': 'disable',
                'dpanimatehover_productname': 'fadeIn',
                'dpanimatehover_star': 'fadeIn',
                'dpanimatehover_price': 'fadeIn',
                'quickview':'default',
                //'skin': 'default',
                'tablebackground': '#ffffff',
                'tableheadbackground': '#DBDADA',
                'tableheadtextcolor':'#ffffff',
                'tablerowhovercolor': '#fafafa',
                'arrowanddot': '1',
                'arrowstyle': '1',
                'arrowposition': 'sideMiddle',
                'backgroundcolor':'#fefefe',
                'bordercolor': '#fc5b5b',
                'productnamecolor': '#444444',
                'productnamehovercolor':'#A88F5C',
                'pricecolor': '#444444',
                'textcolor': '#444444',
                'linkcolor': '#fc5b5b',
                'linkhovercolor':'#A88F5C',
                'buttoncolor': '#fc5b5b',
                'buttonhovercolor':'#444444',
                'featuredcolor': '#ffd347',
                'salecolor':'#fc5b5b',
                'font': 'Droid+Sans',
                'addtocartbutton': 'default',
                'addtocarturl': '',
                'addtocarttext': ''
            };
            var shortcode = '[displayProduct';

            for (var index in options) {
                var value = jQuery('#displayProduct-' + index).val();
                // Type
                if (index === 'fb1' || index === 'fb2' || index === 'fb3' || index === 'fb4' || index === 'fb5' || index === 'fb6') {
                    if (jQuery('#displayProduct-' + index).is(':checked')) {
                        shortcode += ' type="' + value + '"';
                    }
                } else if (index === 'title' || index === 'excerpt' || index === 'image' || index === 'price' || index === 'button'|| index === 'sku'|| index === 'metacategory'|| index === 'metatag' || index === 'featured'|| index === 'outofstock'|| index === 'sale' || index === 'star' || index === 'link'|| index === 'frontsorter') {
                    if (!jQuery('#displayProduct-' + index).is(':checked')) {
                        shortcode += ' ' + index + '="hide"';
                    }
                } else if (index === 'category') {
                    if (value !== null) {
                        shortcode += ' ' + index + '="' + value + '"';
                    }
                } else if (index === 'filter') {
                    if (jQuery('#dp-product-filterproduct').is(':checked')) {
                        shortcode += ' filter="' + value + '"';
                    }
                } else if (index === 'category') {
                    if (jQuery('#dp-product-customcatogory').is(':checked')) {
                        shortcode += ' category="' + value + '"';
                    }
                } else if (value !== options[index]) {
                    shortcode += ' ' + index + '="' + value + '"';
                }
            }

            shortcode += ']';

            // inserts the shortcode into the active editor
            tinyMCE.activeEditor.execCommand('mceInsertContent', 0, shortcode);

            // closes Thickbox
            tb_remove();
        });

        jQuery('#displayProduct-category,#displayProduct-filter,.table,.carousel,.addtocartcustom').hide();
        jQuery('#displayProduct-step-2').hide();
        jQuery('#displayProduct-step-3').hide();
        jQuery('#displayProduct-step-2').next().hide();
        jQuery('#displayProduct-step-3').next().hide();

        jQuery('.fb').click(function() {
            jQuery('#displayProduct-step-2').fadeIn('fast');
            jQuery('#displayProduct-step-3').fadeIn('fast');
            jQuery('#displayProduct-step-2').next().fadeIn('fast');
            jQuery('#displayProduct-step-3').next().fadeIn('fast');

            fbType = jQuery(this).children('input').val();
            if (fbType === 'grid') {
                jQuery('#displayProduct-productnamecolor,#displayProduct-pricecolor,#displayProduct-textcolor').attr({'data-default-color':'#444444','value':'#444444'});
                jQuery('.productnamecolor a.wp-color-result,.pricecolor a.wp-color-result,.textcolor a.wp-color-result').css('background-color','#444444');
                jQuery('#displayProduct-bordercolor').attr({'data-default-color':'#fc5b5b','value':'#fc5b5b'});
                jQuery('.bordercolor a.wp-color-result').css('background-color','#fc5b5b');
                jQuery('#displayProduct-excerpt,#displayProduct-sku,#displayProduct-metacategory,#displayProduct-metatag,#displayProduct-outofstock,#displayProduct-frontsorter').removeAttr('checked');
                jQuery('#displayProduct-frontsorter').attr('checked', 'checked');
                jQuery('.hideintable,.showinall').fadeIn('fast');
                jQuery('.showintable,.box_carousel,.carousel').fadeOut('fast');
            } else if (fbType === 'list') {
                jQuery('#displayProduct-productnamecolor,#displayProduct-pricecolor,#displayProduct-textcolor').attr({'data-default-color':'#444444','value':'#444444'});
                jQuery('.productnamecolor a.wp-color-result,.pricecolor a.wp-color-result,.textcolor a.wp-color-result').css('background-color','#444444');
                jQuery('#displayProduct-bordercolor').attr({'data-default-color':'#fc5b5b','value':'#fc5b5b'});
                jQuery('.bordercolor a.wp-color-result').css('background-color','#fc5b5b');
                jQuery('#displayProduct-excerpt,#displayProduct-sku,#displayProduct-metacategory,#displayProduct-metatag,#displayProduct-outofstock,#displayProduct-frontsorter').attr('checked', 'checked');
                jQuery('.hideintable,.showinall').fadeIn('fast');
                jQuery('.showintable,.box_carousel,.carousel').fadeOut('fast');
            } else if (fbType === 'table') {
                jQuery('#displayProduct-productnamecolor,#displayProduct-pricecolor,#displayProduct-textcolor').attr({'data-default-color':'#444444','value':'#444444'});
                jQuery('.productnamecolor a.wp-color-result,.pricecolor a.wp-color-result,.textcolor a.wp-color-result').css('background-color','#444444');
                jQuery('#displayProduct-bordercolor').attr({'data-default-color':'#eeeeee','value':'#eeeeee'});
                jQuery('.bordercolor a.wp-color-result').css('background-color','#eeeeee');
                jQuery('#displayProduct-sku,#displayProduct-metacategory,#displayProduct-outofstock,#displayProduct-frontsorter').attr('checked', 'checked');
                jQuery('#displayProduct-excerpt,#displayProduct-metatag').removeAttr('checked');
                jQuery('.showintable,.showinall').fadeIn('fast');
                jQuery('.hideintable,.box_carousel,.carousel').fadeOut('fast');
            } else if (fbType === 'box') {
                jQuery('#displayProduct-productnamecolor,#displayProduct-pricecolor,#displayProduct-textcolor').attr({'data-default-color':'#ffffff','value':'#ffffff'});
                jQuery('.productnamecolor a.wp-color-result,.pricecolor a.wp-color-result,.textcolor a.wp-color-result').css('background-color','#ffffff');
                jQuery('#displayProduct-bordercolor').attr({'data-default-color':'#fc5b5b','value':'#fc5b5b'});
                jQuery('.bordercolor a.wp-color-result').css('background-color','#fc5b5b');
                jQuery('#displayProduct-frontsorter').attr('checked', 'checked');
                jQuery('#displayProduct-excerpt,#displayProduct-sku,#displayProduct-metacategory,#displayProduct-metatag,#displayProduct-outofstock,#displayProduct-frontsorter').removeAttr('checked');
                jQuery('.hideintable,.showinall,.box_carousel').fadeIn('fast');
                jQuery('.showintable,.carousel').fadeOut('fast');
            } else if (fbType === 'carousel') {
                jQuery('#displayProduct-productnamecolor,#displayProduct-pricecolor,#displayProduct-textcolor').attr({'data-default-color':'#ffffff','value':'#ffffff'});
                jQuery('.productnamecolor a.wp-color-result,.pricecolor a.wp-color-result,.textcolor a.wp-color-result').css('background-color','#ffffff');
                jQuery('#displayProduct-excerpt,#displayProduct-sku,#displayProduct-metacategory,#displayProduct-metatag,#displayProduct-outofstock,#displayProduct-frontsorter').removeAttr('checked');
                jQuery('.hideintable,.showinall,.box_carousel,.carousel').fadeIn('fast');
                jQuery('.showintable').fadeOut('fast');
            } else if (fbType === 'carouselGrid') {
                jQuery('#displayProduct-productnamecolor,#displayProduct-pricecolor,#displayProduct-textcolor').attr({'data-default-color':'#444444','value':'#444444'});
                jQuery('.productnamecolor a.wp-color-result,.pricecolor a.wp-color-result,.textcolor a.wp-color-result').css('background-color','#444444');
                jQuery('#displayProduct-bordercolor').attr({'data-default-color':'#fc5b5b','value':'#fc5b5b'});
                jQuery('.bordercolor a.wp-color-result').css('background-color','#fc5b5b');
                jQuery('#displayProduct-excerpt,#displayProduct-sku,#displayProduct-metacategory,#displayProduct-metatag,#displayProduct-outofstock,#displayProduct-frontsorter').removeAttr('checked');
                jQuery('.hideintable,.showinall,.carousel').fadeIn('fast');
                jQuery('.showintable,.box_carousel').fadeOut('fast');
            }

        });
        /* Product Filter  */
        jQuery('#dp-product-allproduct').click(function() {
            jQuery('#displayProduct-filter').fadeOut('fast');
        });
        jQuery('#dp-product-filterproduct').click(function() {
            jQuery('#displayProduct-filter').fadeIn('fast');
        });

        /* Product Category */
        jQuery('#dp-product-allcatogory').click(function() {
            jQuery('#displayProduct-category').fadeOut('fast');
        });
        jQuery('#dp-product-customcatogory').click(function() {
            jQuery('#displayProduct-category').fadeIn('fast');
        });
        
        /* Add to cart button*/
        jQuery('#displayProduct-addtocartbutton').change(function() {
            addtocartval=jQuery(this).val();
            if(addtocartval==='customButton'){
                jQuery('.addtocartcustom').fadeIn('fast');
            }else if(addtocartval==='customText'){
                jQuery('.addtocartcustom').fadeIn('fast');
            }else if(addtocartval==='productDetail'){
                jQuery('.productDetail').fadeIn('fast');
                jQuery('.hideproductDetail').fadeOut('fast');
            }else{
                jQuery('.addtocartcustom').fadeOut('fast');
            }
            
        });
        
        jQuery(document).ready(function($) {   
            $('.dp_picker_color').wpColorPicker();
        });
        
    });
})(window.jQuery);
