<?php
/*
  Plugin Name: Display Product for WooCommerce
  Plugin URI: http://persianscript.ir
  Description: A simple user interface for Display Product shortcode
  Version: 1.8.3
  Author: Sureshopress
  Author URI: http://persianscript.ir
 */


if (!defined('ABSPATH'))
    die("Can't load this file directly");

define( 'DP_VER', '1.8.3' );
define( 'DP_PREFIX', 'displayproduct_' );
define( 'DP_TEXTDOMAN', 'displayproduct' ); 
define( 'DP_DIR', plugin_dir_url(__FILE__) ); 


class displayProduct {

    function __construct() {
         
	$plugins = get_option('active_plugins');
	$required_woo_plugin = 'woocommerce/woocommerce.php';
        
	if (in_array( $required_woo_plugin , $plugins ) ) {
            
            load_plugin_textdomain(DP_TEXTDOMAN, false, '/displayProduct/languages');
            add_action('admin_init', array($this, 'action_admin_init'));
            register_activation_hook(__FILE__, array($this,'dpactivate') );
            require_once( plugin_dir_path(__FILE__) . '/tgm-plugin-activation/woocommerce_require.php' );
            require_once( plugin_dir_path(__FILE__) . 'displayProduct-shortcodes.php' );
            require_once( plugin_dir_path(__FILE__) . 'displayProduct-hooks.php' );
            require_once( plugin_dir_path(__FILE__) . '/include/displayProduct-init.php' );
            require_once( plugin_dir_path(__FILE__) . '/include/dp-quickview.php' );
            add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'dp_action_links' ) );
            add_filter('widget_text', 'do_shortcode');            
        }else{
            load_plugin_textdomain(DP_TEXTDOMAN, false, '/displayProduct/languages');
            require_once( plugin_dir_path(__FILE__) . '/tgm-plugin-activation/woocommerce_require.php' );
        }
    }

    function action_admin_init() {

        if (!current_user_can('edit_posts') && !current_user_can('edit_pages'))
            return;

        if (get_user_option('rich_editing') == 'true') {
            add_filter('mce_external_plugins', array($this, 'filter_mce_plugin'));
            add_filter('mce_buttons', array($this, 'filter_mce_button'));
            /* Style */
            wp_enqueue_style('my_custom_script', plugin_dir_url(__FILE__) . '/style.css');
            wp_enqueue_script('wp-color-picker');
            wp_enqueue_style( 'wp-color-picker' );


            //Pharse Product Category ID and Product Category Name to shortcode generator.
            $product_cat = '';
            $args = array('hide_empty' => false);
            $terms = get_terms("product_cat", $args);
            $count = count($terms);
            if ($count > 0) {
                foreach ($terms as $term) {
                    $product_cat.= '<option value="' . $term->slug . '">' . $term->name . '</option>';
                }
            } else {
                $product_cat.= '<option value="nocat">Please Insert product category or add product to category.</option>';
            }
            /* Pharse Variable to Javascript */
            $variable_to_js=array('plugin_folder' => plugin_dir_url(__FILE__), 'product_cat'   => $product_cat);
            $variable_to_js_merge =array_merge($variable_to_js, displayproduct_textdomain());
            wp_localize_script('jquery', 'displayProduct', $variable_to_js_merge);
        }
    }

    function filter_mce_button($buttons) {
       // array_push($buttons, '|', 'displayProduct_button');
        $buttons[] = 'displayProduct_button';
        return $buttons;
    }

    function filter_mce_plugin($plugins) {
        $plugins['displayProduct'] = plugin_dir_url(__FILE__) . '/assets/js/displayProduct_plugin.js';
        return $plugins;
    }
    //Installation
    function dpactivate() {
        $dpCheckpage=get_option("dp_product_shop_page");
        $dp_needs_pages=get_option("dp_needs_pages");
        if ( empty( $dpCheckpage )&& $dp_needs_pages!=1 ){
            update_option( 'dp_needs_pages', 1 );
        }
    }
    public function dp_action_links( $links ) {

		$plugin_links = array(
			'<a target="_blank" href="' . admin_url( 'admin.php?page=display-product-page' ) . '">' . __( 'Settings', DP_TEXTDOMAN ) . '</a>',
			'<a target="_blank" href="http://sureshopress.com/display-product-for-woocommerce/document/">' . __( 'Docs', DP_TEXTDOMAN ) . '</a>',
		);

		return array_merge( $plugin_links, $links );
	}

}

$myproduct = new displayProduct();

$displayimage_width = get_option("display_product_thumbnail_image_size-width");
$displayimage_height = get_option("display_product_thumbnail_image_size-height");
$displayimage_crop = get_option("display_product_thumbnail_image_size-crop");
if(empty($displayimage_width)){
    $displayimage_width=250;
}
if(empty($displayimage_height)){
    $displayimage_height=250;
}
if(empty($displayimage_crop)){
    $displayimage_crop=true;
}
add_image_size( 'display_product_thumbnail', $displayimage_width, $displayimage_height, $displayimage_crop );