<?php
/**
 * Created by PhpStorm.
 * User: fokado
 * Date: 12/11/2017
 * Time: 6:09 PM
 */

public function submit_contact_form($args)
{
    $response = [
        'status' => 'ERROR',
        'errors' => [],
        'message' => esc_html__( "Something Went Wrong", "whcom" ),
    ];
    $whmcs_settings = whcom_get_whmcs_setting();
    if (!empty($args)) {
        if (empty($args['name'])) {
            $response['errors'][] = esc_html__( "You did not enter your name", "whcom" );
        }
        if (empty($args['email'])) {
            $response['errors'][] = esc_html__( "You did not enter your email address", "whcom" );
        }
        else if (!is_email($args['email'])) {
            $response['errors'][] = esc_html__( "You did not enter a valid email address", "whcom" );
        }
        if (empty($args['subject'])) {
            $response['errors'][] = esc_html__( "You did not enter a subject", "whcom" );
        }
        if (empty($args['message'])) {
            $response['errors'][] = esc_html__( "You did not enter a message", "whcom" );
        }
        if (empty($response['errors'])) {
            if (!empty($whmcs_settings) && !empty($whmcs_settings['ContactFormDept']) && (int)$whmcs_settings['ContactFormDept'] > 0) {
                $req = [
                    'action' => 'OpenTicket',
                    'deptid' => esc_attr($args['deptid']),
                    'priority'=> esc_attr($args['priority']),
                    'subject' => esc_attr($args['subject']),
                    'message' => esc_attr($args['message']),
                    'name' => esc_attr($args['name']),
                    'email' => esc_attr($args['email']),

                ];
                $res = whcom_process_api($req);
                if (!empty($res['result'])) {
                    if ($res['result'] == 'success') {
                        $tmp = '<div class="whcom_text_center">' . esc_html__( "Ticket Created", "whcom" ) . " <strong>#" . $res['tid'] . '</strong></div>';
                        $msg = wcap_render_message("",$tmp,"success");

                        $tmp = esc_html__("Your ticket has been successfully created. An email has been sent to your address with the ticket information. If you would like to view this ticket now you can do so.","wcap");
                        $msg2 = wcap_render_message("",$tmp,"");

                        $tmp = '<div class="whcom_text_center">' . wcap_render_continue_button("dashboard","") . '</div>';

                        $response['message'] = $msg.$msg2.$tmp;
                        $response['status'] = 'OK';
                        //$response['debug'] = $res;
                    }
                    else {
                        $response['message'] = esc_html__( "Something went wrong 3", "whcom" );
                    }
                }
                else {
                    $response['message'] = esc_html__( "Something went wrong 2", "whcom" );
                }
            }
            else {
                $to = (!empty($whmcs_settings['ContactFormTo']) && is_email($whmcs_settings['ContactFormTo'])) ? esc_attr($whmcs_settings['ContactFormTo']) : '';
                $subject = 'Contact Form: ' . esc_attr($args['subject']);
                $body = '<strong>' . esc_html__( "Sender Name", "whcom" )  . '</strong>' . esc_attr($args['name']) . '<br>';
                $body .= '<strong>' . esc_html__( "Sender Email", "whcom" )  . '</strong>' .  esc_attr($args['name']) . '<br>';
                $body .= '<strong>' . esc_html__( "Subject", "whcom" )  . '</strong>' .  esc_attr($args['name']) . '<br>';
                $body .= esc_attr($args['message']);
                $headers = array('Content-Type: text/html; charset=UTF-8');

                if (wp_mail( $to, $subject, $body, $headers )) {
                    $response['message'] = esc_html__( "Your Message has been Sent", "whcom" );
                }
                else {
                    $response['message'] = esc_html__( "Something went wrong 4", "whcom" );
                }
            }
        }
    }

    /*		if ($response['status'] == 'OK') {
                $response['message'] = '<div class="whcom_alert whcom_alert_success">' . $response['message'] . '</div>' ;
            }
            else {
                if (!empty($response['errors'])) {
                    $response['message'] = '<div class="whcom_alert whcom_alert_danger">';
                    $response['message'] .= '<div class="whcom_margin_bottom_15"> ' . esc_html__( "The following errors occurred:", "whcom" ) . ' </div>' ;
                    $response['message'] .= '<ul class="whcom_list_padded_narrow">' ;
                    foreach ($response['errors'] as $error) {
                        $response['message'] .= '<li>' .$error. '</li>' ;
                    }
                    $response['message'] .= '</ul>' ;
                    $response['message'] .= '</div>';
                }
                else {
                    $response['message'] = '<div class="whcom_alert whcom_alert_danger">' . $response['message'] . '</div>';
                }
            }*/
    return $response;
}

