<?php defined( 'ABSPATH' ) or die( "Cannot access pages directly." );


if ( ! function_exists( 'whcom_process_api' ) ) {
	function whcom_process_api( $array = [ 'action' => 'GetCurrencies' ] ) {
		$whmcs_url     = esc_url( get_option( 'whcom_whmcs_admin_url' ) );
		$auth_array    = [
			'username'     => esc_attr( get_option( 'whcom_whmcs_admin_user' ) ),
			'password'     => md5( esc_attr( get_option( 'whcom_whmcs_admin_pass' ) ) ),
			'accesskey'    => esc_attr( get_option( 'whcom_whmcs_admin_api_key' ) ),
			'responsetype' => 'json',
		];
		$whmcs_path    = $whmcs_url . '/includes/api.php';
		$request_array = array_merge( $auth_array, $array );

		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $whmcs_path );
		curl_setopt( $ch, CURLOPT_POST, 1 );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $ch, CURLOPT_POSTFIELDS,
			http_build_query( $request_array )
		);
		$res = json_decode( curl_exec( $ch ), true );
		curl_close( $ch );
		return $res;
	}
}

if ( ! function_exists( 'whcom_api_test' ) ) {
	function whcom_api_test() {

		$res = whcom_process_api();

		if (!empty($res['result']) && $res['result'] == 'error' ) {
			whcom_ppa($res);
		}

		$api_test = ( (!empty ($res['result'])) &&  $res['result'] == 'success' ) ? true : false;

		return $api_test;
	}
}
