<?php defined( 'ABSPATH' ) or die( "Cannot access pages directly." );


if ( ! function_exists( 'whcom_process_helper' ) ) {
	function whcom_process_helper( $args = "" ) {
		$Lang = [
			"ar"    => "Arabic",
			"az"    => "Azerbaijani",
			"ca"    => "Catalan",
			"hr"    => "Croatian",
			"cs_CZ" => "Czech",
			"da_DK" => "Danish",
			"de_DE" => "German",
			"en_US" => "English",
			"en_AU" => "English",
			"en_GB" => "English",
			"en"    => "English",
			"fa_IR" => "Farsi",
			"fr_FR" => "French",
			"de_CH" => "German",
			"hu_HU" => "Hungarian",
			"it_IT" => "Italian",
			"nb_NO" => "Norwegian",
			"pt_BR" => "Portuguese-br",
			"pt_PT" => "Portuguese-pt",
			"ru_RU" => "Russian",
			"es_ES" => "Spanish",
			"sv_SE" => "Swedish",
			"tr_TR" => "Turkish",
			"nl_NL" => "Dutch",
		];
		
		


		$response = [
			'status'  => 'ERROR',
			'message' => 'no proper data found in cURL',
			'data'    => []
		];
		$URL = esc_url( get_option( 'whcom_whmcs_admin_url' ) );
		$default = [
			"wcap_db_request" => "",
			"action"          => "wcap_helper_version",
			"hash"            => md5( esc_attr( get_option( 'whcom_whmcs_admin_api_key' ) ) . "creativeON" ),
			"currency"        => whcom_get_current_currency_id(),
		];
		$args    = wp_parse_args( $args, $default );
		
		$URL .= "/index.php?" . http_build_query( $args );

		$c = curl_init();
		curl_setopt( $c, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $c, CURLOPT_URL, $URL );
		$res = curl_exec( $c );
		curl_close( $c );
		if ( whcom_is_json( $res ) ) {
			$response = json_decode( $res, true );
			if (!empty($response['status']) && $response['status'] == 'OK') {
				if (!isset($response['data'])) {
					$response['data'] = '';
				}
			}
			else {
				$response['message'] = (!empty($response['message'])) ? $response['message'] : esc_html__( "Helper data not properly formatted 1", "whcom" );
			}
		}
		else {
			$response['message'] = esc_html__( "Helper data not properly formatted 2", "whcom" );
		}
		return $response;
	}
}

if ( ! function_exists('whcom_helper_test')) {
	function whcom_helper_test () {
		$args     = [
			"wcap_helper_online" => "1",
		];
		$response = whcom_process_helper( $args );
		if ($response['status'] == 'OK') {
			return true;
		}
		else {
			return false;
		}
	}
}

if ( ! function_exists( 'whcom_get_helper_version' ) ) {
	function whcom_get_helper_version() {
		$args     = [
			"action" => "whcom_get_helper_version",
		];
		$response = whcom_process_helper( $args );
		if ($response['status'] == 'OK') {
			return $response['data'];
		}
		else {
			return $response['message'];
		}
	}
}



