<?php defined( 'ABSPATH' ) or die( "Cannot access pages directly." );
$cart          = whcom_get_cart();
$tax_settings  = whcom_get_whmcs_setting();
$domain_addons = whcom_get_domain_addons();

$counter      = 0;
$totals       = [
	'prod_total'   => 0.00,
	'prod_setup'   => 0.00,
	'addon_setup'  => 0.00, // Addon only
	'addon_total'  => 0.00, // Addon only
	'addons_setup' => 0.00, // Product Addons
	'addons_total' => 0.00, // Product Addons
	'domain'       => 0.00,
	'grand'        => 0.00,
	'discount'     => 0.00,
	// recurring
	'monthly'      => false,
	'quarterly'    => false,
	'semiannually' => false,
	'annually'     => false,
	'biennially'   => false,
	'triennially'  => false,
	'base_price'   => 0.00,
	'l1_rate'      => 0.00,
	'l2_rate'      => 0.00,
	'l1_amount'    => 0.00,
	'l2_amount'    => 0.00,
	'final_price'  => 0.00,
];
$summary_html = [
	'full'   => '',
	'side'   => 'Side Summary Start',
	'short'  => 'Short Summary Started ',
	'button' => '',
];


ob_start(); ?>


<ul class="whcom_list whcom_list_padded whcom_list_stripped">

	<?php if ( ! empty( $cart['all_items'] ) ) { ?>
		<?php foreach ( $cart['all_items'] as $cart_index => $cart_item ) {
			$found_item  = $product = $addons = $addon = $service = false;
			$domain_text = $domain_details = [];
			$item_totals = [
				'prod_total'   => 0.00,
				'prod_setup'   => 0.00,
				'addon_setup'  => 0.00, // Addon only
				'addon_total'  => 0.00, // Addon only
				'addons_setup' => 0.00, // Product Addons
				'addons_total' => 0.00, // Product Addons
				'domain'       => 0.00,
				'grand'        => 0.00,
				'discount'     => 0.00,
				// recurring
				'monthly'      => false,
				'quarterly'    => false,
				'semiannually' => false,
				'annually'     => false,
				'biennially'   => false,
				'triennially'  => false,
			];

			$tld         = '';
			$found_array = [
				'product'             => false,
				'product_domain'      => false,
				'product_addons'      => false,
				'product_options'     => false,
				'product_domain_free' => false,
				'addon'               => false,
				'domain'              => false,
				'renew_domain'        => false,
			];
			// Check if domain is found
			if ( ! empty( $cart_item['domain'] ) ) {
				$tld            = whcom_get_tld_from_domain( $cart_item['domain'] );
				$domain_details = whcom_get_tld_details( $tld );
				if ( ! empty( $domain_details ) ) {
					if ( ( ! empty( $cart_item['pid'] ) && (int) $cart_item['pid'] > 0 ) ) {
						$found_array['product_domain'] = true;
					}
					else {
						$found_array['domain'] = true;
					}
					$found_item = true;
				}
			}
			// Check if product is found
			if ( ! empty( $cart_item['pid'] ) && (int) $cart_item['pid'] > 0 ) {
				$product = whcom_get_product_details( $cart_item['pid'] );
				if ( $product ) {
					$found_array['product'] = $found_item = true;
					if ( ! empty( $cart_item['configoptions'] ) ) {
						$found_array['product_options'] = ( empty( $cart_item['configoptions'] ) ) ? [] : $cart_item['configoptions'];
					}
					if ( ! empty( $cart_item['addons'] ) ) {
						$found_array['product_addons']  = ( empty( $cart_item['addons'] ) ) ? [] : explode( ',', (string) $cart_item['addons'] );
					}
					if ( $found_array['product_domain'] ) {
						$free_domain_billingcycles = explode( ',', $product['freedomainpaymentterms'] );
						$free_domain_tlds          = explode( ',', $product['freedomaintlds'] );
						if (
							( (string) $product['freedomain'] == 'on' || (string) $product['freedomain'] == 'once')
							&& ( in_array( $tld, $free_domain_tlds ) )
							&& ( in_array( $cart_item['billingcycle'], $free_domain_billingcycles ) )
							&& ( in_array( $cart_item['billingcycle'], $free_domain_billingcycles ) )

						) {
							$found_array['product_domain_free'] = true;
						}
					}
				}
			}


			// Addon only order
			if ( ! empty( $cart_item['addonids'] ) && ! empty( $cart_item['serviceids'] ) ) {
				$addon   = whcom_get_addon_details( $cart_item['addonids'] );
				$service = whcom_get_service_details( $cart_item['serviceids'] );
				if ( ! empty( $addon ) && ! empty( $service ) ) {
					$addon_duration = ( ! empty( $service['billingcycle'] ) ) ? strtolower( $service['billingcycle'] ) : '';
					if ( empty( $addon['all_prices'][ $addon_duration ] ) ) {
						reset( $addon['all_prices'] );
						$addon_duration = key( $product['all_prices'] );
					}
					$addon_duration = ( $addon_duration == 'recurring' ) ? 'monthly' : $addon_duration;
					$found_array['addon'] = $found_item     = true;

				}
			}

			if ( ! $found_item ) {
				continue;
			}

			$cart_item          = whcom_calculate_promotion( $cart_item );
			$discounted_domain  = ( ! empty( $cart_item['domain_discount'] ) && (float) $cart_item['domain_discount']['value'] > 0.00 ) ? true : false;
			$discounted_product = ( ! empty( $cart_item['product_discount'] ) && (float) $cart_item['product_discount']['value'] > 0.00 ) ? true : false;
			?>

			<?php // Product ?>
			<?php if ( $found_array['product'] ) { ?>
				<?php
				$item_totals['prod_total'] = $product['all_prices'][ $cart_item['billingcycle'] ]['price'];
				$item_totals['prod_setup'] = $product['all_prices'][ $cart_item['billingcycle'] ]['setup'];
				?>
				<li>
					<div class="whcom_op_summary_item_container">
						<a href="#" class="whcom_op_delete_cart_item" data-cart-index="<?php echo $cart_index ?>"><span class="whcom_icon_cancel"></span></a>

						<div class="whcom_row">
							<div class="whcom_col_sm_7">
								<strong><?php echo $product['name']; ?></strong><br>
								<span class="whcom_text_small"><?php echo $product['group_name']; ?></span>
								<?php if ( ! empty( $cart_item['domain'] ) ) { ?>
									<div class="whcom_text_small">
										<a href="<?php echo $cart_item['domain']; ?>" target="_blank"><?php echo $cart_item['domain']; ?></a>
									</div>
								<?php } ?>
								<?php if ( ! empty( $cart_item['hostname'] ) ) { ?>
									<div class="whcom_text_small">
										<?php echo $cart_item['hostname']; ?>
									</div>
								<?php } ?>
								<?php if ( $found_array['product_options'] ) { ?>
									<div class="whcom_text_small whcom_padding_0_10">
										<?php foreach ( $found_array['product_options'] as $option_id => $sub_option_id ) { ?>
											<?php
											$curr_option         = $product['prd_configoptions'][ $option_id ];
											$curr_option_html    = $curr_option['optionname'] . ' ';
											$configoption_amount = 0.00;
											$configoption_setup = 0.00;
											?>
											<?php switch ( $curr_option['optiontype'] ) {
												case '1' : {
													$curr_sub_option     = $curr_option['sub_options'][ $sub_option_id ];
													$curr_option_html    .= '(' . whcom_format_amount( $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'] ) . ')';
													$configoption_amount = (float) $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'];
													$configoption_setup = (float) $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['setup'];
													break;
												}
												case '2' : {
													$curr_sub_option     = $curr_option['sub_options'][ $sub_option_id ];
													$curr_option_html    .= '(' . whcom_format_amount( $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'] ) . ')';
													$configoption_amount = (float) $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'];
													$configoption_setup = (float) $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['setup'];
													break;
												}
												case '3' : {
													$curr_sub_option = reset( $curr_option['sub_options'] );
													if ( $sub_option_id > 0 ) {
														$curr_option_html    .= '(' . whcom_format_amount( $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'] ) . ')';
														$configoption_amount = (float) $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'];
														$configoption_setup = (float) $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['setup'];
													}
													break;
												}
												case '4' : {
													$curr_sub_option  = reset( $curr_option['sub_options'] );
													$curr_option_html .= '(';
													$curr_option_html .= whcom_format_amount( $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'] ) . ' x ';
													$curr_option_html .= $sub_option_id;
													$curr_option_html .= ')';

													$configoption_amount = (float) ( $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['price'] * $sub_option_id );
													$configoption_setup = (float) ( $curr_sub_option['all_prices'][ $cart_item['billingcycle'] ]['setup'] * $sub_option_id );
													break;
												}
												default : {
													$curr_sub_option = [];
												}
											}
											?>
											<div>
												<i class="whcom_icon_angle-double-right"></i> <?php echo $curr_option_html ?>
											</div>
											<?php $item_totals['prod_total'] = $item_totals['prod_total'] + $configoption_amount; ?>
											<?php $item_totals['prod_setup'] = $item_totals['prod_setup'] + $configoption_setup; ?>
										<?php } ?>
									</div>
								<?php } ?>
							</div>
							<div class="whcom_col_sm_5 whcom_text_right">
								<div class="whcom_op_summary_item_price whcom_summary_product_price <?php echo ((float) $setup_price > 0) ? '' : 'free'; ?>">
									<strong><?php echo whcom_format_amount( $item_totals['prod_total'] ) ?></strong>
								</div>
								<div class="whcom_text_small">
									<?php echo whcom_convert_billingcycle( $cart_item['billingcycle'] ); ?>
								</div>
								<div class="whcom_text_small whcom_summary_product_setup <?php echo ((float)$setup_price > 0) ? '' : 'free'; ?>">
									<?php echo whcom_format_amount( $item_totals['prod_setup'] ) ?>
									<?php esc_html_e( 'Setup Fee', 'whcom' ) ?>
								</div>
							</div>
							<?php $item_totals[$cart_item['billingcycle']] = $item_totals['prod_total'] ?>
						</div>


					</div>
				</li>
			<?php } ?>

			<?php // Addons with product ?>
			<?php if ( $found_array['product_addons'] ) { ?>
				<?php foreach ( $found_array['product_addons'] as $addon_id ) { ?>
					<li>
						<div class="whcom_op_summary_item_container">
							<div class="whcom_row">
								<div class="whcom_col_sm_7">
									<?php
									$curr_addon = $product['prd_addons'][ $addon_id ];
									// Addon price logic
									$addon_billingcycle = strtolower( $curr_addon['billingcycle'] );
									if ( $addon_billingcycle == 'recurring' ) {
										if ( isset( $curr_addon[ $cart_item['billingcycle'] ] ) && $curr_addon[ $cart_item['billingcycle'] ] >= 0 ) {
											$addon_billingcycle = $cart_item['billingcycle'];
											$curr_addon_price   = $curr_addon['all_prices'][ $addon_billingcycle ]['price'];
											$curr_addon_setup   = $curr_addon['all_prices'][ $addon_billingcycle ]['setup'];
										}
										else {
											reset( $curr_addon['lowest_price'] );
											$addon_billingcycle = key( $curr_addon['lowest_price'] );
											$curr_addon_price   = $curr_addon['lowest_price'][ $addon_billingcycle ]['price'];
											$curr_addon_setup   = $curr_addon['lowest_price'][ $addon_billingcycle ]['setup'];
										}
									}
									elseif ($addon_billingcycle == 'free') {
										$curr_addon_price = 0.00;
										$curr_addon_setup = 0.00;
									}
									else {
										$curr_addon_price = $curr_addon['monthly'];
										$curr_addon_setup = $curr_addon['msetupfee'];
									}

									$item_totals['addons_total'] = $item_totals['addons_total'] + $curr_addon_price;
									$item_totals['addons_setup'] = $item_totals['addons_setup'] + $curr_addon_setup;
									$item_totals[$addon_billingcycle] = $item_totals[$addon_billingcycle] + $curr_addon_price;

									?>
									<div>
										<strong><?php echo $curr_addon['name']; ?></strong>
										<div class="whcom_text_small">
											<?php esc_html_e( "Addon", "whcom" ); ?>
										</div>
										<div class="whcom_text_small">
											<?php echo whcom_format_amount( $curr_addon_setup ); ?>
											<?php esc_html_e( "Setup Fee", "whcom" ); ?>
										</div>
									</div>
								</div>
								<div class="whcom_col_sm_5 whcom_text_right">
									<?php echo whcom_format_amount( $curr_addon_price ); ?>
									<div class="whcom_text_small">
										<?php echo whcom_convert_billingcycle( $addon_billingcycle ); ?>
									</div>
								</div>
							</div>
						</div>
					</li>
				<?php } ?>
			<?php } ?>

			<?php // Addon only ?>
			<?php if ( $found_array['addon'] ) { ?>
				<li>
					<?php
					// Addon price logic
					$addon_duration = strtolower( $addon['billingcycle'] );
					$service_duration = strtolower( $service['billingcycle'] );
					if ( $addon_duration == 'recurring' ) {
						if ( isset( $addon[ $service_duration ] ) && $addon[ $service_duration ] >= 0 ) {
							$addon_price   = $addon['all_prices'][ $service_duration ]['price'];
							$addon_setup   = $addon['all_prices'][ $service_duration ]['setup'];
						}
						else {
							reset( $addon['lowest_price'] );
							$addon_duration = key( $addon['lowest_price'] );
							$addon_price   = $addon['lowest_price']['price'];
							$addon_setup   = $addon['lowest_price']['setup'];
						}
					}
					else {
						$addon_price = $addon['monthly'];
						$addon_setup = $addon['msetupfee'];
					}

					$item_totals['addon_total'] = $item_totals['addon_total'] + $addon_price;
					$item_totals['addon_setup'] = $item_totals['addon_setup'] + $addon_setup;
					$item_totals[$addon_duration] = $item_totals[$addon_duration] + $addon_price;

					?>
					<div class="whcom_op_summary_item_container">
						<a href="#" class="whcom_op_delete_cart_item" data-cart-index="<?php echo $cart_index ?>"><span class="whcom_icon_cancel"></span></a>
						<div class="whcom_row">
							<div class="whcom_col_sm_7">
								<div><strong><?php echo $addon['name']; ?></strong></div>
								<?php if ( ! empty( $service['name'] ) ) { ?>
									<div class="whcom_text_small"><?php echo $service['name']; ?></div>
								<?php } ?>
								<?php if ( ! empty( $service['domain'] ) ) { ?>
									<div class="whcom_text_small"><?php echo $service['domain']; ?></div>
								<?php } ?>
							</div>
							<div class="whcom_col_sm_5 whcom_text_right">
								<div class="whcom_op_summary_item_price">
									<strong>
										<?php echo whcom_format_amount( $addon_price ) ?> +
										<?php echo whcom_format_amount( $addon_setup ) ?>
										<?php esc_html_e( 'Setup Fee', 'whcom' ) ?>
									</strong>
								</div>
								<div class="whcom_text_small">
									<?php echo whcom_convert_billingcycle( $service_duration ); ?>
								</div>
							</div>
						</div>
					</div>
				</li>
			<?php } ?>

			<?php // Domain, with or without product ?>
			<?php if ( ! empty( $domain_details ) ) { ?>
				<li>
					<div class="whcom_op_summary_item_container">
						<a href="#" class="whcom_op_delete_cart_item" data-cart-index="<?php echo $cart_index ?>"><span class="whcom_icon_cancel"></span></a>
						<?php
						$domain_text           = whcom_generate_domain_text( $domain_details, $cart_item['domaintype'], $cart_item['regperiod'], $found_array['product_domain_free'], $cart_index );
						$item_totals['domain'] = (float) $domain_text['price'];

						?>

						<div class="whcom_op_summary_item_domains">
							<div class="whcom_row">
								<div class="whcom_col_sm_7">
									<strong><?php esc_html_e( 'Domain ', 'whcom' ) ?><?php echo ( $cart_item['domaintype'] == 'register' ) ? esc_html__( "Registration", "whcom" ) : ucfirst( $cart_item['domaintype'] ); ?></strong>
									<div class="whcom_text_small">
										<a href="<?php echo $cart_item['domain']; ?>"
										   target="_blank"><?php echo $cart_item['domain']; ?></a>
									</div>
									<div class="whcom_text_small whcom_padding_0_10">
										<?php if ( ! empty( $cart_item['dnsmanagement'] ) ) { ?>
											<?php $domain_addon_price = (float) $domain_addons['dnsmanagement'] * (float) $cart_item['regperiod']; ?>
											<div><i class="whcom_icon_angle-double-right"></i>
												<?php esc_html_e( "DNS Management", 'whcom' ) ?>
												- <?php echo whcom_format_amount( $domain_addon_price ) . ' ' . $domain_text['text']; ?>
											</div>
											<?php $item_totals['domain'] = $item_totals['domain'] + (float) $domain_addon_price; ?>
										<?php } ?>
										<?php if ( ! empty( $cart_item['emailforwarding'] ) ) { ?>
											<?php $domain_addon_price = (float) $domain_addons['emailforwarding'] * (float) $cart_item['regperiod']; ?>
											<div><i class="whcom_icon_angle-double-right"></i>
												<?php esc_html_e( "Email Forwarding", 'whcom' ) ?>
												- <?php echo whcom_format_amount( $domain_addon_price ) . ' ' . $domain_text['text']; ?>
											</div>
											<?php $item_totals['domain'] = $item_totals['domain'] + (float) $domain_addon_price; ?>
										<?php } ?>
										<?php if ( ! empty( $cart_item['idprotection'] ) ) { ?>
											<?php $domain_addon_price = (float) $domain_addons['idprotection'] * (float) $cart_item['regperiod']; ?>
											<div><i class="whcom_icon_angle-double-right"></i>
												<?php esc_html_e( "ID Protection", 'whcom' ) ?>
												- <?php echo whcom_format_amount( $domain_addon_price ) . ' ' . $domain_text['text']; ?>
											</div>
											<?php $item_totals['domain'] = $item_totals['domain'] + (float) $domain_addon_price; ?>
										<?php } ?>
									</div>
								</div>
								<div class="whcom_col_sm_5 whcom_text_right">
									<?php echo whcom_format_amount( $item_totals['domain'] ); ?>
									<div>
										<?php echo strtolower( $domain_text['text'] ); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</li>
			<?php } ?>


			<?php //$item_totals = whcom_apply_item_discount( $item_totals, $cart_item ); ?>
			<?php //$item_totals = whcom_calculate_tax( $item_totals, $tax_settings ); ?>

			<?php
			// Base
			$totals['prod_total']   = (float) $totals['prod_total'] + (float) $item_totals['prod_total'];
			$totals['prod_setup']   = (float) $totals['prod_setup'] + (float) $item_totals['prod_setup'];
			$totals['addon_setup']  = (float) $totals['addon_setup'] + (float) $item_totals['addon_setup'];
			$totals['addon_total']  = (float) $totals['addon_total'] + (float) $item_totals['addon_total'];
			$totals['addons_setup'] = (float) $totals['addons_setup'] + (float) $item_totals['addons_setup'];
			$totals['addons_total'] = (float) $totals['addons_total'] + (float) $item_totals['addons_total'];
			$totals['domain']       = (float) $totals['domain'] + (float) $item_totals['domain'];

			// Recurring
			$totals['monthly']      = (float) $totals['monthly'] + (float) $item_totals['monthly'];
			$totals['quarterly']    = (float) $totals['quarterly'] + (float) $item_totals['quarterly'];
			$totals['semiannually'] = (float) $totals['semiannually'] + (float) $item_totals['semiannually'];
			$totals['annually']     = (float) $totals['annually'] + (float) $item_totals['annually'];
			$totals['biennially']   = (float) $totals['biennially'] + (float) $item_totals['biennially'];
			$totals['triennially']  = (float) $totals['triennially'] + (float) $item_totals['triennially'];

			// Totals
			$totals['grand']    = (float) $totals['grand'] + (float) $item_totals['grand'];
			$totals['discount'] = (float) $totals['discount'] + (float) $item_totals['discount'];

			// Taxes
			$totals['base_price']  = (float) $totals['base_price'] + (float) $item_totals['base_price'];
			$totals['l1_rate']     = (float) $totals['l1_rate'] + (float) $item_totals['l1_rate'];
			$totals['l2_rate']     = (float) $totals['l2_rate'] + (float) $item_totals['l2_rate'];
			$totals['l1_amount']   = (float) $totals['l1_amount'] + (float) $item_totals['l1_amount'];
			$totals['l2_amount']   = (float) $totals['l2_amount'] + (float) $item_totals['l2_amount'];
			$totals['final_price'] = (float) $totals['final_price'] + (float) $item_totals['final_price'];

			?>


			<?php $counter ++; ?>

			<?php ob_start() ?>
			Sidebar Short Appended
			<?php $summary_html['short'] .= ob_get_clean(); ?>
		<?php } ?>
	<?php } ?>

	<?php if ( ! empty( $cart['order_specific']['domainrenewals'] ) ) { ?>
		<?php foreach ( $cart['order_specific']['domainrenewals'] as $domainrenewal ) { ?>
			<li>Domain Renewal here,</li>
		<?php } ?>
	<?php } ?>
</ul>


<?php if ( $counter < 1 ) { ?>
	<div class="whcom_alert whcom_alert_info">
		<?php esc_html_e( 'Your Shopping Cart is Empty', 'whcom' ); ?>
	</div>
<?php } ?>



<?php ob_start() ?>
<div class="whcom_cart_summary_sidebar">
	<?php
	$totals['base_price'] = $totals['prod_total'] + $totals['prod_setup'] + $totals['addons_total'] + $totals['addons_setup'] + $totals['addon_total'] + $totals['addon_setup'] + $totals['domain'];
	$totals['base_price'] = $totals['prod_total'] + $totals['prod_setup'] + $totals['addons_total'] + $totals['addons_setup'] + $totals['addon_total'] + $totals['addon_setup'] + $totals['domain'];
	$subtotal = $totals['base_price'] + $totals['discount'];


	$totals['final_price'] = $subtotal + $totals['l1_amount'] - $totals['l2_amount'];







	?>


	<div class="whcom_clearfix whcom_margin_bottom_5 whcom_padding_5_0 whcom_bordered_bottom">
		<span class="whcom_pull_left"><?php esc_html_e( 'Subtotal', 'whcom' ) ?></span>
		<span class="whcom_pull_right"><?php echo whcom_format_amount( $subtotal ); ?></span>
	</div>
	<?php if ( $totals['l1_amount'] > 0 || $totals['l2_amount'] > 0 || $totals['discount'] > 0 ) { ?>
		<div class="whcom_padding_10_0 whcom_bordered_top_bottom">
			<?php if ( $totals['discount'] > 0 ) { ?>
				<?php $current_discount = whcom_get_current_promo(); ?>
				<?php
				$discount_value = $current_discount['value'];
				$discount_type  = esc_html__( "One Time Discount", "whcom" );
				if ( $current_discount['recurring'] == '1' ) {
					$discount_type = esc_html__( "Recurring Discount", "whcom" );
				}

				switch ( $current_discount['type'] ) {
					case 'Free Setup' : {
						$discount_value = esc_html__( "Free Setup", "whcom" );
						break;
					}
					case 'Fixed Amount' : {
						$discount_value = whcom_format_amount( $current_discount['value'] );
						break;
					}
					case 'Price Override' : {
						$discount_value = whcom_format_amount( $current_discount['value'] ) . ' ' . esc_html__( "Price Override", "whcom" );
						break;
					}
					case 'Percentage' : {
						$discount_value = $current_discount['value'] . esc_html__( "%", "whcom" );
						break;
					}
					default : {

					}
				}


				?>
				<?php ?>
				<div class="whcom_clearfix">
					<span class="whcom_pull_left">
						<?php echo $discount_value; ?>
						<?php echo $discount_type; ?>
					</span>
					<span class="whcom_pull_right"><?php echo whcom_format_amount( $totals['discount'] ); ?></span>
				</div>
			<?php } ?>
			<?php if ( $totals['l1_amount'] > 0 ) { ?>

				<div class="whcom_clearfix">
					<span class="whcom_pull_left"><?php esc_html_e( "L1 Tax rule, @ ", 'whcom' ) ?><?php echo $totals['l1_rate'] ?>
						&#37;</span>
					<span class="whcom_pull_right"><?php echo whcom_format_amount( $totals['l1_amount'] ); ?></span>
				</div>
			<?php } ?>
			<?php if ( $totals['l2_amount'] > 0 ) { ?>

				<div class="whcom_clearfix">
					<span class="whcom_pull_left"><?php esc_html_e( "L2 Tax rule, @ ", 'whcom' ) ?><?php echo $totals['l2_rate'] ?>
						&#37;</span>
					<span class="whcom_pull_right"><?php echo whcom_format_amount( $totals['l2_amount'] ); ?></span>
				</div>
			<?php } ?>
		</div>
	<?php } ?>
	<div class="whcom_clearfix whcom_margin_bottom_30">
		<span class="whcom_pull_left"><?php esc_html_e( 'Totals', 'whcom' ) ?></span>

		<?php
		$billingcycles = [
			'monthly',
			'quarterly',
			'semiannually',
			'annually',
			'biennially',
			'triennially',
		];
		?>
		<?php foreach ( $totals as $key => $total ) { ?>
			<?php if ( $total && in_array($key, $billingcycles) ) { ?>
				<div class="whcom_clearfix">
					<div class="whcom_pull_right">
						<span><?php echo whcom_format_amount( $total ); ?></span> <span><?php echo whcom_convert_billingcycle( $key ) ?></span>
					</div>
				</div>
			<?php } ?>
		<?php } ?>
	</div>
	<div class="whcom_clearfix">
		<div class="whcom_text_right"><strong><?php echo whcom_format_amount( $totals['final_price'] ); ?></strong></div>
		<div class="whcom_text_right"><?php esc_html_e( 'Total Due Today', 'whcom' ) ?></div>
	</div>
</div>

<?php $summary_html['side'] = ob_get_clean(); ?>

<?php

$summary_html['status']      = 'OK';
$summary_html['message']     = esc_html__( 'Updating Cart Summaries', 'whcom' );
$summary_html['detailed']    = ob_get_clean();
$summary_html['total_items'] = $counter;
$summary_html['grand_total'] = whcom_format_amount( $totals['final_price'] );
?>

