<?php
//page initialization, veriables for whole page
$show_sidebar = wcap_show_side_bar("knowledgebase");

//show front menu where applicable
if (wcap_show_front_menu()) {
    include_once $this->Path . "/views/top_links_front.php";
}
$response = wcap_get_knowledgebase_cats();
?>

<div class="wcap_knowledgebase ">
    <div class="whcom_row">
        <?php if ($show_sidebar) { ?>
            <div class="whcom_col_sm_3">
                <?php //side bar content ?>
                <?php wcap_render_support_panel(); ?>
            </div>
        <?php } ?>
        <div class="<?php echo ($show_sidebar) ? 'whcom_col_sm_9' : 'whcom_col_sm_12'; ?>">
            <div class="whcom_page_heading">
                <span><?php esc_html_e("Knowledgebase", "whcom" ) ?></span>
            </div>

            <?php //main content ?>
            <div class="whcom_margin_bottom_15">
                <h3><?php esc_html_e("Categories", "whcom" ) ?></h3>

                <?php if ($response["status"] != "OK") { ?>
                    <div class="whcom_alert whcom_alert_danger whcom_text_center">
                        <?php echo $response["message"] ?>
                    </div>
                <?php } ?>

                <?php if ($response["status"] == "OK") { ?>
                    <?php foreach ($response["data"] as $key => $category) { ?>
                        <p><i class="whcom_icon_folder-empty"></i>
                            <a href="?catid=<?php echo $category["id"]; ?>" class="wcap_load_page"
                               data-page="kb_articles">
                                <?php echo $category["name"]; ?>
                            </a></br>

                            <?php echo $category["description"]; ?>
                        </p>
                    <?php } ?>
                <?php } ?>

            </div>


        </div>
    </div>
</div>







