<?php
/**
 * Admin class
 *
 * @author  Yithemes
 * @package YITH WooCommerce EU Energy Label Premium
 * @version 1.0.0
 */

if ( !defined( 'YITH_WCEUE' ) ) {
    exit;
} // Exit if accessed directly

if ( !class_exists( 'YITH_WCEUE_Admin_Premium' ) ) {
    /**
     * Admin class.
     * The class manage all the Admin behaviors.
     *
     * @author   Leanza Francesco <leanzafrancesco@gmail.com>
     * @since    1.0.0
     *
     */
    class YITH_WCEUE_Admin_Premium extends YITH_WCEUE_Admin {

        /**
         * Constructor
         *
         * @access public
         * @since  1.0.0
         */
        public function __construct() {
            parent::__construct();

            add_filter( 'yith_wceue_settings_admin_tabs', array( $this, 'set_premium_tabs' ) );
            add_filter( 'yith_wceue_panel_settings_options', array( $this, 'add_options_in_settings_tab' ) );


            // register plugin to licence/update system
            add_action( 'wp_loaded', array( $this, 'register_plugin_for_activation' ), 99 );
            add_action( 'admin_init', array( $this, 'register_plugin_for_updates' ) );
        }

        /*
         * modify Tabs in Best Sellers Settings Panel
         *
         * @access public
         * @since  1.0.0
         */
        public function set_premium_tabs( $tabs ) {
            unset( $tabs[ 'premium' ] );

            return $tabs;
        }

        /*
         * add premium options in Settings Tab
         *
         * @access public
         * @since  1.0.0
         */
        public function add_options_in_settings_tab( $settings ) {
            $premium_settings = array(
                'link-options'                       => array(
                    'title' => __( 'Label Linking Options', 'yith-wceue' ),
                    'type'  => 'title',
                    'desc'  => '',
                    'id'    => 'yith-wceue-link-options'
                ),
                'link-to'                           => array(
                    'name'    => __( 'Energy label links to', 'yith-wceue' ),
                    'type'    => 'select',
                    'desc'    => __( 'Select what you want to link', 'yith-wceue' ),
                    'id'      => 'yith-wceue-link-to',
                    'options' => array(
                        'none' => __( 'Nothing', 'yith-wceue' ),
                        'same_el' => __( 'All products with the same energy label', 'yith-wceue' ),
                        'custom_url' => __( 'Custom URL', 'yith-wceue' ),
                    ),
                    'default' => 'none'
                ),
                'link-custom-url'                            => array(
                    'name'    => __( 'Custom URL', 'yith-wceue' ),
                    'type'    => 'text',
                    'desc'    => __( 'Insert the custom URL', 'yith-wceue' ),
                    'id'      => 'yith-wceue-link-custom-url',
                    'default' => ''
                ),
                'link-options-end'                   => array(
                    'type' => 'sectionend',
                    'id'   => 'yith-wceue-link-options'
                ),
            );


            $settings[ 'settings' ] = array_merge( $settings[ 'settings' ], $premium_settings );

            return $settings;
        }

        /**
         * add panel for EU Energy Label Tab [in product wc-metabox]
         *
         * @access public
         * @since  1.0.0
         * @author Leanza Francesco <leanzafrancesco@gmail.com>
         */
        public function add_product_data_panels() {
            global $post;
            $meta = get_post_meta( $post->ID, '_yith_wceue_eu_meta', true );
            $energy_label = get_post_meta( $post->ID, '_yith_wceue_eu_energy_label', true );

            $default = array(
                'energy_label' => $energy_label,
                'show_tooltip' => 'off',
                'custom_image' => '',
            );

            $meta = wp_parse_args( $meta, $default );

            wc_get_template( '/admin/eu_energy_panel.php', $meta, YITH_WCEUE_TEMPLATE_PATH, YITH_WCEUE_TEMPLATE_PATH );
        }

        /**
         * Add a panel under YITH Plugins tab
         *
         * @return   void
         * @since    1.0
         * @author   Leanza Francesco <leanzafrancesco@gmail.com>
         * @use      /Yit_Plugin_Panel class
         * @see      plugin-fw/lib/yit-plugin-panel.php
         */
        public function register_panel() {
            parent::register_panel();
            add_action( 'woocommerce_admin_field_yith_wceue_upload', array( $this->_panel, 'yit_upload' ), 10, 1 );
        }

        public function admin_enqueue_scripts() {
            wp_enqueue_style( 'yith_wceue_admin_style', YITH_WCEUE_ASSETS_URL . '/css/admin.css' );

            $screen = get_current_screen();

            if ( 'product' == $screen->id ) {
                wp_enqueue_script( 'yith_wceue_admin_product_js', YITH_WCEUE_ASSETS_URL . '/js/admin_product.js', array( 'jquery' ), '1.0.0', true );
                wp_localize_script( 'yith_wceue_admin_product_js', 'yith_lang', array(
                    'choose_image' => __( 'Choose Image', 'yith-wceue' )
                ) );
            }
            $menu_slug = sanitize_title( __( 'YIT Plugins', 'yith-plugin-fw' ) );

            if( $menu_slug . '_page_yith_wceue_panel' == $screen->id  ) {
                wp_enqueue_script( 'yith_wceue_admin_settings_js', YITH_WCEUE_ASSETS_URL . '/js/admin_settings.js', array( 'jquery' ), '1.0.0', true );
            }

        }

        /**
         * Register plugins for activation tab
         *
         * @return void
         * @since 1.0.0
         */
        public function register_plugin_for_activation() {
            if( ! class_exists( 'YIT_Plugin_Licence' ) ){
                require_once( YITH_WCAUTHNET_DIR . 'plugin-fw/lib/yit-plugin-licence.php' );
            }

            YIT_Plugin_Licence()->register( YITH_WCEUE_INIT, YITH_WCEUE_SECRET_KEY, YITH_WCEUE_SLUG );
        }

        /**
         * Register plugins for update tab
         *
         * @return void
         * @since 1.0.0
         */
        public function register_plugin_for_updates() {
            if( ! class_exists( 'YIT_Plugin_Licence' ) ){
                require_once( YITH_WCAUTHNET_DIR . 'plugin-fw/lib/yit-upgrade.php' );
            }

            YIT_Upgrade()->register( YITH_WCEUE_SLUG, YITH_WCEUE_INIT );
        }
    }
}

/**
 * Unique access to instance of YITH_WCEUE_Admin class
 *
 * @return \YITH_WCEUE_Admin_Premium
 * @since 1.0.0
 */
function YITH_WCEUE_Admin_Premium() {
    return YITH_WCEUE_Admin_Premium::get_instance();
}

?>
