<?php
/**
 * Main class
 *
 * @author  Yithemes
 * @package YITH WooCommerce EU Energy Label Premium
 * @version 1.0.0
 */


if ( !defined( 'YITH_WCEUE' ) ) {
    exit;
} // Exit if accessed directly

if ( !class_exists( 'YITH_WCEUE_Premium' ) ) {
    /**
     * YITH WooCommerce EU Energy Label Premium
     *
     * @since 1.0.0
     */
    class YITH_WCEUE_Premium extends YITH_WCEUE {

        /**
         * Constructor
         *
         * @return mixed| YITH_WCEUE_Admin | YITH_WCEUE_Frontend
         * @since 1.0.0
         */
        public function __construct() {

            // Load Plugin Framework
            add_action( 'plugins_loaded', array( $this, 'plugin_fw_loader' ), 15 );

            // Class admin
            if ( is_admin() ) {
                YITH_WCEUE_Admin_Premium();
            } // Class frontend
            else {
                YITH_WCEUE_Frontend_Premium();
            }
        }
    }
}

/**
 * Unique access to instance of YITH_WCEUE class
 *
 * @return \YITH_WCEUE
 * @since 1.0.0
 */
function YITH_WCEUE_Premium() {
    return YITH_WCEUE_Premium::get_instance();
}

?>