<?php
/**
* Plugin Name: YITH WooCommerce EU Energy Label Premium
* Plugin URI: http://persianscript.ir
* Description:YITH WooCommerce EU Energy Label Premium allows you to assign EU Energy Labels to your products.
* Version: 1.0.2
* Author: YIThemes
* Author URI: http://persianscript.ir/
* Text Domain: yith-wceue
* Domain Path: /languages/
*
* @author yithemes
* @package YITH WooCommerce EU Energy Label Premium
* @version 1.0.2
*/
/*  Copyright 2015  Your Inspiration Themes  (email : plugins@yithemes.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

if ( !defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly

if ( ! function_exists( 'is_plugin_active' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

// Free version deactivation if installed __________________

if( ! function_exists( 'yit_deactive_free_version' ) ) {
    require_once 'plugin-fw/yit-deactive-plugin.php';
}
yit_deactive_free_version( 'YITH_WCEUE_FREE_INIT', plugin_basename( __FILE__ ) );

function yith_wceue_pr_install_woocommerce_admin_notice() {
    ?>
    <div class="error">
        <p><?php _e( 'YITH WooCommerce EU Energy Label Premium is enabled but not effective. It requires WooCommerce in order to work.', 'yit' ); ?></p>
    </div>
    <?php
}

if ( ! function_exists( 'yith_plugin_registration_hook' ) ) {
    require_once 'plugin-fw/yit-plugin-registration-hook.php';
}
register_activation_hook( __FILE__, 'yith_plugin_registration_hook' );


if ( ! defined( 'YITH_WCEUE_VERSION' ) ){
    define( 'YITH_WCEUE_VERSION', '1.0.2' );
}

if ( ! defined( 'YITH_WCEUE_PREMIUM' ) ) {
    define( 'YITH_WCEUE_PREMIUM', '1' );
}

if ( ! defined( 'YITH_WCEUE_INIT' ) ) {
    define( 'YITH_WCEUE_INIT', plugin_basename( __FILE__ ) );
}

if ( ! defined( 'YITH_WCEUE' ) ) {
    define( 'YITH_WCEUE', true );
}

if ( ! defined( 'YITH_WCEUE_FILE' ) ) {
    define( 'YITH_WCEUE_FILE', __FILE__ );
}

if ( ! defined( 'YITH_WCEUE_URL' ) ) {
    define( 'YITH_WCEUE_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'YITH_WCEUE_DIR' ) ) {
    define( 'YITH_WCEUE_DIR', plugin_dir_path( __FILE__ )  );
}

if ( ! defined( 'YITH_WCEUE_TEMPLATE_PATH' ) ) {
    define( 'YITH_WCEUE_TEMPLATE_PATH', YITH_WCEUE_DIR . 'templates/premium' );
}

if ( ! defined( 'YITH_WCEUE_ASSETS_URL' ) ) {
    define( 'YITH_WCEUE_ASSETS_URL', YITH_WCEUE_URL . 'assets' );
}

if ( ! defined( 'YITH_WCEUE_ASSETS_PATH' ) ) {
    define( 'YITH_WCEUE_ASSETS_PATH', YITH_WCEUE_DIR . 'assets' );
}

if ( ! defined( 'YITH_WCEUE_SLUG' ) ) {
	define( 'YITH_WCEUE_SLUG', 'yith-woocommerce-eu-energy-label' );
}

if ( ! defined( 'YITH_WCEUE_SECRET_KEY' ) ) {
	define( 'YITH_WCEUE_SECRET_KEY', 'jH02VXJivnehh5NuNgzB' );
}

function yith_wceue_pr_init() {

    load_plugin_textdomain( 'yith-wceue', false, dirname( plugin_basename( __FILE__ ) ). '/languages/' );

    // Load required classes and functions
    require_once('class.yith-wceue-admin.php');
    require_once('class.yith-wceue-frontend.php');
    require_once('class.yith-wceue.php');
    require_once('class.yith-wceue-admin-premium.php');
    require_once('class.yith-wceue-frontend-premium.php');
    require_once('class.yith-wceue-premium.php');

    // Let's start the game!
    YITH_WCEUE_Premium();
}
add_action( 'yith_wceue_pr_init', 'yith_wceue_pr_init' );


function yith_wceue_pr_install() {

    if ( ! function_exists( 'WC' ) ) {
        add_action( 'admin_notices', 'yith_wceue_pr_install_woocommerce_admin_notice' );
    }
    else {
        do_action( 'yith_wceue_pr_init' );
    }
}
add_action( 'plugins_loaded', 'yith_wceue_pr_install', 11 );

/* Plugin Framework Version Check */
if ( !function_exists( 'yit_maybe_plugin_fw_loader' ) && file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
    require_once( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' );
}
yit_maybe_plugin_fw_loader( plugin_dir_path( __FILE__ ) );