<?php
/**
 * Template for EU Energy Label in Frontend
 *
 * @author  Yithemes
 * @package YITH WooCommerce EU Energy Label
 * @version 1.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
$energy_label_array = array(
    1  => 'A+++',
    2  => 'A++',
    3  => 'A+',
    4  => 'A',
    5  => 'B',
    6  => 'C',
    7  => 'D',
    8  => 'E',
    9  => 'F',
    10 => 'G',
);

if ( is_array( $meta ) )
    extract( $meta );

$custom_url = get_option( 'yith-wceue-link-custom-url', '' );
$link_to    = get_option( 'yith-wceue-link-to', 'none' );

$link_url = '';

if ( !is_single() ) {
    $link_to = 'none';
}

if ( $link_to != 'none' ) {
    if ( $link_to == 'custom_url' && !empty( $custom_url ) ) {
        if ( strpos( $custom_url, 'https://' ) < 0 ) {
            $link_url = 'http://' . str_replace( 'http://', '', $custom_url );
        } else {
            $link_url = $custom_url;
        }
    } elseif ( $link_to == 'same_el' ) {
        $link_url = get_site_url() . '?post_type=product&f_energetic_label=' . $energy_label;
    }
}

$tooltip_class = '';
$tooltip_data  = '';

if ( isset( $show_tooltip ) && $show_tooltip == 'on' ) {
    $tooltip_class = 'yith_wceue_tooltip';
    $tooltip_data  = !empty( $custom_image ) ? "data-image='{$custom_image}' data-product-id='{$product_id}'" : '';
}
?>

<?php if ( $energy_label > 0 ) : ?>

    <?php if ( $link_to != 'none' && !empty( $link_url ) ): ?>
        <a class="yith-wceue-noborders" href="<?php echo $link_url ?>">
    <?php endif; ?>

    <div class="yith-wceue-eu-energy-label yith-wceue-eu-energy-label-<?php echo $energy_label ?> <?php echo $class ?>  <?php echo $tooltip_class ?>" <?php echo $tooltip_data ?>>
        <?php echo $energy_label_array[ $energy_label ] ?>
    </div>

    <?php if ( $link_to != 'none' && !empty( $link_url ) ): ?>
        </a>
    <?php endif; ?>


<?php endif; ?>