jQuery( function ( $ ) {
    var energetic_label      = $( '#_yith_wceue_eu_energy_label' ),
        show_if_selected_el  = $( '.yith_wceue_show_if_selected_el' ),
        show_if_show_tooltip = $( '.yith_wceue_show_if_show_tooltip' ),
        show_tooltip         = $( '#_yith_wceue_show_tooltip' ),
        energetic_cat        = $( '#_yith_wceue_energetic_cat' ),
        energetic_cat_data   = $( '.yith-wceue-energetic-cat-data' ),
        choose_image         = $( '.yith-wceue-choose-image' );


    energetic_label.on( 'change', function () {
        if ( $( this )[ 0 ].selectedIndex > 0 ) {
            show_if_selected_el.show();
        } else {
            show_if_selected_el.hide();
        }
    } );

    energetic_label.trigger( 'change' );

    show_tooltip.on( 'change', function () {
        if ( $( this ).prop( 'checked' ) == true ) {
            show_if_show_tooltip.show();
        } else {
            show_if_show_tooltip.hide();
        }
    } );

    show_tooltip.trigger( 'change' );

    choose_image.on( 'click', function ( e ) {
        e.preventDefault();
        var image = wp.media( {
            title: yith_lang.choose_image,
            multiple: false
        } ).open()
            .on( 'select', function ( event ) {
                var uploaded_image = image.state().get( 'selection' ).first(),
                    image_url      = uploaded_image.toJSON().url;
                $( e.target ).parent().find( '.yith-wceue-image-url' ).val( image_url );
            } );
    } );
} );