<?php
/**
 * Frontend class
 *
 * @author  Yithemes
 * @package YITH WooCommerce EU Energy Label Premium
 * @version 1.0.0
 */

if ( !defined( 'YITH_WCEUE' ) ) {
    exit;
} // Exit if accessed directly

if ( !class_exists( 'YITH_WCEUE_Frontend_Premium' ) ) {
    /**
     * Frontend class.
     * The class manage all the Frontend behaviors.
     *
     * @author   Leanza Francesco <leanzafrancesco@gmail.com>
     * @since    1.0.0
     *
     */
    class YITH_WCEUE_Frontend_Premium extends YITH_WCEUE_Frontend {

        /**
         * Constructor
         *
         * @access public
         * @since  1.0.0
         */
        public function __construct() {
            parent::__construct();

            add_action( 'pre_get_posts', array( $this, 'modify_query' ) );
        }


        /**
         * Modify query to show only products with the same energetic label
         *
         * @access public
         * @since  1.0.0
         */
        public function modify_query( $query ) {

            $energetic_label = isset( $_GET[ 'f_energetic_label' ] ) ? $_GET[ 'f_energetic_label' ] : 0;

            if ( $energetic_label < 1 )
                return;

            if ( !is_admin() && $query->is_main_query() && $query->query_vars[ 'post_type' ] == 'product' ) {
                $query->set( 'meta_key', '_yith_wceue_eu_energy_label' );
                $query->set( 'meta_value', $energetic_label );
            }
        }


        public function enqueue_scripts() {
            parent::enqueue_scripts();

            wp_enqueue_style( 'jquery-ui' );

            wp_enqueue_script( 'jquery-ui-core' );
            wp_enqueue_script( 'jquery-ui-tooltip' );
            wp_enqueue_script( 'yith_wceue_frontend_js', YITH_WCEUE_ASSETS_URL . '/js/frontend.js', array( 'jquery', 'jquery-ui-tooltip' ), '1.0.0', true );


            $link_to  = get_option( 'yith-wceue-link-to', 'none' );
            $js_array = array(
                'link_to'    => $link_to,
                'custom_url' => '',
                'link_to_el' => false
            );
            if ( $link_to != 'none' ) {
                wp_add_inline_style( 'yith_wceue_frontend_style', $this->get_inline_css() );
                $custom_url = get_option( 'yith-wceue-link-custom-url', '' );
                if ( $link_to == 'custom_url' && !empty( $custom_url ) ) {
                    $custom_url               = 'http://' . str_replace( 'http://', '', $custom_url );
                    $js_array[ 'custom_url' ] = $custom_url;
                } elseif ( $link_to == 'same_el' ) {
                    $js_array[ 'link_to_el' ] = true;
                }
            }

            wp_localize_script( 'yith_wceue_frontend_js', 'settings_obj', $js_array );
        }

        /**
         * Get the css to add inline for custom styling
         *
         * @access   public
         * @since    1.0.0
         *
         * @author   Leanza Francesco <leanzafrancesco@gmail.com>
         */
        public function get_inline_css() {
            $css = "div.yith-wceue-eu-energy-label{
                cursor: pointer;
            }";

            return $css;
        }
    }
}
/**
 * Unique access to instance of YITH_WCEUE_Frontend_Premium class
 *
 * @return \YITH_WCEUE_Frontend_Premium
 * @since 1.0.0
 */
function YITH_WCEUE_Frontend_Premium() {
    return YITH_WCEUE_Frontend_Premium::get_instance();
}

?>
