<?php
/**
 * Template for EU Energy Label Panel in Product Editing
 *
 * @author  Yithemes
 * @package YITH WooCommerce EU Energy Label
 * @version 1.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
$energy_label_array = array(
    0  => __( 'None', 'yith-wceue' ),
    1  => 'A+++',
    2  => 'A++',
    3  => 'A+',
    4  => 'A',
    5  => 'B',
    6  => 'C',
    7  => 'D',
    8  => 'E',
    9  => 'F',
    10 => 'G',
);

?>

<div id="yith_eu_energy_label_data" class="panel woocommerce_options_panel">

    <div class="options_group">
        <p class="form-field">
            <label for="_yith_wceue_eu_energy_label"><?php _ex( 'EU Energy Label', 'title of label for the dropdown menu in product tab', 'yith-wceue' ) ?></label>
            <select id="_yith_wceue_eu_energy_label" name="_yith_wceue_eu_energy_label" class="select short" style="">
                <?php foreach ( $energy_label_array as $el_id => $el_label ): ?>
                    <option value="<?php echo $el_id; ?>" <?php selected( $energy_label, $el_id ) ?> ><?php echo $el_label; ?></option>
                <?php endforeach; ?>
            </select>
            <img class="help_tip" heigth="16" width="16" data-tip="<?php _e( 'Select the EU Energy Label you want to link to this product.', 'yith-wceue' ); ?>"
                 src="<?php echo WC()->plugin_url(); ?>/assets/images/help.png"/>
        </p>
    </div>

    <div class="options_group yith_wceue_show_if_selected_el">
        <p class="form-field">
            <label for="_yith_wceue_show_tooltip"><?php _e( 'Show Tooltip', 'yith-wceue' ) ?></label>
            <input id="_yith_wceue_show_tooltip" type="checkbox" <?php checked( $show_tooltip, 'on' ); ?> name="_yith_wceue_eu_meta[show_tooltip]">
            <span class="description"><?php _e( 'Flag this option if you want to show the tooltip.', 'yith-wceue' ); ?></span>
        </p>

        <div class="yith_wceue_show_if_show_tooltip">
                <p class="form-field">
                    <label for="_yith_wceue_custom_image"><?php _e( 'Tooltip image', 'yith-wceue' ) ?></label>
                    <input id="_yith_wceue_custom_image" class="yith-wceue-image-url" type="text" value="<?php echo $custom_image ?>" name="_yith_wceue_eu_meta[custom_image]">
                    <input type="button" class="button secondary-button yith-wceue-choose-image" value="<?php _e( 'Choose image', 'yith-wceue' ) ?>">
                    <img class="help_tip" heigth="16" width="16" data-tip="<?php _e( 'Choose an image for the tooltip.', 'yith-wceue' ); ?>"
                         src="<?php echo WC()->plugin_url(); ?>/assets/images/help.png"/>
                </p>
        </div>

    </div>

</div>