<?php
require_once ASTERO_PATH . 'vendors/GeoIp2/geoip2.phar';
use GeoIp2\Database\Reader;

if( !function_exists('astero_get_geoip') ) {
	function astero_get_geoip( $provider ) {
		$reader = new Reader( ASTERO_PATH . "vendors/GeoIp2/GeoLite2-City.mmdb" );
		$record = $reader->city( astero_get_client_ip() );
		$reader->close();

		if( $provider == 'owm' ) {
			return $record->city->name . ',' . $record->country->isoCode;
		} else {
			return array( 'lat' => $record->location->latitude, 'lon' => $record->location->longitude, 'city' => $record->city->name . ',' . $record->country->isoCode );
		}
	}
}