<?php
/*
Plugin Name: افزونه ارسال تیکت در وردپرس
Plugin URI: http://www.persianscript.ir/
Description: با استفاده از این افزونه قادر هستید یک سیستم تیکت و پشتیبانی در وردپرس ایجاد کنید. این افزونه توسط پرشین اسکریپت فارسی سازی شده است
Version: 2.0.7
Author: PersianScript.ir
Author URI: http://www.persianscript.ir/
License: GPL2
*/

/* Define all the plugin constants */
define( 'WPAS_VERSION', '2.0.7' );
define( 'WPAS_NAME', 'WP Awesome Support' );
define( 'WPAS_AUTHOR', 'ThemeAvenue' );
define( 'WPAS_URI', 'http://themeavenue.net' );
define( 'WPAS_URL', plugin_dir_url( __FILE__ ) );
define( 'WPAS_PATH', plugin_dir_path( __FILE__ ) );
define( 'WPAS_PREFIX', 'wpas_ticket_' );
define( 'WPAS_BASENAME', plugin_basename(__FILE__) );
define( 'WPAS_LOG', true );

/* Setup the defaults */
include_once dirname( __FILE__ ).'/install.php';
register_activation_hook( __FILE__, 'wpas_activate_plugin' );

/* Load the global plugin functions */
require( WPAS_PATH . 'functions.php' );

/* Load plugin core classes */
require( WPAS_PATH . 'functions/WP_Awesome_Support.class.php' );
require( WPAS_PATH . 'functions/WPAS_Notifications.class.php' );
require( WPAS_PATH . 'functions/WPAS_Tickets_Manager.class.php' );
require( WPAS_PATH . 'functions/WPAS_Tickets_Submission.class.php' );
require( WPAS_PATH . 'functions/WPAS_Email_Notification.class.php' );

/* Function required in back and front end */
require_once( WPAS_PATH . 'includes/widgets.php' );

/**
 * Load getSentry
 *
 * Only load getSentry if debug mode
 * is disabled as I want to show PHP errors
 * directly while developing.
 *
 * @since 2.0.4
 */
/*if( 1 == 1 ) {

	require( WPAS_PATH . 'vendor/Raven/Autoloader.php' );
	Raven_Autoloader::register();
	$dsn = "https://3fae76d712f1437da9400500ba03765f:b4d65db6a771476bb42e69d353bb9165@app.getsentry.com/17192";
	$client = new Raven_Client( $dsn );
	$error_handler = new Raven_ErrorHandler($client);
	set_error_handler( array($error_handler, 'handleError') );
	set_exception_handler( array($error_handler, 'handleException') );

}*/

/* Load the shortcodes */
if( !is_admin() ) {

	/* Register shortcodes */
	require( WPAS_PATH.'shortcodes/tickets-list.php');
	require( WPAS_PATH.'shortcodes/ticket-submit.php');

	/* Load core classes */
	require( WPAS_PATH  .'functions/WPAS_Ticket_Details.class.php');

	/* Load the plugin file in order to check activated plugins */
	require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	/* Load the WooCommerce integration file */
	require( WPAS_PATH.'integrations/woocommerce.php' );
}

if( is_admin() ) {

	require( WPAS_PATH . 'functions/TAV_Promote_Ratings.class.php' );
	require( WPAS_PATH . 'functions/WPAS_Quick_Replies.class.php' );

	/* Register all admin widgets (metaboxes) */
	require( WPAS_PATH . 'includes/widgets/parties.php' );
	require( WPAS_PATH . 'includes/widgets/details.php' );
	require( WPAS_PATH . 'includes/widgets/envato.php' );
	require( WPAS_PATH . 'includes/widgets/attachments.php' );
	require( WPAS_PATH . 'includes/widgets/replies.php' );
	require( WPAS_PATH . 'includes/widgets/custom_fields.php' );

	/* Load plugin settings with WordPress Settings API */
	require( WPAS_PATH.'includes/settings.php' );

	/* Load the email settings with WordPress Settings API */
	require( WPAS_PATH.'includes/email-settings.php' );

	/* General options */
	require( WPAS_PATH.'options/options.php' );

	/* Email options */
	require( WPAS_PATH.'options/email-templates.php' );

	/* Register taxonomies custom fields */
	require( WPAS_PATH.'includes/taxonomies-custom-fields.php' );

	/* Function to clean the DB */
	require( WPAS_PATH.'functions/clean.php' );
}


	/* Separate back-end and front end functions */
	if( is_admin() ) {


		/* Help files */
		require( WPAS_PATH.'includes/email-templates-help.php' );
		require( WPAS_PATH.'includes/settings-help.php' );

		/* Feature files */
		require( WPAS_PATH.'includes/rendering.php' );
		require( WPAS_PATH.'includes/presstrends.php' );

		/* Debug Information */
		require(WPAS_PATH.'includes/debug.php');
	}

/* Action hook after the plugin has loaded required files */
do_action( 'wpas_after_plugin_loaded' );

/* hook updater to init */
  add_action( 'init', 'wpas_auto_update' );

/**
 * Load and Activate Plugin Updater Class.
 */
function wpas_auto_update() {

    /* Load Plugin Updater */
    require_once( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'includes/updater.php' );

    /* Updater Config */
    $config = array(
        'base'      => plugin_basename( __FILE__ ), //required
        'dashboard' => false,
        'username'  => false,
        'key'       => '',
        'repo_uri'  => 'http://goo.gl/HqQ4dR',
        'repo_slug' => 'wp-awesome-support',
    );

    /* Load Updater Class */
    new WP_Awesome_Support_Plugin_Updater( $config );
}