<?php
class TAV_Promote_Ratings {
	
	public function __construct() {

		$this->delay = 10;
		$this->slug = $wpas->getPostTypeSlug();

		add_action( 'admin_init', array( $this, 'askRating' ) );

	}

	public function ratingNotice() { ?>
		<div id="tav_rated" class="updated fade">
			<p><?php printf( __( 'Dear WordPress user! Once again we\'re proud that you chose <strong>%s</strong> as your support plugin! You\'ve now been using it for a few days and we would love you to rate it on Codecanyon! If you feel like doing it now, <a href="%s" target="_blank">sign in your Codecanyon account</a> ;) &mdash; <em><a href="%s">I did it already, don\'t bug me</a></em>', 'n2cpanel'), WPAS_NAME, 'https://account.envato.com/sign_in?to=codecanyon', admin_url( 'edit.php?post_type=tickets&amp;rate=yes' )); ?></p>
		</div>
	<?php
	}

	/**
	 * Ask user to rate product
	 *
	 * We wait for 10 days of use and then ask the user
	 * to go rate the product on the appropriate marketplace.
	 */
	public function askRating() {

		/* Cancel reting invite */
		if( isset($_GET['rate']) && $_GET['rate'] == 'yes' ) {

			$rated_option = WPAS_PREFIX.'rated';
			update_option( $rated_option, 'rated' );

			if( !headers_sent() )
				wp_redirect( admin_url("edit.php?post_type=$this->slug" ), 302 );
		}

		/* Asking user to rate theme on TF */
		$opt 		= WPAS_PREFIX . 'rated';
		$rated 		= get_option( $opt, true );
		$setup_date = get_option( WPAS_PREFIX.'first_setup_date', true );
		$setup_date = strtotime( $setup_date );
		$limit 		= strtotime( "+$this->delay days", $setup_date );

		if( strtotime( 'now' ) > $limit && isset($_GET['post_type']) && $_GET['post_type'] == $this->slug && current_user_can('delete_ticket') ) {

			if( $rated == 'pending' ) {

				add_action( 'admin_notices', array( $this, 'wpas_show_rate_invite' ) );
			}
		}
	}

}