<?php
class WPAS_Notifications {

	public function __construct() {

		add_action( 'wpas_client_notices', array( $this, 'notification' ) );

	}

	/**
	 * Output the notification
	 */
	public function notification( $case = false, $message = false ) {

		/**
		 * If the case is not defined, we probably are in the situation where this method
		 * has been hooked to the WPAS notifications.
		 */
		if( !$case ) {

			/**
			 * Let's try to get a notification code from the $_REQUEST var
			 */
			if( isset( $_REQUEST['message'] ) ) {

				$predefined = $this->getPredefinedMessages();

				/**
				 * Check if the notification code is set in the predefined messages
				 */
				if( array_key_exists( $_REQUEST['message'], $predefined ) ) {

					/**
					 * Set the case and the message to display
					 */
					$case 	 = $predefined[$_REQUEST['message']]['case'];
					$message = $predefined[$_REQUEST['message']]['message'];

				}

			}

		}

		/**
		 * If the message var is not set, we try to get it from the predefined messages based on the current case
		 */
		if( !$message ) {

			$predefined = isset( $predefined ) ? $predefined : $this->getPredefinedMessages();

			if( array_key_exists( $case, $predefined ) )
				$message = $predefined[$case]['message'];

		}

		/**
		 * We echo the notification if we have all the data
		 */
		if( $case && $message )
			echo $this->template( $case, $message );

	}

	/**
	 * List of predefined messages
	 */
	public function getPredefinedMessages() {

		$messages = array(
			'not_found' => array( 'case' => 'failure', 'message' => __( 'The ticket you requested could not be found.', 'wpas' ) ),
			'0' 		=> array( 'case' => 'success', 'message' => __( 'Your account has been successfully created. You can now post tickets.', 'wpas' ) ),
			'1' 		=> array( 'case' => 'success', 'message' => __( 'Your ticket has been successfully submitted. One of our agents will get in touch with you soon.', 'wpas' ) ),
			'2' 		=> array( 'case' => 'success', 'message' => __( 'Your reply has been sent. Our agent will review it ASAP!', 'wpas' ) ),
		);

		return $messages;

	}

	/**
	 * Available notification templates
	 */
	public function template( $case, $message ) {

		switch( $case ):

			case 'success':

				if( $message ) {

					?>
					<div class="alert alert-success">
						<?php echo $message; ?>
						<span class="close" data-dismiss="alert">×</span>
					</div>
					<?php

				}

			break;

			case 'failure':

				if( $message ) {

					?>
					<div class="alert alert-danger">
						<?php echo $message; ?>
						<span class="close" data-dismiss="alert">×</span>
					</div>
					<?php

				}

			break;

			case 'info':

				if( $message ) {

					?>
					<div class="alert alert-info">
						<?php echo $message; ?>
						<span class="close" data-dismiss="alert">×</span>
					</div>
					<?php

				}

			break;

		endswitch;

	}

}

$wpas_notification = new WPAS_Notifications();