<?php
/**
 * Get the ticket details and the replies
 */
class WPAS_Ticket_Details {

	public function __construct( $id = false ) {

		global $post;

		/**
		 * Get requested ticket ID
		 */
		if( isset( $_GET['ticket'] ) && is_numeric( $_GET['ticket'] ) ) {

			$this->id = $_GET['ticket'];

		} elseif( $id ) {

			$this->id = $id;

		} elseif( isset( $post->ID ) ) {

			$this->id = $post->ID;

		} else {

			$this->id = false;

		}

		$this->list = wpas_get_option( 'ticket_list' );

	}

	/**
	 * Get ticket priority
	 * 
	 * @return (string) Priority tag
	 */
	public function getPriority() {

		$priorities  = get_the_terms( $this->id, 'priority' );

		if( $priorities ) {

			foreach($priorities as $p) {

				$priority = $p->name;
				$pid 	  = $p->term_id;

			}

			$prio_opts  = get_option('taxonomy_'.$pid);

			if( isset($prio_opts['color']) ) {

				$prio_color = $prio_opts['color'];

			} else {

				$prio_color = '';

			}

			if( isset($prio_opts['font_color']) ) {

				$prio_font = $prio_opts['font_color'];

			} else {

				$prio_font = '';

			}

			return '<span class="label label-default" style="background-color: ' . $prio_color . '; color: ' . $prio_font . ';">' . $priority . '</span>';
		}

		else {
			return false;
		}
	}

	/**
	 * Get ticket status
	 * 
	 * @return (string) Current status
	 */
	public function getStatus() {

		/**
		 * Get ticket status
		 */
		$status  = get_the_terms( $this->id, 'status' );

		if( $status ) {

			foreach( $status as $s ) {

				$status = $s->slug;
				$lib = explode('-', $status);

			}

			return $lib[1];

		} else {
			return false;
		}

	}

	/**
	 * Display ticket status with style
	 * 
	 * @return (string) Status tag
	 */
	public function displayStatus() {

		/**
		 * Get ticket status
		 */
		$status  = get_the_terms( $this->id, 'status' );

		if( $status ) {

			foreach($status as $s) {

				$status = $s->slug;
				$lib = explode('-', $status);

			}

		}

		/* Get status color based on the previously retrieved status */
		$status_color = wpas_get_option( 'status_' . $lib[1] . '_color' );

		/* Get the state and apply style to the containing tag */
		if( $status == 'wpas-open' && !empty($states) ) {

			foreach( $states as $sid => $state ) {

				$opts   = get_option('taxonomy_'.$state->term_id);

				/* Tag style */
				$style = 'style="';
				if( isset($opts['color']) ) {
					$style .= 'background-color:'.$opts['color'].';';
				}
				if( isset($opts['font_color']) ) {
					$style .= ' color:'.$opts['font_color'].';';
				}
				$style .= '"';

				$var = '<span';
				if( $style != ' style=""' ) { $var .= ' '.$style; }

				$var .= ' class="label">'.$state->name.'</span>';
				$tags[] = $var;

			}

		}

		/* If no state, let's just use the "open" tag */
		elseif( $status == 'wpas-open' && empty( $states ) ) {

			$label = array(
				'wpas-open'  => __( 'Open', 'wpas' ),
				'wpas-close' => __( 'Closed', 'wpas' )
			);

			$tags = array();
			$tags[] = '<span class="label" style="background-color:'.$status_color.';">' . $label[$status] . '</span>';

		}

		/* If ticket is closed, only use the "closed" tag */
		elseif( $status == 'wpas-close' ) {

			$tags = array();
			$tags[] = '<span class="label" style="background-color:'.$status_color.';">'.ucwords($lib[1]).'</span>';

		}

		return implode( ' ', $tags );

	}

	/**
	 * Get ticket type
	 *
	 * @return (string) Ticket type
	 */
	public function getType() {

		$types  = get_the_terms( $this->id, 'type' );

		if( $types ) {

			foreach($types as $t) {

				/**
				 * A ticket can only have one type, that's why we re-define $type at every iteration of the foreach instead of appending values
				 */
				$type = $t->name;

			}

			return $type;

		}

	}

	/**
	 * Get ticket current state
	 * 
	 * @return (string) Current state with associated tags
	 */
	public function getState() {

		/* Get ticket state */
		$states   = get_the_terms( $this->id, 'state' );

		/**
		 * Get ticket status
		 */
		$status  = $this->getStatus();

		/* Prepare tags array */
		$tags 	  = array();

		/* Get status color based on the previously retrieved status */
		$status_color = wpas_get_option( 'status_' . $lib[1] . '_color' );

		/* Get the state and apply style to the containing tag */
		if( $status == 'open' && !empty($states) ) {

			foreach( $states as $sid => $state ) {

				$opts   = get_option( 'taxonomy_' . $state->term_id );

				/* Tag style */
				$style = 'style="';
				if( isset( $opts['color'] ) ) {
					$style .= 'background-color:'.$opts['color'].';';
				}
				if( isset($opts['font_color']) ) {
					$style .= ' color:'.$opts['font_color'].';';
				}
				$style .= '"';

				$var = '<span';
				if( $style != ' style=""' ) { $var .= ' '.$style; }

				$var .= ' class="label">'.$state->name.'</span>';
				$tags[] = $var;

			}

		}

		/* If no state, let's just use the "open" tag */
		elseif( $status == 'open' && empty( $states ) ) {

			$tags = array();
			$tags[] = '<span class="label" style="background-color:'.$status_color.';">' . ucwords($lib[1]) . '</span>';

		}

		/* If ticket is closed, only use the "closed" tag */
		elseif( $status == 'close' ) {

			$tags = array();
			$tags[] = '<span class="label" style="background-color:'.$status_color.';">'.ucwords($lib[1]).'</span>';

		}

		/* Implode the tags to display them as string */
		return implode(' ', $tags);

	}

	public function getTags() {

		/* Get post tags */
		$posttags = get_the_tags( $this->id );

		if( $posttags ) {
					
			$ptags = array();

			foreach($posttags as $tag) {
				$ptags[] = '<a href="' . add_query_arg( 'tag', $tag->slug, get_permalink( wpas_get_option( 'ticket_list' ) ) ) . '" class="badge badge-inverse">' . $tag->name . '</a>'; 
			}
						
			return implode( ' ', $ptags );

		} else {
			return false;
		}

	}

	/**
	 * Manage the ticket's details header
	 * 
	 * @return (array) List of columns to display
	 */
	public function manageTicketColumns() {

		$columns = array(
			'status' 	=> array( 'title' => __( 'Status', 'wpas' ), 'callback' => $this->displayStatus() ),
			'id' 		=> array( 'title' => __( 'ID', 'wpas' ), 'callback' => $this->id ),
			'priority' 	=> array( 'title' => __( 'Priority', 'wpas' ), 'callback' => $this->getPriority() ),
			'type' 		=> array( 'title' => __( 'Type', 'wpas' ), 'callback' => $this->getType() ),
		);

		if( $this->getTags() ) {
			$columns['tags'] = array( 'title' => __( 'Tags', 'wpas' ), 'callback' => $this->getTags() );
		}

		/**
		 * Return the filtered columns list so that the user can easily customize it
		 */
		return apply_filters( 'wpas_ticket_details_columns', $columns );

	}

	/**
	 * Build the ticket details header actual markup based on the available columns
	 * 
	 * @return (string) Table makrup
	 */
	public function constructTableHead() {

		$cols = $this->manageTicketColumns();

		$markup = '<thead><tr>';

		foreach( $cols as $id => $data ) {
			$markup .= '<td>' . $data['title'] . '</td>';
		}

		$markup .= '</tr></thead>';

		$markup .= '<tbody><tr>';

		foreach( $cols as $id => $data ) {
			$markup .= '<td>' . $data['callback'] . '</td>';
		}

		$markup .= '</td></tbody>';

		return $markup;

	}

	/**
	 * Get the list of replies for the current ticket.
	 * 
	 * @return (array) List of posts
	 */
	public function getReplies() {

		/* Let's prepare the query for the ticket history */
		$args = array(
			'posts_per_page'	=>	-1,
			'orderby'			=>	'post_date',
			'order'				=>	wpas_get_option( 'replies_order', 'ASC' ),
			'post_type'			=>	array( 'ticket_reply' ),
			'post_parent'		=>	$this->id,
			'post_status'		=>	array( 'publish', 'inherit', 'trash' )
		);

		/* Instanciate the query class */
		$replies = new WP_Query( $args );

		if( empty( $replies->posts ) ) {
			return false;
		} else {
			return $replies->posts;
		}

	}

}