<?php
function wpas_upgrade_to_2_0_0() {

	$tickets_page = wpas_get_option('ticket_list');		// Tickets list page
	$submit 	  = wpas_get_option('ticket_submit');	// Ticket submit page

	/* Get posts content */
	$list = get_post( $tickets_page );
	$new  = get_post( $submit );

	/* Update posts and add shortcodes */
	wp_update_post( array( 'ID' => $tickets_page, 'post_content' => $list->post_content . ' [tickets]' ) );
	wp_update_post( array( 'ID' => $submit, 'post_content' => $new->post_content . ' [submit-ticket]' ) );

	/* Get current options */
	$options = get_option( 'wpas_ticket_plugin_options' );

	/* Define new options */
	$new_opts = array(
		'pre_submission_notice' 		=> '',
		'automatically_close' 			=> 'no',
		'remider_before_closing' 		=> 3,
		'recaptcha_enabled' 			=> 'no',
		'recaptcha_public_key' 			=> '',
		'recaptcha_private_key' 		=> '',
		'upload_script' 				=> 'fineuploader',
		'filepicker_api' 				=> '',
		'filepicker_secret' 			=> '',
		'filepicker_services' 			=> Array ( 'COMPUTER', 'DROPBOX', 'FACEBOOK', 'GOOGLE_DRIVE' ),
		'auto_close_exclude_state' 		=> '',
		'live_search' 					=> 'no',
		'live_search_where' 			=> '',
	);

	/* Merge the new options */
	$updated = array_merge( $options, $new_opts );

	/* Update the options */
	update_option( WPAS_PREFIX . 'plugin_options', $updated );

	/* Get e-mail templates */
	$email_opts = get_option( 'wpas_ticket_email_options' );

	$new_email_opts = array(
		'will_be_closed_ticket_subject' => 'Your ticket will be closed soon',
		'will_be_closed_ticket_content' => 'Hi <strong><em>{client_name}</em></strong>,

It\'s been a while since we wrote a reply to your ticket "<strong>{ticket_title}</strong>" but you didn\'t get back to us. If you don\'t update your ticket very soon, it will be automatically closed.

Regards,{agent_name}',
	);

	/* Merge new e-mail options */
	$email_updated = array_merge( $email_opts, $new_email_opts );

	/* Update e-mail options */
	update_option( WPAS_PREFIX . 'email_options', $email_updated );

	/* Mark the setup as done */
	update_option( 'wpas_setup_status', 'done' );

}