<?php

//
// To see the PHP example in action, please do the following steps.
//
// 1. Open test/js/uploader-demo-jquery.js file and change the request.endpoint
// parameter to point to this file.
//
//  ...
//  request: {
//    endpoint: "../server/php/example.php"
//  }
//  ...
//
// 2. As a next step, make uploads and chunks folders writable.
//
// 3. Open test/jquery.html to see if everything is working correctly,
// the uploaded files should be going into uploads folder.
//
// 4. If the upload failed for any reason, please open the JavaScript console,
// if this does not help please read the excellent documentation we have for you.
//
// https://github.com/Widen/fine-uploader/blob/master/readme.md
//

/**
 * Safely load the WordPress core
 */
$bootstrap = 'wp-load.php';

while( !is_file( $bootstrap ) ) {
	if( is_dir( '..' ) ) 
		chdir( '..' );
	else
		die( 'Could not find WordPress!' );
}

require_once( $bootstrap );

/* Include the uploader class */
require_once( WPAS_PATH . 'includes/upload-handler.php' );

/* Instanciate the class */
$uploader = new UploadHandler();

/* Set allowed extentions for upload */
$uploader->allowedExtensions = explode( ',', wpas_get_option( 'allowed_filetypes' ) );

/* Get the max allowed size */
$max_size = wpas_get_upload_max_size();

// Specify max file size in bytes.
$uploader->sizeLimit = $max_size * 1024 * 1024; // default is 10 MiB

// Specify the input name set in the javascript.
$uploader->inputName = "qqfile"; // matches Fine Uploader's default inputName value by default

// If you want to use the chunking/resume feature, specify the folder to temporarily save parts.
$uploader->chunksFolder = "chunks";

$method = $_SERVER["REQUEST_METHOD"];

if( $method == "POST" ) {
	
	header("Content-Type: text/plain");

	// Call handleUpload() with the name of the folder, relative to PHP's getcwd()
	$result = $uploader->handleUpload( ABSPATH . 'wp-content/uploads/wpas_attachments/', md5( mt_rand() ) . '_' . $uploader->getName() );

	// To return a name used for uploaded file you can use the following line.
	$result["uploadName"] = $uploader->getUploadName();

	echo json_encode( $result );

} else {
	header("HTTP/1.0 405 Method Not Allowed");
}