<?php
// add_action( 'admin_menu', 'wpas_email_templates_page' );
add_action( 'admin_init', 'wpas_register_email_settings' );
function wpas_email_templates_page() {
	add_submenu_page( 'edit.php?post_type=tickets', __('WP Awesome Support E-Mail Settings', 'wpas'), __('E-Mail Settings', 'wpas'), 'settings_tickets', 'wpas-email', 'wpas_email_settings' );
}

function wpas_email_settings() { ?>
	<div class="wrap">
        <div class="icon32" id="icon-options-general"></div>  
        <h2><?php _e('WP Awesome Support E-Mail Settings', 'wpas'); ?></h2>

        <?php if( isset($_GET['settings-updated']) ) {
			echo '<div class="updated"><p>E-mail settings updated successfully.</p></div>';

			/* We clear the session as the settings are now changed */
			unset( $_SESSION['wpas_options']['email'] );
		} ?> 
          
        <form action="options.php" method="post">
        	<?php
        	settings_fields( WPAS_PREFIX.'email_options' );
        	do_settings_sections(__FILE__); 
        	?>
            <p class="submit">  
                <input name="Submit" type="submit" class="button-primary" value="<?php esc_attr_e('Save','wpas'); ?>" />  
            </p>  
              
        </form>  
    </div>
    <?php
}

function wpas_register_email_settings() {
	$settings = wpas_email_options();

	register_setting( WPAS_PREFIX.'email_options', WPAS_PREFIX.'email_options' );

	foreach( $settings as $key => $section ) {
		add_settings_section( $section['id'], $section['title'], false, __FILE__);
		foreach( $section['options'] as $k => $option ) {
			if( !isset($option['desc']) ) $option['desc'] = '';
			if( !isset($option['opts']) ) $option['opts'] = array();
			$field_args = array(
				'name' 		=> $option['id'],
				'title' 	=> $option['title'],
				'type' 		=> $option['type'],
				'desc' 		=> $option['desc'],
				'options' 	=> $option['opts'],
				'group' 	=> WPAS_PREFIX.'email_options'
			);
			add_settings_field( $option['id'], $option['title'], 'wpas_render_option_fields', __FILE__, $section['id'], $field_args );
		}
	}
}
?>