<?php
function wpas_templates_help() {

	$email = new WPAS_Email_Notification();

	if( !isset($_GET['page']) || $_GET['page'] != 'wpas-email' ) {
		return;
	}

	$tags = $email->getTemplatesTags();
	$ul = '<ul>';
	foreach( $tags as $tag => $data ) {
		$ul .= '<li><code>'.$data['tag'].'</code>: '.$data['desc'].'</li>';
	}
	$ul .= '</ul>';
	
	$screen = get_current_screen();
	
	$screen->add_help_tab( array(
		'id'      => 'tags',
		'title'   => __( 'Template Tags', 'wpas' ),
		'content' => sprintf(__('<h2>E-Mail Template Tags</h2><p>Here is the list of all template tags you can use. Tags can be used in all fields: <em>E-Mail Sender</em>, <em>Sender E-Mail Address</em>, <em>E-mail Subject</em> and <em>E-Mail Content</em>.%s</p>', 'wpas'), $ul)
	) );
}
add_filter('contextual_help', 'wpas_templates_help', 10, 3);
?>