<?php
function wpas_output_option( $option ) {

	$metas = '';

	/* Prepare field metas values */
	if( isset( $option['metas'] ) && is_array( $option['metas'] ) && !empty( $option['metas'] ) ) {

		$metas = array();

		foreach( $option['metas'] as $meta => $value ) {

			$metas[] = "$meta='$value'";

		}

		$metas = implode( ' ', $metas );

	}

	/* Prepare field class attribute */
	$class =  isset( $option['class'] ) ? $option['class'] : '';

	$field_type = $option['type'];
	$prefix = WPAS_PREFIX;
	if( $option['group'] == WPAS_PREFIX.'plugin_options' ) {
		$current = wpas_get_option( $option['name'] );
	} else {
		$email = new WPAS_Email_Notification();
		$current = $email->getOption( $option['name'] );
	}
	
	switch( $field_type ):
		case 'text': ?>
			<input type="text" name="<?php echo $option['group'].'['.$option['name'].']'; ?>" id="<?php echo $prefix.$option['name']; ?>" value="<?php echo $current; ?>" <?php if( '' != $class ) { echo "class='$class'"; } ?> <?php echo $metas; ?> />
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;
		case 'numeric': ?>
			<input type="text" name="<?php echo $option['group'].'['.$option['name'].']'; ?>" id="<?php echo $prefix.$option['name']; ?>" value="<?php echo $current; ?>" class="small-text" pattern="[0-9]" />
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;
		case 'colorpicker': ?>
			<input type="text" id="<?php echo $prefix.$option['name']; ?>" name="<?php echo $option['group'].'['.$option['name'].']'; ?>" class="wpas-colorpicker" value="<?php echo $current; ?>" />
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;
		case 'email':
			$value = get_option($prefix.$option['name'], ''); ?>
			<input type="email" name="<?php echo $option['group'].'['.$option['name'].']'; ?>" id="<?php echo $prefix.$option['name']; ?>" value="<?php echo $current; ?>" class="regular-text" />
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;

		case 'assignee':
			
			/* get the roles */
			global $wp_roles;

			/* Prepare the empty users list */
			$users = array();

			/* Parse the roles */
			foreach( $wp_roles->roles as $role => $data ) {

				/* Check if current role can edit tickets */
				if( array_key_exists( 'edit_ticket', $data['capabilities'] ) ) {

					/* Get users with current role */
					$usrs = new WP_User_Query( array( 'role' => $role ) );

					/* Save users in global array */
					$users = array_merge( $users, $usrs->get_results() );
				}
			}
			$value 				= get_option($prefix.$option['name'], '');
			?>

			<select name="<?php echo $option['group'].'['.$option['name'].']'; ?>" id="<?php echo $prefix.$option['name']; ?>">
				<?php
				foreach( $users as $usr => $data ) {
					?><option value="<?php echo $data->ID; ?>" <?php if( $data->ID == $current ) { echo 'selected="selected"'; } ?>><?php echo $data->data->display_name; ?></option><?php
				}
				?>
			</select>
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;

		case 'list_pt':

			$pts = get_post_types( array( 'public' => true, 'exclude_from_search' => false ), 'names' );

			if( !empty( $pts ) ) {

				foreach( $pts as $key => $pt ) {

					if( is_array( $current ) && in_array( $pt, $current ) )
						$selected = 'checked';
					else
						$selected = '';
					?>

					<label for="<?php echo $prefix . $option['name'] . $pt; ?>">
						<input type="checkbox" name="<?php echo $option['group'].'['.$option['name'].']'; ?>[]" value="<?php echo $pt; ?>" id="<?php echo $prefix . $option['name'] . $pt; ?>" <?php echo $selected; ?> />
						<?php echo $pt; ?>
					</label><br>

					<?php
				}

			}

		break;
		
		case 'list_pages':
			$pages = get_pages( array('post_status' => 'publish') ); ?>
			<select name="<?php echo $option['group'].'['.$option['name'].']'; ?>" id="<?php echo $prefix.$option['name']; ?>">
				<option value="" <?php if( '' == $current ) { echo 'selected="selected"'; } ?>><?php _e('None', 'wpas'); ?></option>
				<?php
				foreach( $pages as $page ) {
					?><option value="<?php echo $page->ID; ?>" <?php if( $page->ID == $current ) { echo 'selected="selected"'; } ?>><?php echo $page->post_title; ?></option><?php
				}
				?>
			</select>
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;
		case 'state':
			$pages = get_pages( array('post_status' => 'publish') ); ?>
			<select name="<?php echo $option['group'].'['.$option['name'].']'; ?>" id="<?php echo $prefix.$option['name']; ?>">
				<?php
				$states = get_terms( 'state', array('hide_empty' => 0) );
				foreach( $states as $state ) {
					?><option value="<?php echo $state->slug; ?>" <?php if( $current == $state->slug ) { echo 'selected="selected"'; } ?>><?php echo $state->name; ?></option><?php
				}
				?>
			</select>
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;

		case 'radio':
			$value = get_option($prefix.$option['name'], array()); ?>
			<?php foreach( $option['options'] as $val => $choice ):
				if( $val == $current )
					$selected = 'checked';
				else
					$selected = ''; ?>
				<label>
					<input type="radio" name="<?php echo $option['group'].'['.$option['name'].']'; ?>" value="<?php echo $val; ?>" id="<?php echo $prefix . $option['name'] . '-' . $val; ?>" <?php if( '' != $class ) { echo "class='$class'"; } ?> <?php echo $metas; ?> <?php echo $selected; ?> />
					<?php echo $choice; ?>
				</label>
				<br class="n2_clear"/>
			<?php endforeach; ?>
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;

		case 'checkbox':

			$value = get_option($prefix.$option['name'], array());

			foreach( $option['options'] as $val => $choice ):

				if( is_array( $current ) && in_array( $val, $current ) )
					$selected = 'checked';
				else
					$selected = '';
				?>

				<label>
					<input type="checkbox" name="<?php echo $option['group'].'['.$option['name'].']'; ?>[]" value="<?php echo $val; ?>" id="<?php echo $prefix . $option['name'] . '-' . $val; ?>" <?php echo $selected; ?> <?php if( '' != $class ) { echo "class='$class'"; } ?> <?php echo $metas; ?> />
					<?php echo $choice; ?>
				</label>

				<br class="n2_clear"/>

			<?php
			endforeach;
			
			if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif;
		
		break;

		case 'textarea':
			if( !$current && isset($option['std']) ) { $current = $option['std']; } ?>
			<textarea name="<?php echo $option['group'].'['.$option['name'].']'; ?>" id="<?php echo $prefix.$option['name']; ?>" rows="8" cols="70" <?php if( '' != $class ) { echo "class='$class'"; } ?> <?php echo $metas; ?>><?php echo $current; ?></textarea>
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;
		case 'wysiwyg': ?>
			<?php wp_editor( $current, $option['group'].'['.$option['name'].']', array('media_buttons' => false) ); ?>
			<?php if( isset($option['desc']) && $option['desc'] != '' ): ?><p class="description"><?php echo $option['desc']; ?></p><?php endif; ?>
		<?php break;
		case 'button_color': ?>
		<div id="btn-color">
			<button type="button" class="btn btn-default">Default</button>
			<button type="button" class="btn btn-primary">Blue</button>
			<button type="button" class="btn btn-success">Green</button>
			<button type="button" class="btn btn-info">Cyan</button>
			<button type="button" class="btn btn-warning">Orange</button>
			<button type="button" class="btn btn-danger">Red</button>
			<button type="button" class="btn btn-link">Link</button>
		</div>
		<?php break;
	endswitch;
}
?>