<?php
/**
* Loading the backend scripts
*/
add_action( 'admin_print_scripts', 'wpas_load_scripts' );

function wpas_load_scripts() {
	
	/* We make sure the current page belongs to the plugin */
	if( !wpas_is_plugin_page() )
		return;

	/* Enqueue the plugin's admin JS */
	wp_enqueue_script( 'wpas-main-admin', WPAS_URL.'js/admin/main.js', '', false, true );

	/* Enqueue the default WordPress colorpicker script */
	wp_enqueue_script( 'wp-color-picker' );

	/* If file attachment is enabled we call the script */
	if( wpas_can_attach_files() ) {
		wp_enqueue_script( 'wpas-js-fineuploader', WPAS_URL.'plugins/jquery.fineuploader-3.9.1/fineuploader-3.9.1.min.js', '', false, true );
	}
}

/**
* Loading the backend styles
*/
add_action('admin_print_styles', 'wpas_load_styles');

function wpas_load_styles() {

	/* We make sure the current page belongs to the plugin */
	if( !wpas_is_plugin_page() )
		return;

	/* Enqueue the default WordPress colorpicker */
	wp_enqueue_style( 'wp-color-picker' );

	/* Enqueue plugin general style */
	wp_enqueue_style( 'wpas-css', WPAS_URL.'css/admin/wpas.css', '', false, 'screen' );
	wp_enqueue_style( 'wpas-buttons', WPAS_URL.'css/admin/buttons.min.css', '', false, 'screen' );

	/* If file attachment is enabled we call the style */
	if( wpas_can_attach_files() ) {
		wp_enqueue_style( 'wpas-css-fineuploader', WPAS_URL.'plugins/jquery.fineuploader-3.9.1/fineuploader-3.9.1.min.css', '', false, 'screen' );
	}
}

/**
* Loading the frontend styles
*/
add_action('wp_print_styles', 'wpas_load_front_styles');

function wpas_load_front_styles() {

	/* We make sure the current page belongs to the plugin */
	if( !wpas_is_plugin_page() )
		return;

	/* Get the style type the user needs */
	$style = wpas_get_option( 'plugin_style' );

	/* We make sure we're not in the admin */
	if( is_admin() )
		return;

	/* We don't load the styles if the user disabled all plugin styling */
	if( $style != 'disable' && $style != 'no_forms' ) {

		/* Default Bootstrap style (light color) */
		wp_enqueue_style( 'wpas-css-bootstrap', WPAS_URL.'css/bootstrap-custom.min.css', '', false, 'screen' );
		wp_enqueue_style( 'wpas-css-font-awesome', WPAS_URL.'css/font-awesome.min.css', '', false, 'screen' );
		wp_enqueue_style( 'wpas-css-bootstrap-tagmanager', WPAS_URL.'css/bootstrap-tagmanager.css', '', false, 'screen' );

		/* If file attachment is enabled we call the style */
		if( wpas_can_attach_files() ) {
			wp_enqueue_style( 'wpas-css-fineuploader', WPAS_URL.'plugins/jquery.fineuploader-3.9.1/fineuploader-3.9.1.min.css', '', false, 'screen' );
		}

		/* Plugin main style */
		wp_enqueue_style( 'wpas-css-main', WPAS_URL.'css/main.css', '', false, 'screen' );
	}

	/* This CSS is required even if user doesn't want plugin styling */
	wp_enqueue_style( 'wpas-mendatory', WPAS_URL.'css/mandatory.css', '', false, 'screen' );

	/* Load the dark style */
	if( 'dark' == $style ) {
		wp_enqueue_style( 'wpas-css-bootstrap-dark', WPAS_URL . 'css/dark.css', '', false, 'screen' );
	}
}

/**
* Loading the frontend scripts
*/
add_action('wp_print_scripts', 'wpas_load_front_scripts');
function wpas_load_front_scripts() {

	/* We make sure the current page belongs to the plugin */
	if( !wpas_is_plugin_page() )
		return;

	/* We only load those resources in frontend */
	if( !is_admin() ) {

		/* If jQuery is not loaded we load our version */
		if( !wp_script_is('jquery') ) {
			wp_deregister_script( 'jquery' );
			wp_enqueue_script( 'jquery', 'http://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js', false, '1.9.1', false);
		}

		wp_enqueue_script( 'wpas-js-bootstrap', WPAS_URL.'js/bootstrap.min.js', '', false, true );
		wp_enqueue_script( 'wpas-js-bootstrap-tagmanager', WPAS_URL.'js/bootstrap-tagmanager.js', '', false, true );

		/* If file attachment is enabled we call the script */
		if( wpas_can_attach_files() ) {
			wp_enqueue_script( 'wpas-js-fineuploader', WPAS_URL.'plugins/jquery.fineuploader-3.9.1/fineuploader-3.9.1.min.js', '', false, true );
		}

		wp_enqueue_script( 'wpas-placeholder', WPAS_URL.'js/jquery.placeholder.min.js', '', false, true );
		
		/* Main frontend JS File */
		wp_enqueue_script( 'wpas-js-main', WPAS_URL.'js/main.js', '', false, true );
	}
}
?>