<?php
function wpas_settings_help() {
	if( !isset($_GET['page']) || $_GET['page'] != 'wpas-settings' ) {
		return;
	}
	
	$screen = get_current_screen();

	$screen->add_help_tab( array(
		'id'      => 'auto_assign',
		'title'   => __( 'Auto-Assign', 'wpas' ),
		'content' => __('<h2>Tickets Auto Assignment</h2><p>The auto-assignment system is simple but yet effective. However, in order to use this system, you need to define assignment rules first.</p><p>If you enable it, next time a client will post a support ticket, it will be assigned to a specific group of agents depending on the rules you created. The system will check which agent has lightest load of opened tickets and assign the new one to this agent.</p>', 'wpas')
	) );

	$screen->add_help_tab( array(
		'id'      => 'assignment',
		'title'   => __( 'Assignment Mode', 'wpas' ),
		'content' => sprintf(__('<h2>Assignment Mode</h2><ul><li><strong>Standard</strong>: tickets will be assigned to the most available agent (based on the number of tickets assigned).</li><li><strong>By Group</strong>: tickets will be assigned to the most available agent in the relevant group. This option <strong>requires you to assign each user to a specific group</strong> (in <strong><a href="%s">Users</a></strong> tab). Agents not assigned to any group will not be taken into account during tickets attribution.</li></ul>', 'wpas'), home_url().'/wp-admin/users.php')
	) );

	$screen->add_help_tab( array(
		'id'      => 'visibility',
		'title'   => __( 'Tickets Visibility', 'wpas' ),
		'content' => __('<h2>Tickets Visibility</h2><ul><li><strong>Public</strong>: everybody can browse and view the tickets on front-end.</li><li><strong>Private</strong>: all tickets are private and can\'t be browsed nor read.</li><li><strong>Closed are Public</strong>: closed tickets will appear publicly (can be helpful for your clients and avoid duplicate tickets).</li></ul>', 'wpas')
	) );

	$screen->add_help_tab( array(
		'id'      => 'email',
		'title'   => __( 'E-Mail Replies', 'wpas' ),
		'content' => __('<h2>E-Mail Replies</h2><p>If you choose to activate e-mail replies, you have the possibility to customize the e-mails templates in the &laquo;E-Mail Templates&raquo; tab. You will be able to edit the sender, sender e-mail address, subject and message template. A certain number of template tags are available and are explained in the help section.</p>', 'wpas')
	) );
	
	$screen->add_help_tab( array(
		'id'      => 'envato',
		'title'   => __( 'Envato', 'wpas' ),
		'content' => __('<h2>Envato Friendly</h2><p>You want to enable the purchase verification function but don\'t know how to get an Envato API Key? <a href="http://extras.envato.com/api/" target="_blank">Simply go to this page</a>, Envato explains you everything ;) </p>', 'wpas')
	) );

	$screen->add_help_tab( array(
		'id'      => 'force_cache_clear',
		'title'   => __( 'Cache Clear', 'wpas' ),
		'content' => __('<h2>Force Cache to Clear</h2><p>Some themes are coming with a built-in cache control feature. This can mess-up with the plugin.</p><p>The most frequent bug it creates is that your users will be asked to log-in even if they just did it. If your users are complaining about this, then you should enable this option.</p>', 'wpas')
	) );

	$screen->set_help_sidebar(
		sprintf(__('<h3>Documentation</h3><p>If you need more help, please read our documentation. You can also browse our knowledge base or submit a ticket in case of problem.</p><ul><li><a href="%s" target="_blank">Documentation</a></li></ul>', 'wpas'), 'http://support.themeavenue.net/help/plugins/wp-awesome-support/')
	);
}
add_filter('contextual_help', 'wpas_settings_help', 10, 3);
?>