<?php
add_action( 'admin_menu', 'wpas_settings_page' );
add_action( 'admin_init', 'wpas_register_plugin_settings' );
function wpas_settings_page() {
	add_submenu_page( 'edit.php?post_type=tickets', __('WP Awesome Support Settings', 'wpas'), __('Settings', 'wpas'), 'settings_tickets', 'wpas-settings', 'wpas_plugin_settings' );
}

function wpas_plugin_settings() { ?>
	<div class="wrap">  
		<div class="icon32" id="icon-options-general"></div>  
		<h2><?php _e('WP Awesome Support Settings', 'wpas'); ?></h2>

		<?php if( isset($_GET['settings-updated']) ) {
			echo '<div class="updated"><p>Settings updated successfully.</p></div>';

			/* We clear the session as the settings are now changed */
			unset( $_SESSION['wpas_options']['plugin'] );
		} ?>
		  
		<form action="options.php" method="post">
			<?php
			settings_fields( WPAS_PREFIX.'plugin_options' );
			do_settings_sections(__FILE__); 
			?>
			<p class="submit">  
				<input name="Submit" type="submit" class="button-primary" value="<?php esc_attr_e('Save','wpas'); ?>" />  
			</p>  
			  
		</form>  
	</div>
	<?php
}

function wpas_register_plugin_settings() {
	$settings = wpas_plugin_options();

	register_setting( WPAS_PREFIX.'plugin_options', WPAS_PREFIX.'plugin_options' );

	foreach( $settings as $key => $section ) {
		/* We add the sections and then loop through the corresponding options */
		add_settings_section( $section['id'], $section['title'], false, __FILE__);

		/* Get the options now */
		foreach( $section['options'] as $k => $option ) {
			if( !isset($option['desc']) ) $option['desc'] = '';
			if( !isset($option['opts']) ) $option['opts'] = array();
			$field_args = array(
				'name' 		=> $option['id'],
				'title' 	=> $option['title'],
				'type' 		=> $option['type'],
				'desc' 		=> $option['desc'],
				'options' 	=> $option['opts'],
				'group' 	=> WPAS_PREFIX.'plugin_options',
				'parent' 	=> isset( $option['parent'] ) ? $option['parent'] : false,
				'metas' 	=> isset( $option['metas'] ) ? $option['metas'] : array(),
				'class' 	=> isset( $option['class'] ) ? $option['class'] : '',
			);
			add_settings_field( $option['id'], $option['title'], 'wpas_render_option_fields', __FILE__, $section['id'], $field_args );
		}
	}
}

function wpas_render_option_fields( $args ) {
	wpas_output_option( $args );
}
?>