<?php
function wpas_add_color_field_to_taxonomies() { ?>
	<div class="form-field">
		<label for="term_meta[color]"><?php _e( 'Label Background Color', 'wpas' ); ?></label>
		<input type="text" value="" class="wpas-colorpicker" data-default-color="#fff" value="#fff" />
		<p class="description"><?php _e( 'The color will be used to visually identify this item in lists.','wpas' ); ?></p>
	</div>
	<div class="form-field">
		<label for="term_meta[font_color]"><?php _e( 'Label Font Color', 'wpas' ); ?></label>
		<input type="text" class="wpas-colorpicker" data-default-color="#000000" value="#000000" />
		<p class="description"><?php _e( 'Color of the text written in the color tag (color defined above).','wpas' ); ?></p>
	</div>
<?php
}

function wpas_add_color_field_to_taxo_edit_page( $term ) {

	// put the term ID into a variable
	$t_id = $term->term_id;

	// retrieve the existing value(s) for this meta field. This returns an array
	$term_meta = get_option( "taxonomy_$t_id" );
	if( isset($term_meta['color']) ) {
		$color = $term_meta['color'];
	} else {
		$color = '';
	}
	if( isset($term_meta['font_color']) ) {
		$font = $term_meta['font_color'];
	} else {
		$font = '';
	}
	?>
	<tr class="form-field">
		<th valign="top" scope="row"><label for="term_meta[color]"><?php _e( 'Label Background Color', 'wpas' ); ?></label></th>
		<td>
			<input type="text" value="<?php echo esc_attr( $color ); ?>" id="term_meta[color]" name="term_meta[color]" class="wpas-colorpicker" data-default-color="#fff" />
			<p class="description"><?php _e( 'The color will be used to visually identify this item in lists.','wpas' ); ?></p>
		</td>
	</tr>
	<tr class="form-field">
		<th valign="top" scope="row"><label for="term_meta[font_color]"><?php _e( 'Label Font Color', 'wpas' ); ?></label></th>
		<td>
			<input type="text" value="<?php echo esc_attr( $font ); ?>" id="term_meta[font_color]" name="term_meta[font_color]" class="wpas-colorpicker" data-default-color="#000000" />
			<p class="description"><?php _e( 'Color of the text written in the color tag (color defined above).','wpas' ); ?></p>
		</td>
	</tr>
	<?php
}

/* Register the fields for required taxonomies */
add_action( 'priority_edit_form_fields', 'wpas_add_color_field_to_taxo_edit_page', 10, 2 );
add_action( 'state_edit_form_fields', 'wpas_add_color_field_to_taxo_edit_page', 10, 2 );

// Save extra taxonomy fields callback function.
function wpas_save_taxonomy_custom_meta( $term_id ) {

	if( isset( $_POST['term_meta'] ) ) {
		$t_id 		= $term_id;
		$term_meta 	= get_option( 'taxonomy_$t_id' );
		$cat_keys 	= array_keys( $_POST['term_meta'] );

		foreach( $cat_keys as $key ) {
			if( isset( $_POST['term_meta'][$key] ) ) {
				$term_meta[$key] = $_POST['term_meta'][$key];
			}
		}
		// Save the option array.
		update_option( "taxonomy_$t_id", $term_meta );
	}
}

/* Hook the function to save terms color */
add_action( 'edited_priority', 'wpas_save_taxonomy_custom_meta', 10, 2 );
add_action( 'edited_state', 'wpas_save_taxonomy_custom_meta', 10, 2 );
?>