<?php
class WPAS_Latest_Tickets extends WP_Widget {

	function WPAS_Latest_Tickets() {
		$widget_ops = array(
		'classname' => 'Latest_Tickets', 
		'description' => __('Latest Support Tickets', 'wpas')
		);
		$this->WP_Widget('Latest_Tickets', __('WPAS - Latest Tickets', 'wpas'), $widget_ops);
	}

	function widget( $args, $instance ) {

		global $post;

		if( !$post )
			return;

		extract( $args );
		extract( $instance );
		
		echo $before_widget.$before_title.$title.$after_title;

		$latest = get_posts( array(
			'numberposts'		=>	$limit,
			'post_type'			=>	array('tickets')
			)
		);

		if( !empty($latest) ) { echo '<div class="wpas_recent"><ul>'; }
		else { _e('<p>No tickets yet.</p>', 'wpas'); }

		foreach( $latest as $ticket ) {
			if( !wpas_can_view_ticket( $ticket->ID ) )
				continue;
			
			?><li><span>&rsaquo;</span> <a href="<?php echo get_permalink( $ticket->ID ); ?>"><?php echo $ticket->post_title; ?></a> (<time class="timeago" datetime="<?php echo get_the_time('U', $row->ID); ?>"><?php echo get_the_date( get_option('date_format'), $ticket->ID ); ?></time>)</li><?php
		}

		if( !empty($latest) ) { echo '</div></ul>'; }

		echo $after_widget;
	}

	function update($new, $old) {
		return $new;
	}

	function form( $args ) {
		$args = wp_parse_args( $args, array(
		'title' => 'Latest Tickets',
		'limit' => '5'
		) );
		extract( $args );
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wpas'); ?></label><br/>
			<input type="text" value="<?php echo $title; ?>" name="<?php echo $this->get_field_name('title'); ?>" id="<?php echo $this->get_field_id('title'); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('limit'); ?>"><?php _e('Tickets to Show:', 'wpas'); ?></label><br/>
			<input type="text" value="<?php echo $limit; ?>" name="<?php echo $this->get_field_name('limit'); ?>" id="<?php echo $this->get_field_id('limit'); ?>" />
		</p>
		
		<?php
	}
}

class Support_Stats extends WP_Widget {
	function Support_Stats() {
		$widget_ops = array(
		'classname' => 'Support_Stats', 
		'description' => __('Blog\'s latest news', 'n2cpanel')
		);
		$this->WP_Widget('Support_Stats', __('WPAS - Support Stats', 'n2cpanel'), $widget_ops);
	}

	function widget($args, $instance) {
		extract( $args );
		extract( $instance );
		
		echo $before_widget;
		
		echo $before_title.$title.$after_title;
		?>
		
		<ul class="latest_news">
			<?php wp_get_archives( $args = array('type' => 'postbypost', 'limit' => $limit) ); ?>
		</ul>
			
		<?php 
		echo $after_widget;
	}

	function update($new, $old) {
		return $new;
	}

	function form( $args ) {
		$args = wp_parse_args( $args, array(
		'title' => 'Latest News',
		'limit' => '5'
		) );
		extract( $args );
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'n2cpanel'); ?></label><br/>
			<input type="text" value="<?php echo $title; ?>" name="<?php echo $this->get_field_name('title'); ?>" id="<?php echo $this->get_field_id('title'); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('limit'); ?>"><?php _e('Limit:', 'n2cpanel'); ?></label><br/>
			<input type="text" value="<?php echo $limit; ?>" name="<?php echo $this->get_field_name('limit'); ?>" id="<?php echo $this->get_field_id('limit'); ?>" />
		</p>
		
		<?php
	}
}

class Search_Tickets extends WP_Widget {
	function Search_Tickets() {
		$widget_ops = array(
			'classname' => 'Search_Tickets', 
			'description' => __('Tickets are not searchable through the standard WP search function. Use this widget if you want your users to search tickets.', 'wpas')
		);
		$this->WP_Widget('Search_Tickets', __('WPAS - Search Tickets', 'wpas'), $widget_ops);
	}

	function widget($args, $instance) {
		extract( $args );
		extract( $instance );
		echo $before_widget;
		$tickets_page = wpas_get_option('ticket_list');
		
		echo $before_title.$title.$after_title;
		
		?>
		<form method="post" action="<?php echo get_permalink($tickets_page); ?>">
			<div class="form-group">
				<label for="wpas-search" class="sr-only">Email address</label>
				<input type="text" class="form-control" id="wpas-search" placeholder="<?php _e('Search Tickets', 'wpas'); ?>" name="srch">
			</div>
		</form>
		<?php

		echo $after_widget;
	}

	function update($new, $old) {
		return $new;
	}

	function form( $args ) {
		$args = wp_parse_args( $args, array('title' => __('Search Tickets', 'wpas')) );
		extract( $args ); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'n2cpanel'); ?></label><br/>
			<input type="text" value="<?php echo $title; ?>" name="<?php echo $this->get_field_name('title'); ?>" id="<?php echo $this->get_field_id('title'); ?>" />
		</p>
		<?php
	}
}

class Ticket_Details extends WP_Widget {
	function Ticket_Details() {
		$widget_ops = array(
			'classname' => 'Ticket_Details', 
			'description' => __('This widget will display the current ticket details. If the current page is not a ticket, or if user don\'t have the permissions to view tickets, nothing will be displayed.', 'wpas')
		);
		$this->WP_Widget('Ticket_Details', __('WPAS - Ticket Details', 'wpas'), $widget_ops);
	}

	function widget($args, $instance) {
		global $post;

		if( !$post )
			return;

		if( !is_single() || is_single() && $post->post_type != 'tickets' )
			return;

		if( !wpas_can_view_ticket( $post->ID) )
			return;

		extract( $args );
		extract( $instance );
		$posttags = get_the_tags();
		$tickets_page = wpas_get_option('ticket_list');

		/* Get ticket status */
		$status  = get_the_terms( $tkt->ID, 'status' );
		if( $status ) {
			foreach($status as $s) {
				$status = $s->slug;
				$lib = explode('-', $status);
			}
		}

		/* Let's get the tags */
		$tags 	  = array();
		$status_color = wpas_get_option('status_'.$lib[1].'_color');
		if( $status == 'wpas-open' && !empty($states) ) {
			foreach( $states as $sid => $state ) {
				$opts   = get_option('taxonomy_'.$state->term_id);

				/* Tag style */
				$style = 'style="';
				if( isset($opts['color']) ) {
					$style .= 'background-color:'.$opts['color'].';';
				}
				if( isset($opts['font_color']) ) {
					$style .= ' color:'.$opts['font_color'].';';
				}
				$style .= '"';

				$var = '<span';
				if( $style != ' style=""' ) { $var .= ' '.$style; }

				$var .= ' class="label">'.$state->name.'</span>';
				$tags[] = $var;
			}
		} elseif( $status == 'wpas-open' && empty($states) ) {
			$tags = array();
			$tags[] = '<span class="label" style="background-color:'.$status_color.';">'.ucwords($lib[1]).'</span>';
		} elseif( $status == 'wpas-close' ) {
			$tags = array();
			$tags[] = '<span class="label" style="background-color:'.$status_color.';">'.ucwords($lib[1]).'</span>';
		}
		$tags = implode(' ', $tags);

		/* Get priority */
		$priorities  = get_the_terms( $post->ID, 'priority' );
		if( $priorities ) {
			foreach($priorities as $p) {
				$priority = $p->name;
				$pid 	  = $p->term_id;
			}
			$prio_opts  = get_option('taxonomy_'.$pid);
			if( isset($prio_opts['color']) ) {
				$prio_color = $prio_opts['color'];
			} else {
				$prio_color = '';
			}

			if( isset($prio_opts['font_color']) ) {
				$prio_font = $prio_opts['font_color'];
			} else {
				$prio_font = '';
			}
		}

		/* Get type */
		$types  = get_the_terms( $tkt->ID, 'type' );
		if( $types ) {
			foreach($types as $t) {
				$type = $t->name;
			}
		}

		echo $before_widget.$before_title.$title.$after_title;
		
		?>
		<table id="ticket_details_widget" class="table table-striped">
			<tbody>
				<tr>
					<td><?php _e('Status', 'wpas'); ?></td>
					<td><?php echo $tags; ?></td>
				</tr>
				<tr>
					<td><?php _e('ID', 'wpas'); ?></td>
					<td>#<?php echo $post->ID; ?></td>
				</tr>
				<tr>
					<td><?php _e('Priority', 'wpas'); ?></td>
					<td><?php if( $priorities ): ?><span class="label" style="background-color: <?php echo $prio_color; ?>; color: <?php echo $prio_font; ?>;"><?php echo $priority; ?></span><?php endif; ?></td>
				</tr>
				<?php if( !empty($posttags) ): ?>
					<tr>
						<td><?php _e('Tags', 'wpas'); ?></td>
						<td>
							<?php
							$ptags = array();
							foreach($posttags as $tag) {
								$ptags[] = '<a href="'.add_query_arg( 'tag', $tag->slug, get_permalink($tickets_page) ).'" class="badge badge-inverse">'.$tag->name.'</a>'; 
							}
							$ptags = implode(' ', $ptags);
							echo $ptags;
							?>
						</td>
					</tr>
				<?php endif; ?>
				<tr>
					<td><?php _e('Category', 'wpas'); ?></td>
					<td><?php if( $types ): echo $type; endif; ?></td>
				</tr>
			</tbody>
		</table>
		<?php

		echo $after_widget;
	}

	function update($new, $old) {
		return $new;
	}

	function form( $args ) {
		$args = wp_parse_args( $args, array('title' => __('Ticket Details', 'wpas')) );
		extract( $args ); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wpas'); ?></label><br/>
			<input type="text" value="<?php echo $title; ?>" name="<?php echo $this->get_field_name('title'); ?>" id="<?php echo $this->get_field_id('title'); ?>" />
		</p>
		<?php
	}
}
	
add_action( 'widgets_init', 'wpas_register_plugin_widgets' );
/**
 * Let's register all thos widgets now
 */
function wpas_register_plugin_widgets() {
	register_widget( 'WPAS_Latest_Tickets' );
	register_widget('Ticket_Details');
	// register_widget('Support_Stats');
	register_widget('Search_Tickets');
}
?>