<?php
add_action( 'add_meta_boxes', 'wpas_custom_fields' );
/**
 * Register the metabox
 */
function wpas_custom_fields() {

	global $wpas;

	$cf = $wpas->getCustomFields();

	if( empty( $cf ) )
		return;

	add_meta_box( 'wpas_custom_fields', __( 'Custom Information', 'wpas' ), 'wpas_show_custom_fields', wpas_get_slug(), 'side', 'default' );
}

function wpas_show_custom_fields() {

	global $wpas, $post;

	$cf = $wpas->getCustomFields();
	$a  = false;
	?>

	<div class="wpas-cf-container">

		<?php
		foreach( $cf as $key => $field ) {

			$value = get_post_meta( $post->ID, 'wpas_' . $field['name'], true );

			if( '' != $value ) {

				$a = true;

				?><div class="wpas-custom-field" id="wpas-cf-<?php echo $field['id']; ?>"><strong><?php echo $field['label']; ?></strong>: <?php echo $value; ?></div><?php

			}

		}

		if( !$a )
			_e( 'No custom data to show.', 'wpas' );
		?>

	</div><?php

}