<?php
/**
 * Ticket details widget
 *
 * This widget will show basic information about the ticket
 * such as status, state, type and priority.
 * It will also include all custom taxonomies that have been
 * added through WP_Awesome_Support::addTaxonomy
 */

add_action( 'add_meta_boxes', 'wpas_add_details_widget' );
/**
 * Register the metabox
 */
function wpas_add_details_widget() {
	add_meta_box( 'wpas_ticket_details_mb', __('Ticket Details', 'wpas'), 'wpas_ticket_details_mb', 'tickets', 'side', 'high' );
}

/**
 * Get all taxonomies and add a dropdown for each
 */
function wpas_ticket_details_mb() {

	global $post, $wpas;

	$default 	= $wpas->getTaxonomies();
	$count 		= 1;
	?>
	<table class="form-table">
		<tbody>

			<tr valign="top">

				<td>
					<?php
					$count++;
					$currents = get_the_terms( $post->ID, 'status' );

					$curr_status = '';

					if( is_array($currents) ) {
						foreach($currents as $current) {
							$current = $current->slug;
						}
						$curr_status = $current;
					}
					?>
					<label for="status"><strong><?php _e('Status', 'wpas'); ?></strong></label>
					<select name="status" id="status" <?php if( $curr_status == 'open' && !current_user_can('close_ticket') || $curr_status == 'wpas-close' && !current_user_can('create_ticket') ) { echo 'disabled'; } ?> style="width:100%" required>
						<?php
						$statuses = get_terms( 'status', array('hide_empty' => 0) );
						$curr_status = wp_get_object_terms( $post->ID, 'status' );
						if( is_array($curr_status) && !empty($curr_status) ) {
							$curr_status = $curr_status[0]->slug;
						}
						foreach( $statuses as $status ) {
							?><option value="<?php echo $status->slug; ?>" <?php if( !is_array($curr_status) && $curr_status == $status->slug || !$curr_status && $status->slug == 'wpas-open' ) { echo 'selected="selected"'; } ?>><?php echo $status->name; ?></option><?php
						}
						?>
					</select>
				</td>

				<?php
				foreach( $default as $key => $taxonomy ) {

					$tax 		= sanitize_title( $taxonomy['id'] );
					$terms 		= get_terms( $tax, array( 'hide_empty' => 0 ) );
					$current 	= wp_get_object_terms( $post->ID, $tax );
					$single		= '';

					if( is_array( $current ) && !empty( $current ) )
						$single = $current[0]->slug;

					/* Open a new row */
					if( 1 == $count )
						echo '<tr valign="top">';

					?>
					<td>
						<label for="<?php echo $tax; ?>"><strong><?php echo ucwords( $tax ); ?></strong></label>
						<select name="<?php echo $tax; ?>" id="<?php echo $tax; ?>" style="width:100%" <?php if( $taxonomy['required'] ) echo 'required'; ?>><?php

					foreach( $terms as $term ) { ?>

						<option value="<?php echo $term->slug; ?>" <?php if( $single == $term->slug ) { echo 'selected="selected"'; } ?>><?php echo $term->name; ?></option>

					<?php }

					?></select></td><?php

					/* Open a new row */
					if( 2 == $count ) {
						echo '</tr>';
						$count = 0;
					}

					/* Increment the count for row management */
					$count++;

				}

				if( $count == ( 0 || 1 ) ) {
					echo '</tr>';
				}
				?>

		</tbody>
	</table>
<?php }