<?php
add_action( 'add_meta_boxes', 'wpas_add_envato_widget' );
/**
 * Register the metabox
 */
function wpas_add_envato_widget() {

	global $post;

	$licence 	= get_post_meta( $post->ID, WPAS_PREFIX . 'envato_purchase_license', true );
	$item 		= get_post_meta( $post->ID, WPAS_PREFIX . 'envato_purchased_item', true );

	if( !$item && !$licence )
		return;
	
	add_meta_box( 'wpas_envato_license', __('License Information', 'wpas'), 'wpas_envato_license', wpas_get_slug(), 'side', 'default' );
}

function wpas_envato_license() {

	global $post;

	$licence 	= get_post_meta( $post->ID, WPAS_PREFIX . 'envato_purchase_license', true );
	$item 		= get_post_meta( $post->ID, WPAS_PREFIX . 'envato_purchased_item', true );

	if( !$item && !$licence )
		return;
	?>

	<table class="form-table wpas-licence-info">
		<tbody>

			<?php if( $item ): ?>
				<tr valign="top">
					<td>
						<?php printf( __( 'Licence for %s', 'wpas' ), '<strong>' . $item['item_name'] . '</strong>' ); ?><br>
					</td>
				</tr>
				<tr valign="top">
					<td style="width:50%">
						<?php printf( __( 'Bought on %s', 'wpas' ), '<strong>' . $item['item_purchase'] . '</strong>' ); ?><br>
					</td>
				</tr>
				<tr valign="top">
					<td>
						<?php printf( __( 'Bought by %s on Envato', 'wpas' ), '<strong><a href="http://themeforest.net/user/' . $item['item_buyer'] . '" target="_blank">' . $item['item_buyer'] . '</a></strong>' ); ?><br>
					</td>
				</tr>
				<tr valign="top">
					<td>
						<?php printf( __( 'Purchased with %s', 'wpas' ), '<strong>' . $item['item_licence'] . '</strong>' ); ?><br>
					</td>
				</tr>
			<?php endif; ?>
			
			<tr valign="top">
				<td>
					<strong><?php _e( 'License', 'wpas' ); ?></strong><br>
					<?php echo $licence; ?>
				</td>
			</tr>
		</tbody>
	</table>

<?php }