<?php
function wpas_activate_plugin() {
	/* Register the new roles and add the capacities */
	wpas_register_user_roles_capacities();

	/* Update the settings if needed*/
	wpas_update();

	/* Register the default plugin settings */
	wpas_save_default_options();

	/* Register the tickets status */
	WP_Awesome_Support::registerStatusTaxonomy();
	wpas_register_default_status();

}

/* Register the tickets status */
// add_action('init', 'wpas_register_default_status', 11);

/* We define the new capacities and
 * assign them to custom roles. If the
 * roles already exist, nothing will
 * be altered. */
function wpas_register_user_roles_capacities() {
	/* Capacities full list */
	$full_cap = array(
		'view_ticket',
		'edit_ticket',
		'delete_ticket',
		'assign_ticket',
		'close_ticket',
		'reply_ticket',
		'settings_tickets',
		'ticket_taxonomy',
		'create_ticket'
	);

	$agent_cap = array(
		'view_ticket',
		'edit_ticket',
		'assign_ticket',
		'close_ticket',
		'reply_ticket',
		'create_ticket'
	);

	// add all capabilities to admin

	/* Get roles to copy capacities from */
	$editor 	= get_role('editor');
	$author 	= get_role('author');
	$subscriber = get_role('subscriber');
	$admin 		= get_role('administrator');

	/* Add the new roles */
	$manager 	= add_role( 'wpas_manager', 'Manager', $editor->capabilities );
	$smanager 	= add_role( 'wpas_support_manager', 'Support Manager', $subscriber->capabilities );
	$agent 		= add_role( 'wpas_agent', 'Agent', $author->capabilities );
	// $spy 		= add_role( 'wpas_spy', 'Spy', $subscriber->capabilities );

	/* Add full power to admin and give full privileges to manager */
	foreach( $full_cap as $cap ) {
		if( null != $admin ) // Add all the capacities to admin in addition to full WP capacities
			$admin 		-> add_cap( $cap );
		if( null != $manager ) // Add full plugin capacities to manager in addition to the editor capacities
			$manager 	-> add_cap( $cap );
		if( null != $smanager ) // Add full plugin capacities to technical manager
			$smanager 	-> add_cap( $cap );
	}

	/* Add agent capacities */
	foreach( $agent_cap as $cap ) {
		if( null != $agent )
			$agent -> add_cap( $cap );
	}

	/* Add the view capacity to spy */
	/*if( null != $spy )
		$spy -> add_cap( 'view_ticket' );*/
}

/**
 * The open and close status are required
 * to manage the tickets. Thus, I can't let
 * users define their own status. The taxonomy
 * is not editable by users and only those
 * two terms will be available.
 */
function wpas_register_default_status() {

	// print_r( get_term( 'wpas-open', 'status' ) ); exit;

	$open  = wp_insert_term( __('Open', 'wpas'), 'status', array( 'description' => __( 'Tickets currently opened.', 'wpas' ), 'slug' => 'wpas-open' ) );
	$close = wp_insert_term( __('Closed', 'wpas'), 'status', array( 'description' => __( 'Tickets resolved.', 'wpas' ), 'slug' => 'wpas-close' ) );
}

function wpas_save_default_options() {
	/* Define options */
	$setup_date 		= date ( 'Y-m-d H:i:s' );
	$wpas_rated 		= WPAS_PREFIX.'rated';
	$wpas_first_setup 	= WPAS_PREFIX.'first_setup_date';
	$wpas_setup 		= WPAS_PREFIX.'latest_setup_date';
	$wpas_version 		= WPAS_PREFIX.'version';
	$email_opts 		= array();

	/* Check DB */
	$rated 				= get_option( WPAS_PREFIX.'rated', false );
	$first_setup 		= get_option( WPAS_PREFIX.'first_setup_date', false );

	if( !$rated ) { update_option( $wpas_rated, 'pending' ); }
	if( !$first_setup ) { update_option( $wpas_first_setup, $setup_date ); }
	update_option( $wpas_setup, $setup_date );
	update_option( $wpas_version, WPAS_VERSION );

	/* Plugin settings */
	$cfg = array(
		'default_assignee' 				=> '',
		'ticket_auto_assignment' 		=> 'no',
		'assignment_mode' 				=> 'standard',
		'admins_see_all' 				=> 'no',
		'replies_order' 				=> 'ASC',
		'default_state' 				=> '',
		'use_tags' 						=> 'no',
		'allow_file_attachment' 		=> 'no',
		'files_number' 					=> '1',
		'files_size' 					=> '2',
		'allowed_filetypes' 			=> 'jpg,jpeg,png,gif,pdf,doc,docx,ppt,pptx,pps,ppsx,odt,xls,xlsx',
		'ticket_submit' 				=> '',
		'ticket_list' 					=> '',
		'ticket_list_on_submit' 		=> 'no',
		'number_ticket_list_on_submit' 	=> '5',
		'plugin_style' 					=> 'light',
		'status_open_color' 			=> '#72bf3b',
		'status_close_color' 			=> '#bc2b2b',
		'buttons_class' 				=> 'btn btn-primary',
		'gravatar_on_front' 			=> 'yes',
		'date_position' 				=> 'right_side',
		'extra_css' 					=> '',
		'ticket_can_read' 				=> 'author',
		'ticket_can_reply' 				=> 'author',
		'agent_can_assign_ticket' 		=> 'yes',
		'agent_can_close_ticket' 		=> 'yes',
		'snapengage_code' 				=> '',
		'prevent_admin_access' 			=> 'yes',
		'force_cache_clear' 			=> 'no',
		'envato_check' 					=> 'no',
		'envato_api_key' 				=> '',
		'envato_username' 				=> '',
		'envato_purchase_mandatory' 	=> 'no',
		'terms' 						=> '',
		/* Since 1.1.3 */
		'only_list_open' 				=> 'no',
		/* Since 1.1.5 */
		'login_page'					=> '',
		/* Since 1.1.7 */
		'frontend_wysiwyg_editor' 		=> 'no',
		'days_old' 						=> 10,
		'status_old_color' 				=> '#dd9933',
		/* Since 2.0.0 */
		'pre_submission_notice' 		=> '',
		'automatically_close' 			=> 'no',
		'remider_before_closing' 		=> 3,
		'recaptcha_enabled' 			=> 'no',
		'recaptcha_public_key' 			=> '',
		'recaptcha_private_key' 		=> '',
		'upload_script' 				=> 'fineuploader',
		'filepicker_api' 				=> '',
		'filepicker_secret' 			=> '',
		'filepicker_services' 			=> Array ( 'COMPUTER', 'DROPBOX', 'FACEBOOK', 'GOOGLE_DRIVE' ),
		'auto_close_exclude_state' 		=> '',
		'live_search' 					=> 'no',
		'live_search_where' 			=> '',
		/* Since 2.0.1 */
		'show_upload_limitations' 		=> 'no',
		/* Since 2.0.3 */
		'reply_and_back' 				=> 'yes',
	);

	/* E-Mail Options */
	$email_opts = array(
		'email_from_name' => '',
		'email_from_mail' => '',
		'confirm_submission_to_client' => 'yes',
		'email_client_new_reply' => 'yes',
		'email_agent_on_assignation' => 'yes',
		'email_agent_client_reply' => 'yes',
		'email_client_when_closed' => 'yes',
		'ticket_confirm_subject' => 'Request received: {ticket_title}',
		'ticket_confirm_content' => 'Hi <strong><em>{client_name}</em>,</strong>

Your request (<a href="{ticket_url}">#{ticket_id}</a>) has been received, and is being reviewed by our support staff.

To add additional comments, follow the link below:
<h2><a href="{ticket_url}">View Ticket</a></h2>
or follow this link: {ticket_link}

<hr />

Regards,
{site_name}',
		'new_assignment_subject' => 'Ticket #{ticket_id} assigned',
		'new_assignment_content' => 'Hi <strong><em>{agent_name},</em></strong>

The request <strong>{ticket_title}</strong> (<a href="{ticket_admin_url}">#{ticket_id}</a>) has been assigned to you.
<h2><a href="{ticket_admin_url}">View  Ticket</a></h2>
or follow this link: {ticket_admin_link}

<hr />

Regards,
{site_name}',
		'agent_new_reply_subject' => 'New reply to: {ticket_title}',
		'agent_new_reply_content' => 'Hi <strong><em>{client_name}</em>,</strong>

An agent just replied to your ticket "<strong>{ticket_title}</strong>" (<a href="{ticket_url}">#{ticket_id}</a>). To view his reply or add additional comments, click the button below:
<h2><a href="{ticket_url}">View Ticket</a></h2>
or follow this link: {ticket_link}

<hr />

Regards,
{site_name}',
		'client_new_reply_subject' => 'Ticket #{ticket_id}',
		'client_new_reply_content' => 'Hi <strong><em>{agent_name},</em></strong>

A client you are in charge of just posted a new reply to his ticket "<strong>{ticket_title}</strong>".
<h2><a href="{ticket_admin_url}">View  Ticket</a></h2>
or follow this link: {ticket_admin_link}

<hr />

Regards,
{site_name}',
		'will_be_closed_ticket_subject' => 'Your ticket will be closed soon',
		'will_be_closed_ticket_content' => 'Hi <strong><em>{client_name}</em></strong>,

It\'s been a while since we wrote a reply to your ticket "<strong>{ticket_title}</strong>" but you didn\'t get back to us. If you don\'t update your ticket very soon, it will be automatically closed.

Regards,{agent_name}',
		'closed_ticket_subject' => 'Request closed: {ticket_title}',
		'closed_ticket_content' => 'Hi <strong><em>{client_name},</em></strong>

Your request (<a href="{ticket_url}">#{ticket_id}</a>) has been closed by <strong>{agent_name}</strong>.

<hr />

Regards,
{site_name}'
	);

	$config 	= get_option( WPAS_PREFIX.'plugin_options', false );
	$templates  = get_option( WPAS_PREFIX.'email_options', false );

	if( !$config )
		update_option( WPAS_PREFIX.'plugin_options', $cfg );

	if( !$templates )
		update_option( WPAS_PREFIX.'email_options', $email_opts );
}

function wpas_update() {

	/* Get current version */
	$version = get_option( WPAS_PREFIX . 'version', false );

	if( $version && version_compare( $version, '2.0.0', '<' ) ) { exit;

		/* Options to move */
		$move = array(
			'email_from_name',
			'email_from_mail',
			'confirm_submission_to_client',
			'email_client_new_reply',
			'email_agent_on_assignation',
			'email_agent_client_reply',
			'email_client_when_closed'
		);

		/* Previous e-mail templates */
		$email_templates = get_option( WPAS_PREFIX.'email_templates_options', false );
		$email_options   = maybe_unserialize( $email_templates );

		/* Get notifications options */
		$plugin_options = get_option( 'wpas_plugin_options', false );
		$plugin_options = maybe_unserialize( $plugin_options );

		/* Options are moved */
		foreach( $move as $id ) {
			$email_options[$id] = $plugin_options[$id];
			unset($plugin_options[$id]);
		}

		/* New default options */
		$plugin_options['allow_file_attachment'] 	= 'no';
		$plugin_options['files_number'] 			= '1';
		$plugin_options['files_size'] 				= '2';
		$plugin_options['allowed_filetypes'] 		= 'jpg,jpeg,png,gif,pdf,doc,docx,ppt,pptx,pps,ppsx,odt,xls,xlsx';
		$plugin_options['use_tags'] 				= 'yes';
		$plugin_options['date_position'] 			= 'right_side';

		update_option( WPAS_PREFIX.'plugin_options', $plugin_options );
		update_option( WPAS_PREFIX.'email_options', $email_options );

		/* Delete the old options */
		delete_option( WPAS_PREFIX.'email_templates_options' );
		delete_option( 'wpas_plugin_options' );
	}
}

function wpas_update_deprecated() {
	$version = get_option( WPAS_PREFIX.'version', false );

	if( $version && $version == '1.0.0' && WPAS_VERSION == '1.1.0' ) {
		/* Options to move */
		$move = array(
			'email_from_name',
			'email_from_mail',
			'confirm_submission_to_client',
			'email_client_new_reply',
			'email_agent_on_assignation',
			'email_agent_client_reply',
			'email_client_when_closed'
		);

		/* Previous e-mail templates */
		$email_templates = get_option( WPAS_PREFIX.'email_templates_options', false );
		$email_options   = maybe_unserialize( $email_templates );

		/* Get notifications options */
		$plugin_options = get_option( 'wpas_plugin_options', false );
		$plugin_options = maybe_unserialize( $plugin_options );

		/* Options are moved */
		foreach( $move as $id ) {
			$email_options[$id] = $plugin_options[$id];
			unset($plugin_options[$id]);
		}

		/* New default options */
		$plugin_options['allow_file_attachment'] 	= 'no';
		$plugin_options['files_number'] 			= '1';
		$plugin_options['files_size'] 				= '2';
		$plugin_options['allowed_filetypes'] 		= 'jpg,jpeg,png,gif,pdf,doc,docx,ppt,pptx,pps,ppsx,odt,xls,xlsx';
		$plugin_options['use_tags'] 				= 'yes';
		$plugin_options['date_position'] 			= 'right_side';

		update_option( WPAS_PREFIX.'plugin_options', $plugin_options );
		update_option( WPAS_PREFIX.'email_options', $email_options );

		/* Delete the old options */
		delete_option( WPAS_PREFIX.'email_templates_options' );
		delete_option( 'wpas_plugin_options' );
	}
}
?>