<?php
/* WooCommerce Integration */
if( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

	add_action( 'woocommerce_after_my_account', 'wpas_add_tickets_to_woo_account' );
	/**
	 * Add the tickets list to WooCommerce account page
	 */
	function wpas_add_tickets_to_woo_account() {
		echo '<h3>'.__('My Tickets', 'wpas').'</h3>';
		echo wpas_list_tickets( '', array( 'tickets' => wpas_get_option( 'number_ticket_list_on_submit', 5 ), 'search_form' => false, 'pre_table_links' => false ) );
	}

	add_action( 'wpas_before_prevent_admin_access', 'wpas_disable_prevent_admin_access' );
	/**
	 * WooCommerce is more famous that us, so we let him handle the admin redirect ;)
	 */
	function wpas_disable_prevent_admin_access() {
		$lockdown = get_option( 'woocommerce_lock_down_admin', false );

		if( $lockdown && $lockdown == 'yes' )
			return;
	}
}