/*jshint -W065 */
jQuery(document).ready(function ($) {

	'use strict';

	// Reading WordPress Options
	var wpas_json_str = wpas.replace(/&quot;/g, '"');
	var wpas_obj = $.parseJSON(wpas_json_str);

	// File Attachements: FineUploader (http://docs.fineuploader.com/)
	if (jQuery().fineUploader) {
		$('#wpas_fileupload').fineUploader({
			template: 'wpas-qq-template',
			request: {
				endpoint: '' + wpas_obj.global.wpasUrl + 'includes/attachments.php'
			},
			validation: {
				allowedExtensions: wpas_obj.attachments.allowedExtensions,
				sizeLimit: wpas_obj.attachments.maxSize,
				itemLimit: wpas_obj.attachments.maxFiles
			},
			showMessage: function (message) {
				var modalupload = $('#wpas-modalupload').find('.modal-body').html(message);
				modalupload.trigger('openModal');
			},
			classes: {
				success: 'qq-upload-success wpas-alert-upload alert alert-success',
				fail: 'qq-upload-fail wpas-alert-upload alert alert-danger',
				dropActive: 'wpas-dz-active'
			}
		})
			.on('complete', function (event, id, name, responseJSON) {
				$('#wpas_fileuploaded').append('<input type="hidden" name="filenames[]" value="' + name + '"}">');
				$('#wpas_fileuploaded').append('<input type="hidden" name="attachments[]" value="' + responseJSON.uploadName + '"}">');
			})
			.on('error', function (event, id, fileName, reason, maybeXhr) {
				alert(reason);
			});
	}
});