<?php
function wpas_email_options() {
	$options = array(
		array(
			'id' 		=> 'wpas_emails',
			'title' 	=> __('E-Mail Notifications', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'email_from_name',
					'title'		=> __('Sender Name', 'wpas'),
					'desc' 		=> __('Sender name used in e-mail notifications.', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'email_from_mail',
					'title'		=> __('Sender E-Mail', 'wpas'),
					'desc' 		=> __('Sender email used in e-mail notifications (admin e-mail will be used by default).', 'wpas'),
					'type' 		=> 'email'
				),
				array(
					'id'		=> 'confirm_submission_to_client',
					'title'		=> __('E-Mail Client To Confirm Ticket Submission', 'wpas'),
					'desc' 		=> __('Client will receive an e-mail after submitting a ticket.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'email_client_new_reply',
					'title'		=> __('E-Mail Client On New Replies', 'wpas'),
					'desc' 		=> __('Everytime an agent replies a ticket, the client will get a copy via e-mail.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'email_agent_on_assignation',
					'title'		=> __('E-Mail Agent On New Assignment', 'wpas'),
					'desc' 		=> __('Agents will be notified when a new ticket is assigned to them.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'email_agent_client_reply',
					'title'		=> __('E-Mail Agent On Client Reply', 'wpas'),
					'desc' 		=> __('Agents will be notified when a reply is sent to a ticket they are responsible for.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'email_client_when_closed',
					'title'		=> __('E-Mail Client When Ticket Is Closed', 'wpas'),
					'desc' 		=> __('An e-mail will be automatically sent to the client when the agent closes the ticket.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
			),
		),
		array(
			'id' 		=> 'wpas_ticket_confirmation',
			'title' 	=> __('Ticket Submission Confirmation <small>(E-Mail sent to client)</small>', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'ticket_confirm_subject',
					'title'		=> __('E-Mail Subject', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'ticket_confirm_content',
					'title'		=> __('E-mail Content', 'wpas'),
					'type' 		=> 'wysiwyg'
				),
			),
		),
		array(
			'id' 		=> 'wpas_new_assignment',
			'title' 	=> __('New Assignment <small>(E-Mail sent to agent)</small>', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'new_assignment_subject',
					'title'		=> __('E-Mail Subject', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'new_assignment_content',
					'title'		=> __('E-mail Content', 'wpas'),
					'type' 		=> 'wysiwyg'
				),
			),
		),
		array(
			'id' 		=> 'wpas_new_reply_from_agent',
			'title' 	=> __('New Reply From Agent <small>(E-Mail sent to client)</small>', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'agent_new_reply_subject',
					'title'		=> __('E-Mail Subject', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'agent_new_reply_content',
					'title'		=> __('E-mail Content', 'wpas'),
					'type' 		=> 'wysiwyg'
				),
			),
		),
		array(
			'id' 		=> 'wpas_new_reply_from_client',
			'title' 	=> __('New Reply From Client <small>(E-Mail sent to agent)</small>', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'client_new_reply_subject',
					'title'		=> __('E-Mail Subject', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'client_new_reply_content',
					'title'		=> __('E-mail Content', 'wpas'),
					'type' 		=> 'wysiwyg'
				),
			),
		),
		array(
			'id' 		=> 'wpas_ticket_will_close',
			'title' 	=> __('Ticket Will Be Closed <small>(E-Mail sent to client)</small>', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'will_be_closed_ticket_subject',
					'title'		=> __('E-Mail Subject', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'will_be_closed_ticket_content',
					'title'		=> __('E-mail Content', 'wpas'),
					'type' 		=> 'wysiwyg'
				),
			),
		),
		array(
			'id' 		=> 'wpas_ticket_closed',
			'title' 	=> __('Ticket Closed <small>(E-Mail sent to client)</small>', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'closed_ticket_subject',
					'title'		=> __('E-Mail Subject', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'closed_ticket_content',
					'title'		=> __('E-mail Content', 'wpas'),
					'type' 		=> 'wysiwyg'
				),
			),
		),
	);

	$options = apply_filters( 'wpas_edit_email_templates_options', $options );

	return $options;
}
?>