<?php
function wpas_plugin_options() {
	$options = array(
		array(
			'id' 		=> 'wpas_general',
			'title' 	=> __('General Settings', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'default_assignee',
					'title'		=> __('Default Assignee', 'wpas'),
					'desc' 		=> __('Who to assign tickets to by default (if auto-assignment is enabled, this will only be used in case an assignment rule is incorrect).', 'wpas'),
					'type' 		=> 'assignee',
				),
				array(
					'id'		=> 'ticket_auto_assignment',
					'title'		=> __('Tickets auto-assignment', 'wpas'),
					'desc' 		=> sprintf(__('Please <a href="%s" target="_blank">read the doc</a> to understand how auto-assignment works.', 'wpas'), 'http://support.themeavenue.net/plugins/wp-awesome-support/tickets-assignment/'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'assignment_mode',
					'title'		=> __('Assignment Mode', 'wpas'),
					'desc' 		=> __('Please see help to know more about this option (<strong>Help</strong> button in the top-right corner of this screen).', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('standard' => __('Standard', 'wpas'), 'group' => __('By Group', 'wpas'))
				),
				array(
					'id'		=> 'admins_see_all',
					'title'		=> __('Admins See All Tickets', 'wpas'),
					'desc' 		=> __('Administrators can see all tickets regardless of attribution.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				
				array(
					'id'		=> 'replies_order',
					'title'		=> __('Replies Order', 'wpas'),
					'desc' 		=> __('How should the replies be ordered (based on date)?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('ASC' => 'Ascendant', 'DESC' => 'Descendant')
				),
				array(
					'id'		=> 'default_state',
					'title'		=> __('Default State For Tickets', 'wpas'),
					'desc' 		=> __('Default state to assign to newly created tickets.', 'wpas'),
					'type' 		=> 'state',
				),
				array(
					'id'		=> 'only_list_open',
					'title'		=> __('Only List Opened Tickets by Default', 'wpas'),
					'desc' 		=> __('Do you want to only see opened tickets when you list all tickets?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'reply_and_back',
					'title'		=> __('Back to List After Reply', 'wpas'),
					'desc' 		=> __('Do you want to be redirected to the tickets list after replying to one?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'use_tags',
					'title'		=> __('Use Ticket Tags', 'wpas'),
					'desc' 		=> __('Do you want your users to be able to add tags to their tickets?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'live_search',
					'title'		=> __('Enable Live Search', 'wpas'),
					'desc' 		=> __('When a client will type the ticket subject, suggestions of solutions will be displayed based on your FAQ or any other post type.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'live_search_where',
					'title'		=> __('Where to Search?', 'wpas'),
					'desc' 		=> __('Where do you want the live search to get info from?', 'wpas'),
					'type' 		=> 'list_pt'
				),
				array(
					'id'		=> 'days_old',
					'title'		=> __('Ticket Old After', 'wpas'),
					'desc' 		=> __('After how many days should the tickets be considered as old?', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'automatically_close',
					'title'		=> __('Automatically Close Old', 'wpas'),
					'desc' 		=> __('Do you want old tickets to be automatically closed?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'remider_before_closing',
					'title'		=> __('Remider Before Closing', 'wpas'),
					'desc' 		=> __('If tickets are closed automatically when old, a reminder will be sent to the client. How many days before closing should we send the reminder?', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'auto_close_exclude_state',
					'title'		=> __('Exclude State from Auto Close', 'wpas'),
					'desc' 		=> __('Sometimes you need to put a ticket on hold without closing it. Which state is it for you?', 'wpas'),
					'type' 		=> 'state',
				),
				/*array(
					'id'		=> 'pre_submission_notice',
					'title'		=> __('Pre-Submission Message', 'wpas'),
					'desc' 		=> __('Anything you type in this box will appear right above the ticket submission form.', 'wpas'),
					'type' 		=> 'textarea'
				),*/
			),
		),
		array(
			'id' 		=> 'wpas_attachments',
			'title' 	=> __('Attached Files', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'allow_file_attachment',
					'title'		=> __('Allow File Attachment', 'wpas'),
					'desc' 		=> __('Files can be attached to tickets and replies.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array( 'yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas') ),
					'class' 	=> 'n2-parentoption'
				),
				array(
					'id'		=> 'upload_script',
					'title'		=> __('Upload Script', 'wpas'),
					'desc' 		=> __('Which upload script do you want to use? If you don\'t know what this is, leave default option.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array( 'fineuploader' => __('Fineuploader', 'wpas'), 'filepicker' => __('Ink Filepicker', 'wpas') ),
					'metas' 	=> array( 'data-parentoption' => 'wpas_ticket_allow_file_attachment-yes' ),
					'class' 	=> 'n2-optionchild'
				),
				array(
					'id'		=> 'show_upload_limitations',
					'title'		=> __('Show Limitations', 'wpas'),
					'desc' 		=> __('Do you want to show the list of file types and max size allowed next to the uploader?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array( 'yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas') )
				),
				array(
					'id'		=> 'filepicker_api',
					'title'		=> __('Ink Filepicker API Key', 'wpas'),
					'desc' 		=> sprintf( __('If you need a Filepicker API key, <a href="%s" target="_blank">create an account</a>.', 'wpas'), 'https://developers.inkfilepicker.com/register/' ),
					'type' 		=> 'text',
					'metas' 	=> array( 'data-parentoption' => 'wpas_ticket_allow_file_attachment-yes' ),
					'class' 	=> 'n2-optionchild regular-text'
				),
				array(
					'id'		=> 'filepicker_secret',
					'title'		=> __('Ink Filepicker API Secret', 'wpas'),
					'desc' 		=> sprintf( __('OPTIONAL: if you want to improve security with your Filepicker account, provide your API Secret. If you don\'t have one, <a href="%s" target="_blank">enable it in your account by clicking here</a>.', 'wpas'), 'https://developers.inkfilepicker.com/apps/AsTShwc5mRhibsz0uREzqz/security/secret' ),
					'type' 		=> 'text',
					'metas' 	=> array( 'data-parentoption' => 'wpas_ticket_allow_file_attachment-yes' ),
					'class' 	=> 'n2-optionchild regular-text'
				),
				array(
					'id'		=> 'filepicker_services',
					'title'		=> __('Ink Filepicker Services', 'wpas'),
					'desc' 		=> __('Which Ink Filepicker do you want to allow?', 'wpas'),
					'type' 		=> 'checkbox',
					'opts' 		=> array(
						'BOX' 				=> 'Box',
						'COMPUTER' 			=> 'Local Uploads from My Computer',
						'DROPBOX' 			=> 'Dropbox',
						'FACEBOOK' 			=> 'Facebook',
						'GITHUB' 			=> 'Github',
						'GOOGLE_DRIVE' 		=> 'Google Drive',
						'FLCKR' 			=> 'Flickr',
						'EVERNOTE' 			=> 'Evernote',
						'GMAIL' 			=> 'Gmail',
						'INSTAGRAM' 		=> 'Instagram',
						'IMAGE_SEARCH' 		=> 'Web Image Search',
						'URL' 				=> 'Upload from URL',
						'WEBCAM' 			=> 'Webcam Photos',
						'VIDEO' 			=> 'Video recording from webcam',
						'PICASA' 			=> 'Picasa',
						'FTP' 				=> 'FTP',
						'WEBDAV' 			=> 'WebDAV',
					),
					'metas' 	=> array( 'data-parentoption' => 'wpas_ticket_allow_file_attachment-yes' ),
					'class' 	=> 'n2-optionchild'
				),
				array(
					'id'		=> 'files_number',
					'title'		=> __('Max. Attachments', 'wpas'),
					'desc' 		=> __('Maximum number of files that can be attached to a ticket.', 'wpas'),
					'type' 		=> 'text',
					'metas' 	=> array( 'data-parentoption' => 'wpas_ticket_allow_file_attachment-yes' ),
					'class' 	=> 'n2-optionchild regular-text'
				),
				array(
					'id'		=> 'files_size',
					'title'		=> __('Max. Size for Attachments', 'wpas'),
					'desc' 		=> sprintf( __('Maximum size allowed in MB for each file. <strong>Your server only allows %sB</strong>.', 'wpas'), ini_get('upload_max_filesize') ),
					'type' 		=> 'text',
					'metas' 	=> array( 'data-parentoption' => 'wpas_ticket_allow_file_attachment-yes' ),
					'class' 	=> 'n2-optionchild regular-text'
				),
				array(
					'id'		=> 'allowed_filetypes',
					'title'		=> __('Allowed Files Types', 'wpas'),
					'desc' 		=> __('Which files are allowed in the attachments? <em>(Separate the extensions by a comma)</em>', 'wpas'),
					'type' 		=> 'textarea',
					'std' 		=> 'jpg,jpeg,png,gif,pdf,doc,docx,ppt,pptx,pps,ppsx,odt,xls,xlsx',
					'metas' 	=> array( 'data-parentoption' => 'wpas_ticket_allow_file_attachment-yes' ),
					'class' 	=> 'n2-optionchild'
				),
			)
		),
		array(
			'id' 		=> 'wpas_special_pages',
			'title' 	=> __('Special Pages', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'ticket_submit',
					'title'		=> __('Ticket Submit', 'wpas'),
					'desc' 		=> __('This page will also show the registration form if registration is needed to post a ticket.', 'wpas'),
					'type' 		=> 'list_pages',
				),
				array(
					'id'		=> 'ticket_list',
					'title'		=> __('Tickets List', 'wpas'),
					'desc' 		=> __('This will only be used if you defined tickets as public.', 'wpas'),
					'type' 		=> 'list_pages',
				),
				array(
					'id'		=> 'ticket_list_on_submit',
					'title'		=> __('Show Latest Tickets on Submit Page', 'wpas'),
					'desc' 		=> sprintf( __( 'If enabled, the <code>%s</code> latest tickets will apprear next to the submit form.', 'wpas' ), wpas_get_option('number_ticket_list_on_submit')),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
					array(
					'id'		=> 'number_ticket_list_on_submit',
					'title'		=> __('Number of Latest Tickets to Show', 'wpas'),
					'desc' 		=> __('Number of latest tickets to show next to the submit form.', 'wpas'),
					'type' 		=> 'numeric',
				),
			),
		),
		array(
			'id' 		=> 'wpas_style',
			'title' 	=> __('Style', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'plugin_style',
					'title'		=> __('Plugin Stylesheets', 'wpas'),
					// 'desc' 		=> __('By checking Yes, you will disable all stylesheets.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array( 'light' => __('Light Style', 'wpas'), 'dark' => __('Dark Style', 'wpas'), 'disable' => __('Disable Styling (WYSIWYG will be disabled in front-end)', 'wpas') )
				),
				array(
					'id'		=> 'status_open_color',
					'title'		=> __('Open Status Tag Color', 'wpas'),
					'desc' 		=> __('Background color of <code>Open</code> status (will be used in front end).', 'wpas'),
					'type' 		=> 'colorpicker'
				),
				array(
					'id'		=> 'status_close_color',
					'title'		=> __('Closed Status Tag Color', 'wpas'),
					'desc' 		=> __('Background color of <code>Closed</code> status (will be used in front end).', 'wpas'),
					'type' 		=> 'colorpicker'
				),
				array(
					'id'		=> 'status_old_color',
					'title'		=> __('Old Ticket Tag Color', 'wpas'),
					'desc' 		=> __('Background color of <code>Old</code> status.', 'wpas'),
					'type' 		=> 'colorpicker'
				),
				array(
					'id'		=> 'buttons_color',
					'title'		=> __('Buttons Color', 'wpas'),
					'type' 		=> 'button_color'
				),
				array(
					'id'		=> 'buttons_class',
					'title'		=> __('Buttons Class', 'wpas'),
					'desc' 		=> __('You can replace the default button\'s class by a custom one. Default is <code>btn btn-primary</code>.', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'frontend_wysiwyg_editor',
					'title'		=> __('Use WYSIWYG Editor when User Submit Ticket?', 'wpas'),
					'desc' 		=> __('Do you want to allow your users to use the enhanced visual editor when they submit a ticket?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'gravatar_on_front',
					'title'		=> __('Use Gravatar on Front-End', 'wpas'),
					'desc' 		=> __('Do you want to use Gravatar on the front-end of your support site?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'date_position',
					'title'		=> __('Date Position', 'wpas'),
					'desc' 		=> __('Where should the date be displayed when clients read the ticket?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('right_side' => __( 'Right Side', 'wpas' ), 'under_avatar' => __( 'Under Avatar', 'wpas' ) )
				),
				array(
					'id'		=> 'extra_css',
					'title'		=> __('Extra CSS', 'wpas'),
					'desc' 		=> __('You can use custom CSS here.', 'wpas'),
					'type' 		=> 'textarea'
				),
			),
		),
		array(
			'id' 		=> 'wpas_users_permissions',
			'title' 	=> __('Users Permissions', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'ticket_can_read',
					'title'		=> __('Tickets Readability', 'wpas'),
					'desc' 		=> __('Who can read the tickets amongst your visitors?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array(
						'public' => __('Public <em>(Everyone can read)</em>', 'wpas'),
						'author' => __('Private <em>(Only ticket author can read, must log-in)</em>', 'wpas'),
						// 'token' => __('Private Secret <em>(Can be accessed with a secret link, no log-in required)</em>', 'wpas'),
						'closed' => __('Closed are Public <em>(Closed tickets can be viewed by anyone)</em>', 'wpas')
					)
				),
				array(
					'id'		=> 'ticket_can_reply',
					'title'		=> __('Tickets Reply', 'wpas'),
					'desc' 		=> __('Who can reply to tickets?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array(
						'author' => __('Ticket Author Only', 'wpas'),
						'all' 	 => __('Anybody Can Reply', 'wpas')
					)
				),
			),
		),
		array(
			'id' 		=> 'wpas_permissions',
			'title' 	=> __('Agents Permissions', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'agent_can_assign_ticket',
					'title'		=> __('Agent can re-assign a ticket', 'wpas'),
					'desc' 		=> __('One agent can re-assign his tickets to another agent.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'agent_can_close_ticket',
					'title'		=> __('Agent can close a ticket', 'wpas'),
					'desc' 		=> __('Can an agent close a ticket?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
			),
		),
		array(
			'id' 		=> 'wpas_advanced',
			'title' 	=> __('Advanced Settings', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'snapengage_code',
					'title'		=> __('Snapengage Code', 'wpas'),
					'desc' 		=> __('Insert the code given after you registered to <a href="http://www.snapengage.com/partner?ref=n2clic">Snapengage</a>.', 'wpas'),
					'type' 		=> 'textarea',
				),
				array(
					'id'		=> 'prevent_admin_access',
					'title'		=> __('Prevent Clients From Accessing the Admin', 'wpas'),
					'desc' 		=> '',
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'login_page',
					'title'		=> __('Login / Register Page', 'wpas'),
					'desc' 		=> __('If you want to use a custom page for your users to register / login, select it here.', 'wpas'),
					'type' 		=> 'list_pages',
				),
				array(
					'id'		=> 'force_cache_clear',
					'title'		=> __('Force Cache to Clear', 'wpas'),
					'desc' 		=> __('Please see help for more details about this feature.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
			),
		),
		array(
			'id' 		=> 'wpas_envato',
			'title' 	=> __('Envato Friendly', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'envato_check',
					'title'		=> __('Check Envato Purchase', 'wpas'),
					'desc' 		=> __('Do you want to enable Envato purchase verification?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'envato_api_key',
					'title'		=> __('Envato API Key', 'wpas'),
					'desc' 		=> __('Providing your Envate API key option will ask your clients to enter an Envato purchase number. The purchase will then be verified with the Envato API.', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'envato_username',
					'title'		=> __('Envato username', 'wpas'),
					'desc' 		=> __('Your Envato username is mendatory for purchase verification. Verification won\'t be activated if you don\'t provide this information.', 'wpas'),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'envato_purchase_mandatory',
					'title'		=> __('Envate Purchase Code Mandatory', 'wpas'),
					'desc' 		=> __('Can users submit a ticket if they don\'t have an Envato purchase code?', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
			),
		),
		array(
			'id' 		=> 'wpas_recaptcha',
			'title' 	=> __('reCAPTCHA', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'recaptcha_enabled',
					'title'		=> __('Enable reCAPTCHA', 'wpas'),
					'desc' 		=> __('Do you want to enable reCAPTCHA protection on registration form? This will only be enabled if you provide your public and private keys.', 'wpas'),
					'type' 		=> 'radio',
					'opts' 		=> array('yes' => __('Yes', 'wpas'), 'no' => __('No', 'wpas'))
				),
				array(
					'id'		=> 'recaptcha_public_key',
					'title'		=> __('reCAPTCHA Public Key', 'wpas'),
					'desc' 		=> sprintf( __( 'Don\'t have a key yet? <a href="%s" target="_blank">Create it here</a>.', 'wpas' ), 'https://www.google.com/recaptcha/admin/create' ),
					'type' 		=> 'text'
				),
				array(
					'id'		=> 'recaptcha_private_key',
					'title'		=> __('reCAPTCHA Private Key', 'wpas'),
					'type' 		=> 'text'
				),
			),
		),
		array(
			'id' 		=> 'wpas_terms',
			'title' 	=> __('Terms & Conditions', 'wpas'),
			'options' 	=> array(
				array(
					'id'		=> 'terms',
					'title'		=> __('Support Terms & Conditions', 'wpas'),
					'type' 		=> 'wysiwyg'
				)
			),
		),
	);

	$options = apply_filters( 'wpas_edit_plugin_options', $options );

	return $options;
}