<?php
add_shortcode( 'submit-ticket', 'wpas_register_and_submit_ticket' );
/**
 * Ticket submission
 *
 * This shortcode will check if the user is logged-in. The ticket submission form is displayed if the user is authenticated,
 * and if not, it shows the login / registration form.
 * 
 * If the user can specify another registration form in the plugin settings. If so, the user will be redirected automatically to
 * the custom registration form.
 */
function wpas_register_and_submit_ticket() {

	global $post;

	ob_start();

	/* Open main container */
	?><div class="wpas"><?php

		/* If user is not logged in we display the register form */
		if( !is_user_logged_in() ):

			/**
			 * If the form has already been submitted and has errors we display the appropriate messages
			 */
			if( isset($_SESSION['register']['errors']) ) {

				wpas_register_form( $_SESSION['register']['errors'], 'danger' );
				unset( $_SESSION['register']['errors'] );

			}

			/**
			 * Otherwise just show the naked form
			 */
			else {

				wpas_register_form();

			}

		/**
		 * If user is logged in we display the ticket submission form
		 */
		else:

			/**
			 * wpas_before_ticket_submit hook
			 *
			 * Hooked functions:
			 * 
			 * @WPAS_Tickets_Submission::notificationMessages()
			 * @WPAS_Tickets_Submission::freeNotice()
			 */
			do_action( 'wpas_before_ticket_submit' );

			wpas_submit_ticket();

			if( isset( $_SESSION['formtmp'] ) )
				unset( $_SESSION['formtmp'] );

		endif;

		/**
		 * wpas_after_ticket_submit hook
		 */
		do_action( 'wpas_after_ticket_submit' );
		
		if( wpas_get_option('ticket_list_on_submit') == 'yes' ):

			if( wpas_get_option('ticket_can_read') == 'public' || wpas_get_option('ticket_display_status') == 'closed' ): ?>

				<h2><?php _e('Latest Tickets', 'wpas'); ?></h2>

				<?php wpas_list_tickets( array('tickets' => wpas_get_option('number_ticket_list_on_submit', 5)) );

			endif;
		endif; ?>

	</div>

	<?php
	$sc = ob_get_contents();
	ob_end_clean();
	return $sc;
}

/**
 * Get registration / login form
 *
 * The function checks if the standard registration form is
 * needed of if the user setup a custom registration page.
 * Then we load the form template.
 * 
 * @param  (string) $msg Message to display before the form
 * @param  (string) $type Type of info box to use (bootstrap class)
 * @since 1.0.0
 */
function wpas_register_form( $msg = false, $type = 'info' ) {

	/**
	 * wpas_before_registration_form hook
	 *
	 * @WPAS_Tickets_Submission::addCaptchaScript()
	 */
	do_action( 'wpas_before_registration_form' );

	/* First we check if a custom page has been set as the register page */
	$login_page = wpas_get_option( 'login_page' );

	/* We check if a special page has been set */
	if( $login_page && is_numeric( $login_page ) ) {

		/* Prepare the redirect URL */
		$redirect = get_permalink( $login_page );

		/* Redirect the user */
		if( !headers_sent() ) {

			wp_redirect( $redirect, $status = 302 );
			exit;

		} else {

			echo '<meta http-equiv="refresh" content="0;URL='.$redirect.'"> ';

			/* We stop the execution */
			exit;
		}
	}

	/* Filter the message displayed before the form */
	if( !$msg )
		$msg = apply_filters( 'wpas_need_login', __( 'Please <strong>login or register</strong> to create a new tickets or view all public tickets.', 'wpas' ) );

	/**
	 * Show the registration form
	 */
	wpas_get_template_part( 'part', 'registration-form', array( 'msg' => $msg, 'type' => $type ) );
	
	/**
	 * wpas_after_registration_form hook
	 */
	do_action( 'wpas_after_registration_form' );
}

/**
 * Show ticket submission form
 *
 * Echoes the full markup for ticket submission, including notifications and license verification
 * 
 * @since 1.0.0
 */
function wpas_submit_ticket() {

	/**
	 * wpas_before_ticket_submission_form hook
	 */
	do_action( 'wpas_before_ticket_submission_form' );

	/**
	 * Show the actual submission form
	 */
	wpas_get_template_part( 'part', 'submission-form' );

	/**
	 * wpas_after_ticket_submission_form hook
	 */
	do_action( 'wpas_after_ticket_submission_form' );
}
?>