<?php
/**
 * This is a built-in template file. If you need to customize it, please,
 * DO NOT modify this file directly. Instead, copy it to your theme's directory
 * and then modify the code. If you modify this file directly, your changes
 * will be overwritten during next update of the plugin.
 */

/* Exit if accessed directly */
if( !defined( 'ABSPATH' ) )
	exit;

/* IMPORTANT: make the $post var global as it is used in this template */
global $post;

/**
 * wpas_before_original_post hook
 */
do_action( 'wpas_before_original_post' ); ?>

<table id="original_ticket" class="table wpas-ticket-responses">
	<thead class="sr-only">
		<tr>
			<td>Profile</td>
			<td>Reply</td>
		</tr>
	</thead>
	<tbody>
		<tr class="wpas_role wpas_client">
			<td class="tbl_col1">
				<div class="ticket_profile">

					<?php
					/**
					 * If the plugin is set to show Gravatars, we use a 96px Gravatar with the mistery man as a fallback
					 */
					if( wpas_get_option('gravatar_on_front', 'yes') == 'yes' )
						echo get_avatar( $post->post_author, '96', 'mm' );
					?>

					<div>

						<?php
						/**
						 * Display the ticket's author name (client's name)
						 */
						?><span class="wpas-profilename"><?php echo get_the_author(); ?></span> 

						<span class="wpas-profiletype"><?php _e( 'Client', 'wpas' ); ?></span> 

						<time class="visible-xs wpas-timestamp" datetime="<?php echo str_replace( ' ', 'T', $post->post_date ); ?>Z"><?php printf(__('%s ago', 'wpas'), human_time_diff( get_the_time('U', $post->ID), current_time('timestamp') )); ?></time>

					</div>	
				</div>
			</td>

			<td class="tbl_col2" <?php if( wpas_get_option('date_position', 'right_side') == 'under_avatar' ): ?>colspan="2"<?php endif; ?>>
				<?php
				/**
				 * Display the original ticket's content
				 */
				the_content();

				/**
				 * If any files attached we display them in an unordered list
				 * @var [type]
				 */
				if( ( $attachments = get_post_meta( $post->ID, WPAS_PREFIX . 'attachments', true ) ) != '' && is_array( $attachments ) ) {

					echo '<div class="attachments"><strong><span aria-hidden="true" class="glyphicon glyphicon-paperclip"></span> '.__('Attached files', 'wpas').':</strong><ul>';

					wpas_get_uploaded_files( $post->ID );

					echo '</ul></div>';
				}
				?>
			</td>

		</tr>
	</tbody>
</table>

<?php
/**
 * Hook after the original post table
 */
do_action( 'wpas_after_original_post' );