<?php
/**
 * This is a built-in template file. If you need to customize it, please,
 * DO NOT modify this file directly. Instead, copy it to your theme's directory
 * and then modify the code. If you modify this file directly, your changes
 * will be overwritten during next update of the plugin.
 */

/**
 * Make the post data and the pre-form message global
 */
global $post, $wpas_notification;

$submit = get_permalink( wpas_get_option( 'ticket_list' ) );

/**
 * If there is a message to display we show a bootstrap info box
 */
if( $param['msg'] && $param['type'] ):

	$wpas_notification->notification( $param['type'], $param['msg'] );

endif;

$redirect_to = get_permalink( $post->ID );
?>

<div id="wpas_account_forms" class="wpas_clearfix">
	<div class="half">
		<form method="post" role="form" action="<?php echo wp_login_url(); ?>">
			<fieldset>
				<legend>ورود</legend>
				<div class="form-group">
					<input type="text" name="log" class="form-control" placeholder="<?php _e('Username'); ?>" required>
				</div>
				<div class="form-group">
					<input type="password" name="pwd" class="form-control" placeholder="<?php _e('Password'); ?>" required>
				</div>

				<?php
				/**
				 * wpas_after_login_fields hook
				 */
				do_action( 'wpas_after_login_fields' );
				?>

				<div class="form-group">
					<input type="hidden" name="redirect_to" value="<?php echo $redirect_to; ?>">
					<button type="submit" class="<?php echo wpas_get_option('buttons_class', 'btn btn-primary'); ?>">وارد شوید</button>
				</div>
			</fieldset>
		</form>
	</div>
	<div class="half">
		<form method="post" action="<?php echo get_permalink( $post->ID ); ?>">
			<fieldset>
				<legend><?php _e('Register'); ?></legend>
				<div class="form-group">
					<input class="form-control" type="email" placeholder="<?php _e( 'Email' ); ?>" name="email" required>
				</div>
				<div class="form-group">
					<input class="form-control" type="text" placeholder="<?php _e( 'Username' ); ?>" name="username" pattern="[a-zA-Z0-9]+" required>
				</div>
				<div class="form-group">
					<input class="form-control wpas-pwd" type="password" placeholder="<?php _e('Enter a password', 'wpas'); ?>" id="password" name="pwd" required>
				</div>
				<div class="form-group">
					<input class="form-control wpas-checkpwd" type="password" placeholder="<?php _e('Re-enter password', 'wpas'); ?>" id="passwordconf" name="pwd-validate" data-validation="<?php _e('The two passwords must match.', 'wpas'); ?>" required>
				</div>

				<?php
				/**
				 * wpas_after_registration_fields hook
				 * 
				 * @WPAS_Tickets_Submission::addCaptcha()
				 */
				do_action( 'wpas_after_registration_fields' );
				?>

				<div class="form-actions">
					<?php if( wpas_get_option('terms', false) ): ?>
						<label class="checkbox"><input type="checkbox" name="terms" required> <?php printf(__('I accept the %sterms and conditions%s', 'wpas'), '<a href="#wpas-modalterms" class="wpas-modal-trigger">', '</a>' ); ?></label>
					<?php endif; ?>
					<?php wp_nonce_field( 'register', 'user_registration', false, true ); ?>
					<input type="hidden" name="wpas_registration" value="true">
					<button type="submit" class="<?php echo wpas_get_option('buttons_class', 'btn btn-primary'); ?>"><?php _e('Create Account', 'wpas'); ?></button>
				</div>
			</fieldset>
		</form>
	</div>
</div>