<?php
/**
 * This is a built-in template file. If you need to customize it, please,
 * DO NOT modify this file directly. Instead, copy it to your theme's directory
 * and then modify the code. If you modify this file directly, your changes
 * will be overwritten during next update of the plugin.
 */

/**
 * We check if the user is authorized to submit a ticket.
 * User must be logged-in and can't have the capability. If the
 * user isn't authorized to submit, we return the error message hereafter.
 *
 * Basically, admins and agents aren't allowed to submit a ticket as they
 * need ot do it in the back-end.
 *
 * If you want to allow admins and agents to submit tickets through the
 * front-end, just comment the following line...
 */
if( is_user_logged_in() && current_user_can( 'edit_ticket' ) ):

/**
 * And uncomment the following one.
 */
// if( !is_user_logged_in() ):

/**
 * Please make sure one of the two lines above is uncommented at all times, otherwise
 * the site will break.
 * 
 * Also, keep in mind that if you allow agents to open ticket through the front-end, actions
 * will not be tracked.
 */

	global $wpas_notification;

	$wpas_notification->notification( 'info', apply_filters( 'admins_cannot_submit', sprintf( __( 'Sorry, support team members cannot submit tickets from here. If you need to open a ticket, please go to your admin panel or <a href="%s">click here to open a new ticket</a>.', 'wpas' ), admin_url( 'post-new.php?post_type=tickets' ) ) ) );

/**
 * If the user is authorized to post a ticket, we display the submit form
 */
else:

	global $post, $wpas_submit, $wpas;

	$envato 	= wpas_get_option('envato_check');
	$envato_must= wpas_get_option('envato_purchase_mandatory');
	$envato_api = wpas_get_option('envato_api_key');
	$envato_usr = wpas_get_option('envato_username');

	/**
	 * Ticket properties columns
	 *
	 * Defines the number of columns used to display the ticket properties (type, priority).
	 * Change this number if you want to have a different number of columns.
	 */
	$cols = 2;
	?>

	<form role="form" method="post" action="<?php echo get_permalink( $post->ID ); ?>" id="wpas-new-ticket">
		<fieldset>
			<legend><?php _e( 'Ticket Properties', 'wpas' ); ?></legend>

			<?php
			/**
			 * We get all the taxonomies which should be displayed on the submit form,
			 * including user custom taxonomies and then display them in the "Ticket Properties" section
			 */
			$columns = $wpas_submit->getFrontEndTaxonomies();
			
			/* Start a counter for the "row" div */
			$count = 1;

			foreach( $columns as $taxo => $tax ) {

				/* Start a new line */
				if( 1 == $count )
					echo '<div class="row">'; ?>

				<div class="col-lg-6">

					<div class="form-group <?php if( isset( $_SESSION['formtmp']['incorrect'] ) && in_array( "ticket_$taxo", $_SESSION['formtmp']['incorrect'] ) ) { echo 'has-error'; } ?>">

						<label for="ticket_<?php echo $taxo; ?>"><?php echo ucwords( sanitize_title( $tax['label'] ) ); ?></label>

						<select name="ticket_<?php echo $taxo; ?>" id="ticket_<?php echo $taxo; ?>" class="form-control" <?php if( $tax['required'] ) { echo 'required'; } ?>>

							<option value="" selected="selected" disabled=""><?php _e( 'Please Select', 'wpas' ); ?></option>

							<?php
							/* Get the terms for this taxonomy including "empty" terms */
							$terms = get_terms( $taxo, array('hide_empty' => 0) );

							/* Iterate through the terms and add an option for each */
							foreach( $terms as $term ) {

								if( isset( $_SESSION['formtmp']["ticket_$taxo"] ) && $_SESSION['formtmp']["ticket_$taxo"] == $term->slug || count( $terms ) == 1 ) {
									$selected = 'selected="selected"';
								} else {
									$selected = '';
								}

								?><option value="<?php echo $term->slug; ?>" <?php echo $selected; ?>><?php echo $term->name; ?></option><?php
							}
							?>

						</select>
					</div>

				</div>
				
				<?php
				/* Close the row after 2 items has been displayed */
				if( $cols == $count ) {
					echo '</div>';
					$count = 1;
				} else {
					$count++;
				}

			}

			/**
			 * Now we process custom text fields
			 */
			$cf = $wpas->getCustomFields();
			$count = 1;

			foreach( $cf as $key => $field ) {

				$class = array( 'form-control' );

				if( isset( $field['class'] ) )
					array_push( $class, $field['class'] );

				$class = implode( ' ', $class );

				/* Start a new line */
				if( 1 == $count )
					echo '<div class="row">'; ?>

				<div class="col-lg-6">

					<div class="form-group <?php if( isset( $_SESSION['formtmp']['incorrect'] ) && in_array( "ticket_$taxo", $_SESSION['formtmp']['incorrect'] ) ) { echo 'has-error'; } ?>">

						<?php
						if( isset( $field['callback'] ) && function_exists( $field['callback'] ) ):

							if( isset( $field['class'] ) )
								$field['class'] =  implode( ' ', array( 'form-control', $field['class'] ) );

							else
								$field['class'] = 'form-control';

							$field['callback']( $field );

						else: ?>

							<label for="ticket_<?php echo $field['id']; ?>"><?php echo $field['label']; ?></label>

							<input type="text" name="<?php echo $field['name']; ?>" id="ticket_<?php echo $field['id']; ?>" value="<?php echo $wpas_submit->populate_fields_values( $field['name'] ); ?>" class="<?php echo $class; ?>" <?php if( isset( $field['required'] ) ): ?>required<?php endif; ?>>

						<?php endif; ?>

					</div>

				</div>
				
				<?php
				/* Close the row after 2 items has been displayed */
				if( $cols == $count ) {
					echo '</div>';
					$count = 1;
				} else {
					$count++;
				}

			}
			?>
			
		</fieldset>

		<?php
		/**
		 * If the Envato verification is enabled
		 * we check all the required information,
		 * then display the licence field.
		 */
		if( $envato_usr && $envato_api && $envato == 'yes' ): ?>

			<fieldset>
				<legend><?php _e('Envato Purchase', 'wpas'); ?></legend>
				<div class="form-group">
					<label for="wpas-envato-purchase"><?php _e('Envato Purchase Code', 'wpas'); ?></label>
					<input id="wpas-envato-purchase" name="envato_purchase" type="text" class="form-control" <?php if( $envato_must == 'yes' ): ?>required<?php endif; ?> <?php if( isset($_SESSION['formtmp']['envato_purchase']) ): ?>value="<?php echo $_SESSION['formtmp']['envato_purchase']; ?>"<?php endif; ?>>
					<p class="help-block"><?php printf( __('To find your Envato purchase code, %sclick here%s', 'wpas'), '<a href="#wpas-modalenvato" class="wpas-modal-trigger" tabindex="-1">', '</a>' ); ?>.</p>
				</div>				
			</fieldset>

		<?php endif; ?>

		<fieldset>
			<legend><?php _e('Basic Information', 'wpas'); ?></legend>
			<div class="form-group <?php if( isset( $_SESSION['formtmp']['incorrect'] ) && in_array( 'ticket_subject', $_SESSION['formtmp']['incorrect'] ) ) { echo 'has-error'; } ?>">
				<label for="ticket_subject"><?php _e('Subject', 'wpas'); ?></label>
				<input id="ticket_subject" name="ticket_subject" type="text" class="form-control" minlength="10" maxlength="60" pattern=".{10,50}" placeholder="<?php _e('Subject must be 10 to 50 characters', 'wpas'); ?>" required <?php if( isset($_SESSION['formtmp']['ticket_subject']) ): ?>value="<?php echo $_SESSION['formtmp']['ticket_subject']; ?>"<?php endif; ?>>
			</div>
			<div class="form-group <?php if( isset( $_SESSION['formtmp']['incorrect'] ) && ( in_array( 'ticket_issue', $_SESSION['formtmp']['incorrect'] ) || in_array( 'ticket_issue_simple', $_SESSION['formtmp']['incorrect'] ) ) ) { echo 'has-error'; } ?>">
				<label for="ticket_issue"><?php _e('Description', 'wpas'); ?></label>
				<?php
				if( isset($_SESSION['formtmp']['ticket_issue']) ):
					$desc = $_SESSION['formtmp']['ticket_issue'];
				else:
					$desc = '';
				endif;

				/* Use WYSIWYG if enabled and style hasn't been disabled */
				if( wpas_get_option( 'frontend_wysiwyg_editor' ) == 'yes' && 'disable' != wpas_get_option( 'plugin_style' ) ): ?>

					<textarea class="form-control wpas-wysiwyg" id="wpas-ticket-issue" name="ticket_issue" placeholder="<?php _e( 'Describe your problem as accurately as possible.', 'wpas' ); ?>" rows="10"><?php echo $desc; ?></textarea>

					<textarea class="form-control wpas-textarea" id="wpas-ticket-issue-mobile" name="ticket_issue_simple" placeholder="<?php _e( 'Describe your problem as accurately as possible.', 'wpas' ); ?>" rows="6"><?php echo $desc; ?></textarea>

				<?php
				/* Otherwise we just use a simple textarea */
				else: ?>

					<textarea id="wpas-ticket-issue-simple" name="ticket_issue" class="form-control wpas-textarea" placeholder="<?php _e( 'Describe your problem as accurately as possible.', 'wpas' ); ?>" rows="6" rows="10"><?php echo $desc; ?></textarea>

				<?php endif; ?>
			</div>
			
			<?php if( wpas_get_option('use_tags', 'no') == 'yes' ): ?>

				<div class="form-group">
					<label class="sr-only"><?php _e('Tags', 'wpas'); ?></label>
					<input type="text" name="tags" placeholder="<?php _e('Tags', 'wpas'); ?>" class="tm-input form-control" <?php if( isset($_SESSION['formtmp']['tags']) ): ?>value="<?php echo $_SESSION['formtmp']['tags']; ?>"<?php endif; ?> />
					<p class="help-block"><?php _e('Tags separated by a comma', 'wpas'); ?></p>
				</div>

			<?php endif; ?>
		</fieldset>
		<?php
		/**
		 * If file upload is allowed on front-end
		 * we display the upload field.
		 */
		if( wpas_can_attach_files() ): ?>

			<fieldset id="wpas_ticketattach">
				<legend><?php _e('Attach a File', 'wpas'); ?></legend>
				<?php wpas_file_uploader(); ?>
			</fieldset>

		<?php endif; ?>

		<fieldset>
			<?php wp_nonce_field( 'submit', 'submit_ticket', false, true ); ?>
			<button type="submit" class="<?php echo wpas_get_option('buttons_class', 'btn btn-primary'); ?>"><?php _e('Create Ticket', 'wpas'); ?></button>
		</fieldset>
	</form>

<?php endif;