<?php
/**
 * Make sure we're in the uninstallation process
 */
if( defined( 'WP_UNINSTALL_PLUGIN' ) ) {
       
	/**
	 * If multisite install, we loop on each blog
	 */
	function wpas_uninstall_plugin() {

		if( function_exists( 'is_multisite' ) && is_multisite() ) {

			global $wpdb, $current_site;

			/* Let's get all the blogs IDs */
			$site_blog_ids = $wpdb->get_results( $wpdb->prepare( "SELECT blog_id FROM $wpdb->blogs WHERE archived = '0' AND spam = '0' AND deleted = '0'" ) );

			/* Loop through all the blogs to delete the data */
			foreach( $site_blog_ids as $blog ) {

				/* Switch to a different blog */
				switch_to_blog( $blog->blog_id );

				/* Delete the data */
				wpas_remove_data();
			}

		} else {

			/* Simply delete the data once */
			wpas_remove_data();

		}

		/* Detete attachments */
		wpas_empty_attachments();

	}

	/**
	 * Main uninstall function that calls each action
	 */
	function wpas_remove_data() {

		/* Remove pages */
		wpas_delete_special_pages();
		
		/* Delete the plugin data */
		delete_option( WPAS_PREFIX . 'rated' );
		delete_option( WPAS_PREFIX . 'first_setup_date' );
		delete_option( WPAS_PREFIX . 'latest_setup_date' );
		delete_option( WPAS_PREFIX . 'version' );
		delete_option( WPAS_PREFIX . 'plugin_options' );
		delete_option( WPAS_PREFIX . 'email_options' );
		delete_option( 'wpas_setup_status' );

		/* Remove the roles */
		remove_role( 'wpas_manager' );
		remove_role( 'wpas_support_manager' );
		remove_role( 'wpas_agent' );

		/* Delete the terms and taxonomies */
		wpas_deactivate_custom_taxes();

		/* Delete all posts */
		wpas_remove_all_posts();
	}

	/**
	 * Delete plugin related pages
	 *
	 * @since 2.0.6
	 */
	function wpas_delete_special_pages() {

		$options = get_option( WPAS_PREFIX . 'plugin_options', false );
		$list    = $options['ticket_submit'];
		$submit  = $options['ticket_list'];

		wp_delete_post( intval( $list ), true );
		wp_delete_post( intval( $submit ), true );
	}

	/**
	 * Remove all posts created by the plugin
	 */
	function wpas_remove_all_posts() {

		$history = new WP_Query( array(
			'posts_per_page'	=>	-1,
			'post_type'			=>	array( 'ticket_history', 'ticket_reply', 'ticket_status', 'ticket_note', 'tickets' )
			)
		);

		if( !empty( $history->posts ) ) {

			foreach( $history->posts as $post ) {

				wp_delete_post( $post->ID, true );

			}

		}

	}

	/**
	 * Remove plugin custom taxonomies
	 */
	function wpas_deactivate_custom_taxes() {
		wpas_remove_taxonomy( 'status' );
		wpas_remove_taxonomy( 'type' );
		wpas_remove_taxonomy( 'priority' );
		wpas_remove_taxonomy( 'state' );
	}

	/**
	 * Delete taxonomies terms
	 */
	function wpas_remove_taxonomy( $taxonomy ) {

		if( !$taxonomy->_builtin ) {

			global $wp_taxonomies;

			$terms = get_terms( $taxonomy ); 

			foreach( $terms as $term ) {

				wp_delete_term( $term->term_id, $taxonomy );
			}

			unset( $wp_taxonomies[$taxonomy] );
		}
	}

	/**
	 * Delete attachment folder 
	 *
	 * If the user used Fineuploader we delete
	 * the folder where all attachments were saved.
	 */
	function wpas_empty_attachments() {

		$dirPath = ABSPATH . 'wp-content/uploads/wpas_attachments/';

		if ( is_dir($dirPath) ) {
			if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
				$dirPath .= '/';
			}

			$files = glob($dirPath . '*', GLOB_MARK);

			foreach ($files as $file) {
				if (is_dir($file)) {
					self::deleteDir($file);
				} else {
					unlink($file);
				}
			}
			
			rmdir($dirPath);
		}
	}

}