<?php

/**
* Plugin Name: BWL Knowledge Base Manager
* Plugin URI: http://persianscript.ir
* Description: Knowledge Base Manager plugin comes with lots of unique and flexible features to create unlimited number of Knowledge Base question and answers for your website content. Sticky and shortcode base Ajax search options give your user best experiences to find there required asnwers. It has an awesome shortcode editor that provide you all kinds of options to insert shortcode in tinymce editor. Built-in widgets display latest/top up voted/top down voted/popular knowledge base in sidebar area.
* Author: پرشین اسکریپت
* Version: 1.1.9
* Author URI: http://persianscript.ir
* WP Requires at least: 3.6+
* Text Domain: bwl-kb
*/

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

if ( ! class_exists( 'BWL_KB_Manager' ) ) {

    Class BWL_KB_Manager{

        function __construct() {

            //Include For Multisite Network Checking
            //@Introduced In Version 1.1.1

            include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

            GLOBAL $bkb_data;
            
//            delete_option('bkb_options');

            $bkb_data = get_option('bkb_options');

             /*------------------------------ PLUGIN COMMON CONSTANTS ---------------------------------*/
            define( "BWL_KB_PLUGIN_TITLE", 'BWL Knowledge Base Manager');
            define( 'BWL_KB_BASE_FILE', dirname( __FILE__ ) );
            define( "BWL_KB_PLUGIN_DIR", plugins_url() .'/bwl-kb-manager/' );
            define( "BWL_KB_PLUGIN_VERSION", '1.1.9');
            define( "BWL_KB_PLUGIN_PRODUCTION_STATUS", 1);
            define( "PREFIX_BKB_CAT", 'bkb_cat_'); // Required for custom sorting addon.
            define( "PREFIX_BKB_TAG", 'bkb_tag_'); // Required for custom sorting addon.
            $this->register_post_type();
            $this->taxonomies();     
            $this->included_files();
            $this->bkb_version_manager(BWL_KB_PLUGIN_VERSION);
            $this->bkb_cau();
            $this->bkb_flash_rules(); // Added in version 1.1.3
            $this->bkb_update_plugins_data();
            
            //@Description: Check Stylesheet location. 
            //Plugin users can easily copy bkbm-custom-styles.css file from plugin css directory and paste in to theme folder css directoty.
            //Then easiliy add custom rules in there.
            //@Since: 1.1.9
            
            $bkbm_theme_css_file_dir = get_template_directory_uri() . '/css/bkbm-custom-styles.css';
          
            $bkbm_plugin_css_file_dir = plugins_url('css/bkbm-custom-styles.css', __FILE__);
            
            $bkbm_css_located = locate_template( 'css/bkbm-custom-styles.css' );
            
             if (!empty( $bkbm_css_located )) {
                // 'home.php' found in Theme, do something
                 
                 $bkbm_plugin_css_file_dir = $bkbm_theme_css_file_dir;
            }


            define('BKBM_PLUGIN_CSS_FILE', $bkbm_plugin_css_file_dir);
            
            add_filter( 'request', array( $this, 'bkb_fix_single_kb_permalink'), 1 );
            
            //@Description: Load Only Admin Scripts.
            //@Since: 1.0.9
            
            add_action( 'wp_enqueue_scripts', array( &$this, 'bkb_enqueue_scripts' )  );
            add_action( 'the_posts', array( &$this, 'bkb_check_for_shortcode' )  );
            
            //@Description: Load Only Admin Scripts.
            //@Since: 1.0.9
            add_action('admin_enqueue_scripts', array( $this, 'bkbm_admin_load_scripts' ));
            
            if( ! class_exists( 'CPTP' ) ) {
                add_action('admin_notices', array( $this, 'bkbm_cptp_recom_admin_notice' ) );
                add_action('admin_init', array( $this, 'bkbm_cptp_recom_ignore_admin_notice' ) );
            }
            

            // Introduced in version 1.0.9
            add_filter( 'pre_get_posts', array( $this, 'bkbm_taxonomy_filters' ) );
            
        }
        
        /* Display a notice that can be dismissed */

        function bkbm_cptp_recom_admin_notice() {
            
            global $current_user;
            $user_id = $current_user->ID;

            $location = $_SERVER['HTTP_REFERER'];

            /* Check that the user hasn't already clicked to ignore the message */
            if (!get_user_meta($user_id, 'bkbm_cptp_recom_notice')) {
                echo '<div class="notice notice-info"><p>';
                printf(__('<b>Recommendation: </b>For SEO friendly permalink structure for <strong>BWL Knowledge Base Manager</strong>, we recommend to install and activate <b><a href="https://wordpress.org/plugins/custom-post-type-permalinks/" target="_blank">Custom Post Type Permalinks</a></b> plugin.  <a href="%1$s"  class="page-title-action" style="position: relative; top: 1px;"><strong>No Thanks</strong></a>'), '?bkbm_cptp_recom_ignore_admin_notice=0&location=' . $location);
                echo "</p></div>";
            }
        }

        function bkbm_cptp_recom_ignore_admin_notice() {
            global $current_user;
            $user_id = $current_user->ID;
            /* If user clicks to ignore the notice, add that to their user meta */
            if (isset($_GET['bkbm_cptp_recom_ignore_admin_notice']) && '0' == $_GET['bkbm_cptp_recom_ignore_admin_notice']) {
                add_user_meta($user_id, 'bkbm_cptp_recom_notice', 'true', true);
                wp_safe_redirect($_GET['location']);
                exit();
            }
        }


        // Fix Author Issue in version 1.1.5
        // Update author data in version 1.1.5
        
        function bkb_update_plugins_data() {

            if ( BWL_KB_PLUGIN_VERSION == '1.1.5' ) {

                $bkb_1_1_5_update_status = get_option('bkb_1_1_5_update_status');
//            delete_option('bkb_1_1_5_update_status');
//            echo $bkb_1_1_5_update_status;

                if ( $bkb_1_1_5_update_status != 1 ) {

                    $args = array(
                        'post_status' => 'publish',
                        'post_type' => 'bwl_kb',
                        'posts_per_page' => '-1'
                    );

                    $loop = new WP_Query($args);

                    if ($loop->have_posts()) :

                        while ($loop->have_posts()) :

                            $loop->the_post();

                            $post_ID = get_the_ID();

                            $bkb_authors = get_post_meta($post_ID, "bkb_authors", true);

                            $bkb_author_id = ( $bkb_authors == "" ) ? 1 : $bkb_authors;

                            $arg = array(
                                'ID' => $post_ID,
                                'post_type' => 'bwl_kb',
                                'post_author' => $bkb_author_id,
                            );

                            wp_update_post($arg);

                        endwhile;

                    endif;

                    wp_reset_query();

                    update_option('bkb_1_1_5_update_status', 1);
                    
                }
                
            }
            
        }

        function bkb_flash_rules() {
            
            global $bkb_data;
            
            $bkb_flash_rules_status = get_option('bkb_flash_rules_status');

            if( $bkb_flash_rules_status != 1 ) {
                
                flush_rewrite_rules();
                update_option('bkb_flash_rules_status', 1 );

            }
            
            
            // Matching Old Slug & New Slug Value.
            // First we get data from plugin option panel.
            
            $bkb_custom_slug = "bwl-knowledge-base"; 

            if( isset($bkb_data['bkb_custom_slug']) && $bkb_data['bkb_custom_slug'] != "" ) {

                $bkb_custom_slug = trim( $bkb_data['bkb_custom_slug'] ); 

            }
            
            $bkb_old_custom_slug = get_option('bkb_old_custom_slug');

            if( $bkb_old_custom_slug == "" ) {
                
                update_option('bkb_old_custom_slug', $bkb_custom_slug );

            }

            
            if ( $bkb_custom_slug != $bkb_old_custom_slug ) {
                flush_rewrite_rules();
                update_option('bkb_old_custom_slug', $bkb_custom_slug );
            }
            
            
        }
        
        // @Description: Fix Single KB permalink Issue.
        //@Since: Version 1.1.9

        function bkb_fix_single_kb_permalink($query_vars) {

            if (isset($query_vars['bwl_kb'])) {


                $old_slug = explode('/', $query_vars['bwl_kb']);

                $query_vars['bwl_kb'] = $old_slug[count($old_slug) - 1];
            }

            return $query_vars;
        }

        // @Description: Store Plugin Version in Database
        // @Since: version 1.0.1

        function bkb_version_manager( $latest_version ) {

            $current_version = get_option('bwl_kb_plugin_version');

            if( $current_version == "" ) {

                update_option('bwl_kb_plugin_version', $latest_version);

            } elseif( $current_version != $latest_version ) {

                update_option('bwl_kb_plugin_version', $latest_version);

            } else {
                // Do nothing!
            }


        }

        // @Description: Plugin required PHP files.
        // @Since: version 1.0.1

        function included_files() {

            include_once dirname(__FILE__) . '/includes/bkb-helpers.php'; 
            include_once dirname(__FILE__) . '/includes/bkb-ajax-search.php'; 
            include_once dirname(__FILE__) . '/includes/bkb-single-post-functions.php'; 
            include_once dirname(__FILE__) . '/shortcode/bkb-shortcodes.php';       
            include_once dirname(__FILE__) . '/shortcode/bkb-tabify-shortcode.php';
            include_once dirname(__FILE__) . '/shortcode/bkb-shortcode-kb-question-submit-form.php';
            include_once dirname(__FILE__) . '/includes/bkb-vote-counter.php';  
            include_once dirname(__FILE__) . '/includes/bkb-custom-theme.php';
            include_once dirname(__FILE__) . '/includes/custom-tax-class/bkb-custom-taxnomy.php'; 
            include_once dirname(__FILE__) . '/includes/custom-tax-class/bkb-tax-custom-column.php'; 
           
           //Toc Support.
           //@Since: Version 1.1.3
           
//            include_once dirname(__FILE__) . '/includes/bkb-toc.php'; 

           // Custom KB Sorting.
           // @Since: version 1.1.2
           // @Date: 21-03-16

           include_once dirname(__FILE__) . '/includes/bkb-sorting/bkb_sorting.php'; 

            if( is_admin() ) {

                // we removed CMB from version 1.1.2

                include_once dirname(__FILE__) . '/includes/bkb-custom-column.php';  
                include_once dirname(__FILE__) . '/includes/bkb-custom-meta-box.php';
                include_once dirname(__FILE__) . '/includes/bkb-quick-edit.php';
                include_once dirname(__FILE__) . '/includes/bkb-admin-column-filter.php'; 
                include_once dirname(__FILE__) . '/tinymce/bkb-tiny-mce-config.php';
                include_once dirname(__FILE__) . '/option-panel/plugin-option-panel-menu.php';  
                include_once dirname(__FILE__) . '/option-panel/plugin-option-panel-settings.php';
                include_once dirname(__FILE__) . '/option-panel/bkb-addon-settings.php';

            }

        }

        // @Description: Plugin new version update notification.
        // @Since: version 1.0.1

        public function bkb_cau(){

            global $bkb_data;

            if( isset( $bkb_data['bkb_auto_update_status'] ) && $bkb_data['bkb_auto_update_status'] == 1 && is_admin()) {

               include_once dirname(__FILE__) . '/includes/bkb-update-notifier.php'; 

            }


        }

        // @Description: Load Plugin Front-end Required Custom JS & CSS Files.
        // @Since: version 1.0.0

        function bkb_enqueue_scripts() {

            global $bkb_data;

            /* ------------------------------ Add Custom Styles --------------------------------- */

            if (!isset($bkb_data['bkb_fontawesome_status']) || $bkb_data['bkb_fontawesome_status'] == 1) {
                
                wp_enqueue_style('bkb-font-awesome-styles', plugins_url('css/font-awesome.min.css', __FILE__), array(), BWL_KB_PLUGIN_VERSION);
                
            }
             

            // Load Plugin Custom Style.
            // Fixed in version 1.1.2
            
            if ( !isset( $bkb_data['bkb_display_sticky_button'] ) || $bkb_data['bkb_display_sticky_button'] != "" ) {

                wp_enqueue_style('bkbm-remodal-styles', plugins_url('css/remodal.css', __FILE__), array(), BWL_KB_PLUGIN_VERSION);
                wp_enqueue_style('bkbm-remodal-theme-styles', plugins_url('css/remodal-default-theme.css', __FILE__), array(), BWL_KB_PLUGIN_VERSION);
                wp_enqueue_style('bkbm-custom-styles', BKBM_PLUGIN_CSS_FILE, array(), BWL_KB_PLUGIN_VERSION);
                
            }


            if (isset($bkb_data['bkb_rtrl_support']) && $bkb_data['bkb_rtrl_support'] == 1) {
                
                wp_enqueue_style('bkbm-rtl-styles', plugins_url('css/bkbm-rtl-styles.css', __FILE__), array(), BWL_KB_PLUGIN_VERSION);
                
            }

            /* ----------------------------- Add Custom JavaScripts ---------------------------------- */

           
            wp_register_script('bkb-toc-script', plugins_url('js/jquery.toc.js', __FILE__), array('jquery', 'bkb-custom-script'), BWL_KB_PLUGIN_VERSION, TRUE);
            wp_register_script('bkb-accordion-script', plugins_url('js/smk-accordion.min.js', __FILE__), array('jquery', 'bkb-custom-script'), BWL_KB_PLUGIN_VERSION, TRUE);
            wp_register_script('bkb-remodal-script', plugins_url('js/jquery.remodal.js', __FILE__), array('jquery', 'bkb-custom-script'), BWL_KB_PLUGIN_VERSION, TRUE);
            wp_register_script('bkb-tipsy-script', plugins_url('js/jquery.tipsy.js', __FILE__), array('jquery', 'bkb-custom-script'), BWL_KB_PLUGIN_VERSION, TRUE);
            wp_register_script('bkb-custom-search-script', plugins_url('js/custom-search-scripts.js', __FILE__), array('jquery', 'bkb-custom-script'), BWL_KB_PLUGIN_VERSION, TRUE);
            wp_register_script('bkb-tabify-script', plugins_url('js/bkb-tabify.js', __FILE__), array('jquery', 'bkb-custom-script'), BWL_KB_PLUGIN_VERSION, TRUE);
            wp_register_script('bkb-ques-form-script', plugins_url('js/bkb-ques-form-script.js', __FILE__), array('jquery', 'bkb-remodal-script', 'bkb-custom-script'), BWL_KB_PLUGIN_VERSION, TRUE);
            wp_register_script('bkb-custom-script', plugins_url('js/bkb-custom.js', __FILE__), array('jquery'), BWL_KB_PLUGIN_VERSION, TRUE);
            
             wp_register_script('bkb-tableofcontents-script', plugins_url('js/jquery.tableOfContents.js', __FILE__), array('jquery'), BWL_KB_PLUGIN_VERSION, TRUE);
            
        }
        
        // @Description: Load Plugin CSS & JS Codes.
        // @Added in version 1.1.6
        
         function bkb_check_for_shortcode( $posts ) {

            if (empty($posts))
                
                return $posts;

            // false because we have to search through the posts first
            
//            echo "<pre>";
//            print_r($posts);
//            echo "</pre>";
//            
            if ( isset($posts[0]->post_type) && $posts[0]->post_type == "bwl_kb") {
                
                wp_enqueue_style('bkbm-custom-styles', BKBM_PLUGIN_CSS_FILE, array(), BWL_KB_PLUGIN_VERSION);
           
            }

            $found = 0;

            // search through each post

            foreach ($posts as $post) {

                // check the post content for the short code
//echo "<pre>";
//print_r($post->post_content);
//echo "</pre>";
                
                // Find prefix of KB plugin shortcode which is bkb_
                
                if (stripos( $post->post_content, 'bkb_')) {

                    // we have found a post with the short code
                    $found = 1;
                    // stop the search
                }

                
                
                if ( $found == 1 ) {

                    break;
                
                }
                
            }
            
//            echo $found;

            if ( $found == 1 ) {
 
                 // Load Required CSS Codes For BWL Knowledgebase Manager. 
                wp_enqueue_style('bkbm-grid-styles', plugins_url('css/bkbm-grid-styles.css', __FILE__), array(), BWL_KB_PLUGIN_VERSION);
                wp_enqueue_style('bkbm-custom-styles', BKBM_PLUGIN_CSS_FILE, array(), BWL_KB_PLUGIN_VERSION);
                
            }

            return $posts;
            
        }

        // @Description: Load Plugin Admin Panel Required Custom JS & CSS Files.
        // @Since: version 1.0.0

        function bkbm_admin_load_scripts( $hook ) {

            // Check point To Load JS & CSS files in admin.
            // We only load Plugin required JS & CSS files where it acutally required.

           $bkb_post_type = "";

            if (isset( $_GET['post_type'] ) && $_GET['post_type'] == "bwl_kb") {

                $bkb_post_type = "bwl_kb";


            } else if ( isset($_GET['post'] ) && get_post_type( $_GET['post'] ) === 'bwl_kb' ) {

                 $bkb_post_type = "bwl_kb";

             } else {

                  $bkb_post_type = "";
             }

             // End of checking.

            // Load Font-Awesome only in KB Pages.

            if ( $bkb_post_type == "bwl_kb" ) {

                wp_enqueue_style('bkb-admin-font-awesome-styles', plugins_url('css/font-awesome.min.css', __FILE__), array(), BWL_KB_PLUGIN_VERSION);

            }

            // Load sorting style only in KB pages.

            if( $hook == 'bwl_kb_page_bkb_sort' ) {

                wp_enqueue_style('bkb-sort-styles', plugins_url('css/bkbm-sort.css', __FILE__), array(), BWL_KB_PLUGIN_VERSION);

            }

            // Required JS & CSS Files For KB Shortcode Button.

            wp_register_style('bkb-shortcode-editor-multiple-select-style', plugins_url('tinymce/css/multiple-select.css', __FILE__));
            wp_register_style('bkb-shortcode-editor-style', plugins_url('tinymce/css/bkb-shortcode-editor-style.css', __FILE__));
            wp_register_script('bkb-admin-mutiple-select-script', plugins_url('tinymce/js/jquery.multiple.select.js', __FILE__), array('jquery', 'jquery-ui-core', 'jquery-ui-sortable', 'jquery-ui-draggable', 'jquery-ui-droppable'), '', TRUE);

            // Load Admin Custom Script only in KB pages.

            if ( 'edit.php' == $hook && isset($_GET['post_type']) && $_GET['post_type'] == "bwl_kb" ) {

                wp_register_script('bkb-admin-script', plugins_url('js/bkb-admin-custom.js', __FILE__), array('jquery','jquery-ui-core'), '', TRUE);
                wp_enqueue_script('bkb-admin-script');

            }

            // Load live Font Awesome icon changes only in KB pages.

            if ( $bkb_post_type == "bwl_kb" ) {
                
                
                wp_enqueue_script('media-upload');
                wp_enqueue_script('thickbox');
                wp_enqueue_style('thickbox');

                wp_register_script('bkb-cmb-admin-main', BWL_KB_PLUGIN_DIR . 'includes/bkb-cmb-framework/admin/js/bkb_cmb.js', array('jquery', 'jquery-ui-core', 'jquery-ui-sortable'), false, false);
                wp_register_style('bkb-cmb-admin-style', BWL_KB_PLUGIN_DIR . 'includes/bkb-cmb-framework/admin/css/bkb_cmb.css', array(), false, 'all');

                wp_enqueue_script('bkb-cmb-admin-main');
                wp_enqueue_style('bkb-cmb-admin-style');

                wp_register_script('bkb-fa-live', plugins_url('js/bkb-fa-live.js', __FILE__), array('jquery'), BWL_KB_PLUGIN_VERSION, TRUE);
                wp_enqueue_script('bkb-fa-live');

            }

        }

        // @Description: Define & Register Custom Post Type For Plugin.
        // @Since: version 1.0.0

        public function register_post_type() {

            /*
             * Custom Slug Section.
             * @Since: version 1.0.0
             */        

            global $bkb_data;

            // Default custom slug for knowledgebase plugin. 
            // Admin can change this slug value from option panel. 
            // You need to save the parmalink settings after change the slug value. Other wise you will get 404.
            // To solve this, Go to WP admin panel>settings>Permalinks and click save changes button.

            $bkb_custom_slug = "bwl-knowledge-base"; 

            if( isset($bkb_data['bkb_custom_slug']) && $bkb_data['bkb_custom_slug'] != "" ) {

                $bkb_custom_slug = trim( $bkb_data['bkb_custom_slug'] );

            }

            define("BKB_CUSTOM_SLUG", $bkb_custom_slug);

            $labels = array(
                'name'                         => __('All Knowledge Base', 'bwl-kb'),
                'singular_name'            => __('Knowledge Base', 'bwl-kb'),
                'add_new'                    => __('Add New KB', 'bwl-kb'),
                'add_new_item'           => __('Add New KB', 'bwl-kb'),
                'edit_item'                   => __('Edit KB', 'bwl-kb'),
                'new_item'                  => __('New KB', 'bwl-kb'),
                'all_items'                    => __('All KB Items', 'bwl-kb'),
                'view_item'                  => __('View KB Items', 'bwl-kb'),
                'search_items'             => __('Search KB Items', 'bwl-kb'),
                'not_found'                  => __('No KB found', 'bwl-kb'),
                'not_found_in_trash'    => __('No KB found in Trash', 'bwl-kb'),
                'parent_item_colon'     => '',
                'menu_name'              => __('BWL KB', 'bwl-kb')
            );

            // Default form items supports for Knowledge base plugin.
            // Revisions introduced in version 1.1.2

            $bkb_supports = array('title', 'editor','revisions', 'author');


            // Comment section added in version 1.0.6
            // Admin can show/hide comment permssion from plugin option panel.

            if( isset($bkb_data['bkb_comment_status']) && $bkb_data['bkb_comment_status'] == 1 ) {

                $bkb_supports[] = 'comments';

            }

            // KB Thumbnail feature only available with "KB Display As Blog Post" Addon.
            // Download it from: http://codecanyon.net/item/kb-display-as-blog-post-knowledge-base-addon/11245275

            if( class_exists('BKB_kbdabp') ) {

                $bkb_supports[] = 'thumbnail';

            }


            $args = array(
                'labels'                       => $labels,
                'query_var'                => 'bwl_kb',    
                'show_in_nav_menus' => true,
                'public'                       => true,        
                'show_ui'                   => true,
                'show_in_menu'         => true,
                'rewrite'                     => array(
                                                     'slug' => $bkb_custom_slug,
                                                     "with_front" => true //before it was true
                                                   ),
                'publicly_queryable'     => true,
                'capability_type'          => 'post',
                'has_archive'              => FALSE,
                'hierarchical'               => true, // If you need sub category turn it true
                'show_in_admin_bar'  => true,
                'supports'                   => $bkb_supports,
                'menu_icon'                => BWL_KB_PLUGIN_DIR . 'images/bwl_kb_menu_icon.png',
                "cptp_permalink_structure" => "/%bkb_category%/%postname%/"
            );        

            
            register_post_type('bwl_kb', $args); // text domian limitations :D

        }

        // @Description: Register Plugin Required Taxonomies.
        // @Since: Version 1.0.0

        public function taxonomies() {

            /*
             * Custom Slug Section.
             */        

            global $bkb_data;

            $bkb_custom_slug = "bwl-knowledge-base";

            if( isset($bkb_data['bkb_custom_slug']) && $bkb_data['bkb_custom_slug'] != "" ) {

                $bkb_custom_slug = trim( $bkb_data['bkb_custom_slug'] );

            }
            
            $bkb_cat_tax_slug = $bkb_custom_slug. '-category';
            
            if( isset($bkb_data['bkb_custom_cat_slug']) && $bkb_data['bkb_custom_cat_slug'] != "" ) {
                
                $bkb_cat_tax_slug = $bkb_data['bkb_custom_cat_slug'];
                
            }
            

            $taxonomies = array();

            $taxonomies['bkb_category'] = array(
                'hierarchical'      => true,
                'query_var'       => 'bkb_category',
                'rewrite'            => array(
                                            'slug' => $bkb_cat_tax_slug
                                            ),            
                'labels'              => array(
                                                'name' => __('KB Category', 'bwl-kb'),
                                                'singular_name' => __('Category', 'bwl-kb'),
                                                'edit_item' => __('Edit Category', 'bwl-kb'),
                                                'update_item' =>__('Update category', 'bwl-kb'),
                                                'add_new_item' => __('Add Category', 'bwl-kb'),
                                                'new_item_name' => __('Add New category', 'bwl-kb'),
                                                'all_items' => __('All categories', 'bwl-kb'),
                                                'search_items' => __('Search categories', 'bwl-kb'),
                                                'popular_items' => __('Popular categories', 'bwl-kb'),
                                                'separate_items_with_comments' => __('Separate categories with commas', 'bwl-kb'),
                                                'add_or_remove_items' => __('Add or remove category', 'bwl-kb'),
                                                'choose_from_most_used' => __('Choose from most used categories', 'bwl-kb')
                                            )

             );     

            //  INTRODUCED CATEGORY FILTERING IN ADMIN PANEL FROM VESTION 1.4.8 VERSION

            if(is_admin()) {
                $taxonomies['bkb_category']['query_var'] = TRUE;
            }
            
            $bkb_tag_tax_slug = $bkb_custom_slug. '-tags';
            
             if( isset($bkb_data['bkb_custom_tag_slug']) && $bkb_data['bkb_custom_tag_slug'] != "" ) {
                
                $bkb_tag_tax_slug = $bkb_data['bkb_custom_tag_slug'];
                
            }

            $taxonomies['bkb_tags'] = array(
                'hierarchical'      => true,
                'query_var'       => 'bkb_tags',            
                'rewrite'            => array(
                                                    'slug' => $bkb_tag_tax_slug
                                                ),            
                'labels'              => array(
                                                    'name'                                         => __('KB Tags', 'bwl-kb'),
                                                    'singular_name'                            => __('Tags', 'bwl-kb'),
                                                    'edit_item'                                    => __('Edit Tags', 'bwl-kb'),
                                                    'update_item'                               => __('Update Tags', 'bwl-kb'),
                                                    'add_new_item'                            => __('Add Tag', 'bwl-kb'),
                                                    'new_item_name'                         => __('Add New Tag', 'bwl-kb'),
                                                    'all_items'                                     => __('All Tags', 'bwl-kb'),
                                                    'search_items'                              => __('Search Tags', 'bwl-kb'),
                                                    'popular_items'                             => __('Popular Tags', 'bwl-kb'),
                                                    'separate_items_with_comments' => __('Separate Tags with commas', 'bwl-kb'),
                                                    'add_or_remove_items'                => __('Add or remove Tags', 'bwl-kb'),
                                                    'choose_from_most_used'            => __('Choose from most used Tags', 'bwl-kb')
                                              )

            );

            if(is_admin()) {
                $taxonomies['bkb_tags']['query_var'] = TRUE;
            }

            $this->register_all_taxonomies($taxonomies);

        } 

        function register_all_taxonomies($taxonomies) {

            foreach ($taxonomies as $name=> $arr) {
                register_taxonomy($name, array('bwl_kb'), $arr);
            }

        }

        // Addon Support Filter.
        // Templify KB: http://codecanyon.net/item/templify-kb-knowledge-base-addon/11888104
        // Restriction KB: http://codecanyon.net/item/restrict-kb-access-by-user-role-addon/13722991

        function bkbm_taxonomy_filters( $query ) {
 
            global $bkb_data;

            if ( !is_admin() && is_tax('bkb_category') && isset( $bkb_data ['bkb_cat_default_tpl_ordering_status']['enabled']) && $bkb_data['bkb_cat_default_tpl_ordering_status']['enabled'] == 'on' && $query->is_main_query() ) {

                $bkb_cat_default_tpl_order_by = 'date';

                if ( isset( $bkb_data ['bkb_cat_default_tpl_ordering_status']['bkb_cat_default_tpl_order_by']) ){
                    $bkb_cat_default_tpl_order_by = $bkb_data ['bkb_cat_default_tpl_ordering_status']['bkb_cat_default_tpl_order_by'];
                }

                $bkb_cat_default_tpl_order = 'DESC';

                if ( isset( $bkb_data ['bkb_cat_default_tpl_ordering_status']['bkb_cat_default_tpl_order']) ){
                    $bkb_cat_default_tpl_order = $bkb_data ['bkb_cat_default_tpl_ordering_status']['bkb_cat_default_tpl_order'];
                }

                
                if( $bkb_cat_default_tpl_order_by == 'custom_order' ) {
                    
                    global $wp_query;
                    $current_queried_object = $wp_query->get_queried_object();
                    $bkb_sort_prefix = PREFIX_BKB_CAT;
                    $bkb_term_id = $current_queried_object->term_id;

                    $bkb_cat_sorted_posts_id = explode(',', get_option($bkb_sort_prefix . $bkb_term_id)); // call db for post meta.

                    $bkb_cat_all_posts_id = bkb_taxonomoy_custom_sorted_post_ids('bkb_category', $bkb_term_id);

                    $bkb_cat_final_sorted_posts_id = array_values(array_unique(array_merge($bkb_cat_sorted_posts_id, $bkb_cat_all_posts_id)));


                    $query->set('post__in', $bkb_cat_final_sorted_posts_id);
                    $query->set('orderby', 'post__in');
                    
                } else {

                    $query->set('orderby', $bkb_cat_default_tpl_order_by);
                    $query->set('order', $bkb_cat_default_tpl_order);
                }
                
                
                /*------------------------------ Restriction Addon Manager ---------------------------------*/
                if( class_exists( 'BKB_Rkb' ) ) {

                    $query->set( 'post__not_in', bkb_rkb_get_excluded_posts() );

                }

                /*------------------------------ End Restriction Manager ---------------------------------*/
                

                return $query;

            } else if ( !is_admin() && is_tax('bkb_tags') && isset( $bkb_data ['bkb_tag_default_tpl_ordering_status']['enabled']) && $bkb_data['bkb_tag_default_tpl_ordering_status']['enabled'] == 'on' && $query->is_main_query() ) {

                $bkb_tag_default_tpl_order_by = 'date';

                if ( isset( $bkb_data ['bkb_tag_default_tpl_ordering_status']['bkb_tag_default_tpl_order_by']) ){
                    $bkb_tag_default_tpl_order_by = $bkb_data ['bkb_tag_default_tpl_ordering_status']['bkb_tag_default_tpl_order_by'];
                }

                $bkb_tag_default_tpl_order = 'DESC';

                if ( isset( $bkb_data ['bkb_tag_default_tpl_ordering_status']['bkb_tag_default_tpl_order']) ){
                    $bkb_tag_default_tpl_order = $bkb_data ['bkb_tag_default_tpl_ordering_status']['bkb_tag_default_tpl_order'];
                }
                
                // Custom Order Settings.
                
                if( $bkb_tag_default_tpl_order_by == 'custom_order' ) {
                    
                    global $wp_query;
                    $current_queried_object = $wp_query->get_queried_object();
                    $bkb_sort_prefix = PREFIX_BKB_TAG;
                    $bkb_term_id = $current_queried_object->term_id;

                    $bkb_tag_sorted_posts_id = explode(',', get_option($bkb_sort_prefix . $bkb_term_id)); // call db for post meta.

                    $bkb_tag_all_posts_id = bkb_taxonomoy_custom_sorted_post_ids('bkb_tags', $bkb_term_id);

                    $bkb_tag_final_sorted_posts_id = array_values(array_unique(array_merge($bkb_tag_sorted_posts_id, $bkb_tag_all_posts_id)));


                    $query->set('post__in', $bkb_tag_final_sorted_posts_id);
                    $query->set('orderby', 'post__in');
                    
                } else {

                    $query->set('orderby', $bkb_tag_default_tpl_order_by);
                    $query->set('order', $bkb_tag_default_tpl_order);
                }
                
                
                 /*------------------------------ Restriction Addon Manager ---------------------------------*/
                if( class_exists( 'BKB_Rkb' ) ) {

                    $query->set( 'post__not_in', bkb_rkb_get_excluded_posts('tags') );

                }

                /*------------------------------ End Restriction Manager ---------------------------------*/

                return $query;

            } else {

                return $query;

            }

        }

    }

    /*------------------------------ Initialization ---------------------------------*/

    function init_bwl_kb_manager() {
        
        
            
        new BWL_KB_Manager();
    }

    add_action('init', 'init_bwl_kb_manager');

    /*------------------------------  TRANSLATION FILE ---------------------------------*/

    load_plugin_textdomain('bwl-kb', FALSE, dirname(plugin_basename(__FILE__)) . '/lang/');


    /*------------------------------ Integrate Widgets ---------------------------------*/

    include_once dirname(__FILE__) . '/widget/bkb-widget.php';  

    include_once dirname(__FILE__) . '/widget/bkb-category-widget.php';  

    include_once dirname(__FILE__) . '/widget/bkb-tags-widget.php';

    include_once dirname(__FILE__) . '/widget/bkb-related-posts-widget.php'; // Introduced in version 1.0.2
    
    include_once dirname(__FILE__) . '/widget/bkb-toc-widget.php'; // Introduced in version 1.0.6

}