<?php

add_action('wp_ajax_bkb_get_search_results', 'bkb_get_search_results');
add_action('wp_ajax_nopriv_bkb_get_search_results', 'bkb_get_search_results');

function bkb_get_search_results() {

    if (isset($_REQUEST['bwl_ajax_search'])) {

        global $wpdb;
        $like = "";
        $where = "";
        $s = trim($_REQUEST['s']);
        $s = preg_replace('/\s+/', ' ', $s);

        $limit = isset($_REQUEST['search_limit']) ? $_REQUEST['search_limit'] : 10;

        $not_exactonly = FALSE;
        $searchintitle = 1;
        $searchincontent = isset( $_REQUEST['only_title'] ) ? $_REQUEST['only_title'] : 1;;
        $searchinposts = FALSE;
        $searchinpages = FALSE;
        $searchInCustomPostType = true;

        $post_type = 'post';

        if ($searchintitle) {
            if ($not_exactonly) {
                $sr = implode("%' OR lower($wpdb->posts.post_title) like '%", $_s);
                $sr = " lower($wpdb->posts.post_title) like '%" . $sr . "%'";
            } else {
                $sr = " lower($wpdb->posts.post_title) like '%" . $s . "%'";
            }
            $like .= $sr;
        }

        if ($searchincontent) {
            if ($not_exactonly) {
                $sr = implode("%' OR lower($wpdb->posts.post_content) like '%", $_s);
                if ($like != "") {
                    $sr = " OR lower($wpdb->posts.post_content) like '%" . $sr . "%'";
                } else {
                    $sr = " lower($wpdb->posts.post_content) like '%" . $sr . "%'";
                }
            } else {
                if ($like != "") {
                    $sr = " OR lower($wpdb->posts.post_content) like '%" . $s . "%'";
                } else {
                    $sr = " lower($wpdb->posts.post_content) like '%" . $s . "%'";
                }
            }
            $like .= $sr;
        }


        if ($searchinposts) {
            $where = " $wpdb->posts.post_type='post'";
        }

        if ($searchinpages) {
            $post_type = 'page';
            if ($where != "")
                $where.= " OR $wpdb->posts.post_type='page'";
            else
                $where.= "$wpdb->posts.post_type='page'";
        }

        if ($searchInCustomPostType) {
            $post_type = 'bwl_kb';
            if ($where != "")
                $where.= " OR $wpdb->posts.post_type='bwl_kb'";
            else
                $where.= "$wpdb->posts.post_type='bwl_kb'";
        }

        if ($where == "") {
            $where = "$wpdb->posts.post_type=''";
        }

        $orderby = "ID";

        $s = strtolower(addslashes($_REQUEST['s']));

//        $join = "LEFT JOIN $wpdb->users ON $wpdb->users.ID = $wpdb->posts.post_author
//     LEFT JOIN $wpdb->term_relationships ON $wpdb->posts.ID = $wpdb->term_relationships.object_id
//     LEFT JOIN $wpdb->term_taxonomy ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id
//     LEFT JOIN $wpdb->terms ON $wpdb->term_taxonomy.term_id = $wpdb->terms.term_id";

        if (defined('ICL_SITEPRESS_VERSION')) {

            global $sitepress;

            $join .= " INNER JOIN {$wpdb->prefix}icl_translations
             ON {$wpdb->posts}.ID = {$wpdb->prefix}icl_translations.element_id";

            $where .= $wpdb->prepare(") AND ({$wpdb->prefix}icl_translations.language_code = %s
                              AND {$wpdb->prefix}icl_translations.element_type = %s", $sitepress->get_current_language(), "post_{$post_type}");
        }
        

        $querystr = "SELECT 
                                $wpdb->posts.post_title as title,
                                $wpdb->posts.ID as id 
  		FROM $wpdb->posts
                                {$join}
  		WHERE
                                ($wpdb->posts.post_status='publish') AND
                                (" . $where . ")			    
                                AND (" . $like . ")
                                GROUP BY
                                  $wpdb->posts.ID 
  		ORDER BY " . $wpdb->posts . "." . $orderby . "
  		LIMIT $limit ";
        
                                // Restricted KB Filter.
                                
                                if( has_filter('bkb_rkb_search_query_filter') ) {
                                    
                                    $rkb_query_vars = array(
                                        's' => $s,
                                        'orderby' => $orderby,
                                        'limit' => $limit
                                    );
                                    
                                   $results = apply_filters('bkb_rkb_search_query_filter', $rkb_query_vars);
                                    
                                } else {
                                    
                                        if (defined('ICL_SITEPRESS_VERSION')) {
                                            
                                            $pageposts = $wpdb->get_results($querystr, ARRAY_A);
                                            
                                            $output = array();
                                            $counter = 0;
                                            foreach ($pageposts as $k => $v) {

                                                $output[$counter]['title'] = $v['title'];
                                                $output[$counter]['link'] = get_permalink($v['id']);
                                                $counter ++;

                                            }

                                            $results = $output;
                                            
                                        } else {
                                            
                                             $args = array( 
                                                's' => trim( $s ),
                                                'post_type' => 'bwl_kb',
                                                'post_status' => 'publish',
                                                'posts_per_page'  => $limit,
                                                'orderby' => $orderby,
                                            );
                                             
//                                             echo "<pre>";
//                                             print_r($args);
//                                             echo "</pre>";
                                            
                                            $query = new WP_Query( $args );
                                            $pageposts = $query->posts;
                                            $output = array();
                                            $counter = 0;
                                            foreach ($pageposts as $k => $v) {

                            //                        echo "<pre>";
                            //                        print_r($v);
                            //                        echo "</pre>";

                                                $output[$counter]['title'] = $v->post_title;
                                                $output[$counter]['link'] = get_permalink($v->ID);
                                                $counter ++;
                                            }

                                            $results = $output;
                                            
                                        }
                                     

                                }
                                
                                wp_reset_query();

        echo json_encode($results);
        die();
    }

    die();
}

// Ajax Search.

add_filter( 'posts_search',  'bwl_kb_search_by_title', 100, 2 );

function bwl_kb_search_by_title($search, $wp_query) {

//                    echo "<pre>";
//                    print_r($wp_query);
//                    echo "</pre>";
//                    
//                    echo $wp_query->query['post_type'];
//                    
//                    die();
    
    $bkb_data = get_option('bkb_options');
    
//    echo "<pre>";
//    print_r($bkb_data);
//    echo "</pre>";
//    
//    echo $bkb_data['bkb_disable_search_content'];

    $bkb_only_search_title  = ( isset( $bkb_data['bkb_disable_search_content'] ) && $bkb_data['bkb_disable_search_content'] =="1" ) ? 1 : 0;
    
    
//    echo "<pre>";
//    print_r($bkb_data['bkb_disable_search_content']);
//    echo "</pre>";
    
    if (!empty($search) && !empty($wp_query->query_vars['search_terms']) && isset($wp_query->query['post_type']) && $wp_query->query['post_type'] == "bwl_kb" && $bkb_only_search_title == 1 ) {
 
        global $wpdb;

        $q = $wp_query->query_vars;
        $n = !empty($q['exact']) ? '' : '%';

        $search = array();

        foreach ((array) $q['search_terms'] as $term)
            $search[] = $wpdb->prepare("$wpdb->posts.post_title LIKE %s", $n . $wpdb->esc_like($term) . $n);

        if (!is_user_logged_in())
            $search[] = "$wpdb->posts.post_password = ''";

        $search = ' AND ' . implode(' AND ', $search);
        
        return $search;
        
    } else {
        
        return $search;
        
    }

    
}
