<?php


 /*------------------------------  Custom Meta Box Section ---------------------------------*/

class BKB_Meta_Box {
    
    function __construct( $custom_fields ) {

        $this->custom_fields  = $custom_fields; //Set custom field data as global value.

        add_action( 'add_meta_boxes', array( &$this, 'bkb_metaboxes' ) );
        add_action( 'save_post_bwl_kb', array( &$this, 'save_bkb_meta_box_data' ) ); 
        add_action( 'save_post_product', array( &$this, 'save_bkb_meta_box_data' ) ); 
        
    }
            
    
    //Custom Meta Box.
    
    function bkb_metaboxes() {
        
        $bwl_cmb_custom_fields = $this->custom_fields;

        // First parameter is meta box ID.
        // Second parameter is meta box title.
        // Third parameter is callback function.
        // Last paramenter must be same as post_type_name
        
        add_meta_box(
            $bwl_cmb_custom_fields['meta_box_id'],
            $bwl_cmb_custom_fields['meta_box_heading'],
            array( &$this, 'show_meta_box' ),
            $bwl_cmb_custom_fields['post_type'],            
            $bwl_cmb_custom_fields['context'], 
            $bwl_cmb_custom_fields['priority']
        );

    }

    function show_meta_box( $post ) {
  
        $bwl_cmb_custom_fields = $this->custom_fields;
        
        foreach( $bwl_cmb_custom_fields['fields'] as $custom_field ) :

            $field_value = get_post_meta($post->ID, $custom_field['id'], true);
       
        ?>

            <?php if( $custom_field['type'] == 'text' ) : ?>

            <p class="bwl_cmb_row">
                <label for="<?php echo $custom_field['id']?>"><?php echo $custom_field['title']?> </label>
                <input type="<?php echo $custom_field['type']?>" id="<?php echo $custom_field['id']?>" name="<?php echo $custom_field['name']?>" class="<?php echo $custom_field['class']?>" value="<?php echo esc_attr($field_value); ?>"/>
            </p>
            
            <?php endif; ?>
            
            <?php if( $custom_field['type'] == 'select' ) : ?>
            
                <?php 
                
                    $values = get_post_custom( $post->ID );
                    
                    
                    $selected = isset( $values[$custom_field['name']] ) ? esc_attr( $values[$custom_field['name']][0] ) : $custom_field['default_value'];
                    
                ?>
            
                <p class="bwl_cmb_row">
                    <label for="<?php echo $custom_field['id']?>"><?php echo $custom_field['title']?> </label> 
                    <select name="<?php echo $custom_field['name']?>" id="<?php echo $custom_field['id']?>"> 
                        
                        <option value="" selected="selected">- Select -</option>
                        
                        <?php foreach( $custom_field['value'] as $key => $value ) : ?>
                            <option value="<?php echo $key ?>" <?php selected( $selected, $key ); ?> ><?php echo $value; ?></option> 
                        <?php endforeach; ?>
                        
                    </select>
                    
                    <?php if( isset( $custom_field['desc'] ) && $custom_field['desc'] != "" ) { ?>
                        <i><?php echo $custom_field['desc']; ?></i>
                    <?php } ?>
                </p> 

            <?php endif; ?>
                
             <?php if( $custom_field['type'] == 'repeatable_select' ) : ?>

                <p class="bwl_cmb_row bwl_cmb_db">
                    <label for="<?php echo $custom_field['id']?>"><?php echo $custom_field['title']?>: </label>

                    <?php if(isset( $custom_field['desc'] ) && $custom_field['desc'] != "" ): ?>
                        <small class="small-text"><?php echo $custom_field['desc'] ; ?></small>
                    <?php endif; ?>
                </p>
                <textarea id="bwl_cmb_data_set" style="display: none;"><?php echo json_encode( $custom_field['default_value'] ); ?></textarea>
                
                 <?php 
//                 
//                    echo "<pre>";
//                    print_r($custom_field['default_value']);
//                    echo "</pre>";
//                    
//                    echo json_encode($custom_field['default_value']);
                 
                 ?>

                <ul class="bwl_cmb_repeat_field_container">

                    <?php

                        $i = 0;
                        $field_value = apply_filters('filter_kbtfwc_content_data', get_post_meta($post->ID, $custom_field['id']) );
//                        
//                        echo $custom_field['id'];
//                        echo "<pre>";
//                        print_r($field_value);
//                        echo "</pre>";

                        if (!empty( $field_value ) && is_array( $field_value ) ) {

                            foreach ($field_value as $db_save_key=>$db_save_value) {

                                
                                // Find Current Selected Field.


                    ?>

                       <li class="bwl_cmb_repeat_row" data-row_count="<?php echo $i; ?>">				
                            <span class="label"><?php echo $custom_field['label_text'];?></span>
                            <select id="<?php echo $custom_field['id'] . '_' . $i;?>" name="<?php echo $custom_field['name'].'['.$i.']'?>"> 
                        
                                <option value="" selected="selected"><?php _e('- Select -', 'bwl-kb') ?></option>

                                <?php foreach( $custom_field['default_value'] as $default_key => $default_value ) : ?>
                                    <option value="<?php echo $default_key ?>" <?php echo ($db_save_value == $default_key) ? 'selected=selected' : '' ; ?> ><?php echo $default_value ; ?></option> 
                                <?php endforeach; ?>

                            </select>
                            <div class="clear"></div>
                            <a class="delete_row" title="<?php _e('Delete', 'bwl-kb') ?>"><?php _e('Delete', 'bwl-kb') ?></a>
                       </li>	

                <?php

                            $i++;

                    }
                }

                ?>
            </ul>
            
            <input id="add_new_row" type="button" class="button" value="<?php echo $custom_field['btn_text']; ?>" data-delete_text="<?php _e('Delete', 'bwl-kb') ?>"  data-upload_text="<?php _e('Upload', 'bwl-kb') ?>" data-field_type="<?php echo $custom_field['type']?>" data-field_name="<?php echo $custom_field['name']?>" data-label_text ="<?php echo $custom_field['label_text'];?>">

            
            <?php endif; ?>    
                
             <?php if( $custom_field['type'] == 'ques_info_box' && $custom_field['value']  ==1 ) : ?>
            
                <p class="bwl_cmb_row">
                    <label for="<?php echo $custom_field['id']?>"><?php echo $custom_field['title']?></label>
                    <br />
                    <em><?php echo $field_value; ?></em>
                </p>  
            
             <?php endif; ?>   
            
            <?php 
            
                    if( $custom_field['type'] == 'checkbox' ) : 
                 
                ?>
            
                <p> 
                    <input type="checkbox" id="<?php echo $custom_field['id']?>" name="<?php echo $custom_field['name']?>" <?php checked($field_value, 'on', true); ?> />  
                    <label for="<?php echo $custom_field['id']?>"><?php echo $custom_field['title']?></label>  
                </p>  
            
             <?php endif; ?>
                
             <?php if( $custom_field['type'] == 'repeatable' ) : ?>

                <p class="bwl_cmb_row bwl_cmb_db">
                    <label for="<?php echo $custom_field['id']?>"><?php echo $custom_field['title']?>: </label>

                    <?php if(isset( $custom_field['desc'] ) && $custom_field['desc'] != "" ): ?>
                        <small class="small-text"><?php echo $custom_field['desc'] ; ?></small>
                    <?php endif; ?>
                </p>

                <ul class="bwl_cmb_repeat_field_container">

                    <?php

                        $i = 0;
                        
                        $field_value = apply_filters('filter_bkb_attachment_content_data', get_post_meta($post->ID, $custom_field['id']) );
//                        echo "<pre>";
//                        print_r($field_value);
//                        echo "</pre>";

                        if (!empty( $field_value ) && is_array( $field_value ) ) {

                            foreach ($field_value as $data) {

                                // Need attachment ID;

                                $attachment_post_id = $data;

                                if( is_numeric($data) ) {
                                    $get_bkb_attachment_url = home_url() . '/wp-content/uploads/' . get_post_meta( $attachment_post_id, '_wp_attached_file', true);
                                } else {
                                    $get_bkb_attachment_url = $data;
                                }


                    ?>

                       <li class="bwl_cmb_repeat_row" data-row_count="<?php echo $i; ?>">				
                            <span class="label"><?php echo $custom_field['label_text'];?></span>
                             <input id="<?php echo $custom_field['id'] . '_' . $i; ?>_url" class="img-path" type="text" name="<?php echo $custom_field['name'].'['.$i.']'?>" value="<?php if (!empty($get_bkb_attachment_url)) echo $get_bkb_attachment_url ?>" />
                             <input id="upload_<?php echo $custom_field['id'] . '_' . $i; ?>_button" type="button" class="button bwl_cmb_upload_file" value="<?php _e('Upload', 'bwl-kb') ?>" data-parent_field="<?php echo $custom_field['id']; ?>" data-row_count="<?php echo $i; ?>"/>
                            <div class="clear"></div>
                            <a class="delete_row" title="<?php _e('Delete', 'bwl-kb') ?>"><?php _e('Delete', 'bwl-kb') ?></a>
                       </li>	

                <?php

                            $i++;

                    }
                }

                ?>
            </ul>
            
            <input id="add_new_row" type="button" class="button" value="<?php echo $custom_field['btn_text']; ?>" data-delete_text="<?php _e('Delete', 'bwl-kb') ?>"  data-upload_text="<?php _e('Upload', 'bwl-kb') ?>" data-field_type="<?php echo $custom_field['field_type']?>" data-field_name="<?php echo $custom_field['name']?>" data-label_text ="<?php echo $custom_field['label_text'];?>">

            
            <?php endif; ?>  
                
                
             <?php if( $custom_field['type'] == 'bkb_custom' ) : ?>
            
                <div> 
                    
                   <label for="<?php echo $custom_field['title']?>"><strong><?php echo $custom_field['title']?>:</strong> </label> 
                   
                   <?php
                   
                    global $post;
                   
                    $bkb_feedback_message_unique_id = 'bkb_feedback_list_'.$post->ID; // so idea is we are going to add post id after vairable name
//                    delete_post_meta($post->ID, $bkb_feedback_message_unique_id);
                    
                    $prev_bkb_feedback_message = get_post_meta( $post->ID, $bkb_feedback_message_unique_id );
                    
//                    echo "<pre>";
//                    print_r($prev_bkb_feedback_message);
//                    echo "</pre>";


                    if( isset($prev_bkb_feedback_message[0]) ) {

                       $prev_bkb_feedback_message_counter = sizeof( $prev_bkb_feedback_message[0] );

                    } else {

                       $prev_bkb_feedback_message_counter = 0; 

                    }
                   
                   ?>
                   <ul class="bkb_feedbacks">
                   <?php if( $prev_bkb_feedback_message_counter != 0 ) : ?>
                   
                   
                       <?php foreach ( $prev_bkb_feedback_message[0] as $key=>$feedback_message ) :?>
                       
                       <li><?php echo $feedback_message; ?> <a href="#" class="bkb_remove_feedback" data-post_id="<?php echo $post->ID; ?>" data-feedback_index="<?php echo $key; ?>">X</a></li>                        
                       
                       <?php endforeach;?>
                   
                
                    <?php else: ?>
                        <li><?php _e('No Feedback Message Found!', 'bwl-kb') ?></li>
                    <?php endif; ?>
                        
                    </ul>
                </div>  
            
            <?php 
            
//            $array = array('apple', 'orange', 'strawberry', 'blueberry', 'kiwi');
//            echo "<pre>";
//            print_r($array);
//            echo "</pre>";
            
//            if (($key = array_search('strawberry', $array)) !== false) {
//                unset($array[1]); // Main function.
//            }
            
//            echo "<pre>";
//            print_r($array);
//            echo "</pre>";
            ?>
            
             <?php endif; ?>   

        <?php
        
            endforeach;
            
    }        

    function save_bkb_meta_box_data( $id ) {
        
        global $post;
        
         if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){   
            
             return $post_id;  
             
         } else {
        
            $bkb_meta_custom_fields = $this->custom_fields;
            
            $bkb_excluded_fileds = array('bkb_user_email_send_status', 'bkb_attachment_files', 'kbftw_kb_post_ids');
           
            foreach( $bkb_meta_custom_fields['fields'] as $custom_field ) {

                if ( isset( $_POST[$custom_field['name']] ) ) {
                    
                        // Updated in version 1.1.2
                    
                         if ( ! in_array( $custom_field['name'], $bkb_excluded_fileds) ) {

                           update_post_meta($id, $custom_field['name'], strip_tags( $_POST[$custom_field['name']] ));

                       }

                }

            }
            
            
            // Repeatable Fields Data Saving In Here.
            // Introduced in version 1.1.2

            if (isset( $_POST['bkb_attachment_files'] ) ) {

              update_post_meta($id, 'bkb_attachment_files',  $_POST['bkb_attachment_files'] );
//              echo $id;
//              echo "<pre>";
//              print_r($_POST['bkb_attachment_files']);
//              echo "</pre>";
//              $field_value = get_post_meta( $id , 'bkb_attachment_files', TRUE);
//
//              echo "<pre>";
//              print_r($field_value);
//              echo "</pre>";
//               die();
           } else {
               
               delete_post_meta($id, 'bkb_attachment_files');
               
           }
           
           // Repeatable KB Select Fields Data Saving In Here.
           // Introduced in version 1.1.2
           
            if (isset($_POST['kbftw_kb_post_ids'])) {
                
                $kbftw_count_prev_post_meta = get_post_meta($id, 'kbftw_kb_post_ids');
//                
//                echo "<pre>";
//                print_r($kbftw_count_prev_post_meta);
//                echo "</pre>";
                
                if ( count( $kbftw_count_prev_post_meta ) > 1 ) {
                    //remove old meta fields and then update data.
                    delete_post_meta($id, 'kbftw_kb_post_ids');
                }
                
                update_post_meta($id, 'kbftw_kb_post_ids', $_POST['kbftw_kb_post_ids']);
                
            } else {
                
                delete_post_meta($id, 'kbftw_kb_post_ids');
                
            }
            
        }
        
    }
     
}

// Register Custom Meta Box For BWL Pro Related Post Manager

function bkb_custom_meta_init() {
    
     
    
//    return '';
    
    // Default Post Icon.
    
    global $bkb_data;
    
    $bkb_post_icon = "fa fa-file-o"; // Default Icon for Categories/Tags
    
     if (isset($bkb_data['bkb_post_icon']) && $bkb_data['bkb_post_icon'] != "") {
        $bkb_post_icon = $bkb_data['bkb_post_icon'];
    }
    
    $bkb_custom_post_types = array('bwl_kb');
    
 
    foreach ($bkb_custom_post_types as $bkb_custom_post_types_key => $bkb_custom_post_types_value ) {
        
        // Related KB Posts Custom Meta Box.
        
        $bkb_related_custom_fields= array(
        
            'meta_box_id'           => 'cmb_bkb_related_post_manager', // Unique id of meta box.
            'meta_box_heading'  => 'BKB Related Post Manager Settings', // That text will be show in meta box head section.
            'post_type'               => 'bwl_kb', // define post type. go to register_post_type method to view post_type name.        
            'context'                   => 'normal',
            'priority'                    => 'high',
            'fields'                       => array(
                                                        'bkb_related_post_display_status'  => array(
                                                                                    'title'      => __( 'Display Status: ', 'bwl-kb'),
                                                                                    'id'         => 'bkb_related_post_display_status',
                                                                                    'name'    => 'bkb_related_post_display_status',
                                                                                    'type'      => 'select',
                                                                                    'value'     => array(
                                                                                                            '0' => __('Hide', 'bwl-kb'),
                                                                                                            '1' => __('Show', 'bwl-kb')
                                                                                                        ),
                                                                                    'default_value' => 1,
                                                                                    'class'      => 'widefat'
                                                                                ),

                                                            'bkb_related_post_filter_type'  => array(
                                                               'title'      => __( 'Filter Posts: ', 'bwl-kb'),
                                                               'id'         => 'bkb_related_post_filter_type',
                                                               'name'    => 'bkb_related_post_filter_type',
                                                               'type'      => 'select',
                                                               'value'     => array(
                                                                                       '0' => __('Category', 'bwl-kb'),
                                                                                       '1' => __('Tag', 'bwl-kb')
                                                                                   ),
                                                               'default_value' => 0,
                                                               'class'      => 'widefat'
                                                           )

                                                    )
        );


        new BKB_Meta_Box( $bkb_related_custom_fields ); 
       
        // Voting Manager Settings.

        $bkb_voting_meta_fields= array(

            'meta_box_id'           => 'cmb_bkb_voting_box_settings', // Unique id of meta box.
            'meta_box_heading'  => 'KB Voting Manager Settings', // That text will be show in meta box head section.
            'post_type'               => $bkb_custom_post_types_value, // define post type. go to register_post_type method to view post_type name.        
            'context'                   => 'normal',
            'priority'                    => 'high',
            'fields'                       => array( 
                
                                                        'bkb_featured_status'  => array(
                                                                                    'title'      => __( 'Featured Status: ', 'bwl-kb'),
                                                                                    'id'         => 'bkb_featured_status',
                                                                                    'name'    => 'bkb_featured_status',
                                                                                    'type'      => 'select',
                                                                                    'value'     => array(
                                                                                                            '0' => __('No', 'bwl-kb'),
                                                                                                            '1' => __('Yes', 'bwl-kb')
                                                                                                        ),
                                                                                    'default_value' => 0,
                                                                                    'class'      => 'widefat'
                                                            ),
                                                            'bkb_display_status'  => array(
                                                                'title'      => __( 'Display Voting Box: ', 'bwl-kb'),
                                                                'id'         => 'bkb_display_status',
                                                                'name'    => 'bkb_display_status',
                                                                'type'      => 'select',
                                                                'value'     => array(
                                                                                        '0' => __('Hide', 'bwl-kb'),
                                                                                        '1' => __('Show', 'bwl-kb'),
                                                                                        '2' => __('Voting Closed', 'bwl-kb'),
                                                                                    ),
                                                                'default_value' => 1,
                                                                'class'      => 'widefat'
                                                            ),
                                                            'bkb_display_feedbacks'  => array(
                                                               'title'      => __( 'Voting Feedbacks', 'bwl-kb'),
                                                               'id'         => 'bkb_display_feedbacks',
                                                               'name'    => 'bkb_display_feedbacks',
                                                               'type'      => 'bkb_custom'
                                                           )

                                                    )
        );


        new BKB_Meta_Box( $bkb_voting_meta_fields );
         
        $bkb_ques_user_email = "";
        $bkb_user_ques = 0;
        
        if( isset( $_GET['post'] ) && get_post_type( $_GET['post']) == "bwl_kb" ) {
        
            $bkb_ques_user_email = get_post_meta( $_GET['post'], 'bkb_ques_user_email', TRUE );
            
            if ( $bkb_ques_user_email !="" ) {
                $bkb_user_ques = 1;
            } 
            
        }
       
        $bkb_email_settings_custom_fields= array(

            'meta_box_id'           => 'cmb_bkb_email_settings', // Unique id of meta box.
            'meta_box_heading'  => __('KB Email Notification Settings', 'bwl-kb'), // That text will be show in meta box head section.
            'post_type'               => $bkb_custom_post_types_value, // define post type. go to register_post_type method to view post_type name.        
            'context'                   => 'normal',
            'priority'                    => 'high',
            'fields'                       => array(
                
                                                         'bkb_user_ques_details'  =>  array(
                                                                                'title'      => __( 'Question details:', 'bwl-kb'),
                                                                                'id'         => 'bkb_user_ques_details',
                                                                                'name'    => 'bkb_user_ques_details',
                                                                                'type'      => 'ques_info_box',
                                                                                'value'     => $bkb_user_ques,
                                                                                'default_value' => 1,
                                                                                'class'      => 'widefat'
                                                                            ),
                        
                                                        'bkb_ques_user_email'  => array(
                                                                                    'title'      => __( 'Question Submitted By: ', 'bwl-kb'),
                                                                                    'id'         => 'bkb_ques_user_email',
                                                                                    'name'    => 'bkb_ques_user_email',
                                                                                    'type'      => 'text',
                                                                                    'value'     => $bkb_ques_user_email,
                                                                                    'default_value' => $bkb_ques_user_email,
                                                                                    'class'      => 'large'
                                                                                ), 
                                                        'bkb_user_email_send_status'  => array(
                                                                                    'title'      => __( 'Send Notification Email: ', 'bwl-kb'),
                                                                                    'id'         => 'bkb_user_email_send_status',
                                                                                    'name'    => 'bkb_user_email_send_status',
                                                                                    'type'      => 'select',
                                                                                    'value'     => array(
                                                                                                            '1' => __('Yes', 'bwl-kb'),
                                                                                                            '0' => __('No', 'bwl-kb')
                                                                                                        ),
                                                                                    'default_value' => 0,
                                                                                    'class'      => 'widefat',
                                                                                    'desc'  => __('This field value will not saved in database.', 'bwl-kb')
                                                                                )
                                                    )
        );

        new BKB_Meta_Box( $bkb_email_settings_custom_fields );
        
        
        // Custom Attachment Fields.
        //@introduced in version 1.1.2
        
        
        $bkb_kb_post_attachment_fields= array(

            'meta_box_id'           => 'cmb_bkb_attachment_settings', // Unique id of meta box.
            'meta_box_heading'  => __('KB File Attachment Settings', 'bwl-kb'), // That text will be show in meta box head section.
            'post_type'               => $bkb_custom_post_types_value, // define post type. go to register_post_type method to view post_type name.        
            'context'                   => 'normal',
            'priority'                    => 'high',
            'fields'                       => array(
                
                                                        'bkb_attachment_files'  => array(
                                                                                    'title'      => __( 'Add Files', 'bwl-kb'),
                                                                                    'id'         => 'bkb_attachment_files',
                                                                                    'name'    => 'bkb_attachment_files',
                                                                                    'type'      => 'repeatable',
                                                                                    'value'     => '',
                                                                                    'default_value' => '',
                                                                                    'class'      => 'widefat',
                                                                                    'btn_text' => __( 'Add New File', 'bwl-kb'),
                                                                                    'label_text' => __( 'File: ', 'bwl-kb'),
                                                                                    'field_type' => 'upload'
                                                                                )
                                                    )
        );


        new BKB_Meta_Box( $bkb_kb_post_attachment_fields );
        
         $bkb_kb_post_icon_fields= array(

            'meta_box_id'           => 'cmb_bkb_icon_settings', // Unique id of meta box.
            'meta_box_heading'  => 'BKB Post Icon Settings', // That text will be show in meta box head section.
            'post_type'               => $bkb_custom_post_types_value, // define post type. go to register_post_type method to view post_type name.        
            'context'                   => 'normal',
            'priority'                    => 'high',
            'fields'                       => array(
                
                                                        'bkb_kb_post_icon'  => array(
                                                                                    'title'      => __( 'Select Icon: ', 'bwl-kb'),
                                                                                    'id'         => 'bkb_kb_post_icon',
                                                                                    'name'    => 'bkb_fa_id',
                                                                                    'type'      => 'select',
                                                                                    'value'     => bkb_get_fa_icons(TRUE),
                                                                                    'default_value' => $bkb_post_icon,
                                                                                    'class'      => 'widefat'
                                                                                )
                                                    )
        );


        new BKB_Meta_Box( $bkb_kb_post_icon_fields );
    
            
    }
    
}


// META BOX START EXECUTION FROM HERE.

add_action('admin_init', 'bkb_custom_meta_init');


/*------------------------------ After Save Post We are going to send email to user ---------------------------------*/

function bkb_post_updated_send_email( $post_id ) {

            // If this is just a revision, don't send the email.
    
            if ( wp_is_post_revision( $post_id ) || wp_is_post_autosave($post_id) || get_post_type( $post_id ) != 'bwl_kb' )
		
                return;
 
        
            if ( get_post_status( $post_id ) == 'publish' && get_post_type( $post_id ) == 'bwl_kb' && 
                 isset( $_POST['bkb_user_email_send_status'] ) && $_POST['bkb_user_email_send_status'] == 1 && 
                 isset( $_POST['bkb_ques_user_email'] ) && $_POST['bkb_ques_user_email'] != get_bloginfo( 'admin_email' ) ) {
        
                
              $bkb_ques_user_email = $_POST['bkb_ques_user_email']; 
	$post_title = get_the_title( $post_id );
	$post_url = get_permalink( $post_id );
	$subject = __('Knowledgebase Question has been updated!', 'bwl-kb');
              $sender_email =  get_bloginfo( 'admin_email' ); // Email send from blog admin.
              
              
	$message = "<p>Hello, <br />Your submitted Knowledgebase question has been updated on our website. More details - <br />";
	$message .= '<a href="'.$post_url.'">'. $post_title . '</a></p>' ;
	$message .= "<p>Thanks.</p>";
                
              $headers[]= "From: Knowledgebase Question <$sender_email>";
              
              add_filter( 'wp_mail_content_type', 'bkb_ques_set_html_content_type' );
              
	// Send email to admin.
	wp_mail( $bkb_ques_user_email, $subject, $message, $headers );
        
              remove_filter ( 'wp_mail_content_type', 'bkb_ques_set_html_content_type' );
        
            }
            
}

add_action( 'save_post_bwl_kb', 'bkb_post_updated_send_email' );


/*
 *@Description: Remove  
 * 
 *  */

function bkb_remove_feedback_data() {


    $feedback_index = $_POST['feedback_index']; // get category slug.
    $post_id = $_POST['post_id']; // get category slug. 


    $bkb_feedback_message_unique_id = 'bkb_feedback_list_' . $post_id; // so idea is we are going to add post id after vairable name

    $bkb_feedback_messages = get_post_meta($post_id, $bkb_feedback_message_unique_id);

    unset($bkb_feedback_messages[0][$feedback_index]); // Main function.
//
//    echo "<pre>";
//    print_r($bkb_feedback_messages);
//    echo "</pre>";
    
    update_post_meta($post_id, $bkb_feedback_message_unique_id, $bkb_feedback_messages[0]);

    $msg = "";

    if (isset($bkb_feedback_messages[0])) {
        
        $count = sizeof($bkb_feedback_messages[0]);
        
    } else {
        
        $count = 0;
        
    }

    $post_data = array(
        'count' => $count,
        'msg' => ( $count == 0 )  ? __('No Feedback Message Found!', 'bwl-kb') : ""
    );
    
    sleep(3);
    echo json_encode($post_data);
    
    die();
}

add_action('wp_ajax_bkb_remove_feedback_data', 'bkb_remove_feedback_data');

add_action('wp_ajax_nopriv_bkb_remove_feedback_data', 'bkb_remove_feedback_data');