<?php

function cb_bkb_post_view_counter( $content ) {
    
    if ( ! is_singular('bwl_kb') ) {
        return $content;
    }

    if ( is_singular('bwl_kb') && is_main_query()  && in_the_loop() ) { // Fix in version 1.1.0
        
         global $post, $bkb_data;
         
         $bkb_toc_status = ( isset($bkb_data['bkb_toc_status']) && $bkb_data['bkb_toc_status'] =="on" ) ? 1 : 0;
         $bkb_toc_title = ( isset($bkb_data['bkb_toc_title']) && $bkb_data['bkb_toc_title'] !="" ) ? $bkb_data['bkb_toc_title'] : __("Table of content", 'bwl-kb');
         $bkb_toc_min_tag = ( isset($bkb_data['bkb_toc_min_tag']) && $bkb_data['bkb_toc_min_tag'] !="" && is_numeric( $bkb_data['bkb_toc_min_tag'] ) && $bkb_data['bkb_toc_min_tag'] > 2 ) ? $bkb_data['bkb_toc_min_tag'] : 2;
    
         
         $content = '<div class="bkb-single-post" data-bkb_toc_status="'.$bkb_toc_status.'" data-bkb_toc_title="'.$bkb_toc_title.'" data-bkb_toc_min_tag="'.$bkb_toc_min_tag.'">'. $content .'</div>';
         
         if( $bkb_toc_status == 0 ) {
    
             wp_enqueue_script('bkb-tableofcontents-script');
             
         }
        
        // Fixed in version 1.1.2

        $postID = $post->ID;
        
        /***********************************************************************************************/
        /* Custom Filter For "Restrict Access By User Role Addon" */
        /* @Since: version 1.0.9 */
        /* @Created: 15-11-2015 */
        /***********************************************************************************************/
        if( has_filter("bkb_rkb_post_access") ) {
            
            $bkb_rkb_post_access_result = apply_filters('bkb_rkb_post_access', $postID);
            
            if ( $bkb_rkb_post_access_result != 1 ) {
                return $bkb_rkb_post_access_result;
            }
            
        }
        
        /*------------------------------ End Restrict Access By User Role Addon Function ---------------------------------*/
        
        $bkb_post_view_ip = $_SERVER['REMOTE_ADDR'];

        $count_key = 'bkbm_post_views';
        
        $count = get_post_meta($postID, $count_key, true);
        
        // Return current post IP and last view time information as an Array.
        
        $get_post_view_ip = get_post_meta($postID, "bkb_post_view_ip");  // Get voters'IPs for the current post 
        
        if ( $count == '' ) {
            
            $count = 0;
            
            delete_post_meta($postID, $count_key);
            
            $bkb_set_post_view_ip_info = array(
                'IP' => $bkb_post_view_ip,
                'view_time' => time()
            );
            
            add_post_meta($postID, "bkb_post_view_ip", $bkb_set_post_view_ip_info);
            add_post_meta($postID, $count_key, '1');
            
        } else {
            
             $view_time_interval = 1440; // = 24 hours = 1440 Mins  If user visit after 2 hours of his previous view then we count another view.
            
             $now = time();  
             
             if( sizeof( $get_post_view_ip ) == 0 ) {
                 
                 $last_bkb_post_view_ip = $bkb_post_view_ip;
                 $last_view_time = 0;
                 
             } else {
                 
                 $last_bkb_post_view_ip = $get_post_view_ip[0]['IP'];
                 $last_view_time = $get_post_view_ip[0]['view_time'];
                 
             }
          
            // Compare between current time and vote time 
        
            if( $last_bkb_post_view_ip != $bkb_post_view_ip || ( round(($now - $last_view_time) / 60 ) > $view_time_interval ) ) {
                
                $count++;
                
                $bkb_set_post_view_ip_info = array(
                    'IP' => $bkb_post_view_ip,
                    'view_time' => time()
                );

                update_post_meta($postID, "bkb_post_view_ip", $bkb_set_post_view_ip_info);
                
                update_post_meta($postID, $count_key, $count);
                
            }
            
        }
        
//        $bkb_post_breadcrumb = bkb_get_post_breadcrumb();
        
        
       
     
        $total_post_view_html = "";
        $bkb_post_breadcrumb = "";
        $no_of_post_views = "";
        $bkb_edit_link_interface = "";
        // Filter date meta display status.
        
        if( ! isset( $bkb_data['bkb_meta_date_status'] ) || $bkb_data['bkb_meta_date_status'] == 1 ) {
            
            $bkb_post_date_time_info = '<i class="fa fa-calendar btn_like"></i> ' .get_the_time('F j, Y') . ' &nbsp; ';
            
            $total_post_view_status = 1;

        } else {
            
            $bkb_post_date_time_info = "";
            
        }
        
        // Filter no of post view display status.
        
        if( ! isset( $bkb_data['bkb_meta_view_status'] ) || $bkb_data['bkb_meta_view_status'] == 1 ) {

            $no_of_post_views = '<i class="fa fa-eye"></i> ' . do_shortcode("[bkb_pv /]") . ' &nbsp; ';

        } else {
            
            $no_of_post_views = "";
            
        }
        
        // Filter post author name display status.
        
        $bkb_post_author_info = "";
        
        if( ! isset( $bkb_data['bkb_meta_author_status'] ) || $bkb_data['bkb_meta_author_status'] == 1 ) {
            
            $author_id=$post->post_author;
                
            $bkb_author = get_the_author_meta( 'display_name' , $author_id );

            $bkb_author_name = ( $bkb_author == "" ) ? __( 'Anonymous', 'bwl-kb') : $bkb_author;

            $bkb_post_author_info = "<i class='fa fa-user'></i> " . $bkb_author_name . " &nbsp;";
            
            
        }
        
        
        $bkbm_post_categories = ""; // Initialize Categories value.
        
        $bkbm_post_categories .= do_shortcode("[bkb_gpc /]");
        
        $bkbm_post_tags = ""; // Initialize Categories value.
        
        $bkbm_post_tags .= do_shortcode("[bkb_gpt /]");
        
        // @Description: Show Hide Voting Button.
        // @Since: Version 1.0.9
        
        if( isset( $bkb_data['bkb_voting_btn_status'] ) && $bkb_data['bkb_voting_btn_status'] == 1) {
             
            $post_voting_interface = "";
            
        } else {
        
            $post_voting_interface = do_shortcode("[bkb_vm /]");
        
        }
        
        $bkb_related_kb = do_shortcode("[bkb_grp /]");
        
        // @Description: Form Layout Settings.
        // @Since: Version 1.1.9
        
        if( isset( $bkb_data['bkb_from_layout'] ) && $bkb_data['bkb_from_layout'] == "layout_2") {
             
            $bkb_from_layout = "layout_2";
            
        } else {
        
            $bkb_from_layout = "";
        
        }
        
        $bkb_ques_form = do_shortcode("[bkb_ques_form layout='" . $bkb_from_layout . "' /]");
        
        $bkb_attachment = do_shortcode("[bkb_attachment /]");
        
        
        // @Description: Show Hide Share Button
        // @Since: Version 1.0.9
         
        if( isset( $bkb_data['bkb_share_btn_status'] ) && $bkb_data['bkb_share_btn_status'] == 0 ) {     
            
            $bkb_share = "";
            
        } else {
        
            $bkb_share = do_shortcode("[bkb_share/]");
        
        }
         
        
        
        // Filter post category display status.
        
        if( ! isset( $bkb_data['bkb_meta_category_status'] ) || $bkb_data['bkb_meta_category_status'] == 1 ) {
        
            if ( $bkbm_post_categories != "" ) {

                $bkbm_post_categories = '<i class="fa fa-bookmark"></i> &nbsp;'.$bkbm_post_categories . ' &nbsp; ';

            }
            
        } else {
            
            $bkbm_post_categories = "";
            
        }
        
        // Filter Post Tag display status.
        
        if( ! isset( $bkb_data['bkb_meta_topics_status'] ) || $bkb_data['bkb_meta_topics_status'] == 1 ) {
        
            if ( $bkbm_post_tags != "" ) {

                $bkbm_post_tags = '<i class="fa fa-tags"></i> &nbsp;' . $bkbm_post_tags;

            }
            
        } else {
            
            $bkbm_post_tags = "";
            
        }
        
        // Finally we count if all string length is greater than zero or not.
        
        if ( strlen( $bkb_post_date_time_info . $no_of_post_views . $bkb_post_author_info . $bkbm_post_categories . $bkbm_post_tags ) > 0 ) {
        
            $total_post_view_html = '<div class="bkpm-total-post-view">'
                                                        . $bkb_post_date_time_info
                                                        . $no_of_post_views
                                                        . $bkb_post_author_info
                                                        . $bkbm_post_categories
                                                        . $bkbm_post_tags .
                                              '</div>';
        
        }
        
        $bkb_edit_link_interface = "".$bkb_attachment;
        
        // @Description: Display KB last modified date info.
        // @Since: version 1.1.2
        if( isset( $bkb_data['bkb_last_mod_info_status'] ) && $bkb_data['bkb_last_mod_info_status'] == 1 ) {
            
            $bkb_post_last_modified_info = get_the_modified_date('F j, Y');
            $bkb_edit_link_interface .= '<p><strong>' . __('Last Update: ', 'bwl-kb') .'</strong> '. $bkb_post_last_modified_info.' &nbsp; ';
            
        }
        
        
        if( current_user_can( 'edit_post', $postID ) ) {
                $bkb_edit_link = get_edit_post_link();
                $bkb_edit_link_interface .= '<a href="'.$bkb_edit_link.'" target="_blank" title="'.get_the_title().'" class="bkb-post-edit-link" style="display: inline;"><span class="fa fa-edit"></span> ' . __('Edit', 'bwl-kb') . '</a>';
        }
        
        $bkb_edit_link_interface.='</p>';
        
        $bkb_edit_link_interface.=$bkb_share;
    
        $content .= $bkb_edit_link_interface . $bkb_post_breadcrumb . $total_post_view_html . $post_voting_interface . $bkb_related_kb . $bkb_ques_form;
        
        return do_shortcode( $content);
        
    }
    
}
    
add_filter('the_content', 'cb_bkb_post_view_counter', 100, 1);

/*-------------------------- Get Total No Of Post Viwes -------------------------------------*/

add_shortcode('bkb_pv', 'bkb_post_views');
    
function bkb_post_views() {

    global $post;

    $postID = $post->ID;

    $count_key = 'bkbm_post_views';
    $count = get_post_meta($postID, $count_key, true);

    if ($count == '') {
        $count = 0;
    }

    return $count;
    
}

/*--------------------------- GET Knowledge Base Categories------------------------------------*/

add_shortcode('bkb_gpc', 'bkb_get_post_categories');
        
function bkb_get_post_categories() {

    global $post;

    $postID = $post->ID;
//    the_taxonomies($args);
    $terms = wp_get_post_terms($postID, 'bkb_category');

    $bkb_single_post_categories = "";

    if (sizeof($terms) > 0) {

        $bkb_single_post_categories .='<span class="bkb-single-post-categories">';

        foreach ($terms as $term) {

            $bkb_single_post_categories .='<a href="' . get_term_link($term->slug, 'bkb_category') . '" title="' . ucwords($term->name) . '">' . ucwords($term->name) . '</a>, ';
        }

        $bkb_single_post_categories = substr($bkb_single_post_categories, 0, strlen($bkb_single_post_categories) - 2);

        $bkb_single_post_categories .='</span>';
    }

    return $bkb_single_post_categories;
    
}

/*--------------------------- Knowledge Base Tags------------------------------------*/

add_shortcode('bkb_gpt', 'bkb_get_post_tags');
        
function bkb_get_post_tags() {

    global $post;

    $postID = $post->ID;

    $terms = wp_get_post_terms($postID, 'bkb_tags');

    $bkb_single_post_tags = "";

    if (sizeof($terms) > 0) {

        $bkb_single_post_tags .='<span class="bkb-single-post-tags">';

        foreach ($terms as $term) {

            $bkb_single_post_tags .='<a href="' . get_term_link($term->slug, 'bkb_tags') . '" title="' . ucwords($term->name) . '">' . ucwords($term->name) . '</a> , ';
        }

        $bkb_single_post_tags = substr($bkb_single_post_tags, 0, strlen($bkb_single_post_tags) - 2);

        $bkb_single_post_tags .='</span>';
    }

    return $bkb_single_post_tags;
}


/*---------------------------BKB Related Post ------------------------------------*/

add_shortcode('bkb_grp', 'get_bkb_related_kb');
        
function get_bkb_related_kb($id) {

    $id = get_the_ID();

    $bkb_related_post_display_status = TRUE;

    $get_bkb_related_post_display_status = trim(get_post_meta($id, 'bkb_related_post_display_status', true));

    if (isset($get_bkb_related_post_display_status) && $get_bkb_related_post_display_status != "" && $get_bkb_related_post_display_status == 0) {

        $bkb_related_post_display_status = FALSE;

        return '';
        
    }

    $bkb_related_post_filter_type = 'category';

    $get_bkb_related_post_filter_type = trim(get_post_meta($id, 'bkb_related_post_filter_type', true));

    if (isset($get_bkb_related_post_filter_type) && $get_bkb_related_post_filter_type != "" && $get_bkb_related_post_filter_type == 1) {

        $bkb_related_post_filter_type = 'tags';
    }

    $cats = array();

    if (isset($bkb_related_post_filter_type) && $bkb_related_post_filter_type == 'category') {

        $terms = wp_get_object_terms($id, 'bkb_category');

        if( sizeof($terms) > 0 ) {

            foreach ($terms as $term) {

                $cats[] = $term->term_id; // store categoires in array.
            }

        } else {
            
            $cats = "";
            
        }

        $args = array(
            'post_type' => 'bwl_kb',
            'post__not_in' => array($id),
            'showposts' => 3,
            'orderby' => 'rand',
            'tax_query' => array(
                array(
                    'taxonomy' => 'bkb_category',
                    'field' => 'id',
                    'terms' => $cats
                )
            )
        );
    }

    // Just consider, a post may contain more than 1 tags, so we need to create an array to store all tags.

    $tags = array();

    if (isset($bkb_related_post_filter_type) && $bkb_related_post_filter_type == 'tags') {

        $terms = wp_get_object_terms($id, 'bkb_tags');

        if( sizeof($terms) > 0 ) {

            foreach ($terms as $term) {

                $tags[] = $term->term_id; // store tags in array.
            }

        } else {
            
            $tags = "";
            
        }

        $args = array(
            'post_type' => 'bwl_kb',
            'post__not_in' => array($id),
            'showposts' => 3,
            'orderby' => 'rand',
            'tax_query' => array(
                array(
                    'taxonomy' => 'bkb_tags',
                    'field' => 'id',
                    'terms' => $tags
                )
            )
        );
    }

    // We are going to set a filter in here for Restriction Addon.
    
    $args = apply_filters('bkb_rkb_query_filter', $args);
    
    $loop = new WP_Query($args); // Finally we pass arguments WP_Query Function.
    
    $bkb_related_kb_string = '<section class="bkb_related_posts bkb_clearfix">';

    $bkb_related_post_heading = __("Related Knowledge Base Posts -", 'bwl-kb');

    $bkb_related_kb_string .= '<h2>' . $bkb_related_post_heading . '</h2>';

    if ($loop->have_posts()) {

        $bkb_related_kb_string .= '<ul class="bkb-related-posts">';

        while ($loop->have_posts()) {

            $loop->the_post();
            $bkb_post_title = apply_filters('custom_rkb_title', get_the_title());
            $bkb_related_kb_string .='<li>';
            $bkb_related_kb_string .= '<a href="' . get_permalink() . '">' . $bkb_post_title . '</a>';
            $bkb_related_kb_string .="</li>";
        }

        $bkb_related_kb_string .= '</ul>';

        wp_reset_query(); // reset SQL query. VERY IMPORTANT.
        
    } else {

        $bkb_related_kb_string .="<p>" . __('No related posts found !', 'bwl-kb') . "</p>";
    }

    $bkb_related_kb_string .='</section>';
    
    wp_reset_query();
    
    return $bkb_related_kb_string; // Finally return content with related post.
    
}


/**
 * @Shortcode For Knowledge base single post attachments.
 * @Since: Version 1.0.1
 * @Last Update: 28-03-2016
 **/


add_shortcode('bkb_attachment', 'get_bkb_attachment');
        
function get_bkb_attachment( $id ) {

    $id = get_the_ID();
    
    $bkb_file_attachment_string = "";
    
    $bkb_display_file_name_status = 0;
    
    global $bkb_data;
    
    if( isset($bkb_data['bkb_display_file_name_status']) && $bkb_data['bkb_display_file_name_status']==1  ) {
        
        $bkb_display_file_name_status = 1;
        
    }

    // Updated in version 1.1.2
    // First we get the attachment value and it will be a single value ( serialize array)
    
    $get_bkb_attachment_ids =  apply_filters('filter_bkb_attachment_content_data', get_post_meta( get_the_ID(), 'bkb_attachment_files' ) );
    
//    // Then if it's comes with numeric value then we again submit query for get all values as an array.
//    if ( is_numeric($get_bkb_attachment_ids) ) {
//        $get_bkb_attachment_ids =  get_post_meta(get_the_ID(), 'bkb_attachment_files');
//    }
    
    // Finally we got an array.
    if ( ! empty($get_bkb_attachment_ids) ) {
        
        $bkb_file_attachment_string .= '<section class="bkb_file_attachment bkb_clearfix">';

        $bkb_file_attachment_heading = __("Attachments -", 'bwl-kb');

        $bkb_file_attachment_string .= '<h2>' . $bkb_file_attachment_heading . '</h2>';
        
        $counter  = 1;
        
        $bkb_file_attachment_string .= '<ul class="bkb-attachment-items">';
        
        foreach ($get_bkb_attachment_ids as $attachment_post_id){
            
            if( is_numeric( $attachment_post_id ) ) {
                
                $get_bkb_attachment_url = home_url() . '/wp-content/uploads/' . get_post_meta( $attachment_post_id, '_wp_attached_file', true);
                
            } else {
                
                $get_bkb_attachment_url = $attachment_post_id;
                
            }
            
            $bkb_file_attachment_string .='<li>';
            
                if( $bkb_display_file_name_status == 1 ) {
                    
                    $custom_bkb_attachment_url = str_replace( home_url().'/wp-content/uploads/', '', $get_bkb_attachment_url);
                    
                    $bkb_file_name = ' '.basename($get_bkb_attachment_url);
                    
                } else {
            
                    $bkb_file_name =  __(' File# ', 'bwl-kb') . $counter;
                
                }
            
                $bkb_file_attachment_string .= '<a href="'. esc_url( $get_bkb_attachment_url ) .'" target="_blank">' . $bkb_file_name . '</a>';
            
            $bkb_file_attachment_string .='</li>';
            
            $counter++;
             
        }
        
        $bkb_file_attachment_string .= '</ul>';
        
        $bkb_file_attachment_string .='</section>';
        
    }
    
    return $bkb_file_attachment_string;
     
}


/*
 * @Description: KB Share Button.
 * @Created by: Md Mahbub Alam Khan
 * @Since: 1.0.7
 * @Created at: 20-02-2015
 * @Last Update: 20-02-2015
 *  */

add_shortcode('bkb_share', 'bkb_share');

function bkb_share( $atts ) {
    
    extract(shortcode_atts(array(
        'post_id' => ''
    ), $atts));

    $bkbm_post_title = get_the_title( $post_id );
    $bkbm_post_url = get_permalink( $post_id );
    
    return '<p class="bkbm-share-links"> <strong>' .__('Share : ', 'bwl-pro-voting-manager') .'</strong>&nbsp;  

                        <a class="btn-share bkb_share" href="https://twitter.com/share?url='.$bkbm_post_url.'&amp;text='.$bkbm_post_title.'" title="Tweet It">
                           <i class="fa fa-twitter"></i>
                        </a>

                        <a class="btn-share bkb_share" href="http://www.facebook.com/sharer.php?u='.$bkbm_post_url.'" title="Share at Facebook">
                             <i class="fa fa-facebook"></i>
                        </a>

                        <a class="btn-share bkb_share" href="http://plus.google.com/share?url='.$bkbm_post_url.'" title="Share at Google+">
                           <i class="fa fa-google-plus"></i>
                        </a>

                        <a class="btn-share bkb_share" href="http://pinterest.com/pin/create/button/?url='.$bkbm_post_url.'" title="Share at Pinterest">
                            <i class="fa fa-pinterest"></i>
                        </a>

                        <a class="btn-share bkb_share" href="http://www.linkedin.com/shareArticle?mini=true&amp;url='.$bkbm_post_url.'" title="Share at LinkedIn">
                             <i class="fa fa-linkedin"></i>
                        </a>

                        <a class="btn-share bkb_share" href="http://www.tumblr.com/share/link?url='.$bkbm_post_url.'&amp;name='.$bkbm_post_title.'" title="Share at Tumblr">
                            <i class="fa fa-tumblr"></i>
                        </a>

                        <a class="btn-share bkb_share" href="mailto:?subject='.$bkbm_post_title.'&amp;body='.$bkbm_post_url.'" title="Share via Email">
                             <i class="fa fa-envelope-o"></i>
                        </a>

            </p>';
    
}