<?php

//Table of Content Required Minimum PHP Version 5.3.6
//Otherwise it's generate a warnting message. Reference-
//https://github.com/owncloud/news/issues/444

add_filter('the_content', 'bkb_toc_filter', 10);

//add_shortcode('bkb_toc_filter', 'bkb_toc_filter');

function bkb_toc_filter($content) {
    
    if ( ! is_singular('bwl_kb') ) {
        return $content;
    }

    if ( is_singular('bwl_kb') && is_main_query()  && in_the_loop() ) { // Fix in version 1.1.0
        
        global $bkb_data;
        
        $bkb_toc_status = ( isset($bkb_data['bkb_toc_status']) && $bkb_data['bkb_toc_status'] =="on" ) ? 0 : 1;
        
        if ( $bkb_toc_status == 0 ) {
            return  $content;
        }
        
        
        
        
        $bkb_toc_min_tag = 2;
        
        $toc = bkb_create_toc($content, $bkb_toc_min_tag);
        
        $bkb_hide_toc_menu_status = ( isset($bkb_data['bkb_hide_toc_menu_status']) && $bkb_data['bkb_hide_toc_menu_status'] =="on" ) ? 1: 0;
        
        if( $bkb_hide_toc_menu_status == 1 ) {
            
            return $content;
            
        } else {
            
            $content = $toc . "\r\n" . $content;
            
            return $content;
            
        }
        
        
    }
    
   
}

function bkb_toc_shortcode($attr = array(), $content = false) {

    global $post;
    
    $defaults = array(
        'bkb_toc_min_tag' => 2,
    );
    $attr = shortcode_atts($defaults, $attr);
    $toc = bkb_create_toc($post->post_content, $attr['bkb_toc_min_tag']);
    return $toc;
}

function bkb_create_toc( &$content, $bkb_toc_min_tag ) {
    
    global $bkb_data;
    
    $general_list_type = 'ol';
    $items = bkb_parse_toc( $content );
    
    $output = '';
    
    
                
    $bkb_toc_title = ( isset($bkb_data['bkb_toc_title']) && $bkb_data['bkb_toc_title'] !="" ) ? $bkb_data['bkb_toc_title'] : __("Table of content", 'bwl-kb');
    $bkb_toc_min_tag = ( isset($bkb_data['bkb_toc_min_tag']) && $bkb_data['bkb_toc_min_tag'] !="" && is_numeric( $bkb_data['bkb_toc_min_tag'] ) && $bkb_data['bkb_toc_min_tag'] > 2 ) ? $bkb_data['bkb_toc_min_tag'] : $bkb_toc_min_tag;
    
    $toc_title = '<p class="bkb-toc-title">'.$bkb_toc_title.'</p>';
    
    if (sizeof($items) >= $bkb_toc_min_tag) {
        $walker = new bkb_toc_walker();
        $output = $walker->walk($items, 0);
        $tag = $general_list_type;
        $output = "<div class=\"bkb_toc_wrapper\" id=\"#top\">{$toc_title}\n<{$tag}>\n{$output}</{$tag}>\n</div>\n\n";
    }
    
    return $output;
}

function bkb_toc_parent(&$items, $item) {
    
    if (sizeof($items) == 0) {
        return 0;
    }
    $i = 0;
    $parent = false;
    do {
        ++$i;
        $previous = sizeof($items) - $i;
        if ($item->depth > $items[$previous]->depth) {
            $parent = $items[$previous]->db_id;
        }
    } while (!$parent && sizeof($items) - $i > 0);
    if (!$parent && sizeof($items) - $i == 0) {
        return 0;
    }
    $a = 0;
    while ($item->depth - $items[$previous]->depth > 1) {
        ++$a;
        $empty_item = new stdClass();
        $empty_item->text = '';
        $empty_item->name = '';
        $empty_item->depth = $item->depth - $a;
        $empty_item->id = $parent . '-skip' . $a;
        $empty_item->db_id = sizeof($items) + 1;
        $empty_item->parent = $parent;
        $empty_item->empty = true;
        $items[] = $empty_item;
        $previous = sizeof($items) - $i;
    }
    return $parent;
}

function bkb_parse_toc(&$content) {
    
    $general_bookmark = 'numeric';
    
    $content = mb_convert_encoding($content, 'HTML-ENTITIES', get_bloginfo('charset'));
    $content = '<html><head><meta charset="' . get_bloginfo('charset') . '"></head><body>' . ($content) . '</body></html>';
    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($content);
    libxml_use_internal_errors(false);
    $xpath = new DOMXPath($dom);
    $tags = $xpath->query('/html/body/*[self::h1 or self::h2 or self::h3 or self::h4 or self::h5 or self::h6]');
    $items = array();
    $min_depth = 6;
    $parent = array();
    $used = array();
    
    for ($i = 0; $i < $tags->length; ++$i) {
        
        $text = $tags->item($i)->nodeValue;
        $id = $tags->item($i)->getAttribute('id');
        $name = $id;
        
        if (!$id) {
            
            $slug = remove_accents($text);
            $slug = sanitize_title_with_dashes($slug);
            $id = 'bkb-h' . $i;
            
            switch ( $general_bookmark ) {
                case 'numeric' :
                    $name = $id;
                    break;
                case 'slug' :
                    $name = $slug;
                    break;
                case 'combined' :
                    $name = $id . '-' . $slug;
                    break;
            }
            // Prevent the same names
            $old_name = $name;
            
            if (in_array($name, $used)) {
                $occurences = array_count_values($used);
                $next_number = ( $occurences[$name] + 1 );
                $name = $name . '-' . $next_number;
            }
            
            $used[] = $old_name;

            $tags->item($i)->setAttribute('id', $name);
            $tags->item($i)->setAttribute('class', 'bkb-toc-heading');
        }
        
        $depth = $tags->item($i)->nodeName[1];
        
        if ($depth < $min_depth) {
            $min_depth = $depth;
        }
        
        $item = new stdClass();
        $item->text = $text;
        $item->name = $tags->item($i)->nodeName;
        $item->depth = $depth;
        $item->id = $name;
        $item->parent =  bkb_toc_parent($items, $item);
        $item->db_id = sizeof($items) + 1;
        $items[] = $item;
        
    }
    
    $text = $xpath->query('/html/body');
    $text = $dom->saveHTML($text->item(0));
    
    if (version_compare(PHP_VERSION, '5.3.6', '<')) {
        $text = str_replace(array('<html>', '</html>', '<body>', '</body>'), '', $text);
        $text = preg_replace('/^<!DOCTYPE.+?>/', '', $text);
    }
    
    $content = $text;
    
    return $items;
}

class bkb_toc_walker extends Walker {

    var $db_fields = array(
        'parent' => 'parent',
        'id' => 'db_id'
    );

    function start_lvl(&$output, $depth = 0, $args = array()) {
        $output .= "\n<ol class='bkb-nested-list'>\n";
    }

    function start_el(&$output, $object, $depth = 0, $args = array(), $current_object_id = 0) {
        $output .= '<li>';
        if (isset($object->empty) && $object->empty) {
            
        } else {
            $output .= "<a href=\"#{$object->id}\">{$object->text}</a>";
        }
    }

    function end_el(&$output, $object, $depth = 0, $args = array()) {
        $output .= "</li>\n";
    }

    function end_lvl( &$output, $depth = 0, $args = array()) {
        $output .= "</ol>\n";
    }

}