/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

(function($) {
     
    if( $('select[name=bkb_fa_id]').length > 0 ) {

        function bkb_display_demo_icon($bkb_fa_id, $bkb_current_icon) {

            if( $bkb_current_icon.length == 0 ) {
                $("span.bkb-icon-demo").html('');
            } else {
                $("span.bkb-icon-demo").html('<i class="'+$bkb_current_icon+'"></i>');
            }

        }

        var $bkb_fa_id = $('select[name=bkb_fa_id]');
             $bkb_fa_id.after('<span class="bkb-icon-demo"></span>');

        // Default on page Load Event.
        if( $bkb_fa_id.length > 0 ) {
            bkb_display_demo_icon($bkb_fa_id, $bkb_fa_id.val());
        }

        // Mouse change Event.
        $bkb_fa_id.on("change", function(){

            var $bkb_current_icon = $(this).val();
                 bkb_display_demo_icon($bkb_fa_id, $bkb_current_icon);

        });

        // Keyboard Change Event.
        $bkb_fa_id.on("keyup", function(event){

            var $bkb_current_icon = $(this).val();

        var key = event.which;                
                switch(key) {
                  case 37:
                      // Key left.
    //                  console.log("Key left");
                      bkb_display_demo_icon($bkb_fa_id, $bkb_current_icon);
                      break;
                  case 38:
                      // Key up.
    //                  console.log("Key up");
                      bkb_display_demo_icon($bkb_fa_id, $bkb_current_icon);
                      break;
                  case 39:
                      // Key right.
    //                  console.log("Key right");
                      bkb_display_demo_icon($bkb_fa_id, $bkb_current_icon);
                      break;
                  case 40:
                      // Key down.
    //                  console.log("Key down");
                      bkb_display_demo_icon($bkb_fa_id, $bkb_current_icon);
                      break;
            }   
      });


    }
    
    if ($('select#bkb_roles_settings').length > 0 ) {

        $('select#bkb_roles_settings').add("multiple","multiple");

        $('select#bkb_roles_settings').multipleSelect({
            placeholder: "- Select -",
            selectAll: false,
            filter: true

        });
    
    }
    
    
 /*------------------------------KB SORTING JS @Since Version 1.0.0 @Last Update: 27-10-2015  ---------------------------------*/
 
    if ( $( '#bkb_sorting_container' ).length > 0 ) {
        
        var $bkb_save_sorting = $("#bkb_save_sorting");
        
        $bkb_save_sorting.attr('data-term_id', 0);
        
        // Save Sorting Data.
        
        function bkb_save_sort_data( bkb_sort_filter_type, bkb_sort_data ) {
            return $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'bkb_apply_sort', // this is the name of our WP AJAX function that we'll set up next
                    bkb_sort_filter_type: bkb_sort_filter_type,
                    bkb_sort_data: bkb_sort_data,
                    bkb_term_id: $bkb_save_sorting.attr('data-term_id')
                },
                dataType: 'JSON'
            });
        }
        
        // Get Sort Data.
        
        function bkb_get_sorting_data( bkb_category_slug, bkb_term_id ) {

            return $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'bkb_get_sorting_data', // this is the name of our WP AJAX function that we'll set up next
                    bkb_category_slug: bkb_category_slug,
                    bkb_term_id: bkb_term_id,
                    bkb_sort_filter: $bkb_save_sorting.data('sort_filter')
                },
                dataType: 'JSON'
            });
        }
        
        /*------------------------------ Initializing  ---------------------------------*/
        
        var $bkb_msg_container = $( '#bkb_sorting_container' ).find("#sort-status");
        var $bkb_sort_subtitle = $bkb_msg_container.data("sort_subtitle");
        var $bwl_bkb_items = $( '#bkb_sorting_container' ).find("#bwl_bkb_items");
         
        if( $bwl_bkb_items.find('li').length ) {
            $bwl_bkb_items.sortable({placeholder: "bwl-sorting-highlight"});
        }
        
        // Category Wise Sorting.
        
        if($("#bkb_sort_category").length) {
            
            $bkb_save_sorting.attr("disabled", "disabled");
            
            var $bkb_sort_category = $("#bkb_sort_category");
                 $bkb_sort_category.val("");
            
            $bkb_sort_category.on("change", function () {
                
                $bkb_save_sorting.attr("disabled", "disabled");
                
                if ($bkb_sort_category.val() == "") {
                     $bkb_save_sorting.removeAttr('data-term_id');
                    $bwl_bkb_items.html("");
                    return '';
                    
                }
                
                $bkb_msg_container.html(bkb_text_loading);
                
                var bkb_category_slug = $(this).val(),
                      bkb_term_id = $( "#bkb_sort_category option:selected" ).attr('data-term_id');
               

                $.when(bkb_get_sorting_data( bkb_category_slug, bkb_term_id )).done(function ( response_data ) {
 
                    if (response_data.status == 1) {
                        
                        $bkb_msg_container.html($bkb_sort_subtitle);
                        $bkb_save_sorting.attr('data-term_id', bkb_term_id);
                        
                        var output = '';
                        
                        $.each(response_data.data, function (index, data) {

                            output += '<li id="' + data['post_id'] + '" class="menu-item">'+
                                            '<dl class="menu-item-bar">'+
                                                '<dt class="menu-item-handle">'+
                                                '<span class="menu-item-title">' + data['post_title'] + '</span>'+
                                                '</dt>'+
                                            '</dl>'+
                                            '<ul class="menu-item-transport"></ul>'+
                                        '</li>';

                        });
                    
                        $bwl_bkb_items.html(output);
                        
                        setTimeout(function(){
                             if( $bwl_bkb_items.find('li').length ) {

                                    $bwl_bkb_items.sortable({placeholder: "bwl-sorting-highlight"});
                                    
                                    $bkb_save_sorting.removeAttr("disabled");
                             }
                        },500);
                        
                    } else {
                        
                        $bkb_msg_container.html($bkb_sort_subtitle);
                        $bkb_save_sorting.attr("disabled", "disabled");
                        
                    }

                });

            })
            
        } else {
           
            $bkb_save_sorting.removeAttr("disabled");
            
        }
        
        
        /*------------------------------ Sorting Data Save Event  ---------------------------------*/
        
        
        $bkb_save_sorting.on("click", function(){
            
            $bkb_save_sorting.val("Saving...").attr("disabled", "disabled");
            
            $.when( bkb_save_sort_data( $(this).data('sort_filter'), $bwl_bkb_items.sortable('toArray').toString())).done(function (response_data) {
                
                if( response_data.status == 1 ) {
                    $bkb_save_sorting.val("Saved !");
                    
                    setTimeout(function(){
                        $bkb_save_sorting.val("Save").removeAttr("disabled");
                    }, 2000)
                }
                
            });
            
        });
        
    }   
    
    
    /*------------------------------ KB Remove Feedback @Since Version 1.1.5  ---------------------------------*/
 
 
    if( $('.bkb_remove_feedback').length > 0 ) {
        
        var $bkb_remove_feedback = $('.bkb_remove_feedback');
        
        $bkb_remove_feedback.on("click", function(){
            
            var feedback_index = $(this).data('feedback_index');
            var post_id = $(this).data('post_id');
            
            var $feedback_index_parent = $(this).parent('li');
            
            $feedback_index_parent.html("Removing....");
            
            
            $.when( bkb_remove_feedback_data( feedback_index, post_id )).done(function (response_data) {
                
                $feedback_index_parent.fadeOut("slow");
                
                if( response_data.count === 0 ) {
                    
                    $(".bkb_feedbacks").html("<li>"+response_data.msg+"</li>");
                    
                }
                
            });
            
            
//            alert(" "+feedback_index);
            
            return false;
            
        });
        
        
        // Get Sort Data.
        
        function bkb_remove_feedback_data( feedback_index, post_id ) {

            return $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'bkb_remove_feedback_data', // this is the name of our WP AJAX function that we'll set up next
                    feedback_index: feedback_index,
                    post_id: post_id
                },
                dataType: 'JSON'
            });
        }
        
        
    }
 
})(jQuery);