(function ($) {

    // Default settings.
    var defaults = {
        ulClass: null,
        appendAfterSelector: 'h1'
    };

    var opt = null;

    jQuery.fn.tableOfContents = function (options) {

        opt = $.extend(true, defaults, options);

        var H_MIN = 1;
        var H_MAX = 6;

        var h = H_MIN;

        var counter = 1;

        var out = '<ul';
        if (opt.ulClass) {
            out += ' class="' + opt.ulClass + '"';
        }
        out += '>';

        var out = '<div id="#top" class="bkb_toc_wrapper"><p class="bkb-toc-title">'+ $(opt.appendAfterSelector).data('bkb_toc_title') +'</p><ol>';

        function buildListItemsAndAnchors(headers, headerNum) {

            if (headerNum > H_MAX) {
                return;
            }

            $(opt.appendAfterSelector).find(headers).each(function () {

                var self = $(this);

                self.before('<a name="' + counter + '"></a>');
                
                self.addClass("bkb-toc-heading");

                var hnext = self.nextUntil('h' + headerNum, 'h' + (headerNum + 1));
                var hnextLength = hnext.size();

                
                out += '<li>';
                out += '<a class="jqtoc-link" href="#' + counter + '">' + self.text() + '</a>';

                counter++;

                if (hnextLength) {
                    out += '<ol>';
                    buildListItemsAndAnchors(hnext, headerNum + 1);
                    out += '</ol>';
                }
                out += '</li>';
            });
        }

        buildListItemsAndAnchors(this.find('h' + h), h);

        out += '</ol></div>';
      
        if(  counter < $(opt.appendAfterSelector).data('bkb_toc_min_tag') ) {
        
            return '';
            
        }
        
        $(opt.appendAfterSelector).find(".bkb-toc-heading").append(' &nbsp; <a href="#top" class="bkb-toc-top"><i class="fa fa-angle-up"></i></a>');

        var appendAfter = $(opt.appendAfterSelector);

        if (appendAfter) {

            appendAfter.prepend($(out));

            $('body').on('click', '.jqtoc-link', function () {
                
                var anchor = $(this).attr('href').replace('#', '');
                $('html, body').animate({
                    scrollTop: $('a[name=' + anchor + ']').next().offset().top-100
                }, 1000);
                
                return false;
                
            });

        }

        return this;

    };
    

})(jQuery);


(function ($) {

    $(function () {

        $('body').tableOfContents({
            ulClass: 'bkb-toc-wrapper',
            appendAfterSelector: '.bkb-single-post'
        });

        $('body').on("click", '.bkb-toc-top', function () {
            var target = $(this.hash);
            target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
            if (target.length) {
                $('html, body').animate({
                    scrollTop: target.offset().top - parseInt(bkb_toc_offset, 0)
                }, 1000);
                return false;
            }

            return false;

        });
        
        if($('.bkb-toc-widget').length>0) {
            
            var $bkb_toc_wrapper = $('.bkb-single-post').find('.bkb_toc_wrapper');
           
            var $bkb_toc = $bkb_toc_wrapper.html();
            
            $bkb_toc_wrapper.hide();
            
             $('.bkb-toc-widget').html($bkb_toc);
             
              jQuery(window).resize(function () {
                   var bkb_window_width = jQuery(window).width();
                   
                   if(bkb_window_width<900) {
                       $bkb_toc_wrapper.show();
                   } else {
                       $bkb_toc_wrapper.hide();
                   }
             })
            
        }

    });

})(jQuery);